-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

-------------------------------------------------------------------------------
--                                                                           --
-- SPARK.Ada.Strings.Maps                                                    --
--                                                                           --
-- Description                                                               --
--   This is a binding to package Ada.Strings.Maps                           --
--                                                                           --
-- Language                                                                  --
--   Specification : SPARK                                                   --
--   Private Part  : Ada                                                     --
--   Body          : Ada                                                     --
--                                                                           --
-- Runtime Requirements and Dependencies                                     --
--   No Ada Runtime                                                          --
--                                                                           --
-- Verification                                                              --
--   N/A                                                                     --
--                                                                           --
-- Exceptions                                                                --
--   Ada.Strings.Translation_Error (Guarded)                                 --
--                                                                           --
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
--
--  A few subprograms, in particular ones involving Character_Ranges
--  or Character_Sequence cannot currently be SPARK; you will find
--  them in SPARK.Ada.Strings.Maps.Not_SPARK.
--
-------------------------------------------------------------------------------

with Ada.Strings.Maps;

package SPARK.Ada.Strings.Maps is

   --------------------------------
   -- Character Set Declarations --
   --------------------------------

   type Character_Set is private;

   Null_Set : constant Character_Set;

   ---------------------------
   -- Constructors for Sets --
   ---------------------------

   type Character_Range is record
      Low  : Character;
      High : Character;
   end record;

   --  function To_Set    (Span   : Character_Range)  return Character_Set;
   function Character_Range_To_Set
     (Span : Character_Range) return Character_Set;

   ----------------------------------
   -- Operations on Character Sets --
   ----------------------------------

   --  function "="   (Left, Right : Character_Set) return Boolean;
   function Operator_Equal (Left, Right : Character_Set) return Boolean;

   --  function "not" (Right       : Character_Set) return Character_Set;
   function Operator_Not (Right : Character_Set) return Character_Set;
   --  function "and" (Left, Right : Character_Set) return Character_Set;
   function Operator_And (Left, Right : Character_Set) return Character_Set;
   --  function "or"  (Left, Right : Character_Set) return Character_Set;
   function Operator_Or (Left, Right : Character_Set) return Character_Set;
   --  function "xor" (Left, Right : Character_Set) return Character_Set;
   function Operator_Xor (Left, Right : Character_Set) return Character_Set;
   --  function "-"   (Left, Right : Character_Set) return Character_Set;
   function Operator_Minus (Left, Right : Character_Set) return Character_Set;

   --  function Is_In
   --    (Element : Character;
   --     Set     : Character_Set) return Boolean;
   function Is_In
     (Arg_Element : Character;
      Arg_Set     : Character_Set) return Boolean;

   --  function Is_Subset
   --    (Elements : Character_Set;
   --     Set      : Character_Set) return Boolean;
   function Is_Subset
     (Elements : Character_Set;
      Arg_Set  : Character_Set) return Boolean;

   --  function To_Set (Sequence  : Character_Sequence) return Character_Set;
   function Character_Sequence_To_Set
     (Arg_Sequence : String) return Character_Set;
   --  function To_Set (Singleton : Character)          return Character_Set;
   function Singleton_To_Set (Singleton : Character) return Character_Set;

   ------------------------------------
   -- Character Mapping Declarations --
   ------------------------------------

   type Character_Mapping is private;
   --  Representation for a character to character mapping:

   --  function Value
   --    (Map     : Character_Mapping;
   --     Element : Character) return Character;
   function Value
     (Map         : Character_Mapping;
      Arg_Element : Character) return Character;

   Identity : constant Character_Mapping;

   ----------------------------
   -- Operations on Mappings --
   ----------------------------

   --  function To_Mapping
   --    (From, To : Character_Sequence) return Character_Mapping;
   function To_Mapping
     (Arg_From, To : String) return Character_Mapping;
   --# pre (Arg_From'Length = To'Length) and
   --#     (for all I in Positive range Arg_From'Range =>
   --#        (for all J in Positive range I + 1 .. Arg_From'Last =>
   --#           (Arg_From (I) /= Arg_From (J))));

private
   --# hide SPARK.Ada.Strings.Maps;
   type Character_Set is new Standard.Ada.Strings.Maps.Character_Set;

   Null_Set : constant Character_Set :=
     Character_Set (Standard.Ada.Strings.Maps.Null_Set);

   type Character_Mapping is new Standard.Ada.Strings.Maps.Character_Mapping;

   Identity : constant Character_Mapping :=
     Character_Mapping (Standard.Ada.Strings.Maps.Identity);

end SPARK.Ada.Strings.Maps;
