# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, Type, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._governance_rules_operations import (
    build_create_or_update_request,
    build_delete_request,
    build_execute_request,
    build_get_request,
    build_list_request,
    build_operation_results_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class GovernanceRulesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.security.v2022_01_01_preview.aio.SecurityCenter`'s
        :attr:`governance_rules` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @distributed_trace
    def list(self, scope: str, **kwargs: Any) -> AsyncIterable["_models.GovernanceRule"]:
        """Get a list of all relevant governance rules over a scope.

        :param scope: The scope of the Governance rules. Valid scopes are: management group (format:
         'providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
         'subscriptions/{subscriptionId}'), or security connector (format:
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'.
         Required.
        :type scope: str
        :return: An iterator like instance of either GovernanceRule or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.security.v2022_01_01_preview.models.GovernanceRule]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2022-01-01-preview")
        )
        cls: ClsType[_models.GovernanceRuleList] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_request(
                    scope=scope,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("GovernanceRuleList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(self, scope: str, rule_id: str, **kwargs: Any) -> _models.GovernanceRule:
        """Get a specific governance rule for the requested scope by ruleId.

        :param scope: The scope of the Governance rules. Valid scopes are: management group (format:
         'providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
         'subscriptions/{subscriptionId}'), or security connector (format:
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'.
         Required.
        :type scope: str
        :param rule_id: The governance rule key - unique key for the standard governance rule (GUID).
         Required.
        :type rule_id: str
        :return: GovernanceRule or the result of cls(response)
        :rtype: ~azure.mgmt.security.v2022_01_01_preview.models.GovernanceRule
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2022-01-01-preview")
        )
        cls: ClsType[_models.GovernanceRule] = kwargs.pop("cls", None)

        _request = build_get_request(
            scope=scope,
            rule_id=rule_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("GovernanceRule", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update(
        self,
        scope: str,
        rule_id: str,
        governance_rule: _models.GovernanceRule,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.GovernanceRule:
        """Creates or updates a governance rule over a given scope.

        :param scope: The scope of the Governance rules. Valid scopes are: management group (format:
         'providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
         'subscriptions/{subscriptionId}'), or security connector (format:
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'.
         Required.
        :type scope: str
        :param rule_id: The governance rule key - unique key for the standard governance rule (GUID).
         Required.
        :type rule_id: str
        :param governance_rule: Governance rule over a given scope. Required.
        :type governance_rule: ~azure.mgmt.security.v2022_01_01_preview.models.GovernanceRule
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: GovernanceRule or the result of cls(response)
        :rtype: ~azure.mgmt.security.v2022_01_01_preview.models.GovernanceRule
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update(
        self,
        scope: str,
        rule_id: str,
        governance_rule: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.GovernanceRule:
        """Creates or updates a governance rule over a given scope.

        :param scope: The scope of the Governance rules. Valid scopes are: management group (format:
         'providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
         'subscriptions/{subscriptionId}'), or security connector (format:
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'.
         Required.
        :type scope: str
        :param rule_id: The governance rule key - unique key for the standard governance rule (GUID).
         Required.
        :type rule_id: str
        :param governance_rule: Governance rule over a given scope. Required.
        :type governance_rule: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: GovernanceRule or the result of cls(response)
        :rtype: ~azure.mgmt.security.v2022_01_01_preview.models.GovernanceRule
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update(
        self, scope: str, rule_id: str, governance_rule: Union[_models.GovernanceRule, IO[bytes]], **kwargs: Any
    ) -> _models.GovernanceRule:
        """Creates or updates a governance rule over a given scope.

        :param scope: The scope of the Governance rules. Valid scopes are: management group (format:
         'providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
         'subscriptions/{subscriptionId}'), or security connector (format:
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'.
         Required.
        :type scope: str
        :param rule_id: The governance rule key - unique key for the standard governance rule (GUID).
         Required.
        :type rule_id: str
        :param governance_rule: Governance rule over a given scope. Is either a GovernanceRule type or
         a IO[bytes] type. Required.
        :type governance_rule: ~azure.mgmt.security.v2022_01_01_preview.models.GovernanceRule or
         IO[bytes]
        :return: GovernanceRule or the result of cls(response)
        :rtype: ~azure.mgmt.security.v2022_01_01_preview.models.GovernanceRule
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2022-01-01-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.GovernanceRule] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(governance_rule, (IOBase, bytes)):
            _content = governance_rule
        else:
            _json = self._serialize.body(governance_rule, "GovernanceRule")

        _request = build_create_or_update_request(
            scope=scope,
            rule_id=rule_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("GovernanceRule", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("GovernanceRule", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, scope: str, rule_id: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2022-01-01-preview")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_request(
            scope=scope,
            rule_id=rule_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["location"] = self._deserialize("str", response.headers.get("location"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def begin_delete(self, scope: str, rule_id: str, **kwargs: Any) -> AsyncLROPoller[None]:
        """Delete a Governance rule over a given scope.

        :param scope: The scope of the Governance rules. Valid scopes are: management group (format:
         'providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
         'subscriptions/{subscriptionId}'), or security connector (format:
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'.
         Required.
        :type scope: str
        :param rule_id: The governance rule key - unique key for the standard governance rule (GUID).
         Required.
        :type rule_id: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2022-01-01-preview")
        )
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                scope=scope,
                rule_id=rule_id,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _execute_initial(  # pylint: disable=inconsistent-return-statements
        self,
        scope: str,
        rule_id: str,
        execute_governance_rule_params: Optional[Union[_models.ExecuteGovernanceRuleParams, IO[bytes]]] = None,
        **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2022-01-01-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(execute_governance_rule_params, (IOBase, bytes)):
            _content = execute_governance_rule_params
        else:
            if execute_governance_rule_params is not None:
                _json = self._serialize.body(execute_governance_rule_params, "ExecuteGovernanceRuleParams")
            else:
                _json = None

        _request = build_execute_request(
            scope=scope,
            rule_id=rule_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["location"] = self._deserialize("str", response.headers.get("location"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @overload
    async def begin_execute(
        self,
        scope: str,
        rule_id: str,
        execute_governance_rule_params: Optional[_models.ExecuteGovernanceRuleParams] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Execute a governance rule.

        :param scope: The scope of the Governance rules. Valid scopes are: management group (format:
         'providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
         'subscriptions/{subscriptionId}'), or security connector (format:
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'.
         Required.
        :type scope: str
        :param rule_id: The governance rule key - unique key for the standard governance rule (GUID).
         Required.
        :type rule_id: str
        :param execute_governance_rule_params: Execute governance rule over a given scope. Default
         value is None.
        :type execute_governance_rule_params:
         ~azure.mgmt.security.v2022_01_01_preview.models.ExecuteGovernanceRuleParams
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_execute(
        self,
        scope: str,
        rule_id: str,
        execute_governance_rule_params: Optional[IO[bytes]] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Execute a governance rule.

        :param scope: The scope of the Governance rules. Valid scopes are: management group (format:
         'providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
         'subscriptions/{subscriptionId}'), or security connector (format:
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'.
         Required.
        :type scope: str
        :param rule_id: The governance rule key - unique key for the standard governance rule (GUID).
         Required.
        :type rule_id: str
        :param execute_governance_rule_params: Execute governance rule over a given scope. Default
         value is None.
        :type execute_governance_rule_params: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_execute(
        self,
        scope: str,
        rule_id: str,
        execute_governance_rule_params: Optional[Union[_models.ExecuteGovernanceRuleParams, IO[bytes]]] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Execute a governance rule.

        :param scope: The scope of the Governance rules. Valid scopes are: management group (format:
         'providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
         'subscriptions/{subscriptionId}'), or security connector (format:
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'.
         Required.
        :type scope: str
        :param rule_id: The governance rule key - unique key for the standard governance rule (GUID).
         Required.
        :type rule_id: str
        :param execute_governance_rule_params: Execute governance rule over a given scope. Is either a
         ExecuteGovernanceRuleParams type or a IO[bytes] type. Default value is None.
        :type execute_governance_rule_params:
         ~azure.mgmt.security.v2022_01_01_preview.models.ExecuteGovernanceRuleParams or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2022-01-01-preview")
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._execute_initial(  # type: ignore
                scope=scope,
                rule_id=rule_id,
                execute_governance_rule_params=execute_governance_rule_params,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def operation_results(
        self, scope: str, rule_id: str, operation_id: str, **kwargs: Any
    ) -> Optional[_models.OperationResultAutoGenerated]:
        """Get governance rules long run operation result for the requested scope by ruleId and
        operationId.

        :param scope: The scope of the Governance rules. Valid scopes are: management group (format:
         'providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format:
         'subscriptions/{subscriptionId}'), or security connector (format:
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'.
         Required.
        :type scope: str
        :param rule_id: The governance rule key - unique key for the standard governance rule (GUID).
         Required.
        :type rule_id: str
        :param operation_id: The governance rule long running operation unique key. Required.
        :type operation_id: str
        :return: OperationResultAutoGenerated or None or the result of cls(response)
        :rtype: ~azure.mgmt.security.v2022_01_01_preview.models.OperationResultAutoGenerated or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version or "2022-01-01-preview")
        )
        cls: ClsType[Optional[_models.OperationResultAutoGenerated]] = kwargs.pop("cls", None)

        _request = build_operation_results_request(
            scope=scope,
            rule_id=rule_id,
            operation_id=operation_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            deserialized = self._deserialize("OperationResultAutoGenerated", pipeline_response)

        if response.status_code == 202:
            response_headers["location"] = self._deserialize("str", response.headers.get("location"))

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore
