# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SubscriptionValidationResponse(Model):
    """To complete an event subscription validation handshake, a subscriber can
    use either the validationCode or the validationUrl received in a
    SubscriptionValidationEvent. When the validationCode is used, the
    SubscriptionValidationResponse can be used to build the response.

    :param validation_response: The validation response sent by the subscriber
     to Azure Event Grid to complete the validation of an event subscription.
    :type validation_response: str
    """

    _attribute_map = {
        'validation_response': {'key': 'validationResponse', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SubscriptionValidationResponse, self).__init__(**kwargs)
        self.validation_response = kwargs.get('validation_response', None)
