# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class NodeReimageParameter(Model):
    """Options for reimaging a compute node.

    :param node_reimage_option: When to reimage the compute node and what to
     do with currently running tasks. Values are:
     requeue - Terminate running task processes and requeue the tasks. The
     tasks will run again when a node is available. Reimage the node as soon as
     tasks have been terminated.
     terminate - Terminate running tasks. The tasks will not run again. Reimage
     the node as soon as tasks have been terminated.
     taskcompletion - Allow currently running tasks to complete. Schedule no
     new tasks while waiting. Reimage the node when all tasks have completed.
     retaineddata - Allow currently running tasks to complete, then wait for
     all task data retention periods to expire. Schedule no new tasks while
     waiting. Reimage the node when all task retention periods have expired.
     The default value is requeue. Possible values include: 'requeue',
     'terminate', 'taskCompletion', 'retainedData'
    :type node_reimage_option: str or :class:`ComputeNodeReimageOption
     <azure.batch.models.ComputeNodeReimageOption>`
    """

    _attribute_map = {
        'node_reimage_option': {'key': 'nodeReimageOption', 'type': 'ComputeNodeReimageOption'},
    }

    def __init__(self, node_reimage_option=None):
        self.node_reimage_option = node_reimage_option
