/* Auto generated file: with makeref.py .  Docs go in docs/reST/ref/ . */
#define DOC_PYGAMEJOYSTICK "Pygame module for interacting with joysticks, gamepads, and trackballs."
#define DOC_PYGAMEJOYSTICKINIT "init() -> None\nInitialize the joystick module."
#define DOC_PYGAMEJOYSTICKQUIT "quit() -> None\nUninitialize the joystick module."
#define DOC_PYGAMEJOYSTICKGETINIT "get_init() -> bool\nReturns True if the joystick module is initialized."
#define DOC_PYGAMEJOYSTICKGETCOUNT "get_count() -> count\nReturns the number of joysticks."
#define DOC_PYGAMEJOYSTICKJOYSTICK "Joystick(id) -> Joystick\nCreate a new Joystick object."
#define DOC_JOYSTICKINIT "init() -> None\ninitialize the Joystick"
#define DOC_JOYSTICKQUIT "quit() -> None\nuninitialize the Joystick"
#define DOC_JOYSTICKGETINIT "get_init() -> bool\ncheck if the Joystick is initialized"
#define DOC_JOYSTICKGETID "get_id() -> int\nget the device index (deprecated)"
#define DOC_JOYSTICKGETINSTANCEID "get_instance_id() -> int\nget the joystick instance id"
#define DOC_JOYSTICKGETGUID "get_guid() -> str\nget the joystick GUID"
#define DOC_JOYSTICKGETPOWERLEVEL "get_power_level() -> str\nget the approximate power status of the device"
#define DOC_JOYSTICKGETNAME "get_name() -> string\nget the Joystick system name"
#define DOC_JOYSTICKGETNUMAXES "get_numaxes() -> int\nget the number of axes on a Joystick"
#define DOC_JOYSTICKGETAXIS "get_axis(axis_number) -> float\nget the current position of an axis"
#define DOC_JOYSTICKGETNUMBALLS "get_numballs() -> int\nget the number of trackballs on a Joystick"
#define DOC_JOYSTICKGETBALL "get_ball(ball_number) -> x, y\nget the relative position of a trackball"
#define DOC_JOYSTICKGETNUMBUTTONS "get_numbuttons() -> int\nget the number of buttons on a Joystick"
#define DOC_JOYSTICKGETBUTTON "get_button(button) -> bool\nget the current button state"
#define DOC_JOYSTICKGETNUMHATS "get_numhats() -> int\nget the number of hat controls on a Joystick"
#define DOC_JOYSTICKGETHAT "get_hat(hat_number) -> x, y\nget the position of a joystick hat"
#define DOC_JOYSTICKRUMBLE "rumble(low_frequency, high_frequency, duration) -> bool\nStart a rumbling effect"
#define DOC_JOYSTICKSTOPRUMBLE "stop_rumble() -> None\nStop any rumble effect playing"


/* Docs in a comment... slightly easier to read. */

/*

pygame.joystick
Pygame module for interacting with joysticks, gamepads, and trackballs.

pygame.joystick.init
 init() -> None
Initialize the joystick module.

pygame.joystick.quit
 quit() -> None
Uninitialize the joystick module.

pygame.joystick.get_init
 get_init() -> bool
Returns True if the joystick module is initialized.

pygame.joystick.get_count
 get_count() -> count
Returns the number of joysticks.

pygame.joystick.Joystick
 Joystick(id) -> Joystick
Create a new Joystick object.

pygame.joystick.Joystick.init
 init() -> None
initialize the Joystick

pygame.joystick.Joystick.quit
 quit() -> None
uninitialize the Joystick

pygame.joystick.Joystick.get_init
 get_init() -> bool
check if the Joystick is initialized

pygame.joystick.Joystick.get_id
 get_id() -> int
get the device index (deprecated)

pygame.joystick.Joystick.get_instance_id
 get_instance_id() -> int
get the joystick instance id

pygame.joystick.Joystick.get_guid
 get_guid() -> str
get the joystick GUID

pygame.joystick.Joystick.get_power_level
 get_power_level() -> str
get the approximate power status of the device

pygame.joystick.Joystick.get_name
 get_name() -> string
get the Joystick system name

pygame.joystick.Joystick.get_numaxes
 get_numaxes() -> int
get the number of axes on a Joystick

pygame.joystick.Joystick.get_axis
 get_axis(axis_number) -> float
get the current position of an axis

pygame.joystick.Joystick.get_numballs
 get_numballs() -> int
get the number of trackballs on a Joystick

pygame.joystick.Joystick.get_ball
 get_ball(ball_number) -> x, y
get the relative position of a trackball

pygame.joystick.Joystick.get_numbuttons
 get_numbuttons() -> int
get the number of buttons on a Joystick

pygame.joystick.Joystick.get_button
 get_button(button) -> bool
get the current button state

pygame.joystick.Joystick.get_numhats
 get_numhats() -> int
get the number of hat controls on a Joystick

pygame.joystick.Joystick.get_hat
 get_hat(hat_number) -> x, y
get the position of a joystick hat

pygame.joystick.Joystick.rumble
 rumble(low_frequency, high_frequency, duration) -> bool
Start a rumbling effect

pygame.joystick.Joystick.stop_rumble
 stop_rumble() -> None
Stop any rumble effect playing

*/