# Info
__author__ = 'Ruoyi Jiang'

# Imports
import os
import sys
import time
import unittest
from Bio.Seq import Seq
from Bio.SeqRecord import SeqRecord
import numpy as np

# Paths
test_path = os.path.dirname(os.path.realpath(__file__))

# Import script
sys.path.append(os.path.join(test_path, os.pardir, 'bin'))
import EstimateError


class TestEstimateError(unittest.TestCase):
    def setUp(self):
        print('-> %s()' % self._testMethodName)
        
        # Test DNA
        seq_list = ['CATACAGCCCGT',
                     'CATACAGAGCTA',
                     'CATACAGCGCTC',
                     'CATACAGGATCA',
                     'CATACATCTAGT',
                     'CATACATGAGTT',
                     'CATACATAACCC',
                     'CATACATTAATG',
                     'CATACAGTGTAA',
                     'CATACATCAAAT',
                     'CATACATACCAT',
                     'CATACAGTCACT',
                     'CATACATAAATT',
                     'CATACATGCCGT',
                     'CATACAGTGGAA',
                     'CATACATTAACA',
                     'CATACATAGTCT',
                     'CATACAGAAAGC',
                     'CATACAGTACTG',
                     'CATACAGAAGAA',
                     'CATACATAAAAG',
                     'CATACAGTCATC',
                     'CATACAGATCTG',
                     'CATACAGGCCGA',
                     'CATACATGCGCC',
                     'CATACATTAGCG',
                     'CATACATCCACA',
                     'CATACAGTCCCC',
                     'CATACACTTCAC',
                     'CATACATCTATC']

        seq_dna = [Seq(seq) for seq in seq_list]
 
        seq_qual = [[27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27],
                     [14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14],
                     [21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21],
                     [16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16],
                     [28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28],
                     [27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27],
                     [13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13],
                     [25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25],
                     [17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17],
                     [15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15],
                     [19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19],
                     [21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21],
                     [10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10],
                     [22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22],
                     [29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29],
                     [25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25],
                     [14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14],
                     [29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29],
                     [22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22],
                     [19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19],
                     [14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14],
                     [14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14],
                     [29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29],
                     [12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12],
                     [14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14],
                     [13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13],
                     [13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13],
                     [12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12],
                     [26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26],
                     [16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16]]
        
        
        
        seq_list = [SeqRecord(seq_list[i], id='SEQ' + str(i+1), name='SEQ' + str(i+1), description='',
                                      letter_annotations={'phred_quality':seq_qual[i]})
                            for i in range(len(seq_dna))]
        self.records_dna = seq_list
        
        ref_seq = 'CATACAGTCAAA'
        self.records_original = ref_seq 
        
       # True empty mismatch dict

        self.empty_mismatch_dict = {'nuc': {'mismatch': {'A': {'A': 0, 'C': 0, 'G': 0, 'T': 0},
               'C': {'A': 0, 'C': 0, 'G': 0, 'T': 0},
               'G': {'A': 0, 'C': 0, 'G': 0, 'T': 0},
               'T': {'A': 0, 'C': 0, 'G': 0, 'T': 0}},
              'q_sum': {'A': {'A': 0, 'C': 0, 'G': 0, 'T': 0},
               'C': {'A': 0, 'C': 0, 'G': 0, 'T': 0},
               'G': {'A': 0, 'C': 0, 'G': 0, 'T': 0},
               'T': {'A': 0, 'C': 0, 'G': 0, 'T': 0}},
              'total': {'A': {'A': 0, 'C': 0, 'G': 0, 'T': 0},
               'C': {'A': 0, 'C': 0, 'G': 0, 'T': 0},
               'G': {'A': 0, 'C': 0, 'G': 0, 'T': 0},
               'T': {'A': 0, 'C': 0, 'G': 0, 'T': 0}}},
             'pos': {
                 'mismatch': {quality:0 for quality in range(12)},
                 'q_sum': {quality:0 for quality in range(12)},
                 'total': {quality:0 for quality in range(12)}
             },
             'qual': {
                 'mismatch': {quality:0 for quality in range(94)},
                 'q_sum': {quality:0 for quality in range(94)},
                 'total': {quality:0 for quality in range(94)}
             },
             'set': {'mismatch': None, 'q_sum': None, 'total': None}}
        

        # True mismatch dict

        self.true_mismatch_dict = {
             'nuc': {'mismatch': {'A': {'A': 116, 'C': 28, 'G': 15, 'T': 21},
               'C': {'A': 12, 'C': 69, 'G': 5, 'T': 4},
               'G': {'A': 0, 'C': 1, 'G': 14, 'T': 15},
               'T': {'A': 9, 'C': 6, 'G': 5, 'T': 40}},
              'q_sum': {'A': {'A': 2611, 'C': 2611, 'G': 2611, 'T': 2611},
               'C': {'A': 1955, 'C': 1955, 'G': 1955, 'T': 1955},
               'G': {'A': 791, 'C': 791, 'G': 791, 'T': 791},
               'T': {'A': 1555, 'C': 1555, 'G': 1555, 'T': 1555}},
              'total': {'A': {'A': 137, 'C': 137, 'G': 137, 'T': 137},
               'C': {'A': 104, 'C': 104, 'G': 104, 'T': 104},
               'G': {'A': 39, 'C': 39, 'G': 39, 'T': 39},
               'T': {'A': 80, 'C': 80, 'G': 80, 'T': 80}}},
             'pos': {'mismatch': {0: 0,
               1: 0,
               2: 0,
               3: 0,
               4: 0,
               5: 0,
               6: 16,
               7: 20,
               8: 21,
               9: 19,
               10: 23,
               11: 22},
              'q_sum': {0: 576,
               1: 576,
               2: 576,
               3: 576,
               4: 576,
               5: 576,
               6: 576,
               7: 576,
               8: 576,
               9: 576,
               10: 576,
               11: 576},
              'total': {0: 30,
               1: 30,
               2: 30,
               3: 30,
               4: 30,
               5: 30,
               6: 30,
               7: 30,
               8: 30,
               9: 30,
               10: 30,
               11: 30}},
             'qual': {'mismatch': {0: 0,
               1: 0,
               2: 0,
               3: 0,
               4: 0,
               5: 0,
               6: 0,
               7: 0,
               8: 0,
               9: 0,
               10: 5,
               11: 0,
               12: 6,
               13: 14,
               14: 21,
               15: 4,
               16: 9,
               17: 2,
               18: 0,
               19: 7,
               20: 0,
               21: 7,
               22: 9,
               23: 0,
               24: 0,
               25: 7,
               26: 4,
               27: 10,
               28: 5,
               29: 11,
               30: 0,
               31: 0,
               32: 0,
               33: 0,
               34: 0,
               35: 0,
               36: 0,
               37: 0,
               38: 0,
               39: 0,
               40: 0,
               41: 0,
               42: 0,
               43: 0,
               44: 0,
               45: 0,
               46: 0,
               47: 0,
               48: 0,
               49: 0,
               50: 0,
               51: 0,
               52: 0,
               53: 0,
               54: 0,
               55: 0,
               56: 0,
               57: 0,
               58: 0,
               59: 0,
               60: 0,
               61: 0,
               62: 0,
               63: 0,
               64: 0,
               65: 0,
               66: 0,
               67: 0,
               68: 0,
               69: 0,
               70: 0,
               71: 0,
               72: 0,
               73: 0,
               74: 0,
               75: 0,
               76: 0,
               77: 0,
               78: 0,
               79: 0,
               80: 0,
               81: 0,
               82: 0,
               83: 0,
               84: 0,
               85: 0,
               86: 0,
               87: 0,
               88: 0,
               89: 0,
               90: 0,
               91: 0,
               92: 0,
               93: 0},
              'q_sum': {0: 0,
               1: 0,
               2: 0,
               3: 0,
               4: 0,
               5: 0,
               6: 0,
               7: 0,
               8: 0,
               9: 0,
               10: 120,
               11: 0,
               12: 288,
               13: 468,
               14: 840,
               15: 180,
               16: 384,
               17: 204,
               18: 0,
               19: 456,
               20: 0,
               21: 504,
               22: 528,
               23: 0,
               24: 0,
               25: 600,
               26: 312,
               27: 648,
               28: 336,
               29: 1044,
               30: 0,
               31: 0,
               32: 0,
               33: 0,
               34: 0,
               35: 0,
               36: 0,
               37: 0,
               38: 0,
               39: 0,
               40: 0,
               41: 0,
               42: 0,
               43: 0,
               44: 0,
               45: 0,
               46: 0,
               47: 0,
               48: 0,
               49: 0,
               50: 0,
               51: 0,
               52: 0,
               53: 0,
               54: 0,
               55: 0,
               56: 0,
               57: 0,
               58: 0,
               59: 0,
               60: 0,
               61: 0,
               62: 0,
               63: 0,
               64: 0,
               65: 0,
               66: 0,
               67: 0,
               68: 0,
               69: 0,
               70: 0,
               71: 0,
               72: 0,
               73: 0,
               74: 0,
               75: 0,
               76: 0,
               77: 0,
               78: 0,
               79: 0,
               80: 0,
               81: 0,
               82: 0,
               83: 0,
               84: 0,
               85: 0,
               86: 0,
               87: 0,
               88: 0,
               89: 0,
               90: 0,
               91: 0,
               92: 0,
               93: 0},
              'total': {0: 0,
               1: 0,
               2: 0,
               3: 0,
               4: 0,
               5: 0,
               6: 0,
               7: 0,
               8: 0,
               9: 0,
               10: 12,
               11: 0,
               12: 24,
               13: 36,
               14: 60,
               15: 12,
               16: 24,
               17: 12,
               18: 0,
               19: 24,
               20: 0,
               21: 24,
               22: 24,
               23: 0,
               24: 0,
               25: 24,
               26: 12,
               27: 24,
               28: 12,
               29: 36,
               30: 0,
               31: 0,
               32: 0,
               33: 0,
               34: 0,
               35: 0,
               36: 0,
               37: 0,
               38: 0,
               39: 0,
               40: 0,
               41: 0,
               42: 0,
               43: 0,
               44: 0,
               45: 0,
               46: 0,
               47: 0,
               48: 0,
               49: 0,
               50: 0,
               51: 0,
               52: 0,
               53: 0,
               54: 0,
               55: 0,
               56: 0,
               57: 0,
               58: 0,
               59: 0,
               60: 0,
               61: 0,
               62: 0,
               63: 0,
               64: 0,
               65: 0,
               66: 0,
               67: 0,
               68: 0,
               69: 0,
               70: 0,
               71: 0,
               72: 0,
               73: 0,
               74: 0,
               75: 0,
               76: 0,
               77: 0,
               78: 0,
               79: 0,
               80: 0,
               81: 0,
               82: 0,
               83: 0,
               84: 0,
               85: 0,
               86: 0,
               87: 0,
               88: 0,
               89: 0,
               90: 0,
               91: 0,
               92: 0,
               93: 0}},
             'set': {'mismatch': {30: 121}, 'q_sum': {30: 6912}, 'total': {30: 360}}}
        
        # True distance dict
        self.true_distance_dict = {
              'all': 
                  np.array([  0,   1,  24,  70, 152, 133,  55,   0,   0,   0,   0,   0,   0])}
        
        # Start clock
        self.start = time.time()

    def tearDown(self):
        # End clock
        t = time.time() - self.start
        print('<- %s() %.3f' % (self._testMethodName, t))

    def test_initializeMismatchDictionary(self):
        result = EstimateError.initializeMismatchDictionary(len(self.records_original))
        del result['dist']
        self.assertEqual(self.empty_mismatch_dict, result)
    
    def test_countMismatches(self):
        result = EstimateError.countMismatches(self.records_dna, self.records_original)
        del result['dist']
        self.assertEqual(self.true_mismatch_dict, result)

    def test_calculateDistances(self):
        result = EstimateError.calculateDistances(self.records_dna, bin_count = len(self.records_original) + 1)
        np.allclose(self.true_distance_dict['all'], result['all'])
        
if __name__ == '__main__':
    unittest.main()