## Dependency licenses

Although Plaso is licensed under the [Apache License 2.0](http://www.apache.org/licenses/LICENSE-2.0), binary builds of Plaso include third party code that have been made available under various licenses.

### Core dependencies

Dependency | License
--- | ---
[artifacts](https://github.com/ForensicArtifacts/artifacts) | [Apache License 2.0](http://www.apache.org/licenses/LICENSE-2.0)
[LibYAML and Python-bindings](http://pyyaml.org/wiki/LibYAML) | [MIT license](http://opensource.org/licenses/MIT)
[Psutil](https://code.google.com/p/psutil/) | [BSD 3-clause license](http://opensource.org/licenses/BSD-3-Clause)
[Python](http://www.python.org/) | [Python Software Foundation License](http://opensource.org/licenses/Python-2.0) <br> Also see: http://docs.python.org/2/license.html
[Python dateutil](https://dateutil.readthedocs.org) | [BSD 3-clause license](http://opensource.org/licenses/BSD-3-Clause)
[pytz](http://pytz.sourceforge.net/) | [MIT license](http://opensource.org/licenses/MIT)
[pywin32](http://pywin32.sourceforge.net/) | [Python Software Foundation License](http://opensource.org/licenses/Python-2.0) <br> **Windows only**
[pyzmq](http://zeromq.org/bindings:python) | [GNU Lesser General Public License 3](http://www.gnu.org/licenses/lgpl.html)
[requests](https://github.com/kennethreitz/requests/) | [Apache License 2.0](http://www.apache.org/licenses/LICENSE-2.0)
[zeromq](http://zeromq.org/) | [GNU Lesser General Public License 3](http://www.gnu.org/licenses/lgpl.html)

### dfVFS dependencies

Dependency | License
--- | ---
[dfVFS](https://github.com/log2timeline/dfvfs/) | [Apache License 2.0](http://www.apache.org/licenses/LICENSE-2.0)
[Libbde and Python-bindings](https://github.com/libyal/libbde/) | [GNU Lesser General Public License 3](http://www.gnu.org/licenses/lgpl.html)
[Libewf and Python-bindings](https://github.com/libyal/libewf/) | [GNU Lesser General Public License 3](http://www.gnu.org/licenses/lgpl.html)
[Libqcow and Python-bindings](https://github.com/libyal/libqcow/) | [GNU Lesser General Public License 3](http://www.gnu.org/licenses/lgpl.html)
[Libsigscan and Python-bindings](https://github.com/libyal/libsigscan/) | [GNU Lesser General Public License 3](http://www.gnu.org/licenses/lgpl.html)
[Libsmdev and Python-bindings](https://github.com/libyal/libsmdev/) | [GNU Lesser General Public License 3](http://www.gnu.org/licenses/lgpl.html)
[Libsmraw and Python-bindings](https://github.com/libyal/libsmraw/) | [GNU Lesser General Public License 3](http://www.gnu.org/licenses/lgpl.html)
[Libvhdi and Python-bindings](https://github.com/libyal/libvhdi/) | [GNU Lesser General Public License 3](http://www.gnu.org/licenses/lgpl.html)
[Libvmdk and Python-bindings](https://github.com/libyal/libvmdk/) | [GNU Lesser General Public License 3](http://www.gnu.org/licenses/lgpl.html)
[Libvshadow and Python-bindings](https://github.com/libyal/libvshadow/) | [GNU Lesser General Public License 3](http://www.gnu.org/licenses/lgpl.html)
[Pytsk](https://github.com/py4n6/pytsk/) | [Apache License 2.0](http://www.apache.org/licenses/LICENSE-2.0)
[SleuthKit](http://www.sleuthkit.org/) | The SleuthKit is multi licensed <br> Common Public License 1.0; applies to most of the code <br> IBM Public License 1.0; applies to the file system code (tsk/fs, tools/fstools) <br> [GNU General Public License 2](http://www.gnu.org/licenses/gpl-2.0.html); applies to srch_strings which **should not be included in a binary build of plaso**.
[talloc](http://talloc.samba.org/talloc/doc/html/index.html) | [GNU Lesser General Public License 3](http://www.gnu.org/licenses/lgpl.html)

### Parser dependencies

Dependency | License
--- | ---
[bencode](https://pypi.python.org/pypi/bencode) | [BitTorrent Open Source License](http://web.archive.org/web/20080213154112/http://www.bittorrent.com/bittorrent-open-source-license)
[Libesedb and Python-bindings](https://github.com/libyal/libesedb/) | [GNU Lesser General Public License 3](http://www.gnu.org/licenses/lgpl.html)
[Libevt and Python-bindings](https://github.com/libyal/libevt/) | [GNU Lesser General Public License 3](http://www.gnu.org/licenses/lgpl.html)
[Libevtx and Python-bindings](https://github.com/libyal/libevtx/) | [GNU Lesser General Public License 3](http://www.gnu.org/licenses/lgpl.html)
[Libfwsi and Python-bindings](https://github.com/libyal/libfwsi/) | [GNU Lesser General Public License 3](http://www.gnu.org/licenses/lgpl.html)
[Liblnk and Python-bindings](https://github.com/libyal/liblnk/) | [GNU Lesser General Public License 3](http://www.gnu.org/licenses/lgpl.html)
[Libmsiecf and Python-bindings](https://github.com/libyal/libmsiecf/) | [GNU Lesser General Public License 3](http://www.gnu.org/licenses/lgpl.html)
[Libolecf and Python-bindings](https://github.com/libyal/libolecf/) | [GNU Lesser General Public License 3](http://www.gnu.org/licenses/lgpl.html)
[Libregf and Python-bindings](https://github.com/libyal/libregf/) | [GNU Lesser General Public License 3](http://www.gnu.org/licenses/lgpl.html)
[Six](https://pypi.python.org/pypi/six/) | [MIT license](http://opensource.org/licenses/MIT)
[Sqlite](http://www.sqlite.org/index.html) | [Public domain](http://www.sqlite.org/copyright.html)
[pefile](https://github.com/erocarrera/pefile) | [BSD 3-clause license](http://opensource.org/licenses/BSD-3-Clause)
[Pyparsing](http://pyparsing.wikispaces.com/) | [MIT license](http://opensource.org/licenses/MIT)
[Pysqlite](https://pypi.python.org/pypi/pysqlite) | [zlib/libpng license](https://github.com/ghaering/pysqlite/blob/master/LICENSE)

### Output/Storage dependencies

Dependency | License
--- | ---
[Pyelasticsearch](https://github.com/rhec/pyelasticsearch/) | [BSD 3-clause license](http://opensource.org/licenses/BSD-3-Clause)
[XlsxWriter](https://github.com/jmcnamara/XlsxWriter) | [BSD 2-clause license](http://opensource.org/licenses/BSD-2-Clause)

### Windows packaged version dependencies

Dependency | License
--- | ---
[PyInstaller](http://www.pyinstaller.org/) | [GNU General Public License 2](http://www.gnu.org/licenses/gpl-2.0.html) with an exception for the bootloader, which is the part that is used in plaso binaries.

### To do
Dependencies not mentioned explicitly yet:

* zlib (used in libqcow and libewf)
* openssl (used in libqcow and libewf)
* bzip2 (or part of python)
* Visual studio runtime DLLs
