//=======================================================================
// mainwindow.h
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#ifndef GPACO_MAIN_WINDOW_H
#define GPACO_MAIN_WINDOW_H

#include <gtkmm/window.h>
#include <gtkmm/label.h>
#include <gtkmm/progressbar.h>
#include <gtkmm/uimanager.h>

namespace Gpaco
{

class MainTreeView;

class MainWindow : public Gtk::Window 
{
	public:

	MainWindow();
	virtual ~MainWindow();

	MainTreeView* treeView()		{ return mpTreeView; }
	Gtk::ProgressBar& progressBar()	{ return mProgressBar; }
	Gtk::Label& label()				{ return mLabel; }

	bool isColumnVisible(int colId);
	void setColumnVisible(int colId, bool visible = true);

	private:

	Gtk::Label						mLabel;
	MainTreeView*					mpTreeView;
	Gtk::ProgressBar				mProgressBar;
	Glib::RefPtr<Gtk::UIManager>	mpUIManager;
	Glib::RefPtr<Gtk::ActionGroup>	mpActionGroupMenuBar;
	Glib::RefPtr<Gtk::ActionGroup>	mpActionGroupPkg;
	Glib::RefPtr<Gtk::Action>		mpActionUpdate;
	Glib::RefPtr<Gtk::Action>		mpActionViewFiles;
	Glib::RefPtr<Gtk::Action>		mpActionProperties;
	Glib::RefPtr<Gtk::Action>		mpActionRemovePkg;
	Glib::RefPtr<Gtk::Action>		mpActionCreatePackage;
	Glib::RefPtr<Gtk::Action>		mpActionUnlogPkg;

	virtual bool on_delete_event(GdkEventAny*);
	void quit();
	bool writeLabel();
	void buildUIManager();
	void about();
	void find();
	void preferences();
	bool onPkgMenu(GdkEvent*);
};

// Global MainWindow
extern MainWindow* gpMainWindow;

} // namespace Gpaco


#endif  // GPACO_MAIN_WINDOW_H
