
// 1N4148 table generated by DK/diode_table_gen.py -- do not modify manually

struct table1d { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct table1d_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator table1d&() const { return *(table1d*)this; }
};

static table1d_imp<100> diode_table __rt_data = {
	0.0,0.5937,54.379,100, {
	0.0,0.00351758788047,0.0105527636381,0.0175879393858,0.0246231151162,0.0316582908211,
	0.0386934664908,0.0457286421138,0.0527638176759,0.0597989931596,0.066834168543,
	0.0738693437987,0.0809045188923,0.0879396937803,0.094974868408,0.102010042706,
	0.109045216588,0.116080389942,0.123115562629,0.130150734474,0.137185905252,
	0.144221074683,0.151256242409,0.158291407981,0.16532657083,0.172361730234,
	0.179396885285,0.186432034831,0.193467177417,0.200502311205,0.207537433869,
	0.21457254247,0.22160763329,0.228642701631,0.235677741553,0.242712745545,
	0.249747704112,0.256782605253,0.263817433791,0.270852170544,0.277886791262,
	0.284921265289,0.291955553874,0.298989608037,0.306023365868,0.313056749125,
	0.320089658926,0.327121970329,0.33415352548,0.34118412498,0.348213517015,
	0.355241383662,0.362267323689,0.369290830956,0.376311267366,0.383327829054,
	0.390339504275,0.397345021155,0.404342783184,0.411330790114,0.418306541772,
	0.425266922359,0.432208063281,0.439125183571,0.446012408958,0.452862573873,
	0.459667015676,0.466415377272,0.473095443114,0.479693043336,0.486192069532,
	0.492574649878,0.498821526116,0.504912656017,0.510828030285,0.516548646641,
	0.52205753732,0.527340715756,0.532387908139,0.537192970401,0.541753951165,
	0.546072826932,0.550154986804,0.55400856877,0.557643747726,0.561072055031,
	0.564305781538,0.567357489251,0.570239636106,0.572964305088,0.575543022076,
	0.577986644697,0.580305305236,0.582508392889,0.584604563352,0.586601766447,
	0.588507284808,0.590327778588,0.592069332661,0.593737503929
	}
};

double always_inline diodeclip(double x) {
    double f = fabs(x);
    f = f * diode_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = diode_table.data[0];
    } else if (i >= diode_table.size-1) {
        f = diode_table.data[diode_table.size-1];
    } else {
	f -= i;
	f = diode_table.data[i]*(1-f) + diode_table.data[i+1]*f;
    }
    return copysign(f, x);
}

