/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.vaultoptions;

import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Provider;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.changepassword.ChangePasswordComponent;
import org.cryptomator.ui.common.DefaultSceneFactory;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxControllerKey;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlLoaderFactory;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.common.StageFactory;
import org.cryptomator.ui.mainwindow.MainWindow;
import org.cryptomator.ui.recoverykey.RecoveryKeyComponent;
import org.cryptomator.ui.vaultoptions.GeneralVaultOptionsController;
import org.cryptomator.ui.vaultoptions.MasterkeyOptionsController;
import org.cryptomator.ui.vaultoptions.MountOptionsController;
import org.cryptomator.ui.vaultoptions.SelectedVaultOptionsTab;
import org.cryptomator.ui.vaultoptions.VaultOptionsController;
import org.cryptomator.ui.vaultoptions.VaultOptionsScoped;
import org.cryptomator.ui.vaultoptions.VaultOptionsWindow;

@Module(subcomponents={ChangePasswordComponent.class, RecoveryKeyComponent.class})
abstract class VaultOptionsModule {
    VaultOptionsModule() {
    }

    @Provides
    @VaultOptionsScoped
    static ObjectProperty<SelectedVaultOptionsTab> provideSelectedTabProperty() {
        return new SimpleObjectProperty((Object)SelectedVaultOptionsTab.ANY);
    }

    @Provides
    @VaultOptionsWindow
    @VaultOptionsScoped
    static FxmlLoaderFactory provideFxmlLoaderFactory(Map<Class<? extends FxController>, Provider<FxController>> factories, DefaultSceneFactory sceneFactory, ResourceBundle resourceBundle) {
        return new FxmlLoaderFactory(factories, sceneFactory, resourceBundle);
    }

    @Provides
    @VaultOptionsWindow
    @VaultOptionsScoped
    static Stage provideStage(StageFactory factory, @MainWindow Stage owner, @VaultOptionsWindow Vault vault) {
        Stage stage = factory.create();
        stage.setTitle(vault.getDisplayName());
        stage.setResizable(true);
        stage.setMinWidth(400.0);
        stage.setMinHeight(300.0);
        stage.initModality(Modality.WINDOW_MODAL);
        stage.initOwner((Window)owner);
        return stage;
    }

    @Provides
    @FxmlScene(value=FxmlFile.VAULT_OPTIONS)
    @VaultOptionsScoped
    static Scene provideVaultOptionsScene(@VaultOptionsWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.VAULT_OPTIONS);
    }

    @Binds
    @IntoMap
    @FxControllerKey(value=VaultOptionsController.class)
    abstract FxController bindVaultOptionsController(VaultOptionsController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=GeneralVaultOptionsController.class)
    abstract FxController bindGeneralVaultOptionsController(GeneralVaultOptionsController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=MountOptionsController.class)
    abstract FxController bindMountOptionsController(MountOptionsController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=MasterkeyOptionsController.class)
    abstract FxController bindMasterkeyOptionsController(MasterkeyOptionsController var1);
}

