/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.vaultoptions;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.fxml.FXML;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.cryptomator.common.keychain.KeychainManager;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.integrations.keychain.KeychainAccessException;
import org.cryptomator.ui.changepassword.ChangePasswordComponent;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.recoverykey.RecoveryKeyComponent;
import org.cryptomator.ui.vaultoptions.VaultOptionsScoped;
import org.cryptomator.ui.vaultoptions.VaultOptionsWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VaultOptionsScoped
public class MasterkeyOptionsController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(MasterkeyOptionsController.class);
    private final Vault vault;
    private final Stage window;
    private final ChangePasswordComponent.Builder changePasswordWindow;
    private final RecoveryKeyComponent.Builder recoveryKeyWindow;
    private final KeychainManager keychain;
    private final BooleanExpression passwordSaved;

    @Inject
    MasterkeyOptionsController(@VaultOptionsWindow Vault vault, @VaultOptionsWindow Stage window, ChangePasswordComponent.Builder changePasswordWindow, RecoveryKeyComponent.Builder recoveryKeyWindow, KeychainManager keychain) {
        this.vault = vault;
        this.window = window;
        this.changePasswordWindow = changePasswordWindow;
        this.recoveryKeyWindow = recoveryKeyWindow;
        this.keychain = keychain;
        this.passwordSaved = keychain.isSupported() && !keychain.isLocked() ? Bindings.createBooleanBinding(this::isPasswordSaved, (Observable[])new Observable[]{keychain.getPassphraseStoredProperty(vault.getId())}) : new SimpleBooleanProperty(false);
    }

    @FXML
    public void changePassword() {
        this.changePasswordWindow.vault(this.vault).owner(this.window).build().showChangePasswordWindow();
    }

    @FXML
    public void showRecoveryKey() {
        this.recoveryKeyWindow.vault(this.vault).owner(this.window).build().showRecoveryKeyCreationWindow();
    }

    @FXML
    public void showRecoverVaultDialogue() {
        this.recoveryKeyWindow.vault(this.vault).owner(this.window).build().showRecoveryKeyRecoverWindow();
    }

    @FXML
    public void removePasswordFromKeychain() {
        assert (this.keychain.isSupported());
        try {
            this.keychain.deletePassphrase(this.vault.getId());
        }
        catch (KeychainAccessException e) {
            LOG.error("Failed to delete passphrase from system keychain.", (Throwable)e);
        }
        this.window.close();
    }

    public BooleanExpression passwordSavedProperty() {
        return this.passwordSaved;
    }

    public boolean isPasswordSaved() {
        if (this.keychain.isSupported() && !this.keychain.isLocked() && this.vault != null) {
            return this.keychain.getPassphraseStoredProperty(this.vault.getId()).get();
        }
        return false;
    }
}

