/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.mainwindow;

import java.io.IOException;
import java.io.UncheckedIOException;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Callback;
import javax.inject.Inject;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.common.FxmlLoaderFactory;
import org.cryptomator.ui.controls.DraggableListCell;
import org.cryptomator.ui.mainwindow.MainWindow;
import org.cryptomator.ui.mainwindow.MainWindowScoped;
import org.cryptomator.ui.mainwindow.VaultListCellController;

@MainWindowScoped
public class VaultListCellFactory
implements Callback<ListView<Vault>, ListCell<Vault>> {
    private final FxmlLoaderFactory fxmlLoaders;

    @Inject
    VaultListCellFactory(@MainWindow FxmlLoaderFactory fxmlLoaders) {
        this.fxmlLoaders = fxmlLoaders;
    }

    public ListCell<Vault> call(ListView<Vault> param) {
        try {
            FXMLLoader fxmlLoader = this.fxmlLoaders.load("/fxml/vault_list_cell.fxml");
            return new Cell((Parent)fxmlLoader.getRoot(), (VaultListCellController)fxmlLoader.getController());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to load /fxml/vault_list_cell.fxml.", e);
        }
    }

    private static class Cell
    extends DraggableListCell<Vault> {
        private final Parent node;
        private final VaultListCellController controller;

        public Cell(Parent node, VaultListCellController controller) {
            this.node = node;
            this.controller = controller;
        }

        protected void updateItem(Vault item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                this.setGraphic((Node)this.node);
                this.controller.setVault(item);
            }
        }
    }
}

