/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.controls;

import com.tobiasdiez.easybind.EasyBind;
import java.util.Collection;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.ListCell;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;

public class DraggableListCell<T>
extends ListCell<T> {
    private static final String DROP_ABOVE_CLASS = "drop-above";
    private static final String DROP_BELOW_CLASS = "drop-below";
    private final BooleanProperty dropAbove = new SimpleBooleanProperty();
    private final BooleanProperty dropBelow = new SimpleBooleanProperty();

    public DraggableListCell() {
        this.setOnDragDetected(this::onDragDetected);
        this.setOnDragOver(this::onDragOver);
        this.setOnDragEntered(this::onDragEntered);
        this.setOnDragExited(this::onDragExited);
        this.setOnDragDropped(this::onDragDropped);
        this.setOnDragDone(Event::consume);
        EasyBind.includeWhen((Collection)this.getStyleClass(), (Object)DROP_ABOVE_CLASS, (ObservableValue)this.dropAbove);
        EasyBind.includeWhen((Collection)this.getStyleClass(), (Object)DROP_BELOW_CLASS, (ObservableValue)this.dropBelow);
    }

    private void setDropPositionStyleClass(double verticalCursorPosition) {
        boolean isUpperHalf;
        boolean bl = isUpperHalf = verticalCursorPosition < this.getHeight() / 2.0;
        if (isUpperHalf) {
            this.dropAbove.set(true);
            this.dropBelow.set(false);
        } else {
            this.dropAbove.set(false);
            this.dropBelow.set(true);
        }
    }

    private void resetDropPositionStyleClasses() {
        this.dropAbove.set(false);
        this.dropBelow.set(false);
    }

    private void onDragDetected(MouseEvent event) {
        if (this.getItem() == null) {
            return;
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(Integer.toString(this.getIndex()));
        WritableImage snapshot = this.snapshot(new SnapshotParameters(), null);
        Dragboard dragboard = this.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
        dragboard.setDragView((Image)snapshot);
        dragboard.setContent((Map)content);
        event.consume();
    }

    private void onDragOver(DragEvent event) {
        if (this.getItem() == null) {
            return;
        }
        if (event.getGestureSource() instanceof DraggableListCell && event.getGestureSource() != this && event.getDragboard().hasString()) {
            event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            this.setDropPositionStyleClass(event.getY());
        }
        event.consume();
    }

    private void onDragEntered(DragEvent event) {
        if (this.getItem() == null) {
            return;
        }
        if (event.getGestureSource() instanceof DraggableListCell && event.getGestureSource() != this && event.getDragboard().hasString()) {
            this.setDropPositionStyleClass(event.getY());
        }
    }

    private void onDragExited(DragEvent event) {
        if (this.getItem() == null) {
            return;
        }
        if (event.getGestureSource() instanceof DraggableListCell && event.getGestureSource() != this && event.getDragboard().hasString()) {
            this.resetDropPositionStyleClasses();
        }
    }

    private void onDragDropped(DragEvent event) {
        if (this.getItem() == null) {
            return;
        }
        if (event.getGestureSource() instanceof DraggableListCell && event.getDragboard().hasString()) {
            ObservableList list = this.getListView().getItems();
            try {
                int draggedIdx = Integer.parseInt(event.getDragboard().getString());
                Object currentItem = this.getItem();
                Object draggedItem = list.remove(draggedIdx);
                int currentItemIdx = list.indexOf(currentItem);
                boolean insertBefore = event.getY() < this.getHeight() / 2.0;
                int insertPosition = insertBefore ? currentItemIdx : currentItemIdx + 1;
                this.getListView().getItems().add(insertPosition, draggedItem);
                this.getListView().getSelectionModel().select(insertPosition);
                event.setDropCompleted(true);
            }
            catch (NumberFormatException e) {
                event.setDropCompleted(false);
            }
        }
        event.consume();
    }
}

