/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.common;

import java.io.IOException;
import java.io.InputStream;
import javafx.scene.text.Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontLoader {
    private static final Logger LOG = LoggerFactory.getLogger(FontLoader.class);
    private static final double DEFAULT_FONT_SIZE = 12.0;

    public static Font load(String resourcePath) throws FontLoaderException {
        Font font;
        block9: {
            InputStream in = FontLoader.class.getResourceAsStream(resourcePath);
            try {
                if (in == null) {
                    throw new FontLoaderException(resourcePath);
                }
                font = FontLoader.load(resourcePath, in);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FontLoaderException(resourcePath, e);
                }
            }
            in.close();
        }
        return font;
    }

    private static Font load(String resourcePath, InputStream in) throws FontLoaderException {
        Font font = Font.loadFont((InputStream)in, (double)12.0);
        if (font != null) {
            LOG.debug("Loaded family: {}", (Object)font.getFamily());
            return font;
        }
        throw new FontLoaderException(resourcePath);
    }

    public static class FontLoaderException
    extends IOException {
        private FontLoaderException(String resourceName) {
            super("Failed to load font: " + resourceName);
        }

        private FontLoaderException(String resourceName, Throwable cause) {
            super("Failed to load font: " + resourceName, cause);
        }
    }
}

