/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.vaults;

import com.google.common.base.CharMatcher;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Provider;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.common.settings.VaultSettings;
import org.cryptomator.common.settings.VolumeImpl;
import org.cryptomator.common.settings.WebDavUrlScheme;
import org.cryptomator.common.vaults.MountPointRequirement;
import org.cryptomator.common.vaults.Volume;
import org.cryptomator.common.vaults.WindowsDriveLetters;
import org.cryptomator.cryptofs.CryptoFileSystem;
import org.cryptomator.frontend.webdav.WebDavServer;
import org.cryptomator.frontend.webdav.mount.MountParams;
import org.cryptomator.frontend.webdav.mount.Mounter;
import org.cryptomator.frontend.webdav.servlet.WebDavServletController;

public class WebDavVolume
implements Volume {
    private static final String LOCALHOST_ALIAS = "cryptomator-vault";
    private final Provider<WebDavServer> serverProvider;
    private final VaultSettings vaultSettings;
    private final Settings settings;
    private final WindowsDriveLetters windowsDriveLetters;
    private WebDavServer server;
    private WebDavServletController servlet;
    private Mounter.Mount mount;
    private Consumer<Throwable> onExitAction;

    @Inject
    public WebDavVolume(Provider<WebDavServer> serverProvider, VaultSettings vaultSettings, Settings settings, WindowsDriveLetters windowsDriveLetters) {
        this.serverProvider = serverProvider;
        this.vaultSettings = vaultSettings;
        this.settings = settings;
        this.windowsDriveLetters = windowsDriveLetters;
    }

    @Override
    public void mount(CryptoFileSystem fs, String mountFlags, Consumer<Throwable> onExitAction) throws Volume.VolumeException {
        this.startServlet(fs);
        this.mountServlet();
        this.onExitAction = onExitAction;
    }

    private void startServlet(CryptoFileSystem fs) {
        if (this.server == null) {
            this.server = (WebDavServer)this.serverProvider.get();
        }
        if (!this.server.isRunning()) {
            this.server.start();
        }
        CharMatcher acceptable = CharMatcher.inRange((char)'0', (char)'9').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'a', (char)'z'));
        String urlConformMountName = acceptable.negate().collapseFrom((CharSequence)this.vaultSettings.mountName().get(), '_');
        this.servlet = this.server.createWebDavServlet(fs.getPath("/", new String[0]), this.vaultSettings.getId() + "/" + urlConformMountName);
        this.servlet.start();
    }

    private void mountServlet() throws Volume.VolumeException {
        if (this.servlet == null) {
            throw new IllegalStateException("Mounting requires unlocked WebDAV servlet.");
        }
        Supplier<String> driveLetterSupplier = System.getProperty("os.name").toLowerCase().contains("windows") && this.vaultSettings.winDriveLetter().isEmpty().get() ? () -> this.windowsDriveLetters.getDesiredAvailableDriveLetter().orElse(null) : () -> (String)this.vaultSettings.winDriveLetter().get();
        MountParams mountParams = MountParams.create().withWindowsDriveLetter(driveLetterSupplier.get()).withPreferredGvfsScheme(((WebDavUrlScheme)((Object)this.settings.preferredGvfsScheme().get())).getPrefix()).withWebdavHostname(this.getLocalhostAliasOrNull()).build();
        try {
            this.mount = this.servlet.mount(mountParams);
        }
        catch (Mounter.CommandFailedException e) {
            throw new Volume.VolumeException(e);
        }
    }

    @Override
    public void reveal(Volume.Revealer revealer) throws Volume.VolumeException {
        try {
            this.mount.reveal(revealer::reveal);
        }
        catch (Exception e) {
            throw new Volume.VolumeException(e);
        }
    }

    @Override
    public synchronized void unmount() throws Volume.VolumeException {
        try {
            this.mount.unmount();
        }
        catch (Mounter.CommandFailedException e) {
            throw new Volume.VolumeException(e);
        }
        this.cleanup();
        this.onExitAction.accept(null);
    }

    @Override
    public synchronized void unmountForced() throws Volume.VolumeException {
        try {
            ((Mounter.UnmountOperation)this.mount.forced().orElseThrow(IllegalStateException::new)).unmount();
        }
        catch (Mounter.CommandFailedException e) {
            throw new Volume.VolumeException(e);
        }
        this.cleanup();
        this.onExitAction.accept(null);
    }

    @Override
    public Optional<Path> getMountPoint() {
        return this.mount.getMountPoint();
    }

    @Override
    public MountPointRequirement getMountPointRequirement() {
        return MountPointRequirement.NONE;
    }

    private String getLocalhostAliasOrNull() {
        try {
            InetAddress alias = InetAddress.getByName(LOCALHOST_ALIAS);
            if (alias.getHostAddress().equals("127.0.0.1")) {
                return LOCALHOST_ALIAS;
            }
            return null;
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    private void cleanup() {
        if (this.servlet != null) {
            this.servlet.stop();
        }
    }

    @Override
    public boolean isSupported() {
        return WebDavVolume.isSupportedStatic();
    }

    @Override
    public VolumeImpl getImplementationType() {
        return VolumeImpl.WEBDAV;
    }

    @Override
    public boolean supportsForcedUnmount() {
        return this.mount != null && this.mount.forced().isPresent();
    }

    public static boolean isSupportedStatic() {
        return true;
    }
}

