/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.vaults;

import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.cryptomator.common.settings.VaultSettings;
import org.cryptomator.common.vaults.Vault;

class VaultListChangeListener
implements ListChangeListener<Vault> {
    private final ObservableList<VaultSettings> vaultSettingsList;

    public VaultListChangeListener(ObservableList<VaultSettings> vaultSettingsList) {
        this.vaultSettingsList = vaultSettingsList;
    }

    public void onChanged(ListChangeListener.Change<? extends Vault> c) {
        while (c.next()) {
            if (c.wasAdded()) {
                List<VaultSettings> addedSettings = c.getAddedSubList().stream().map(Vault::getVaultSettings).toList();
                this.vaultSettingsList.addAll(c.getFrom(), addedSettings);
                continue;
            }
            if (!c.wasRemoved()) continue;
            List<VaultSettings> removedSettings = c.getRemoved().stream().map(Vault::getVaultSettings).toList();
            this.vaultSettingsList.removeAll(removedSettings);
        }
    }
}

