//  Copyright (C) 2002 RealVNC Ltd. All Rights Reserved.
//  Copyright (C) 1999 AT&T Laboratories Cambridge. All Rights Reserved.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
//  USA.
//
// If the source code for the program is not available from the place from
// which you received this file, check http://www.realvnc.com/ or contact
// the authors on info@realvnc.com for information on obtaining it.

// This is an object and macros which provide general logging and debugging functions.
// It can log to a file, to a new console, and/or to debug - others maybe to follow.
// Every log object has a logging level (which can be changed).
// Only log requests with a high enough level attached get logged. So the
// level can be thought of as 'amount of detail'.
// We use Unicode-portable stuff here for compatibility with WinCE.
//
// Typical use:
//
//       Log log;
//       log.SetFile( _T("myapp.log") );
//       ...
//       log.Print(2, _T("x = %d\n"), x);
//

#ifndef VNCLOGGING
#define VNCLOGGING

#include <stdarg.h>
#include <stdio.h>
#include <time.h>

class VNCLog  
{
public:
    // Logging mode flags:
    static const int ToDebug;
    static const int ToFile;
    static const int ToConsole;

    // Create a new log object.
    // Parameters as follows:
    //    mode     - specifies where output should go, using combination
    //               of flags above.
    //    level    - the default level
    //    filename - if flag Log::ToFile is specified in the type,
    //               a filename must be specified here.
    //    append   - if logging to a file, whether or not to append to any
    //               existing log.
	VNCLog();

    inline void Print(int level, const char* format, ...) {
#ifndef ULTRAVNC_VEYON_SUPPORT
        if ( level > m_level ) return;
		if (!m_todebug && !m_toconsole && !m_tofile) return;
#endif
        va_list ap;
        va_start(ap, format);
#ifndef ULTRAVNC_VEYON_SUPPORT
        ReallyPrint(format, ap);
#else
        ReallyPrint(level, format, ap);
#endif
        va_end(ap);
    }
    
    // Change the log level
    void SetLevel(int level);
	int  GetLevel() const {return m_level;};

	void SetVideo(bool enable) {m_video=enable;};
	bool GetVideo() {return m_video;};
	void SetPath(char path[512]);
	char *GetPath();
	void ClearAviConfig();

    // Change the logging mode
    void SetMode(int mode);
	int  GetMode() const {return m_mode;};

    // Change or set the logging filename.  This only has an effect if
	// the log mode includes ToFile
    void SetFile();

	virtual ~VNCLog();

private:
#ifdef ULTRAVNC_VEYON_SUPPORT
	void ReallyPrintLine(int level, const char* line);
    void ReallyPrint(int level, const char* format, va_list ap);
#else
	void ReallyPrintLine(const char* line);
    void ReallyPrint(const char* format, va_list ap);
	void OpenFile();
    void CloseFile();
#endif
    bool m_tofile, m_todebug, m_toconsole;
	int m_mode;
    int m_level;
    HANDLE hlogfile;
#ifdef ULTRAVNC_VEYON_SUPPORT
	char m_filename[512];
#endif
	bool m_append;
	bool m_video;
	char m_path[MAX_PATH];

	time_t m_lastLogTime;
	void GetLastErrorMsg(LPSTR szErrorMsg) const;
};

#endif // VNCLOGGING
