; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -instcombine -S < %s | FileCheck %s

define i16 @sext_shl_trunc_same_size(i16 %x, i32 %y) {
; CHECK-LABEL: @sext_shl_trunc_same_size(
; CHECK-NEXT:    [[CONV1:%.*]] = zext i16 [[X:%.*]] to i32
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 [[CONV1]], [[Y:%.*]]
; CHECK-NEXT:    [[T:%.*]] = trunc i32 [[SHL]] to i16
; CHECK-NEXT:    ret i16 [[T]]
;
  %conv = sext i16 %x to i32
  %shl = shl i32 %conv, %y
  %t = trunc i32 %shl to i16
  ret i16 %t
}

define i5 @sext_shl_trunc_smaller(i16 %x, i32 %y) {
; CHECK-LABEL: @sext_shl_trunc_smaller(
; CHECK-NEXT:    [[CONV1:%.*]] = zext i16 [[X:%.*]] to i32
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 [[CONV1]], [[Y:%.*]]
; CHECK-NEXT:    [[T:%.*]] = trunc i32 [[SHL]] to i5
; CHECK-NEXT:    ret i5 [[T]]
;
  %conv = sext i16 %x to i32
  %shl = shl i32 %conv, %y
  %t = trunc i32 %shl to i5
  ret i5 %t
}

; negative test - demanding 1 high-bit too many to change the extend

define i17 @sext_shl_trunc_larger(i16 %x, i32 %y) {
; CHECK-LABEL: @sext_shl_trunc_larger(
; CHECK-NEXT:    [[CONV:%.*]] = sext i16 [[X:%.*]] to i32
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 [[CONV]], [[Y:%.*]]
; CHECK-NEXT:    [[T:%.*]] = trunc i32 [[SHL]] to i17
; CHECK-NEXT:    ret i17 [[T]]
;
  %conv = sext i16 %x to i32
  %shl = shl i32 %conv, %y
  %t = trunc i32 %shl to i17
  ret i17 %t
}

define i32 @sext_shl_mask(i16 %x, i32 %y) {
; CHECK-LABEL: @sext_shl_mask(
; CHECK-NEXT:    [[CONV1:%.*]] = zext i16 [[X:%.*]] to i32
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 [[CONV1]], [[Y:%.*]]
; CHECK-NEXT:    [[T:%.*]] = and i32 [[SHL]], 65535
; CHECK-NEXT:    ret i32 [[T]]
;
  %conv = sext i16 %x to i32
  %shl = shl i32 %conv, %y
  %t = and i32 %shl, 65535
  ret i32 %t
}

; negative test - demanding a bit that could change with sext

define i32 @sext_shl_mask_higher(i16 %x, i32 %y) {
; CHECK-LABEL: @sext_shl_mask_higher(
; CHECK-NEXT:    [[CONV:%.*]] = sext i16 [[X:%.*]] to i32
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 [[CONV]], [[Y:%.*]]
; CHECK-NEXT:    [[T:%.*]] = and i32 [[SHL]], 65536
; CHECK-NEXT:    ret i32 [[T]]
;
  %conv = sext i16 %x to i32
  %shl = shl i32 %conv, %y
  %t = and i32 %shl, 65536
  ret i32 %t
}

; May need some, but not all of the bits set by the 'or'.

define i32 @set_shl_mask(i32 %x, i32 %y) {
; CHECK-LABEL: @set_shl_mask(
; CHECK-NEXT:    [[Z:%.*]] = or i32 [[X:%.*]], 65537
; CHECK-NEXT:    [[S:%.*]] = shl i32 [[Z]], [[Y:%.*]]
; CHECK-NEXT:    [[R:%.*]] = and i32 [[S]], 65536
; CHECK-NEXT:    ret i32 [[R]]
;
  %z = or i32 %x, 196609
  %s = shl i32 %z, %y
  %r = and i32 %s, 65536
  ret i32 %r
}

; PR50341

define i8 @must_drop_poison(i32 %x, i32 %y)  {
; CHECK-LABEL: @must_drop_poison(
; CHECK-NEXT:    [[S:%.*]] = shl i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[T:%.*]] = trunc i32 [[S]] to i8
; CHECK-NEXT:    ret i8 [[T]]
;
  %a = and i32 %x, 255
  %s = shl nuw nsw i32 %a, %y
  %t = trunc i32 %s to i8
  ret i8 %t
}

; This would infinite loop with D110170 / bb9333c3504a

define i32 @f_t15_t01_t09(i40 %t2) {
; CHECK-LABEL: @f_t15_t01_t09(
; CHECK-NEXT:    [[SH_DIFF:%.*]] = ashr i40 [[T2:%.*]], 15
; CHECK-NEXT:    [[TR_SH_DIFF:%.*]] = trunc i40 [[SH_DIFF]] to i32
; CHECK-NEXT:    [[SHL1:%.*]] = and i32 [[TR_SH_DIFF]], -65536
; CHECK-NEXT:    ret i32 [[SHL1]]
;
  %downscale = ashr i40 %t2, 31
  %resize = trunc i40 %downscale to i32
  %shl1 = shl i32 %resize, 16
  %resize1 = ashr i32 %shl1, 16
  %r = shl i32 %resize1, 31
  ret i32 %shl1
}
