/***************************************************************
 * Name:      dxcalendarpickerctrl.h
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2020
 * License:   GPL3
 **************************************************************/

#ifndef DXCALENDARPICKERCTRL_H
#define DXCALENDARPICKERCTRL_H

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif
#include "dxcalendarctrl.h"

class DateDialog: public wxDialog
{
    DECLARE_DYNAMIC_CLASS(DateDialog)
public:
    DateDialog() {}
    DateDialog(wxWindow *parent, const wxDateTime &date);

    wxDateTime date() const;
private:
    dxCalendar *m_calendar;

    void OnCalendarMonthYear(wxCalendarEvent& event);
    void OnCalendarDoubleclick(wxCalendarEvent& event);
};

class dxCalendarPickerCtrl: public wxPanel
{
    DECLARE_EVENT_TABLE()
public:
    dxCalendarPickerCtrl(wxWindow *parent, const wxDateTime &date);

    wxDateTime date() const;
    void setDate(const wxDateTime &date);
private:
    wxBoxSizer *m_mainSizer;
    wxStaticText *m_text;
    wxBitmapButton *m_select;
    wxDateTime m_date;

    void OnSelect(wxCommandEvent &event);
};

#endif  /* DXCALENDARPICKERCTRL_H */

