/***************************************************************
 * Name:      dxsettings.h
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2020
 * License:   GPL3
 **************************************************************/

#ifndef DXSETTINGS_H
#define DXSETTINGS_H

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif
#include "filters/filter.h"

#define dxsettings dxSettings::instance()

class dxSettings
{
public:
    dxSettings();
//    dxSettings(const dxSettings &s);
    ~dxSettings();

    static dxSettings &instance();
    void load();
    void save();
    bool startOnLogin() const;
    void setStartOnLogin(bool startOnLogin);
    bool startAtTray() const;
    void setStartAtTray(bool startAtTray);
    bool hideTrayIcon() const;
    void setHideTrayIcon(bool hideTrayIcon);
    int x() const;
    void setX(int x);
    int y() const;
    void setY(int y);
    int w() const;
    void setW(int w);
    int h() const;
    void setH(int h);
    int look() const;
    void setLook(int look);
    wxColour calForeground() const;
    void setCalForeground(const wxColour &calForeground);
    wxColour calBackground() const;
    void setCalBackground(const wxColour &calBackground);
    wxColour calHighlightFg() const;
    void setCalHighlightFg(const wxColour &calHighlightFg);
    wxColour calHighlightBg() const;
    void setCalHighlightBg(const wxColour &calHighlightBg);
    wxColour calHolidayFg() const;
    void setCalHolidayFg(const wxColour &calHolidayFg);
    wxColour calHolidayBg() const;
    void setCalHolidayBg(const wxColour &calHolidayBg);
    bool iconize() const;
    void setIconize(bool iconize);
    wxColour calReminder() const;
    void setCalReminder(const wxColour &calReminder);
    int colDateWidth() const;
    void setColDateWidth(int colDateWidth);
    bool colDateShow() const;
    void setColDateShow(bool colDateShow);
    int colReminderWidth() const;
    void setColReminderWidth(int colReminderWidth);
    bool colReminderShow() const;
    void setColReminderShow(bool colReminderShow);
    int colRecurrenceWidth() const;
    void setColRecurrenceWidth(int colRecurrenceWidth);
    bool colRecurrenceShow() const;
    void setColRecurrenceShow(bool colRecurrenceShow);
    wxString dateFormat() const;
    void setDateFormat(const wxString &dateFormat);
    wxString timeFormat() const;
    void setTimeFormat(const wxString &timeFormat);
    bool useAMPM() const;
    void setUseAMPM(bool useAMPM);
    bool resize() const;
    void setResize(bool resize);
    int dateLayout() const;
    void setDateLayout(int dateLayout);
    wxColour calRecurrence() const;
    void setCalRecurrence(const wxColour &calRecurrence);
    bool encrypt() const;
    void setEncrypt(bool encrypt);
    bool showNote() const;
    void setShowNote(bool showNote);
    wxString pk() const;
    void setPk(const wxString &pk);
    bool easternMonday() const;
    void setEasternMonday(bool easternMonday);
    bool easternFriday() const;
    void setEasternFriday(bool easternFriday);
    wxColour calWeekendFg() const;
    void setCalWeekendFg(const wxColour &calWeekendFg);
    wxColour calWeekendBg() const;
    void setCalWeekendBg(const wxColour &calWeekendBg);
    wxString locale() const;
    void setLocale(const wxString &locale);
    int colEventWidth() const;
    void setColEventWidth(int colEventWidth);
    bool remindHoliday() const;
    void setRemindHoliday(bool remindHoliday);
    int remindHolidayDays() const;
    void setRemindHolidayDays(int remindHolidayDays);
    wxDateTime remindHolidayTime() const;
    void setRemindHolidayTime(const wxDateTime &remindHolidayTime);
    wxDateTime remindHolidayLast() const;
    void setRemindHolidayLast(const wxDateTime &remindHolidayLast);
    int easternMondayReminded() const;
    void setEasternMondayReminded(int easternMondayReminded);
    int easternFridayReminded() const;
    void setEasternFridayReminded(int easternFridayReminded);
    wxString calFont() const;
    void setCalFont(const wxString &calFont);
    wxString calMiniFont() const;
    void setCalMiniFont(const wxString &calMiniFont);
    wxColour oddMonth() const;
    void setOddMonth(const wxColour &oddMonth);
    wxColour evenMonth() const;
    void setEvenMonth(const wxColour &evenMonth);
    bool disableColors() const;
    void setDisableColors(bool disableColors);
    wxString eventsFont() const;
    void setEventsFont(const wxString &eventsFont);
    bool silentMode() const;
    void setSilentMode(bool silentMode);
    bool notaskbar() const;
    void setNotaskbar(bool notaskbar);
    wxColour highlightFg() const;
    void setHighlightFg(const wxColour &highlightFg);
    wxColour highlightBg1() const;
    void setHighlightBg1(const wxColour &highlightBg1);
    bool closeDayDialog() const;
    void setCloseDayDialog(bool closeDayDialog);
    int reminderTime() const;
    void setReminderTime(int reminderTime);
    wxDateTime reminderPresetTime() const;
    void setReminderPresetTime(const wxDateTime &reminderPresetTime);
    int reminderMinutes() const;
    void setReminderMinutes(int reminderMinutes);
    bool rightclickNewevent() const;
    void setRightclickNewevent(bool rightclickNewevent);
    int daydialogW() const;
    void setDaydialogW(int daydialogW);
    int daydialogH() const;
    void setDaydialogH(int daydialogH);
    bool calendarToday() const;
    void setCalendarToday(bool calendarToday);
    bool showWeekNumber() const;
    void setShowWeekNumber(bool showWeekNumber);
    wxColour highlightBg2() const;
    void setHighlightBg2(const wxColour &highlightBg2);
    wxColour highlightBg3() const;
    void setHighlightBg3(const wxColour &highlightBg3);
    wxColour highlightBg4() const;
    void setHighlightBg4(const wxColour &highlightBg4);
    bool filter() const;
    void setFilter(bool filter);
    wxString eventfilterValue() const;
    void setEventfilterValue(const wxString &eventfilterValue);
    bool eventfilterUsage() const;
    void setEventfilterUsage(bool eventfilterUsage);
    wxDateTime datefilterValue() const;
    void setDatefilterValue(const wxDateTime &datefilterValue);
    bool datefilterUsage() const;
    void setDatefilterUsage(bool datefilterUsage);
    bool reminderfilterUsage() const;
    void setReminderfilterUsage(bool reminderfilterUsage);
    bool recurrencefilterUsage() const;
    void setRecurrencefilterUsage(bool recurrencefilterUsage);
    int eventfilterAction() const;
    void setEventfilterAction(int eventfilterAction);
    int datefilterAction() const;
    void setDatefilterAction(int datefilterAction);
    int recurrencefilterValue() const;
    void setRecurrencefilterValue(int recurrencefilterValue);
    Reminder reminderfilterValue() const;
    void setReminderfilterValue(const Reminder &reminderfilterValue);
    int reminderfilterAction() const;
    void setReminderfilterAction(int reminderfilterAction);
    int timefilterYears() const;
    void setTimefilterYears(int timefilterYears);
    int timefilterMonths() const;
    void setTimefilterMonths(int timefilterMonths);
    int timefilterWeeks() const;
    void setTimefilterWeeks(int timefilterWeeks);
    int timefilterDays() const;
    void setTimefilterDays(int timefilterDays);
    int timefilterHours() const;
    void setTimefilterHours(int timefilterHours);
    int timefilterMinutes() const;
    void setTimefilterMinutes(int timefilterMinutes);
    bool timefilterUsage() const;
    void setTimefilterUsage(bool timefilterUsage);
    wxColour highlightBg5() const;
    void setHighlightBg5(const wxColour &highlightBg5);
    bool hiddenfilterUsage() const;
    void setHiddenfilterUsage(bool hiddenfilterUsage);
    bool alwaysNone() const;
    void setAlwaysNone(bool alwaysNone);
    int defaultReminder() const;
    void setDefaultReminder(int defaultReminder);
    int defaultRecurrence() const;
    void setDefaultRecurrence(int defaultRecurrence);
    int lastFilter() const;
    void setLastFilter(int lastFilter);
    bool alwaysOncenotdelete() const;
    void setAlwaysOncenotdelete(bool alwaysOncenotdelete);
    bool hideDonotdelete() const;
    void setHideDonotdelete(bool hideDonotdelete);
    wxString shortcutKey(int id);
    bool hidden() const;
    void setHidden(bool newHidden);

private:
    bool m_startOnLogin;
    bool m_startAtTray;
    bool m_hideTrayIcon;
    bool m_silentMode;
    bool m_encrypt;
    wxString m_pk;
    bool m_closeDayDialog;
    bool m_rightclickNewevent;
    int m_x;
    int m_y;
    int m_w;
    int m_h;
    bool m_iconize;
    bool m_notaskbar;
    int m_look;
    bool m_resize;
    bool m_showNote;
    int m_daydialogW;
    int m_daydialogH;
    wxColor m_calForeground;
    wxColor m_calBackground;
    wxColor m_calHighlightFg;
    wxColor m_calHighlightBg;
    wxColor m_calWeekendFg;
    wxColor m_calWeekendBg;
    wxColor m_calHolidayFg;
    wxColor m_calHolidayBg;
    wxColor m_calReminder;
    wxColor m_calRecurrence;
    wxString m_calFont;
    wxString m_calMiniFont;
    bool m_showWeekNumber;
    int m_colEventWidth;
    int m_colDateWidth;
    bool m_colDateShow;
    int m_colReminderWidth;
    bool m_colReminderShow;
    int m_colRecurrenceWidth;
    bool m_colRecurrenceShow;
    wxColor m_oddMonth;
    wxColor m_evenMonth;
    wxColor m_highlightFg;
    wxColor m_highlightBg1;
    wxColor m_highlightBg2;
    wxColor m_highlightBg3;
    wxColor m_highlightBg4;
    wxColor m_highlightBg5;
    bool m_disableColors;
    wxString m_eventsFont;
    bool m_alwaysNone;
    bool m_alwaysOncenotdelete;
    bool m_hideDonotdelete;
    int m_dateLayout;
    wxString m_dateFormat;
    wxString m_timeFormat;
    bool m_useAMPM;
    bool m_easternMonday;
    bool m_easternFriday;
    wxString m_locale;
    bool m_remindHoliday;
    int m_remindHolidayDays;
    wxDateTime m_remindHolidayTime;
    wxDateTime m_remindHolidayLast;
    int m_easternMondayReminded;
    int m_easternFridayReminded;
    /**
     * @brief m_reminderTime
     * 0 - current time
     * 1 - preset time
     * 2 - "X" minutes ahead from now
     */
    int m_reminderTime;
    wxDateTime m_reminderPresetTime;
    int m_reminderMinutes;
    bool m_calendarToday;
    bool m_filter;
    bool m_hidden;
    int m_eventfilterAction;
    wxString m_eventfilterValue;
    bool m_eventfilterUsage;
    int m_datefilterAction;
    wxDateTime m_datefilterValue;
    bool m_datefilterUsage;
    int m_reminderfilterAction;
    Reminder m_reminderfilterValue;
    bool m_reminderfilterUsage;
    int m_recurrencefilterValue;
    bool m_recurrencefilterUsage;
    int m_timefilterYears;
    int m_timefilterMonths;
    int m_timefilterWeeks;
    int m_timefilterDays;
    int m_timefilterHours;
    int m_timefilterMinutes;
    bool m_timefilterUsage;
    bool m_hiddenfilterUsage;
    int m_lastFilter;
    int m_defaultReminder;
    int m_defaultRecurrence;

    wxString makePK();
};

#endif // DXSETTINGS_H
