/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.document.view;

import ancestris.api.imports.Import;
import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.actions.AncestrisAPIEntry;
import ancestris.core.resources.Images;
import ancestris.modules.document.view.AbstractDocumentView;
import ancestris.util.swing.FileChooserBuilder;
import ancestris.view.SelectionDispatcher;
import genj.fo.Format;
import genj.fo.HTMLFormat;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.io.FileAssociation;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.w3c.dom.Document;

public class FopDocumentView
extends AbstractDocumentView {
    private File tempfile = null;
    private genj.fo.Document document = null;
    private Preferences preferences = null;
    private JEditorPane editorPane = new JEditorPane();
    private Runnable runnable = null;

    public FopDocumentView(Context context, String title, String tooltip) {
        this(context, title, tooltip, new AbstractAncestrisAction[0]);
    }

    public FopDocumentView(Context context, String title, String tooltip, AbstractAncestrisAction[] action) {
        super(context, title, tooltip);
        this.editorPane.setEditable(false);
        this.editorPane.setName(title);
        this.setView(this.editorPane);
        if (action == null) {
            action = new AbstractAncestrisAction[]{};
        }
        Action[] listOfActions = new Action[1 + action.length];
        listOfActions[0] = new ActionSave();
        for (int i = 1; i < listOfActions.length; ++i) {
            listOfActions[i] = action[i - 1];
        }
        this.setToolbarActions(listOfActions);
    }

    public void displayDocument(genj.fo.Document doc, Preferences preferences) {
        HTMLFormat htmlFormatter = new HTMLFormat();
        Document domDoc = doc.getDomDoc();
        this.document = doc;
        this.preferences = preferences;
        try {
            this.tempfile = File.createTempFile("name", ".html");
            htmlFormatter.format(this.document, this.tempfile);
            this.document.setDomDoc(domDoc);
            this.editorPane.setPage(this.tempfile.toURI().toURL());
        }
        catch (IOException e) {
            Import.LOG.log(Level.WARNING, "formatting " + doc + " failed", e);
        }
        this.editorPane.addHyperlinkListener(new Hyperactive());
    }

    @Override
    protected void closeNotify() {
        if (this.tempfile != null) {
            this.tempfile.delete();
            super.closeNotify();
        }
        if (this.runnable != null) {
            this.runnable.run();
        }
    }

    public void executeOnClose(Runnable runnable) {
        this.runnable = runnable;
    }

    private class ActionSave
    extends AbstractAncestrisAction {
        protected ActionSave() {
            this.setImage((Icon)Images.imgSave);
            this.setTip(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TITL_SaveDocument", (Object)""));
        }

        public void actionPerformed(ActionEvent event) {
            Format[] formats = Format.getFormats();
            HashMap<String, String> fmts = new HashMap<String, String>();
            for (Format format : formats) {
                if (!format.supports(FopDocumentView.this.document)) continue;
                fmts.put(format.getFormat(), format.getFileExtension());
            }
            String fileName = ancestris.util.Utilities.removeDiacriticsUnderscore((String)FopDocumentView.this.document.getTitle());
            File f = new File(fileName);
            FileChooserBuilder fcb = new FileChooserBuilder(FopDocumentView.class).setFilesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TITL_SaveDocument", (Object)FopDocumentView.this.document.getTitle())).setApproveText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"OK_Button")).setDefaultExtension(formats[0].getFileExtension()).setFileFilters(fmts).setAcceptAllFileFilterUsed(false).setDefaultDirAsReportDirectory().setSelectedFile(f).setFileHiding(true);
            File file = fcb.showSaveDialog();
            if (file == null) {
                return;
            }
            Format formatter = Format.getFormatFromExtension((String)FileChooserBuilder.getExtension((String)file.getName()));
            try {
                file.getParentFile().mkdirs();
                formatter.format(FopDocumentView.this.document, file);
                fileName = file.getCanonicalPath();
                if (!fileName.equals("")) {
                    FopDocumentView.this.preferences.put("documentFilename", fileName);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                FileAssociation.getDefault().execute(file.getAbsolutePath());
            }
            catch (Throwable t) {
                Logger.getLogger("ancestris.modules.document.view").log(Level.INFO, "cannot open " + file, t);
            }
        }
    }

    private static class Hyperactive
    implements HyperlinkListener {
        private Hyperactive() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    String description = e.getDescription();
                    if (description.startsWith("#") && description.contains(Property.DELIMITER_IN_ANCHOR)) {
                        Gedcom myGedcom;
                        Context context = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
                        if (context != null && (myGedcom = context.getGedcom()) != null) {
                            String[] bits = description.substring(1).split(Property.DELIMITER_IN_ANCHOR_REGEX);
                            String linkedTag = bits.length > 0 ? bits[0] : "";
                            String linkedId = bits.length > 1 ? bits[1] : "";
                            String linkedTagpath = bits.length > 2 ? bits[2] : "";
                            Entity entity = null;
                            if (!linkedId.isEmpty()) {
                                entity = !linkedTag.isEmpty() ? myGedcom.getEntity(linkedTag, linkedId) : myGedcom.getEntity(linkedId);
                            } else if (!linkedTag.isEmpty()) {
                                entity = myGedcom.getFirstEntity(linkedTag);
                            }
                            if (entity != null) {
                                if (!linkedTagpath.isEmpty()) {
                                    Property property = entity.getPropertyByPath(linkedTagpath);
                                    SelectionDispatcher.fireSelection((Context)new Context(property));
                                } else {
                                    SelectionDispatcher.fireSelection((Context)new Context(entity));
                                }
                            }
                        }
                    } else if (description.startsWith("#") && description.contains("*")) {
                        Gedcom myGedcom;
                        Context context = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
                        if (context != null && (myGedcom = context.getGedcom()) != null) {
                            AncestrisAPIEntry api;
                            String[] bits = description.substring(1).split("\\*");
                            String linkedTag = bits.length > 0 ? bits[0] : "";
                            String linkedId = bits.length > 1 ? bits[1] : "";
                            String linkedView = bits.length > 2 ? bits[2] : "";
                            String linkedCommand = bits.length > 2 ? bits[3] : "";
                            Entity entity = null;
                            if (!linkedId.isEmpty()) {
                                entity = !linkedTag.isEmpty() ? myGedcom.getEntity(linkedTag, linkedId) : myGedcom.getEntity(linkedId);
                            } else if (!linkedTag.isEmpty()) {
                                entity = myGedcom.getFirstEntity(linkedTag);
                            }
                            if (entity != null && (api = AncestrisAPIEntry.Factory.lookupAll((String)linkedView, (Gedcom)myGedcom, (boolean)true)) != null) {
                                api.processAction(linkedCommand, entity);
                            }
                        }
                    } else {
                        try {
                            pane.setPage(e.getURL());
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

