/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.document.view;

import ancestris.modules.document.view.DocumentViewTopComponent;
import ancestris.modules.document.view.HyperLinkTextPane;
import genj.gedcom.Context;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class AbstractDocumentView
extends JPanel {
    private transient JScrollPane scrollPane = null;
    private Action[] actions = null;
    private Context context;
    private Point lastPoint;

    private AbstractDocumentView() {
        this.setFocusCycleRoot(true);
        this.scrollPane = new JScrollPane();
        this.scrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                AbstractDocumentView.this.lastPoint = e.getPoint();
                AbstractDocumentView.this.scrollPane.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                AbstractDocumentView.this.scrollPane.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.scrollPane.addMouseMotionListener(new MouseMotionAdapter(){
            private final JScrollBar hSb;
            private final JScrollBar vSb;
            {
                this.hSb = AbstractDocumentView.this.scrollPane.getHorizontalScrollBar();
                this.vSb = AbstractDocumentView.this.scrollPane.getVerticalScrollBar();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                int dX = AbstractDocumentView.this.lastPoint.x - e.getX();
                int dY = AbstractDocumentView.this.lastPoint.y - e.getY();
                this.hSb.setValue(this.hSb.getValue() + dX);
                this.vSb.setValue(this.vSb.getValue() + dY);
                AbstractDocumentView.this.lastPoint = e.getPoint();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
    }

    public AbstractDocumentView(Context context, String title, String tooltip) {
        this();
        this.context = context;
        this.setName(title);
        this.setToolTipText(tooltip);
        this.setView(null);
        this.setToolbarActions(null);
        this.init();
    }

    final void init() {
        DocumentViewTopComponent.findInstance().addPanel(this);
    }

    public Context getContext() {
        return this.context;
    }

    public final void setView(JComponent component) {
        if (component == null) {
            component = new JLabel(NbBundle.getMessage(AbstractDocumentView.class, (String)"nocontent"));
        }
        this.scrollPane.setViewportView(component);
        this.setPrintable(component);
        if (component instanceof HyperLinkTextPane) {
            HyperLinkTextPane hyperLinkTextPane;
            HyperLinkTextPane hltp = hyperLinkTextPane = (HyperLinkTextPane)component;
            WindowManager.getDefault().invokeWhenUIReady(() -> {
                hltp.setCaretPosition(0);
                this.validate();
                this.repaint();
            });
        }
        this.validate();
    }

    private void setPrintable(JComponent component) {
        Component[] children;
        if (component.isShowing() && !(component instanceof JScrollPane) && !(component instanceof JScrollBar)) {
            component.putClientProperty("print.printable", Boolean.TRUE);
        }
        for (Component child : children = component.getComponents()) {
            if (!(child instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)child;
            this.setPrintable(jComponent);
        }
    }

    protected void setToolbar() {
        Component oldTb = ((BorderLayout)this.getLayout()).getLayoutComponent("West");
        if (oldTb != null) {
            this.remove(oldTb);
        }
        if (this.actions != null) {
            JToolBar toolBar = new JToolBar(1);
            toolBar.setFloatable(false);
            for (Action a : this.actions) {
                toolBar.add(a);
            }
            this.add((Component)toolBar, "West");
        }
        this.validate();
    }

    public final void setToolbarActions(Action[] actions) {
        this.actions = actions == null ? null : (Action[])actions.clone();
        this.setToolbar();
        this.validate();
    }

    public Action[] getToolbarActions() {
        return this.actions == null ? null : (Action[])this.actions.clone();
    }

    public void close() {
        DocumentViewTopComponent.findInstance().removePanel(this);
        this.closeNotify();
    }

    protected void closeNotify() {
        if (this.scrollPane != null) {
            this.scrollPane.setViewport(null);
        }
    }
}

