/*
 * Decompiled with CFR 0.152.
 */
package ancestris.welcome.content;

import ancestris.welcome.content.BundleSupport;
import ancestris.welcome.content.Constants;
import ancestris.welcome.content.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.awt.StatusDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class Logo
extends JPanel
implements Constants,
MouseListener {
    private String url;

    public static Logo createAncestrisLogo() {
        return new Logo("ancestris/welcome/resources/ancestris_logo_small.png", BundleSupport.getURL("AncestrisLogo"), BundleSupport.getLabel("AncestrisLogo_tip"));
    }

    public static Logo createAncestrisIcon() {
        return new Logo("ancestris/welcome/resources/ancestris_icon48.png", BundleSupport.getURL("AncestrisIcon"), BundleSupport.getLabel("AncestrisIcon_tip"));
    }

    public Logo(String img, String url, String tip) {
        super(new BorderLayout());
        ImageIcon image = ImageUtilities.loadImageIcon((String)img, (boolean)true);
        JLabel label = new JLabel(image);
        label.setBorder(BorderFactory.createEmptyBorder());
        label.setOpaque(false);
        label.addMouseListener(this);
        label.setToolTipText(tip);
        this.setOpaque(false);
        this.add((Component)label, "Center");
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.url = url;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        LogRecord rec = new LogRecord(Level.INFO, "USG_START_PAGE_LINK");
        rec.setParameters(new Object[]{this.url});
        rec.setLoggerName(Constants.USAGE_LOGGER.getName());
        rec.setResourceBundle(NbBundle.getBundle((String)"ancestris.welcome.resources.Bundle"));
        rec.setResourceBundleName("ancestris.welcome.resources.Bundle");
        Constants.USAGE_LOGGER.log(rec);
        Utils.showURL(this.url);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        StatusDisplayer.getDefault().setStatusText(this.url);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        StatusDisplayer.getDefault().setStatusText(null);
    }
}

