/*
 * Decompiled with CFR 0.152.
 */
package ancestris.api.place;

import ancestris.api.place.Place;
import ancestris.core.TextOptions;
import genj.gedcom.PropertyLatitude;
import genj.gedcom.PropertyLongitude;
import genj.gedcom.PropertyPlace;
import java.text.DecimalFormat;
import org.jxmapviewer.viewer.GeoPosition;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class PlaceFactory
implements Place {
    private static String SEP = ";";
    private PropertyPlace propertyPlace = null;
    private Double latitude = (double)Math.round(Double.valueOf(TextOptions.getInstance().defaultLatitude()) * 100000.0) / 100000.0;
    private Double longitude = (double)Math.round(Double.valueOf(TextOptions.getInstance().defaultLongitude()) * 100000.0) / 100000.0;
    private Long population = 0L;
    private String name = "";
    private String countryCode = "";
    private String countryName = "";
    private String[] adminCodes = new String[]{"", "", "", "", ""};
    private String[] adminNames = new String[]{"", "", "", "", ""};
    private String timezoneId = "";
    private String timezoneGmtOffset = "";

    public PlaceFactory(PropertyPlace pPlace) {
        if (pPlace == null) {
            return;
        }
        this.propertyPlace = pPlace;
        this.setValues(PlaceFactory.getValues(pPlace.getPlaceToLocalFormat()));
        PropertyLatitude pLat = this.propertyPlace.getLatitude(true);
        PropertyLongitude pLon = this.propertyPlace.getLongitude(true);
        if (pLat != null && pLat.isValid()) {
            this.latitude = pLat.getDoubleValue();
        }
        if (pLon != null && pLon.isValid()) {
            this.longitude = pLon.getDoubleValue();
        }
        if (this.name.isEmpty()) {
            this.name = pPlace.getCity();
        }
    }

    public PlaceFactory(PropertyPlace pPlace, GeoPosition geoPoint) {
        this.propertyPlace = pPlace;
        this.setValues(PlaceFactory.getValues(pPlace.getPlaceToLocalFormat()));
        this.latitude = geoPoint.getLatitude();
        this.longitude = geoPoint.getLongitude();
    }

    private PlaceFactory(PropertyPlace pPlace, String value) {
        this.propertyPlace = pPlace;
        this.setValues(value);
    }

    public static Place getLocalPlace(PropertyPlace pPlace) {
        if (pPlace == null) {
            return null;
        }
        String value = PlaceFactory.getValues(pPlace.getPlaceToLocalFormat());
        if (value == null || value.isEmpty()) {
            return null;
        }
        return new PlaceFactory(pPlace, value);
    }

    public static void putLocalPlace(PropertyPlace pPlace, Place place) {
        if (place == null) {
            throw new UnsupportedOperationException("PlaceFactory - null place.");
        }
        String key = pPlace.getPlaceToLocalFormat();
        StringBuilder sb = new StringBuilder();
        sb.append(place.getLatitude()).append(SEP);
        sb.append(place.getLongitude()).append(SEP);
        sb.append(place.getPopulation()).append(SEP);
        sb.append(place.getCountryCode()).append(SEP);
        sb.append(place.getAdminCode(1)).append(SEP);
        sb.append(place.getAdminCode(2)).append(SEP);
        sb.append(place.getAdminCode(3)).append(SEP);
        sb.append(place.getAdminCode(4)).append(SEP);
        sb.append(place.getAdminCode(5)).append(SEP);
        sb.append(place.getName()).append(SEP);
        sb.append(place.getAdminName(1)).append(SEP);
        sb.append(place.getAdminName(2)).append(SEP);
        sb.append(place.getAdminName(3)).append(SEP);
        sb.append(place.getAdminName(4)).append(SEP);
        sb.append(place.getAdminName(5)).append(SEP);
        sb.append(place.getCountryName()).append(SEP);
        sb.append(place.getTimeZoneId()).append(SEP);
        sb.append(place.getTimeZoneGmtOffset());
        String value = sb.toString();
        PlaceFactory.putValues(key, value);
    }

    private void setValues(String value) {
        if (value == null) {
            return;
        }
        try {
            String[] bits = value.split(SEP);
            int max = bits.length;
            int i = 0;
            if (i < max) {
                this.latitude = Double.valueOf(bits[i++]);
            }
            if (i < max) {
                this.longitude = Double.valueOf(bits[i++]);
            }
            if (i < max) {
                this.population = Long.valueOf(bits[i++]);
            }
            if (i < max) {
                this.countryCode = bits[i++];
            }
            if (i < max) {
                this.adminCodes[0] = bits[i++];
            }
            if (i < max) {
                this.adminCodes[1] = bits[i++];
            }
            if (i < max) {
                this.adminCodes[2] = bits[i++];
            }
            if (i < max) {
                this.adminCodes[3] = bits[i++];
            }
            if (i < max) {
                this.adminCodes[4] = bits[i++];
            }
            if (i < max) {
                this.name = bits[i++];
            }
            if (i < max) {
                this.adminNames[0] = bits[i++];
            }
            if (i < max) {
                this.adminNames[1] = bits[i++];
            }
            if (i < max) {
                this.adminNames[2] = bits[i++];
            }
            if (i < max) {
                this.adminNames[3] = bits[i++];
            }
            if (i < max) {
                this.adminNames[4] = bits[i++];
            }
            if (i < max) {
                this.countryName = bits[i++];
            }
            if (i < max) {
                this.timezoneId = bits[i++];
            }
            if (i < max) {
                this.timezoneGmtOffset = bits[i++];
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static String getValues(String key) {
        return NbPreferences.forModule(PlaceFactory.class).get(key, null);
    }

    private static void putValues(String key, String value) {
        NbPreferences.forModule(PlaceFactory.class).put(key, value);
    }

    public static String buildInfo(Place place) {
        String spa = " ";
        String sep = "   \n";
        String name = place.getName() == null ? NbBundle.getMessage(PlaceFactory.class, (String)"TXT_UNKNOWN") : place.getName();
        StringBuilder str = new StringBuilder();
        String timezone = place.getTimeZoneId() + " (" + place.getTimeZoneGmtOffset() + ")";
        str.append(NbBundle.getMessage(PlaceFactory.class, (String)"TXT_Name")).append(spa).append(name).append(sep);
        str.append(NbBundle.getMessage(PlaceFactory.class, (String)"TXT_Coord")).append(spa).append(PlaceFactory.getTextCoordinates(place)).append(sep);
        str.append(NbBundle.getMessage(PlaceFactory.class, (String)"TXT_Time")).append(spa).append(timezone).append(sep);
        str.append(sep);
        str.append(NbBundle.getMessage(PlaceFactory.class, (String)"TXT_CdInsee")).append(spa).append(PlaceFactory.dispName(place.getAdminCode(4))).append(sep);
        str.append(NbBundle.getMessage(PlaceFactory.class, (String)"TXT_Distri")).append(spa).append(PlaceFactory.dispName(place.getAdminName(4))).append(" (").append(PlaceFactory.dispName(place.getAdminCode(3))).append(")").append(sep);
        str.append(NbBundle.getMessage(PlaceFactory.class, (String)"TXT_Dept")).append(spa).append(PlaceFactory.dispName(place.getAdminName(2))).append(" (").append(PlaceFactory.dispName(place.getAdminCode(2))).append(")").append(sep);
        str.append(NbBundle.getMessage(PlaceFactory.class, (String)"TXT_Region")).append(spa).append(PlaceFactory.dispName(place.getAdminName(1))).append(" (").append(PlaceFactory.dispName(place.getAdminCode(1))).append(")").append(sep);
        str.append(NbBundle.getMessage(PlaceFactory.class, (String)"TXT_Cntry")).append(spa).append(PlaceFactory.dispName(place.getCountryName())).append(sep);
        str.append(sep);
        str.append(NbBundle.getMessage(PlaceFactory.class, (String)"TXT_Pop")).append(spa).append(place.getPopulation());
        str.append(sep);
        str.append(" ");
        return str.toString();
    }

    private static String dispName(String str) {
        return str == null || str.isEmpty() ? "-" : str;
    }

    private static String getTextCoordinates(Place place) {
        Double lat = place.getLatitude();
        Double lon = place.getLongitude();
        char we = 'E';
        char ns = 'N';
        if (lat < 0.0) {
            lat = -lat.doubleValue();
            ns = 'S';
        }
        if (lon < 0.0) {
            lon = -lon.doubleValue();
            we = 'W';
        }
        DecimalFormat format = new DecimalFormat("0.0");
        return ns + format.format(lat) + " " + we + format.format(lon);
    }

    public String toString() {
        return "PropPlace:" + this.propertyPlace.getDisplayValue() + "; Name: " + this.getName() + " ;CC: " + this.getCountryCode() + "; AC1: " + this.getAdminCode(1) + "; AC2: " + this.getAdminCode(2) + "; AC3: " + this.getAdminCode(3) + "; AC4: " + this.getAdminCode(4) + "; AC5: " + this.getAdminCode(5) + "; ";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getInfo() {
        return PlaceFactory.buildInfo(this);
    }

    @Override
    public String getCountryCode() {
        return this.countryCode;
    }

    @Override
    public String getCountryName() {
        return this.countryName;
    }

    @Override
    public String getAdminCode(int level) {
        return this.adminCodes[level - 1];
    }

    @Override
    public String getAdminName(int level) {
        return this.adminNames[level - 1];
    }

    @Override
    public Double getLongitude() {
        return this.longitude;
    }

    @Override
    public Double getLatitude() {
        return this.latitude;
    }

    @Override
    public String getTimeZoneId() {
        return this.timezoneId;
    }

    @Override
    public String getTimeZoneGmtOffset() {
        return this.timezoneGmtOffset;
    }

    @Override
    public Long getPopulation() {
        return this.population;
    }

    @Override
    public String getCity() {
        if (this.propertyPlace == null) {
            return "";
        }
        return this.propertyPlace.getCity();
    }

    @Override
    public String getFirstAvailableJurisdiction() {
        if (this.propertyPlace == null) {
            return "";
        }
        return this.propertyPlace.getFirstAvailableJurisdiction();
    }

    @Override
    public String[] getFormat() {
        if (this.propertyPlace == null) {
            return null;
        }
        return this.propertyPlace.getFormat();
    }

    @Override
    public String getFormatAsString() {
        if (this.propertyPlace == null) {
            return "";
        }
        return this.propertyPlace.getFormatAsString();
    }

    @Override
    public String getJurisdiction(int hierarchyLevel) {
        if (this.propertyPlace == null) {
            return "";
        }
        return this.propertyPlace.getJurisdiction(hierarchyLevel);
    }

    @Override
    public String[] getJurisdictions() {
        if (this.propertyPlace == null) {
            return null;
        }
        return this.propertyPlace.getJurisdictions();
    }

    @Override
    public String getValueStartingWithCity() {
        if (this.propertyPlace == null) {
            return "";
        }
        return this.propertyPlace.getValueStartingWithCity();
    }

    @Override
    public void setFormatAsString(boolean global, String format) {
        if (this.propertyPlace == null) {
            return;
        }
        this.propertyPlace.setFormatAsString(global, format);
    }

    @Override
    public String getPlaceToLocalFormat() {
        if (this.propertyPlace == null) {
            return "";
        }
        return this.propertyPlace.getPlaceToLocalFormat();
    }

    @Override
    public int compareTo(Place that) {
        if (this.propertyPlace == null) {
            return -1;
        }
        return that.getValueStartingWithCity().compareToIgnoreCase(this.propertyPlace.getValueStartingWithCity());
    }
}

