/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree.output;

import ancestris.report.svgtree.IndiBox;
import ancestris.report.svgtree.filter.TreeFilter;
import ancestris.report.svgtree.filter.TreeFilterBase;
import java.util.HashMap;
import java.util.Map;

public class HorizontalLines
implements TreeFilter {
    private int levelMin = 0;
    private int levelMax = 0;
    private final Map<Integer, Integer> levelHeight = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> levelIndiHeight = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> levelFamilyHeight = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> levelCoord = new HashMap<Integer, Integer>();
    private final int spacing;

    public HorizontalLines(int spacing) {
        this.spacing = spacing;
    }

    @Override
    public void filter(IndiBox indibox) {
        this.levelMin = 0;
        this.levelMax = 0;
        this.levelHeight.clear();
        this.levelIndiHeight.clear();
        this.levelFamilyHeight.clear();
        this.levelCoord.clear();
        new DetermineLevelHeight().filter(indibox);
        int yCoord = 0;
        for (int i = this.levelMin; i <= this.levelMax; ++i) {
            this.levelCoord.put(i, yCoord);
            yCoord += this.levelHeight.get(i).intValue();
        }
        this.levelCoord.put(this.levelMax + 1, yCoord);
        new AssignCoordinates().filter(indibox);
    }

    private int getYCoord(int level) {
        return this.levelCoord.get(level);
    }

    private class DetermineLevelHeight
    extends TreeFilterBase {
        private int level = 0;

        private DetermineLevelHeight() {
        }

        @Override
        protected void preFilter(IndiBox indibox) {
            int newHeight;
            Integer height;
            int newFamilyHeight;
            Integer familyHeight;
            int newIndiHeight;
            Integer indiHeight;
            if (indibox.prev != null) {
                this.level += indibox.y;
            }
            if (this.level > HorizontalLines.this.levelMax) {
                HorizontalLines.this.levelMax = this.level;
            }
            if (this.level < HorizontalLines.this.levelMin) {
                HorizontalLines.this.levelMin = this.level;
            }
            if ((indiHeight = HorizontalLines.this.levelIndiHeight.get(this.level)) == null) {
                indiHeight = 0;
            }
            if ((newIndiHeight = indibox.height) > indiHeight) {
                indiHeight = newIndiHeight;
                HorizontalLines.this.levelIndiHeight.put(this.level, indiHeight);
            }
            if ((familyHeight = HorizontalLines.this.levelFamilyHeight.get(this.level)) == null) {
                familyHeight = 0;
            }
            int n = newFamilyHeight = indibox.family != null ? indibox.family.height : 0;
            if (newFamilyHeight > familyHeight) {
                familyHeight = newFamilyHeight;
                HorizontalLines.this.levelFamilyHeight.put(this.level, newFamilyHeight);
            }
            if ((height = HorizontalLines.this.levelHeight.get(this.level)) == null) {
                height = 0;
            }
            if ((newHeight = indiHeight + familyHeight + HorizontalLines.this.spacing * 2) > height) {
                HorizontalLines.this.levelHeight.put(this.level, newHeight);
            }
        }

        @Override
        protected void postFilter(IndiBox indibox) {
            if (indibox.prev != null) {
                this.level -= indibox.y;
            }
        }
    }

    private class AssignCoordinates
    extends TreeFilterBase {
        private int level = 0;

        private AssignCoordinates() {
        }

        @Override
        protected void preFilter(IndiBox indibox) {
            if (indibox.prev != null) {
                this.level += indibox.y;
            }
        }

        @Override
        protected void postFilter(IndiBox indibox) {
            int thisLevel = this.level;
            if (indibox.prev != null) {
                this.level -= indibox.y;
                indibox.y = HorizontalLines.this.getYCoord(thisLevel) - HorizontalLines.this.getYCoord(thisLevel - indibox.y);
            }
            indibox.hPlus = HorizontalLines.this.getYCoord(thisLevel + indibox.hPlus) - HorizontalLines.this.getYCoord(thisLevel);
            indibox.hMinus = HorizontalLines.this.getYCoord(thisLevel) - HorizontalLines.this.getYCoord(thisLevel - indibox.hMinus);
            indibox.height = HorizontalLines.this.levelIndiHeight.get(thisLevel);
            if (indibox.family != null) {
                indibox.family.height = HorizontalLines.this.levelFamilyHeight.get(thisLevel);
            }
        }
    }
}

