/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.gedcom;

import ancestris.api.imports.Import;
import ancestris.api.imports.ImportFix;
import ancestris.modules.imports.gedcom.Bundle;
import ancestris.modules.imports.gedcom.FixesWindow;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.TagPath;
import java.io.IOException;

public class ImportGeneatique
extends Import {
    public boolean isGeneric() {
        return false;
    }

    public String toString() {
        return Bundle.importgeneatique_name();
    }

    protected String getImportComment() {
        return Bundle.importgeneatique_note();
    }

    protected void init() {
        super.init();
        this.invalidPaths.add("INDI:QUAY");
        this.invalidPaths.add("INDI:PLAC");
    }

    protected void firstPass() {
        super.firstPass();
        this.GEDCOM_VERSION = "5.5.1";
    }

    protected boolean process() throws IOException {
        String tag = this.input.getTag();
        TagPath path = this.input.getPath();
        String pathBefore = path.getShortName();
        String valueBefore = this.input.getValue();
        boolean v55 = this.GEDCOM_VERSION.equals("5.5");
        if ("DECO".equalsIgnoreCase(tag)) {
            String newTag = v55 ? "EVEN" : "FACT";
            this.output.writeLine(this.input.getLevel(), newTag, valueBefore);
            this.fixes.add(new ImportFix(this.currentXref, "invalidTag.2", pathBefore, path.getParent().getShortName() + ":" + newTag, valueBefore, valueBefore));
            return true;
        }
        if (this.input.getLevel() == 1 && ("_IMA".equalsIgnoreCase(tag) || "_IMG".equalsIgnoreCase(tag))) {
            String newTag = "_PRIM";
            int startLevel = this.input.getLevel();
            this.input.getNextLine(false);
            int currentLevel = this.input.getLevel();
            while (currentLevel > startLevel) {
                this.input.getNextLine(true);
                this.output.writeLine(this.input.getLevel() - 1, this.input.getTag(), this.input.getValue());
                this.input.getNextLine(false);
                if (this.input.getLevel() > startLevel) {
                    this.output.writeLine(startLevel + 1, newTag, "Y");
                }
                currentLevel = this.input.getLevel();
            }
            this.fixes.add(new ImportFix(this.currentXref, "invalidTag.3", pathBefore, path.getParent().getShortName() + ":" + newTag, valueBefore, valueBefore));
            return true;
        }
        if (super.process()) {
            return true;
        }
        return this.processOther();
    }

    protected void finalise() throws IOException {
        super.finalise();
    }

    public boolean fixGedcom(Gedcom gedcom) {
        boolean ret = super.fixGedcom(gedcom);
        this.incrementProgress();
        return ret |= this.fixOther(gedcom);
    }

    public void complete() {
        super.complete();
    }

    public void showDetails(Context context, boolean extract) {
        new FixesWindow(this.summary, context, this.fixes).displayFixes(extract);
    }

    private boolean processOther() {
        return false;
    }

    public boolean fixOther(Gedcom gedcom) {
        return false;
    }
}

