/*
 * Decompiled with CFR 0.152.
 */
package org.miv.pherd.ntree;

import java.util.ArrayList;
import org.miv.pherd.Particle;
import org.miv.pherd.ParticleBox;
import org.miv.pherd.geom.Point3;
import org.miv.pherd.ntree.Anchor;
import org.miv.pherd.ntree.Cell;
import org.miv.pherd.ntree.CellData;
import org.miv.pherd.ntree.CellSpace;
import org.miv.pherd.ntree.NTreeListener;
import org.miv.pherd.ntree.OctreeCellSpace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NTree {
    protected ParticleBox pbox;
    protected Cell laMama;
    protected int pmax = 10;
    protected int depthmax = 100;
    protected ArrayList<NTreeListener> listeners = new ArrayList();
    protected OutOfUniverseMode oum = OutOfUniverseMode.RESIZE;
    protected boolean needResize = false;
    protected Point3 min = new Point3();
    protected Point3 max = new Point3();

    public NTree(int pmax, CellData data, ParticleBox pbox) {
        this(pmax, new OctreeCellSpace(new Anchor(-1.0, -1.0, -1.0), new Anchor(1.0, 1.0, 1.0)), data, pbox);
    }

    public NTree(int pmax, CellSpace space, CellData data, ParticleBox pbox) {
        this.pmax = pmax;
        this.pbox = pbox;
        this.laMama = new Cell(this, space, "laMama", data);
        this.min.copy(space.lo);
        this.max.copy(space.hi);
    }

    public Cell getRootCell() {
        return this.laMama;
    }

    public int getMaxParticlePerCell() {
        return this.pmax;
    }

    public int getMaxDepth() {
        return this.depthmax;
    }

    public ArrayList<NTreeListener> getListeners() {
        return this.listeners;
    }

    public OutOfUniverseMode getOutOfUniverseMode() {
        return this.oum;
    }

    public Point3 getLowestPoint() {
        return this.min;
    }

    public Point3 getHighestPoint() {
        return this.max;
    }

    public void setDepthMax(int max) {
        assert (max > 0) : "invalid max depth";
        this.depthmax = max;
        this.laMama.recompute();
    }

    public void addListener(NTreeListener listener) {
        this.listeners.add(listener);
        this.describeTheCurrentState(listener);
    }

    public void removeListener(NTreeListener listener) {
        int n = this.listeners.indexOf(listener);
        if (n >= 0) {
            this.listeners.remove(n);
        }
    }

    protected void describeTheCurrentState(NTreeListener listener) {
        this.laMama.describe(listener);
    }

    public void removeParticle(Particle particle) {
        Cell cell = particle.getCell();
        if (cell != null) {
            cell.removeParticle(particle.getId());
        }
    }

    public void addParticle(Particle particle) {
        if (!this.laMama.contains(particle)) {
            this.handleOutParticle(particle);
            this.checkDivisions();
            assert (this.laMama.contains(particle));
        }
        this.laMama.addParticle(particle);
    }

    public void checkDivisions() {
        if (this.needResize) {
            CellSpace space = this.laMama.getSpace();
            double dbMinX = space.lo.x - Math.abs(space.lo.x);
            double dbMinY = space.lo.y - Math.abs(space.lo.y);
            double dbMinZ = space.lo.z - Math.abs(space.lo.z);
            double dbMaxX = space.hi.x + Math.abs(space.hi.x);
            double dbMaxY = space.hi.y + Math.abs(space.hi.y);
            double dbMaxZ = space.hi.z + Math.abs(space.hi.z);
            if (this.min.x > dbMinX) {
                this.min.x = dbMinX;
            }
            if (this.min.y > dbMinY) {
                this.min.y = dbMinY;
            }
            if (this.min.z > dbMinZ) {
                this.min.z = dbMinZ;
            }
            if (this.max.x < dbMaxX) {
                this.max.x = dbMaxX;
            }
            if (this.max.y < dbMaxY) {
                this.max.y = dbMaxY;
            }
            if (this.max.z < dbMaxZ) {
                this.max.z = dbMaxZ;
            }
            double dx = (this.max.x - this.min.x) * (double)0.001f;
            double dy = (this.max.y - this.min.y) * (double)0.001f;
            double dz = (this.max.z - this.min.z) * (double)0.001f;
            this.max.x += dx;
            this.min.x -= dx;
            this.max.y += dy;
            this.min.y -= dy;
            this.max.z += dz;
            this.min.z -= dz;
            this.laMama.resize(this.min, this.max);
            this.needResize = false;
        } else {
            this.laMama.recompute();
        }
        assert (this.isValid());
    }

    public String generateCellIdentifier(Cell parent, int index) {
        StringBuilder sb = new StringBuilder();
        sb.append("C[");
        sb.append(index);
        sb.append("/");
        sb.append(parent.index);
        for (parent = parent.getParent(); parent != null; parent = parent.getParent()) {
            sb.append("/");
            sb.append(parent.index);
        }
        sb.append("]");
        return sb.toString();
    }

    public void setOutOfUniverseMode(OutOfUniverseMode mode) {
        this.oum = mode;
    }

    protected void handleOutParticle(Particle particle) {
        switch (this.oum) {
            case DELETE: {
                this.delete(particle);
                break;
            }
            case RESIZE: {
                this.resize(particle);
                break;
            }
            default: {
                assert (false) : "unknown OutOfUniverseMode";
                break;
            }
        }
    }

    protected void delete(Particle particle) {
        particle.suicide();
    }

    protected void resize(Particle particle) {
        Point3 p = particle.getPosition();
        this.needResize = true;
        if (p.x > this.max.x) {
            this.max.x = p.x;
        } else if (p.x < this.min.x) {
            this.min.x = p.x;
        }
        if (p.y > this.max.y) {
            this.max.y = p.y;
        } else if (p.y < this.min.y) {
            this.min.y = p.y;
        }
        if (p.z > this.max.z) {
            this.max.z = p.z;
        } else if (p.z < this.min.z) {
            this.min.z = p.z;
        }
    }

    protected boolean isValid() {
        return this.laMama.isValid();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutOfUniverseMode {
        DELETE,
        RESIZE;

    }
}

