/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.model;

import ancestris.modules.releve.model.Field;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FieldDate
extends Field {
    private static final Pattern jjmmaaaa = Pattern.compile("([0-9]{1,2})/([0-9]{1,2})/([0-9]{4,4})");
    private static final Pattern mmaaaa = Pattern.compile("([0-9]{1,2})/([0-9]{4,4})");
    private static final Pattern aaaa = Pattern.compile("([0-9]{4,4})");
    private static final Pattern jjmonthaaaa = Pattern.compile("([0-9]{1,2}) ([A-Za-z]*) ([0-9]{4,4})");
    PropertyDate eventDate = new PropertyDate();

    public String toString() {
        return this.getValueDDMMYYYY();
    }

    @Override
    public String getValue() {
        return this.getValueDDMMYYYY();
    }

    public String getValueDDMMYYYY() {
        try {
            PointInTime pit = this.eventDate.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN);
            String result = pit.getYear() == Integer.MAX_VALUE || pit.getYear() == Integer.MIN_VALUE ? "" : (pit.getMonth() == Integer.MAX_VALUE || pit.getMonth() == Integer.MIN_VALUE ? String.format("%04d", pit.getYear()) : (pit.getDay() == Integer.MAX_VALUE || pit.getDay() == Integer.MIN_VALUE ? String.format("%02d/%04d", pit.getMonth() + 1, pit.getYear()) : String.format("%02d/%02d/%04d", pit.getDay() + 1, pit.getMonth() + 1, pit.getYear())));
            return result;
        }
        catch (GedcomException ex) {
            return "";
        }
    }

    public String getFrenchCalendarValue() {
        try {
            PointInTime pit = this.eventDate.getStart().getPointInTime((Calendar)PointInTime.FRENCHR);
            String result = pit.toString();
            return result;
        }
        catch (GedcomException ex) {
            return "";
        }
    }

    public String getDisplayValue() {
        return this.eventDate.getDisplayValue();
    }

    @Override
    public void setValue(String dateString) {
        String inputDate = dateString.trim();
        Matcher matcher = jjmmaaaa.matcher(inputDate);
        if (matcher.matches()) {
            PointInTime pit = new PointInTime(Integer.parseInt(matcher.group(1)) - 1, Integer.parseInt(matcher.group(2)) - 1, Integer.parseInt(matcher.group(3)));
            this.eventDate.setValue(this.eventDate.getFormat(), pit, null, null);
        } else {
            matcher = mmaaaa.matcher(inputDate);
            if (matcher.matches()) {
                PointInTime pit = new PointInTime(Integer.MAX_VALUE, Integer.parseInt(matcher.group(1)) - 1, Integer.parseInt(matcher.group(2)));
                this.eventDate.setValue(this.eventDate.getFormat(), pit, null, null);
            } else {
                matcher = aaaa.matcher(inputDate);
                if (matcher.matches()) {
                    PointInTime pit = new PointInTime(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.parseInt(matcher.group(1)));
                    this.eventDate.setValue(this.eventDate.getFormat(), pit, null, null);
                } else {
                    matcher = jjmonthaaaa.matcher(inputDate);
                    if (matcher.matches()) {
                        String mmm = matcher.group(2);
                        PointInTime pit = new PointInTime(Integer.parseInt(matcher.group(1)) - 1, PointInTime.getMonth((String)mmm), Integer.parseInt(matcher.group(3)));
                        this.eventDate.setValue(this.eventDate.getFormat(), pit, null, null);
                    } else {
                        this.eventDate.setValue(inputDate);
                    }
                }
            }
        }
    }

    public void setValue(String strDay, String strMonth, String strYear) throws NumberFormatException {
        try {
            int day = Integer.MAX_VALUE;
            int month = Integer.MAX_VALUE;
            int year = Integer.MAX_VALUE;
            if (!strDay.isEmpty()) {
                day = Integer.parseInt(strDay) - 1;
            }
            if (!strMonth.isEmpty()) {
                month = Integer.parseInt(strMonth) - 1;
            }
            if (!strYear.isEmpty()) {
                year = Integer.parseInt(strYear);
            }
            PointInTime pit = new PointInTime(day, month, year);
            this.eventDate.setValue(this.eventDate.getFormat(), pit, null, null);
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException("Error " + strDay + " " + ex);
        }
    }

    public void setCalendar(Calendar calendar) {
        try {
            this.eventDate.getStart().set(calendar);
        }
        catch (GedcomException gedcomException) {
            // empty catch block
        }
    }

    public Calendar getCalendar() {
        return this.eventDate.getStart().getCalendar();
    }

    public PropertyDate getPropertyDate() {
        return this.eventDate;
    }

    @Override
    public int compareTo(Field that) {
        if (that instanceof FieldDate) {
            return this.eventDate.compareTo((Property)((FieldDate)that).eventDate);
        }
        return -1;
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof FieldDate) {
            return this.eventDate.equals(((FieldDate)that).eventDate);
        }
        return false;
    }

    @Override
    public boolean equalsProperty(Object that) {
        if (that instanceof PropertyDate) {
            PropertyDate propertyDate = (PropertyDate)that;
            PointInTime thatStart = propertyDate.getStart();
            PointInTime thisStart = this.eventDate.getStart();
            return thisStart.getDay() == thatStart.getDay() && thisStart.getMonth() == thatStart.getMonth() && thisStart.getYear() == thatStart.getYear();
        }
        if (that instanceof PointInTime) {
            PointInTime thatStart = (PointInTime)that;
            PointInTime thisStart = this.eventDate.getStart();
            return thisStart.getDay() == thatStart.getDay() && thisStart.getMonth() == thatStart.getMonth() && thisStart.getYear() == thatStart.getYear();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.eventDate.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return !this.eventDate.getStart().isValid();
    }
}

