# Copyright (c) 2017-2020, Intel Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
# OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
# ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.

media_include_subdirectory(user_setting)

set(TMP_SOURCES_
    ${CMAKE_CURRENT_LIST_DIR}/mediamemdecomp.cpp
    ${CMAKE_CURRENT_LIST_DIR}/media_perf_profiler.cpp
    ${CMAKE_CURRENT_LIST_DIR}/media_user_settings_mgr.cpp
    ${CMAKE_CURRENT_LIST_DIR}/memory_policy_manager.cpp
    ${CMAKE_CURRENT_LIST_DIR}/null_hardware.cpp
    ${CMAKE_CURRENT_LIST_DIR}/media_debug_interface.cpp
    ${CMAKE_CURRENT_LIST_DIR}/media_debug_config_manager.cpp
)

set(TMP_HEADERS_
    ${CMAKE_CURRENT_LIST_DIR}/mediamemdecomp.h
    ${CMAKE_CURRENT_LIST_DIR}/media_perf_profiler.h
    ${CMAKE_CURRENT_LIST_DIR}/media_user_settings_mgr.h
    ${CMAKE_CURRENT_LIST_DIR}/memory_policy_manager.h
    ${CMAKE_CURRENT_LIST_DIR}/null_hardware.h
    ${CMAKE_CURRENT_LIST_DIR}/media_debug_interface.h
    ${CMAKE_CURRENT_LIST_DIR}/media_debug_config_manager.h
    ${CMAKE_CURRENT_LIST_DIR}/media_debug_utils.h
)

set(SOURCES_
    ${SOURCES_}
    ${TMP_SOURCES_}
)

set(HEADERS_
    ${HEADERS_}
    ${TMP_HEADERS_}
)

set(COMMON_SOURCES_
    ${COMMON_SOURCES_}
    ${TMP_SOURCES_}
)

set(COMMON_HEADERS_
    ${COMMON_HEADERS_}
    ${TMP_HEADERS_}
)

source_group( "Common Files" FILES ${TMP_SOURCES_} ${TMP_HEADERS_} )


media_add_curr_to_include_path()
