/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.isg.pyramidio;

import gov.nist.isg.archiver.FilesArchiver;
import gov.nist.isg.pyramidio.DziFile;
import gov.nist.isg.pyramidio.ImageReaderCache;
import gov.nist.isg.pyramidio.PartialImageReader;
import gov.nist.isg.pyramidio.tools.BufferedImageHelper;
import gov.nist.isg.pyramidio.tools.ImageResizingHelper;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;

class TileBuilder {
    private final int tileSize;
    private final int overlap;
    private final String tileFormat;
    private final PartialImageReader imageReader;
    private final FilesArchiver archiver;
    private final int nbLevels;
    private final String imgDir;
    private final int originalWidth;
    private final int originalHeight;

    TileBuilder(int tileSize, int overlap, String tileFormat, String descriptorExt, PartialImageReader imageReader, String fileName, FilesArchiver archiver) throws IOException {
        this.tileSize = tileSize;
        this.overlap = overlap;
        this.tileFormat = tileFormat;
        this.imageReader = imageReader;
        this.archiver = archiver;
        this.originalWidth = imageReader.getWidth();
        this.originalHeight = imageReader.getHeight();
        String nameWithoutExtension = FilenameUtils.getBaseName((String)fileName);
        String descriptorName = nameWithoutExtension + '.' + descriptorExt;
        DziFile dziFile = new DziFile(tileSize, overlap, tileFormat, this.originalWidth, this.originalHeight);
        dziFile.write(descriptorName, archiver);
        int maxDim = Math.max(this.originalWidth, this.originalHeight);
        this.nbLevels = (int)Math.ceil(Math.log(maxDim) / Math.log(2.0));
        this.imgDir = fileName + "_files";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void build(int parallelism, float maxImageCachePercentage) {
        boolean useCache = maxImageCachePercentage > 0.0f;
        int cacheLevel = this.getCacheLevel(maxImageCachePercentage);
        if (parallelism <= 1) {
            new TileBuilderTask(0, 0, 0, false, useCache, cacheLevel, null).compute();
            return;
        }
        ForkJoinPool forkJoinPool = new ForkJoinPool(parallelism);
        try {
            forkJoinPool.invoke(new TileBuilderTask(0, 0, 0, true, useCache, cacheLevel, null));
        }
        finally {
            forkJoinPool.shutdownNow();
        }
    }

    private int getCacheLevel(float maxImageCachePercentage) {
        if (maxImageCachePercentage >= 1.0f) {
            return 0;
        }
        if (maxImageCachePercentage <= 0.0f) {
            return this.nbLevels;
        }
        int imageWidth = this.imageReader.getWidth();
        int imageHeight = this.imageReader.getHeight();
        long area = (long)imageWidth * (long)imageHeight;
        float maxCachedArea = (float)area * maxImageCachePercentage;
        double maxCachedSize = Math.floor(Math.sqrt(maxCachedArea));
        for (int i = 0; i < this.nbLevels; ++i) {
            Rectangle tileRegion = this.getTileRegionInEntireImage(i, 0, 0);
            if (!((double)tileRegion.width <= maxCachedSize) || !((double)tileRegion.height <= maxCachedSize)) continue;
            return i;
        }
        return this.nbLevels;
    }

    private Rectangle getTileRegionInEntireImage(int level, int row, int col) {
        Rectangle tileRegionAtLevel = this.getTileRegionAtLevel(level, row, col);
        if (tileRegionAtLevel == null) {
            return null;
        }
        double factor = Math.pow(2.0, this.nbLevels - level);
        int scaledX = (int)Math.ceil((double)tileRegionAtLevel.x * factor);
        int scaledY = (int)Math.ceil((double)tileRegionAtLevel.y * factor);
        int scaledWidth = (int)Math.ceil((double)tileRegionAtLevel.width * factor);
        int scaledHeight = (int)Math.ceil((double)tileRegionAtLevel.height * factor);
        if (scaledX + scaledWidth > this.originalWidth) {
            scaledWidth = this.originalWidth - scaledX;
        }
        if (scaledY + scaledHeight > this.originalHeight) {
            scaledHeight = this.originalHeight - scaledY;
        }
        return new Rectangle(scaledX, scaledY, scaledWidth, scaledHeight);
    }

    private Rectangle getTileRegionAtLevel(int level, int row, int col) {
        double factor = Math.pow(2.0, this.nbLevels - level);
        int levelWidth = (int)Math.ceil((double)this.originalWidth / factor);
        int levelHeight = (int)Math.ceil((double)this.originalHeight / factor);
        int nbCols = (int)Math.ceil((double)levelWidth / (double)this.tileSize);
        int nbRows = (int)Math.ceil((double)levelHeight / (double)this.tileSize);
        if (col >= nbCols || row >= nbRows) {
            return null;
        }
        int x = col * this.tileSize - (col == 0 ? 0 : this.overlap);
        int y = row * this.tileSize - (row == 0 ? 0 : this.overlap);
        int w = this.tileSize + (col == 0 ? 1 : 2) * this.overlap;
        int h = this.tileSize + (row == 0 ? 1 : 2) * this.overlap;
        if (x + w > levelWidth) {
            w = levelWidth - x;
        }
        if (y + h > levelHeight) {
            h = levelHeight - y;
        }
        return new Rectangle(x, y, w, h);
    }

    private Dimension getTileDimensions(int level, int row, int col) {
        Rectangle tileRegionAtLevel = this.getTileRegionAtLevel(level, row, col);
        if (tileRegionAtLevel == null) {
            return new Dimension(0, 0);
        }
        return new Dimension(tileRegionAtLevel.width, tileRegionAtLevel.height);
    }

    private static void writeImage(final BufferedImage image, final String format, String fileName, FilesArchiver archiver) throws IOException {
        boolean write = (Boolean)archiver.appendFile(fileName = fileName + "." + format, (FilesArchiver.FileAppender)new FilesArchiver.FileAppender<Boolean>(){

            public Boolean append(OutputStream outputStream) throws IOException {
                return ImageIO.write((RenderedImage)image, format, outputStream);
            }
        });
        if (!write) {
            throw new IOException("No " + format + " image writer found.");
        }
    }

    private class TileBuilderTask
    extends RecursiveTask<BufferedImage> {
        private final int level;
        private final int tileRow;
        private final int tileColumn;
        private final boolean useFork;
        private final boolean useCache;
        private final int cacheLevel;
        private final ImageReaderCache imageReaderCache;

        private TileBuilderTask(int level, int tileRow, int tileColumn, boolean useFork, boolean useCache, int cacheLevel, ImageReaderCache imageReaderCache) {
            Rectangle tileRegion;
            this.level = level;
            this.tileRow = tileRow;
            this.tileColumn = tileColumn;
            this.useFork = useFork;
            this.useCache = useCache;
            this.cacheLevel = cacheLevel;
            if (useCache && level == cacheLevel && (tileRegion = TileBuilder.this.getTileRegionInEntireImage(level, tileRow, tileColumn)) != null) {
                try {
                    imageReaderCache = new ImageReaderCache(TileBuilder.this.imageReader, tileRegion);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot cache region " + tileRegion, e);
                }
            }
            this.imageReaderCache = imageReaderCache;
        }

        @Override
        protected BufferedImage compute() {
            BufferedImage result;
            if (this.level == TileBuilder.this.nbLevels) {
                try {
                    result = this.getTile(this.tileRow, this.tileColumn);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Cannot read tile at row " + this.tileRow + " column " + this.tileColumn + ".", ex);
                }
            } else {
                BufferedImage bottomLeft;
                BufferedImage topRight;
                BufferedImage topLeft;
                BufferedImage bottomRight;
                TileBuilderTask bottomRightTask;
                TileBuilderTask bottomLeftTask;
                TileBuilderTask topRightTask;
                TileBuilderTask topLeftTask;
                Dimension tileDimensions = TileBuilder.this.getTileDimensions(this.level, this.tileRow, this.tileColumn);
                if (tileDimensions.width == 0 || tileDimensions.height == 0) {
                    return null;
                }
                if (this.useFork && (!this.useCache || this.level >= this.cacheLevel)) {
                    topLeftTask = this.getTask(this.level + 1, this.tileRow * 2, this.tileColumn * 2);
                    topRightTask = this.getTask(this.level + 1, this.tileRow * 2, this.tileColumn * 2 + 1);
                    bottomLeftTask = this.getTask(this.level + 1, this.tileRow * 2 + 1, this.tileColumn * 2);
                    bottomRightTask = this.getTask(this.level + 1, this.tileRow * 2 + 1, this.tileColumn * 2 + 1);
                    topLeftTask.fork();
                    topRightTask.fork();
                    bottomLeftTask.fork();
                    bottomRight = bottomRightTask.compute();
                    topLeft = (BufferedImage)topLeftTask.join();
                    topRight = (BufferedImage)topRightTask.join();
                    bottomLeft = (BufferedImage)bottomLeftTask.join();
                } else {
                    topLeftTask = this.getTask(this.level + 1, this.tileRow * 2, this.tileColumn * 2);
                    topLeft = topLeftTask.compute();
                    topRightTask = this.getTask(this.level + 1, this.tileRow * 2, this.tileColumn * 2 + 1);
                    topRight = topRightTask.compute();
                    bottomLeftTask = this.getTask(this.level + 1, this.tileRow * 2 + 1, this.tileColumn * 2);
                    bottomLeft = bottomLeftTask.compute();
                    bottomRightTask = this.getTask(this.level + 1, this.tileRow * 2 + 1, this.tileColumn * 2 + 1);
                    bottomRight = bottomRightTask.compute();
                }
                int bigWidth = topLeft.getWidth() + (topRight == null ? 0 : topRight.getWidth() - 2 * TileBuilder.this.overlap);
                int bigHeight = topLeft.getHeight() + (bottomLeft == null ? 0 : bottomLeft.getHeight() - 2 * TileBuilder.this.overlap);
                result = BufferedImageHelper.createBufferedImage(bigWidth, bigHeight, topLeft);
                WritableRaster raster = result.getRaster();
                int rightTilesX = TileBuilder.this.tileSize - TileBuilder.this.overlap + (this.tileColumn == 0 ? 0 : TileBuilder.this.overlap);
                int bottomTilesY = TileBuilder.this.tileSize - TileBuilder.this.overlap + (this.tileRow == 0 ? 0 : TileBuilder.this.overlap);
                raster.setRect(0, 0, topLeft.getRaster());
                if (topRight != null) {
                    raster.setRect(rightTilesX, 0, topRight.getRaster());
                }
                if (bottomLeft != null) {
                    raster.setRect(0, bottomTilesY, bottomLeft.getRaster());
                }
                if (bottomRight != null) {
                    raster.setRect(rightTilesX, bottomTilesY, bottomRight.getRaster());
                }
                result = ImageResizingHelper.resizeImage(result, tileDimensions.width, tileDimensions.height);
            }
            if (result != null) {
                String dir = FilenameUtils.concat((String)TileBuilder.this.imgDir, (String)Integer.toString(this.level));
                String outputFile = FilenameUtils.concat((String)dir, (String)(this.tileColumn + "_" + this.tileRow));
                try {
                    TileBuilder.writeImage(result, TileBuilder.this.tileFormat, outputFile, TileBuilder.this.archiver);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Cannot write tile at level " + this.level + " row " + this.tileRow + " column " + this.tileColumn + ".", ex);
                }
            }
            return result;
        }

        private TileBuilderTask getTask(int level, int tileRow, int tileColumn) {
            return new TileBuilderTask(level, tileRow, tileColumn, this.useFork, this.useCache, this.cacheLevel, this.imageReaderCache);
        }

        private BufferedImage getTile(int row, int col) throws IOException {
            Rectangle region;
            int x = col * TileBuilder.this.tileSize - (col == 0 ? 0 : TileBuilder.this.overlap);
            int y = row * TileBuilder.this.tileSize - (row == 0 ? 0 : TileBuilder.this.overlap);
            int w = TileBuilder.this.tileSize + (col == 0 ? 1 : 2) * TileBuilder.this.overlap;
            int h = TileBuilder.this.tileSize + (row == 0 ? 1 : 2) * TileBuilder.this.overlap;
            if (x + w > TileBuilder.this.originalWidth) {
                w = TileBuilder.this.originalWidth - x;
            }
            if (y + h > TileBuilder.this.originalHeight) {
                h = TileBuilder.this.originalHeight - y;
            }
            if ((region = new Rectangle(x, y, w, h)).isEmpty()) {
                return null;
            }
            return this.useCache ? this.imageReaderCache.read(region) : TileBuilder.this.imageReader.read(region);
        }
    }
}

