/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transforms.tabular.ui.dnd;

import com.paterva.maltego.graph.table.io.TabularGraphFileImporterFactory;
import com.paterva.maltego.transform.gen.TransformSource;
import com.paterva.maltego.transforms.tabular.TabularTransformSourceRepository;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.transforms.tabular.ui.TabularTransformSourceCreator;
import com.paterva.maltego.transforms.tabular.ui.TabularTransformSourceDetailsDisplayer;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.ui.dnd.FileDropHandler;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openide.util.Exceptions;

public class TabularFileDropHandler
extends FileDropHandler {
    public List<String> getLowercaseExtensions() {
        return Arrays.stream(TabularGraphFileImporterFactory.getAll()).map(factory -> factory.getExtension()).collect(Collectors.toList());
    }

    public void handleDrop(List<File> validFiles) {
        Args.notNull(validFiles, (String)"validFiles");
        TabularTransformSourceRepository repo = TabularTransformSourceRepository.getInstance();
        validFiles.stream().map(this::createTransformSource).filter(Optional::isPresent).map(Optional::get).forEach(txSource -> {
            repo.add(txSource);
            new TabularTransformSourceDetailsDisplayer().show((TransformSource)txSource);
        });
    }

    private Optional<TabularTransformSource> createTransformSource(File file) {
        Args.notNull((Object)file, (String)"file");
        TabularTransformSource txSource = null;
        try {
            txSource = TabularTransformSourceCreator.getDefault().create(file);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return Optional.ofNullable(txSource);
    }
}

