/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BodyType;
import org.xlightweb.ComposedByteBuffer;
import org.xlightweb.IHttpHeader;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xsocket.MaxReadSizeExceededException;

abstract class AbstractBodyParser
implements ComposedByteBuffer.IBufferSink {
    private static final Logger LOG = Logger.getLogger(AbstractBodyParser.class.getName());
    private final AbstractHttpConnection httpConnection;
    private final IHttpHeader header;
    private final NonBlockingBodyDataSource dataSource;
    private AtomicBoolean isComplete = new AtomicBoolean(false);

    public AbstractBodyParser(BodyType bodyType, AbstractHttpConnection httpConnection, IHttpHeader header) throws IOException {
        this.httpConnection = httpConnection;
        this.header = header;
        this.dataSource = new NonBlockingBodyDataSource(bodyType, header.getCharacterEncoding(), httpConnection, httpConnection.getExecutor());
    }

    final IHttpHeader getHeader() {
        return this.header;
    }

    final String getConnectionId() {
        return this.httpConnection.getId();
    }

    final void setPersistent(boolean isPersistent) {
        this.httpConnection.setPersistent(isPersistent);
    }

    public final void add(ByteBuffer buffer) throws IOException {
        this.dataSource.append(true, buffer);
    }

    final void register(IOException ioe) {
        this.dataSource.setIOException(ioe);
    }

    NonBlockingBodyDataSource getDataSource() {
        return this.dataSource;
    }

    final boolean parse(ComposedByteBuffer rawData) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        if (!this.dataSource.isComplete()) {
            try {
                this.doParse(rawData);
                return this.isComplete.get();
            }
            catch (BufferUnderflowException bue) {
                throw bue;
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.httpConnection.getId() + "] (protocol?) error occured by reading body " + ioe.toString());
                }
                if (!this.isComplete()) {
                    this.dataSource.setIOException(ioe);
                }
                this.httpConnection.destroy();
                this.dataSource.close();
                throw ioe;
            }
        }
        return false;
    }

    abstract void doParse(ComposedByteBuffer var1) throws IOException;

    abstract void onException(IOException var1, ComposedByteBuffer var2);

    final void setComplete() {
        this.isComplete.set(true);
        this.dataSource.setComplete(true);
    }

    final boolean isComplete() {
        return this.isComplete.get();
    }

    void onDisconnect() {
        this.dataSource.onDisconnect();
    }
}

