/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.bkdtree3d;

import org.apache.lucene.bkdtree3d.HeapReader;
import org.apache.lucene.bkdtree3d.Reader;
import org.apache.lucene.bkdtree3d.Writer;

final class HeapWriter
implements Writer {
    final int[] xs;
    final int[] ys;
    final int[] zs;
    final int[] docIDs;
    final long[] ords;
    private int nextWrite;
    private boolean closed;

    public HeapWriter(int count) {
        this.xs = new int[count];
        this.ys = new int[count];
        this.zs = new int[count];
        this.docIDs = new int[count];
        this.ords = new long[count];
    }

    @Override
    public void append(int x, int y, int z, long ord, int docID) {
        this.xs[this.nextWrite] = x;
        this.ys[this.nextWrite] = y;
        this.zs[this.nextWrite] = z;
        this.ords[this.nextWrite] = ord;
        this.docIDs[this.nextWrite] = docID;
        ++this.nextWrite;
    }

    @Override
    public Reader getReader(long start) {
        assert (this.closed);
        return new HeapReader(this.xs, this.ys, this.zs, this.ords, this.docIDs, (int)start, this.xs.length);
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.nextWrite != this.xs.length) {
            throw new IllegalStateException("only wrote " + this.nextWrite + " values, but expected " + this.xs.length);
        }
    }

    @Override
    public void destroy() {
    }

    public String toString() {
        return "HeapWriter(count=" + this.xs.length + ")";
    }
}

