/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class SlownessDetector {
    public static final String SLOWNESS_PREFIX = "EDT slowness detected: ";
    private static final Logger LOG = Logger.getLogger(SlownessDetector.class.getName());
    private static final int INVOKE_DELAY = 1000;
    private static final int DUMP_INTERVAL = 3600000;
    private static final int MAX_DELAY = 10000;
    private static final int LOG_INTERVAL = 10000;
    private static final int SERIOUS_FACTOR = 10;
    private static final AtomicLong _invokeStartTime = new AtomicLong();
    private static final AtomicLong _invokeDoneTime = new AtomicLong();
    private static final AtomicLong _logTime = new AtomicLong();
    private static final AtomicBoolean _enabled = new AtomicBoolean(true);
    private static long _lastDumpTime = 0L;

    public static void setEnabled(boolean enabled) {
        _invokeDoneTime.set(_invokeStartTime.get());
        _enabled.set(enabled);
    }

    public static void start() {
        LOG.fine("Starting slowness detector");
        Timer t = new Timer("Slowness detector timer", true);
        t.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (_enabled.get()) {
                    LOG.fine("Checking slowness...");
                    boolean isDone = true;
                    long startTime = _invokeStartTime.get();
                    if (startTime > 0L) {
                        long doneTime = _invokeDoneTime.get();
                        LOG.log(Level.FINE, "startTime: {0}", startTime);
                        LOG.log(Level.FINE, "doneTime: {0}", doneTime);
                        isDone = doneTime >= startTime;
                        long delayTime = isDone ? doneTime - startTime : System.currentTimeMillis() - startTime;
                        LOG.log(Level.FINE, "delayTime: {0}", delayTime);
                        long timeSinceLastLog = System.currentTimeMillis() - _logTime.get();
                        if (delayTime > 10000L && timeSinceLastLog > 10000L) {
                            SlownessDetector.dumpThreads(delayTime);
                            _logTime.set(System.currentTimeMillis());
                        }
                    }
                    if (isDone) {
                        SlownessDetector.scheduleInvoke();
                    }
                }
            }
        }, 1000L, 1000L);
    }

    private static void scheduleInvoke() {
        LOG.fine("Scheduling invoke");
        _invokeStartTime.set(System.currentTimeMillis());
        SwingUtilities.invokeLater(() -> {
            LOG.fine("Invoke done");
            _invokeDoneTime.set(System.currentTimeMillis());
        });
    }

    private static synchronized void dumpThreads(long delay) {
        boolean seriousSlowness;
        String msg = SLOWNESS_PREFIX + delay / 1000L + "s";
        boolean bl = seriousSlowness = delay > 90000L && delay < 110000L;
        if (seriousSlowness || System.currentTimeMillis() - _lastDumpTime > 3600000L) {
            String threadDump = SlownessDetector.getThreadDump();
            LOG.severe(() -> msg + "\n" + threadDump);
            _lastDumpTime = System.currentTimeMillis();
        } else {
            LOG.warning(msg);
        }
    }

    public static String getThreadDump() {
        StringBuilder sb = new StringBuilder();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfos = threadMXBean.dumpAllThreads(true, true);
        SlownessDetector.printThreads(sb, threadInfos);
        return sb.toString();
    }

    private static void printThreads(StringBuilder sb, ThreadInfo[] threads) {
        for (ThreadInfo thread : threads) {
            if (thread == null) continue;
            SlownessDetector.print16Thread(sb, thread);
        }
    }

    private static void print16Thread(StringBuilder sb, ThreadInfo thread) {
        LockInfo[] synchronizers;
        StackTraceElement[] stackTrace = thread.getStackTrace();
        if (stackTrace == null || stackTrace.length == 0) {
            return;
        }
        MonitorInfo[] monitors = thread.getLockedMonitors();
        sb.append("\"").append(thread.getThreadName()).append("\" - Thread t@").append(thread.getThreadId()).append("\n");
        sb.append("    java.lang.Thread.State: ").append((Object)thread.getThreadState());
        sb.append("\n");
        int index = 0;
        for (StackTraceElement st : stackTrace) {
            LockInfo lock = thread.getLockInfo();
            String stackElementText = st.toString();
            String lockOwner = thread.getLockOwnerName();
            String stackEl = stackElementText;
            sb.append("\tat ").append(stackEl).append("\n");
            if (index == 0) {
                if ("java.lang.Object".equals(st.getClassName()) && "wait".equals(st.getMethodName())) {
                    if (lock != null) {
                        sb.append("\t- waiting on ");
                        SlownessDetector.printLock(sb, lock);
                        sb.append("\n");
                    }
                } else if (lock != null) {
                    if (lockOwner == null) {
                        sb.append("\t- parking to wait for ");
                        SlownessDetector.printLock(sb, lock);
                        sb.append("\n");
                    } else {
                        sb.append("\t- waiting to lock ");
                        SlownessDetector.printLock(sb, lock);
                        sb.append(" owned by \"").append(lockOwner).append("\" t@").append(thread.getLockOwnerId()).append("\n");
                    }
                }
            }
            SlownessDetector.printMonitors(sb, monitors, index);
            ++index;
        }
        StringBuilder jnisb = new StringBuilder();
        SlownessDetector.printMonitors(jnisb, monitors, -1);
        if (jnisb.length() > 0) {
            sb.append("   JNI locked monitors:\n");
            sb.append((CharSequence)jnisb);
        }
        if ((synchronizers = thread.getLockedSynchronizers()) != null && synchronizers.length != 0) {
            sb.append("\n   Locked ownable synchronizers:");
            for (LockInfo li : synchronizers) {
                sb.append("\n\t- locked ");
                SlownessDetector.printLock(sb, li);
                sb.append("\n");
            }
        }
        sb.append("\n");
    }

    private static void printMonitors(StringBuilder sb, MonitorInfo[] monitors, int index) {
        if (monitors != null) {
            for (MonitorInfo mi : monitors) {
                if (mi.getLockedStackDepth() != index) continue;
                sb.append("\t- locked ");
                SlownessDetector.printLock(sb, mi);
                sb.append("\n");
            }
        }
    }

    private static void printLock(StringBuilder sb, LockInfo lock) {
        String id = Integer.toHexString(lock.getIdentityHashCode());
        String className = lock.getClassName();
        sb.append("<").append(id).append("> (a ").append(className).append(")");
    }
}

