/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory.parts;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.GraphUserData;
import com.paterva.maltego.imgfactoryapi.ImageFactory;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageCallback;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Dimension;
import java.awt.Image;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

public abstract class EntityImageFactory {
    private static EntityImageFactory _default;
    private static final int ICON_SIZE_TINY_16;

    public static synchronized EntityImageFactory getDefault() {
        if (_default == null && (_default = (EntityImageFactory)Lookup.getDefault().lookup(EntityImageFactory.class)) == null) {
            throw new IllegalStateException("Entity Image Factory not found.");
        }
        return _default;
    }

    public static synchronized EntityImageFactory forGraph(GraphID graphID) {
        String key;
        GraphUserData gud = GraphUserData.forGraph((GraphID)graphID);
        EntityImageFactory factory = (EntityImageFactory)gud.get((Object)(key = EntityImageFactory.class.getName()));
        if (factory == null) {
            factory = new Registry(graphID);
            gud.put((Object)key, (Object)factory);
        }
        return factory;
    }

    public abstract Image getImage(MaltegoEntity var1, int var2, int var3, ImageCallback var4);

    public abstract Image getImage(String var1, Object var2, int var3, int var4, ImageCallback var5);

    public Image getImage(MaltegoEntity entity, ImageCallback cb) {
        return this.getImage(entity, -1, -1, cb);
    }

    public ImageIcon getIcon(MaltegoEntity entity, int width, int height) {
        Image image = this.getImage(entity, width, height, null);
        return image == null ? null : new ImageIcon(image);
    }

    public abstract Image getImageMax(MaltegoEntity var1, int var2, int var3, ImageCallback var4);

    public ImageIcon getIcon(MaltegoEntity entity) {
        return this.getIcon(entity, -1, -1);
    }

    public ImageIcon getTypeIcon(String typeName) {
        return this.getTypeIcon(typeName, -1, -1);
    }

    public ImageIcon getSmallTypeIcon(String typeName) {
        return this.getTypeIcon(typeName, ICON_SIZE_TINY_16, ICON_SIZE_TINY_16);
    }

    public abstract boolean hasImage(MaltegoEntity var1);

    public ImageIcon getTypeIcon(String typeName, int width, int height) {
        Image image = this.getTypeImage(typeName, width, height, null);
        return image == null ? null : new ImageIcon(image);
    }

    public abstract Image getTypeImage(String var1, int var2, int var3, ImageCallback var4);

    public Image getTypeImage(String typeName, ImageCallback cb) {
        return this.getTypeImage(typeName, -1, -1, cb);
    }

    public Image getSmallTypeImage(String typeName, ImageCallback cb) {
        return this.getTypeImage(typeName, ICON_SIZE_TINY_16, ICON_SIZE_TINY_16, cb);
    }

    public abstract Image getDefaultSmallImage();

    public abstract Image getDefaultLargeImage();

    public abstract Icon getDefaultSmallIcon();

    public abstract Icon getDefaultLargeIcon();

    static {
        ICON_SIZE_TINY_16 = IconSize.TINY.getSize();
    }

    public static class Registry
    extends Abstract {
        private GraphID _graphID;
        private EntityRegistry _registry;

        public Registry() {
            this.init(null);
        }

        public Registry(GraphID graphID) {
            this.init(graphID);
        }

        public Registry(GraphID graphID, String defaultResource) {
            super(defaultResource);
            this.init(graphID);
        }

        private void init(GraphID graphID) {
            this._graphID = graphID;
            this._registry = this._graphID != null ? EntityRegistry.forGraphID((GraphID)graphID) : EntityRegistry.getDefault();
        }

        @Override
        public Image getImage(MaltegoEntity entity, int width, int height, ImageCallback cb) {
            Object imageKey = this.getImageKey(entity);
            return this.getImage(entity.getTypeName(), imageKey, width, height, cb);
        }

        @Override
        public Image getImage(String typeName, Object object, int width, int height, ImageCallback cb) {
            Image image;
            if (object == null) {
                image = this.getTypeImage(typeName, width, height, cb);
            } else {
                image = this.getImageFromFactory(object, width, height, cb);
                if (image == null) {
                    image = this.getTypeImage(typeName, width, height, cb);
                }
            }
            return image;
        }

        private Image getImageFromFactory(Object key, int width, int height, ImageCallback cb) {
            if (cb == null) {
                cb = this::doNothing;
            }
            return ImageFactory.getDefault().getImage(this._graphID, key, width, height, cb);
        }

        @Override
        public Image getTypeImage(String typeName, int width, int height, ImageCallback cb) {
            Image image = null;
            MaltegoEntitySpec spec = (MaltegoEntitySpec)this._registry.get(typeName);
            if (spec != null) {
                image = this.getSpecImage(spec, width, height);
            }
            if (image == null) {
                image = this.defaultImageIcon(height).getImage();
            }
            return image;
        }

        public Image getSpecImage(MaltegoEntitySpec spec, int width, int height) {
            if (height >= 0 && height <= 20) {
                if (!StringUtilities.isNullOrEmpty((String)spec.getSmallIconResource())) {
                    return this.getImageFromResource(spec.getSmallIconResource(), width, height);
                }
                return spec.getSmallIcon();
            }
            if (!StringUtilities.isNullOrEmpty((String)spec.getLargeIconResource())) {
                return this.getImageFromResource(spec.getLargeIconResource(), width, height);
            }
            return spec.getLargeIcon();
        }

        private Image getImageFromResource(String resource, int width, int height) {
            Image image = ImageFactory.getDefault().getImage(this._graphID, (Object)resource, width, height, null);
            return image;
        }

        private static boolean mustResize(int width, int height, int imageWidth, int imageHeight) {
            if (width == -1 && height == -1) {
                return false;
            }
            return width != imageWidth || height != imageHeight;
        }

        @Override
        public Image getImageMax(MaltegoEntity entity, final int maxWidth, final int maxHeight, final ImageCallback cb) {
            Image image;
            final Object imageKey = this.getImageKey(entity);
            ImageCallback myCB = new ImageCallback(){

                public void imageReady(Image image) {
                    Dimension d = this.calcNewSize(image.getWidth(null), image.getHeight(null), maxWidth, maxHeight);
                    if (d != null) {
                        this.getImageFromFactory(imageKey, -1, -1, cb);
                    } else {
                        cb.imageReady(image);
                    }
                }

                public void imageFailed(Exception ex) {
                    cb.imageFailed(ex);
                }

                public boolean needAwtThread() {
                    return cb.needAwtThread();
                }
            };
            if (imageKey == null) {
                image = this.getTypeImage(entity.getTypeName(), myCB);
            } else {
                image = this.getImageFromFactory(imageKey, -1, -1, myCB);
                if (image == null) {
                    return this.getTypeImage(entity.getTypeName(), myCB);
                }
                Dimension d = this.calcNewSize(image.getWidth(null), image.getHeight(null), maxWidth, maxHeight);
                if (d != null) {
                    image = this.getImageFromFactory(imageKey, d.width, d.height, myCB);
                }
            }
            return image;
        }

        private Dimension calcNewSize(float width, float height, float maxWidth, float maxHeight) {
            float newHeight;
            float newWidth;
            if (width <= maxWidth && height <= maxHeight) {
                return null;
            }
            float ratio = width / height;
            float maxRatio = maxWidth / maxHeight;
            if (ratio > maxRatio) {
                newWidth = maxWidth;
                newHeight = maxWidth / ratio;
            } else {
                newHeight = maxHeight;
                newWidth = ratio * maxHeight;
            }
            return new Dimension((int)newWidth, (int)newHeight);
        }

        @Override
        public boolean hasImage(MaltegoEntity entity) {
            Object imageKey = this.getImageKey(entity);
            return imageKey != null && StringUtils.isNotBlank((CharSequence)imageKey.toString());
        }

        private Object getImageKey(MaltegoEntity entity) {
            return InheritanceHelper.getImageKey((EntityRegistry)this._registry, (MaltegoEntity)entity).orElse(null);
        }

        private void doNothing(Object obj) {
        }
    }

    public static abstract class Abstract
    extends EntityImageFactory {
        private String _defaultResource;
        private Map<IconSize, ImageIcon> _defaults = new EnumMap<IconSize, ImageIcon>(IconSize.class);

        public Abstract() {
            this("com/paterva/maltego/ui/graph/impl/Unknown.png");
        }

        public Abstract(String defaultResource) {
            this._defaultResource = defaultResource;
        }

        @Override
        public Image getDefaultSmallImage() {
            return this.defaultImageIcon(IconSize.TINY).getImage();
        }

        @Override
        public Image getDefaultLargeImage() {
            return this.defaultImageIcon(IconSize.LARGE).getImage();
        }

        @Override
        public Icon getDefaultSmallIcon() {
            return this.defaultImageIcon(IconSize.TINY);
        }

        @Override
        public Icon getDefaultLargeIcon() {
            return this.defaultImageIcon(IconSize.LARGE);
        }

        protected ImageIcon defaultImageIcon(int size) {
            return this.defaultImageIcon(IconSize.getSize((int)size));
        }

        protected synchronized ImageIcon defaultImageIcon(IconSize size) {
            ImageIcon icon = this._defaults.get(size);
            if (icon == null) {
                String resource = size.addPostfix(this._defaultResource);
                Image image = ImageUtilities.loadImage((String)resource);
                if (image == null && size == IconSize.MASSIVE) {
                    resource = IconSize.LARGE.addPostfix(this._defaultResource);
                    image = ImageUtilities.loadImage((String)resource);
                }
                icon = new ImageIcon(image);
                this._defaults.put(size, icon);
            }
            return icon;
        }
    }
}

