/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.treelist;

import com.paterva.maltego.util.ui.treelist.ConstraintUtils;
import com.paterva.maltego.util.ui.treelist.TreeListItem;
import com.paterva.maltego.util.ui.treelist.TreeListItemPanel;
import com.paterva.maltego.util.ui.treelist.TreeListPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.Timer;

class TreeListExpandAnimator {
    private static final int TIMER_DELAY_MS = 8;
    private static final int EXPAND_TIME_MS = 250;
    private final TreeListPanel _treeList;
    private final TimerListener _listener = new TimerListener();
    private Timer _timer;
    private TreeListItem _item;
    private TreeListItem[] _children;
    private Component[] _components;
    private int[] _heights;
    private int _heightTotal;
    private long _startTime;

    public TreeListExpandAnimator(TreeListPanel treeList) {
        this._treeList = treeList;
    }

    public void start(TreeListItem item) {
        if (this._timer != null) {
            this.stop();
        }
        this.init(item);
        this._timer = new Timer(8, this._listener);
        this._timer.setRepeats(true);
        this._timer.start();
    }

    public void stop() {
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
        if (this._item != null) {
            int i;
            if (this._item.isExpanded()) {
                for (i = 0; i < this._components.length; ++i) {
                    this.setTopInset(i, 0);
                }
            } else {
                for (i = 0; i < this._components.length; ++i) {
                    this.setTopInset(i, -this._heights[i]);
                    this._components[i].setVisible(false);
                }
            }
            for (Component component : this._components) {
                TreeListItemPanel itemComponent = (TreeListItemPanel)component;
                itemComponent.setExpanding(false);
            }
            this._item = null;
            this._treeList.revalidate();
            this._treeList.repaint();
        }
    }

    private void init(TreeListItem item) {
        this._item = item;
        TreeListItem rootItem = this._treeList.getRootItem();
        List<TreeListItem> items = rootItem.getAsList();
        int itemIndex = items.indexOf(item);
        int childStartIndex = itemIndex + 1;
        int childEndIndex = childStartIndex + item.getAsList().size() - 1;
        List<TreeListItem> children = items.subList(childStartIndex, childEndIndex);
        this._children = children.toArray(new TreeListItem[childEndIndex - childStartIndex]);
        for (Component component : this._components = Arrays.copyOfRange(this._treeList.getComponents(), childStartIndex, childEndIndex)) {
            TreeListItemPanel itemComponent = (TreeListItemPanel)component;
            itemComponent.setExpanding(true);
        }
        this._heights = this.getHeights(item, this._components, this._children);
        this._heightTotal = this.getTotal(this._heights);
        this._startTime = System.currentTimeMillis();
    }

    private int[] getHeights(TreeListItem updatedItem, Component[] components, TreeListItem[] childItems) {
        int[] heights = new int[childItems.length];
        for (int i = 0; i < heights.length; ++i) {
            boolean isVisible = this.isVisible(updatedItem, childItems[i]);
            heights[i] = isVisible ? components[i].getPreferredSize().height : 0;
        }
        return heights;
    }

    private boolean isVisible(TreeListItem updatedItem, TreeListItem childItem) {
        for (TreeListItem parent = childItem.getParent(); parent != null && !updatedItem.equals(parent); parent = parent.getParent()) {
            if (parent.isExpanded()) continue;
            return false;
        }
        return true;
    }

    private int getTotal(int[] values) {
        int total = 0;
        for (int value : values) {
            total += value;
        }
        return total;
    }

    private void setTopInset(int index, int insetTop) {
        ConstraintUtils.setTopInset(this._treeList, this._components[index], insetTop);
    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            long endTime;
            long now = System.currentTimeMillis();
            if (now > (endTime = TreeListExpandAnimator.this._startTime + 250L)) {
                TreeListExpandAnimator.this.stop();
            } else {
                double totalTime = endTime - TreeListExpandAnimator.this._startTime;
                double expandedness = TreeListExpandAnimator.this._item.isExpanded() ? (double)(now - TreeListExpandAnimator.this._startTime) / totalTime : (double)(endTime - now) / totalTime;
                expandedness = this.slowFastSlow(expandedness);
                int heightExpanded = (int)(expandedness * (double)TreeListExpandAnimator.this._heightTotal);
                int currentIndex = this.getCurrentIndex(heightExpanded);
                int insetTop = -this.getObsuredHeight(currentIndex, heightExpanded);
                this.updateTopInsets(currentIndex, insetTop);
                this.updateVisibility(currentIndex);
                TreeListExpandAnimator.this._treeList.revalidate();
                TreeListExpandAnimator.this._treeList.repaint();
            }
        }

        private double slowFastSlow(double expandedness) {
            boolean noTrig = false;
            if (noTrig) {
                if (expandedness <= 0.5) {
                    return 2.0 * expandedness * expandedness;
                }
                double oneMinus = 1.0 - expandedness;
                return 1.0 - 2.0 * oneMinus * oneMinus;
            }
            return (1.0 + Math.sin(Math.PI * (expandedness - 0.5))) / 2.0;
        }

        private int getCurrentIndex(int heightExpanded) {
            int heightSum = 0;
            for (int i = TreeListExpandAnimator.this._heights.length - 1; i >= 0; --i) {
                int heightNext = heightSum + TreeListExpandAnimator.this._heights[i];
                if (heightNext > heightExpanded) {
                    return i;
                }
                heightSum = heightNext;
            }
            return 0;
        }

        private int getObsuredHeight(int index, int heightExpanded) {
            int heightSum = 0;
            for (int i = TreeListExpandAnimator.this._heights.length - 1; i >= 0; --i) {
                int heightNext = heightSum + TreeListExpandAnimator.this._heights[i];
                if (index == i) {
                    return heightNext - heightExpanded;
                }
                heightSum = heightNext;
            }
            return 0;
        }

        private void updateVisibility(int currentIndex) {
            for (int i = 0; i < TreeListExpandAnimator.this._heights.length; ++i) {
                TreeListExpandAnimator.this._components[i].setVisible(TreeListExpandAnimator.this._heights[i] != 0 && i >= currentIndex);
            }
        }

        private void updateTopInsets(int currentIndex, int insetTop) {
            for (int i = 0; i < TreeListExpandAnimator.this._components.length; ++i) {
                if (i > currentIndex) {
                    TreeListExpandAnimator.this.setTopInset(i, 0);
                    continue;
                }
                if (i != currentIndex) continue;
                TreeListExpandAnimator.this.setTopInset(i, insetTop);
            }
        }
    }
}

