/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.privacymode;

import com.paterva.maltego.certificates.CertificateUtils;
import com.paterva.maltego.util.FastURL;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PrivacyModeStrategy {
    private static final List<String> DEFAULT_IMAGE_WHITE_LIST = new ArrayList<String>(Arrays.asList("*.paterva.com", "*.maltego.com"));
    private static final List<String> IMAGE_WHITE_LIST = new ArrayList<String>(DEFAULT_IMAGE_WHITE_LIST);

    public static void refreshWhiteList(List<String> hubWhiteList) {
        IMAGE_WHITE_LIST.clear();
        IMAGE_WHITE_LIST.addAll(DEFAULT_IMAGE_WHITE_LIST);
        IMAGE_WHITE_LIST.addAll(hubWhiteList);
    }

    public static boolean mayDownload(FastURL fastUrl) {
        boolean download = true;
        try {
            if (!CertificateUtils.urlMatchesHostnames(IMAGE_WHITE_LIST, (URL)fastUrl.getURL())) {
                download = false;
            }
        }
        catch (NullPointerException | MalformedURLException ex) {
            download = false;
        }
        return download;
    }
}

