/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.impl;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.descriptor.TransformServerRegistry;
import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.descriptor.TransformSetRepository;
import com.paterva.maltego.transform.manager.api.TransformManager;
import com.paterva.maltego.transform.runner.TransformMenuFactory;
import com.paterva.maltego.transform.runner.TransformRequestProcessor;
import com.paterva.maltego.transform.runner.TransformSelector;
import com.paterva.maltego.transform.runner.api.TransformRunOrigin;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.ListMap;
import com.paterva.maltego.util.ui.menu.BasicMenuViewItem;
import com.paterva.maltego.util.ui.menu.MenuViewFactory;
import com.paterva.maltego.util.ui.menu.MenuViewItem;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public class DefaultTransformMenuFactory
extends TransformMenuFactory {
    public static final int TAS_SELECTION_FIRST = 0;
    public static final int TAS_SELECTION_LAST = 1;
    public static final int TAS_SELECTION_RANDOM = 2;
    public static final int SORT_NONE = 0;
    public static final int SORT_ASCENDING = 1;

    @Override
    public MenuViewItem[] getMenuItems(GraphID graphID, Set<EntityID> entities) {
        MenuViewItem[] items = null;
        Set<TransformDefinition> transforms = TransformSelector.getDefault().getTransforms(graphID, entities);
        if (transforms.isEmpty() && this.showUtilityActionsIfEmpty()) {
            items = this.createEmptyActions();
        } else {
            Map<TransformServerInfo, Collection<TransformDefinition>> tases;
            if (this.tasSelection() == 0 && (tases = this.getTransformsByTas(transforms)).size() > 1) {
                MenuViewItem[] tasItems = new MenuViewItem[tases.size()];
                int index = 0;
                for (Map.Entry<TransformServerInfo, Collection<TransformDefinition>> entry : tases.entrySet()) {
                    BasicMenuViewItem item = new BasicMenuViewItem(this.getMenuNodes(entry.getValue(), graphID, entities));
                    item.setDisplayName(entry.getKey().getDisplayName());
                    item.setDescription(entry.getKey().getDescription());
                    tasItems[index] = item;
                }
                if (this.tasSorting() == 1) {
                    Arrays.sort(tasItems, new TransformMenuFactory.DisplayAscendingComparator());
                }
                items = tasItems;
            }
            if (items == null) {
                items = this.getMenuNodes(transforms, graphID, entities);
            }
        }
        items = this.restrictMaxItemsPerMenu(items, this.getMaxMenuItemsForScreen());
        return items;
    }

    private MenuViewItem[] getMenuNodes(Collection<TransformDefinition> transforms, GraphID graphID, Set<EntityID> entities) {
        if (this.showSets()) {
            return this.createSets(transforms, graphID, entities);
        }
        MenuViewItem allTransforms = this.createAllTransformsNode(transforms, graphID, entities);
        MenuViewItem[] items = this.createTransforms(transforms, allTransforms, graphID, entities);
        return items;
    }

    private Map<TransformServerInfo, Collection<TransformDefinition>> getTransformsByTas(Collection<TransformDefinition> transforms) {
        Collection servers = TransformServerRegistry.getDefault().getAll();
        ListMap map = new ListMap();
        if (servers.size() == 1) {
            map.put(servers.iterator().next(), transforms);
        } else {
            for (TransformDefinition transform : transforms) {
                for (TransformServerInfo server : servers) {
                    if (!server.getTransforms().contains(transform.getName())) continue;
                    DefaultTransformMenuFactory.addToMap((Map<TransformServerInfo, Collection<TransformDefinition>>)map, server, transform);
                }
            }
        }
        return map;
    }

    private static void addToMap(Map<TransformServerInfo, Collection<TransformDefinition>> map, TransformServerInfo server, TransformDefinition transform) {
        Collection<TransformDefinition> transforms = map.get(server);
        if (transforms == null) {
            transforms = new LinkedList<TransformDefinition>();
            map.put(server, transforms);
        }
        transforms.add(transform);
    }

    private boolean showUtilityActionsIfEmpty() {
        return true;
    }

    private boolean showSets() {
        return true;
    }

    private boolean showEmptySets() {
        return false;
    }

    private boolean showRunAllTransforms() {
        return true;
    }

    private boolean showRunAllInThisSet() {
        return true;
    }

    private boolean addOrphanTransformsAsSet() {
        return true;
    }

    private boolean askWhenRunningAllTransforms() {
        return true;
    }

    private boolean showAllSet() {
        return true;
    }

    private int tasSelection() {
        return 1;
    }

    private int tasSorting() {
        return 1;
    }

    private int setSorting() {
        return 1;
    }

    private int transformSorting() {
        return 1;
    }

    private MenuViewItem[] createTransforms(Collection<TransformDefinition> transforms, GraphID graphID, Set<EntityID> entities) {
        return this.createTransforms(transforms, null, graphID, entities);
    }

    private MenuViewItem[] createTransforms(Collection<TransformDefinition> transforms, MenuViewItem allTransforms, GraphID graphID, Set<EntityID> entities) {
        ArrayList<MenuViewItem> nodes = new ArrayList<MenuViewItem>();
        for (TransformDefinition def : transforms) {
            nodes.add(this.createTransformNode(def, graphID, entities));
        }
        if (allTransforms != null) {
            nodes.add(null);
            nodes.add(allTransforms);
        }
        MenuViewItem[] items = nodes.toArray(new MenuViewItem[nodes.size()]);
        if (this.transformSorting() == 1) {
            Arrays.sort(items, new TransformMenuFactory.DisplayAscendingComparator());
        }
        return items;
    }

    private MenuViewItem[] createSets(Collection<TransformDefinition> transforms, GraphID graphID, Set<EntityID> entities) {
        MenuViewItem allSet;
        boolean showEmptySets = this.showEmptySets();
        ArrayList<Object> nodes = new ArrayList<Object>();
        HashSet<TransformDefinition> otherTransforms = new HashSet<TransformDefinition>();
        otherTransforms.addAll(transforms);
        if (this.showAllSet() && (allSet = this.createAllSetNode(transforms, graphID, entities)).getChildren().length > 0) {
            nodes.add(this.createAllSetNode(transforms, graphID, entities));
        }
        Set sets = TransformSetRepository.getDefault().allSets();
        ArrayList<MenuViewItem> setNodes = new ArrayList<MenuViewItem>();
        for (TransformSet set : sets) {
            Set subSet = set.getIntersection(transforms);
            if (subSet.isEmpty() && !showEmptySets) continue;
            otherTransforms.removeAll(subSet);
            setNodes.add(this.createSetNode(set.getName(), set.getDescription(), subSet, graphID, entities));
        }
        if (this.setSorting() == 1) {
            Collections.sort(setNodes, new TransformMenuFactory.DisplayAscendingComparator());
        }
        nodes.addAll(setNodes);
        MenuViewItem runAllTransforms = this.createAllTransformsNode(transforms, graphID, entities);
        if (nodes.isEmpty()) {
            return this.createTransforms(transforms, runAllTransforms, graphID, entities);
        }
        if (!otherTransforms.isEmpty()) {
            if (this.addOrphanTransformsAsSet()) {
                if (!setNodes.isEmpty()) {
                    nodes.add(this.createSetNode("Other transforms", "Transforms that are not in any set", otherTransforms, graphID, entities));
                }
            } else {
                nodes.addAll(Arrays.asList(this.createTransforms(otherTransforms, null, graphID, entities)));
            }
        }
        if (runAllTransforms != null) {
            nodes.add(null);
            nodes.add(runAllTransforms);
        }
        return nodes.toArray(new MenuViewItem[nodes.size()]);
    }

    private MenuViewItem createAllTransformsNode(Collection<TransformDefinition> allTransforms, GraphID graphID, Set<EntityID> entities) {
        if (this.showRunAllTransforms() && allTransforms.size() > 0) {
            return this.createTransformsNode("All transforms", allTransforms, this.askWhenRunningAllTransforms(), graphID, entities, true);
        }
        return null;
    }

    private MenuViewItem createTransformsNode(String title, Collection<TransformDefinition> transforms, boolean ask, GraphID graphID, Set<EntityID> entities, boolean runAll) {
        TransformsAction action = new TransformsAction(transforms, null, ask, graphID, entities, runAll);
        BasicMenuViewItem node = new BasicMenuViewItem((Action)action);
        node.setDisplayName(title);
        return node;
    }

    private MenuViewItem createTransformNode(TransformDefinition transform, GraphID graphID, Set<EntityID> entities) {
        BasicMenuViewItem node;
        if (this.tasSelection() == 1) {
            Set servers = TransformServerRegistry.getDefault().findServers(transform.getName(), true);
            if (servers.isEmpty()) {
                node = this.createActionItem(transform, null, graphID, entities);
            } else if (servers.size() == 1) {
                node = this.createActionItem(transform, (TransformServerInfo)servers.iterator().next(), graphID, entities);
            } else {
                node = new BasicMenuViewItem(this.createTasChildren(servers, transform, graphID, entities));
                String name = transform.getName();
                node.setName(name);
                node.setSettingsAction((ActionListener)(name == null ? null : new TransformSettingsAction(name)));
            }
        } else {
            node = this.createActionItem(transform, null, graphID, entities);
        }
        node.setDescription(transform.getDescription());
        node.setDisplayName(transform.getHtmlDisplayName());
        return node;
    }

    private MenuViewItem[] createTasChildren(Set<TransformServerInfo> servers, TransformDefinition transform, GraphID graphID, Set<EntityID> entities) {
        BasicMenuViewItem[] items = new BasicMenuViewItem[servers.size()];
        int index = 0;
        for (TransformServerInfo server : servers) {
            items[index] = new BasicMenuViewItem((Action)new TransformAction(transform, server, graphID, entities));
            String url = server.getHelpUrl(transform);
            items[index].setHelpAction((ActionListener)(url == null ? null : new ShowUrlAction(url)));
            items[index].setDescription(server.getDescription());
            items[index].setDisplayName(server.getDisplayName());
            ++index;
        }
        if (this.tasSorting() == 1) {
            Arrays.sort(items, new TransformMenuFactory.DisplayAscendingComparator());
        }
        return items;
    }

    private BasicMenuViewItem createActionItem(TransformDefinition transform, TransformServerInfo server, GraphID graphID, Set<EntityID> entities) {
        String url = server.getHelpUrl(transform);
        String name = transform.getName();
        BasicMenuViewItem item = new BasicMenuViewItem((Action)new TransformAction(transform, server, graphID, entities));
        item.setName(name);
        item.setHelpAction((ActionListener)(url == null ? null : new ShowUrlAction(url)));
        item.setSettingsAction((ActionListener)(name == null ? null : new TransformSettingsAction(name)));
        return item;
    }

    private MenuViewItem createSetNode(String name, String description, Collection<TransformDefinition> transforms, GraphID graphID, Set<EntityID> entities) {
        MenuViewItem[] children = this.createTransforms(transforms, graphID, entities);
        if (children.length > 0 && this.showRunAllInThisSet()) {
            children = Arrays.copyOf(children, children.length + 2);
            children[children.length - 1] = this.createTransformsNode("All in this set", transforms, false, graphID, entities, true);
        }
        BasicMenuViewItem node = new BasicMenuViewItem(children);
        node.setDisplayName(name);
        node.setDescription(description);
        return node;
    }

    private MenuViewItem createAllSetNode(Collection<TransformDefinition> transforms, GraphID graphID, Set<EntityID> entities) {
        MenuViewItem[] children = this.createTransforms(transforms, graphID, entities);
        if (children.length > 0 && this.showRunAllInThisSet()) {
            children = Arrays.copyOf(children, children.length + 2);
            children[children.length - 1] = this.createAllTransformsNode(transforms, graphID, entities);
        }
        BasicMenuViewItem node = new BasicMenuViewItem(children);
        node.setDisplayName("All Transforms");
        node.setDescription("All transforms independent of their set");
        return node;
    }

    private MenuViewItem[] createEmptyActions() {
        AbstractAction a = new AbstractAction("(empty)"){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        a.setEnabled(false);
        return new MenuViewItem[]{new BasicMenuViewItem((Action)a)};
    }

    private MenuViewItem[] createUtilityActions() {
        List actions = Utilities.actionsForPath((String)"Maltego/ContextActions/EmptyTransformPopup");
        MenuViewItem[] items = new MenuViewItem[actions.size()];
        for (int i = 0; i < actions.size(); ++i) {
            items[i] = actions.get(i) == null ? null : new BasicMenuViewItem((Action)actions.get(i));
        }
        return items;
    }

    private MenuViewItem[] restrictMaxItemsPerMenu(MenuViewItem[] items, int max) {
        if (items == null) {
            return null;
        }
        if (items.length > max) {
            ArrayList<MenuViewItem> keepItems = new ArrayList<MenuViewItem>(Arrays.asList(Arrays.copyOf(items, max - 1)));
            MenuViewItem[] subMenuItems = Arrays.copyOfRange(items, max - 1, items.length);
            BasicMenuViewItem moreItem = new BasicMenuViewItem(subMenuItems);
            moreItem.setDisplayName("More");
            moreItem.setChildren(subMenuItems);
            keepItems.add((MenuViewItem)moreItem);
            items = keepItems.toArray(new MenuViewItem[keepItems.size()]);
        }
        for (MenuViewItem item : items) {
            if (!(item instanceof BasicMenuViewItem)) continue;
            BasicMenuViewItem abstractItem = (BasicMenuViewItem)item;
            abstractItem.setChildren(this.restrictMaxItemsPerMenu(abstractItem.getChildren(), max));
        }
        return items;
    }

    private int getMaxMenuItemsForScreen() {
        Rectangle bounds = WindowManager.getDefault().getMainWindow().getGraphicsConfiguration().getBounds();
        int height = new JMenuItem((String)"GetHeight").getPreferredSize().height;
        return Math.max(bounds.height / height, 10);
    }

    private static class TransformSettingsAction
    implements ActionListener {
        private final String _name;

        public TransformSettingsAction(String name) {
            this._name = name;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TransformManager.getDefault().openTransform(this._name);
        }
    }

    private static class ShowUrlAction
    implements ActionListener {
        private final String _url;

        public ShowUrlAction(String url) {
            this._url = url;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                URL url = new URL(this._url);
                if (!FileUtilities.isRemoteFileURL((URL)url)) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                }
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static class TransformAction
    extends AbstractAction {
        private final GraphID _graphID;
        private final Set<EntityID> _entities;
        private final TransformDefinition _transform;
        private final TransformServerInfo _server;

        public TransformAction(TransformDefinition def, TransformServerInfo server, GraphID graphID, Set<EntityID> entities) {
            this._graphID = graphID;
            this._entities = entities;
            this._transform = def;
            this._server = server;
            this.putValue(MenuViewFactory.ACTION_CAN_REPEAT, Boolean.FALSE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TransformRequestProcessor.getDefault().runTransform(this._transform, this._server, this._graphID, this._entities, TransformRunOrigin.fromDirectRun());
        }
    }

    private static class TransformsAction
    extends AbstractAction {
        private final GraphID _graphID;
        private final Set<EntityID> _entities;
        private final Collection<? extends TransformDefinition> _transforms;
        private final boolean _ask;
        private final TransformServerInfo _server;
        private final boolean _runAll;

        public TransformsAction(Collection<? extends TransformDefinition> defs, TransformServerInfo server, boolean ask, GraphID graphID, Set<EntityID> entities, boolean runAll) {
            this._graphID = graphID;
            this._entities = entities;
            this._transforms = defs;
            this._ask = ask;
            this._server = server;
            this._runAll = runAll;
            this.putValue(MenuViewFactory.ACTION_CAN_REPEAT, Boolean.FALSE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.ask()) {
                TransformRequestProcessor.getDefault().runTransforms(this._transforms, this._server, this._graphID, this._entities, this._runAll, TransformRunOrigin.fromDirectRun());
            }
        }

        private boolean ask() {
            if (this._ask) {
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)("Running " + this.getDisplayName() + " can take a long time and might not return valuable results.\nAre you sure you want to do that?"), "Run " + this.getDisplayName(), 1);
                return DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.YES_OPTION;
            }
            return true;
        }

        private String getDisplayName() {
            return (String)this.getValue("Name");
        }
    }
}

