/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.store.syncronization;

import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.authorization.store.syncronization.Synchronizer;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.authorization.GroupPolicyRepresentation;

public class GroupSynchronizer
implements Synchronizer<GroupModel.GroupRemovedEvent> {
    @Override
    public void synchronize(GroupModel.GroupRemovedEvent event, KeycloakSessionFactory factory) {
        ProviderFactory providerFactory = factory.getProviderFactory(AuthorizationProvider.class);
        AuthorizationProvider authorizationProvider = (AuthorizationProvider)providerFactory.create(event.getKeycloakSession());
        StoreFactory storeFactory = authorizationProvider.getStoreFactory();
        PolicyStore policyStore = storeFactory.getPolicyStore();
        GroupModel group = event.getGroup();
        EnumMap<Policy.FilterOption, String[]> attributes = new EnumMap<Policy.FilterOption, String[]>(Policy.FilterOption.class);
        attributes.put(Policy.FilterOption.TYPE, new String[]{"group"});
        attributes.put(Policy.FilterOption.CONFIG, new String[]{"groups", group.getId()});
        attributes.put(Policy.FilterOption.ANY_OWNER, Policy.FilterOption.EMPTY_FILTER);
        List<Policy> search = policyStore.find(null, attributes, null, null);
        for (Policy policy : search) {
            PolicyProviderFactory policyFactory = authorizationProvider.getProviderFactory(policy.getType());
            GroupPolicyRepresentation representation = (GroupPolicyRepresentation)GroupPolicyRepresentation.class.cast(policyFactory.toRepresentation(policy, authorizationProvider));
            Set groups = representation.getGroups();
            groups.removeIf(groupDefinition -> groupDefinition.getId().equals(group.getId()));
            policyFactory.onUpdate(policy, representation, authorizationProvider);
        }
    }
}

