/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.chatapi;

import com.paterva.maltego.chatapi.ChatRoom;
import com.paterva.maltego.chatapi.file.DefaultFileTransferController;
import com.paterva.maltego.chatapi.file.FileTransferController;
import com.paterva.maltego.chatapi.msg.ChatMessagePropagator;
import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.chatapi.user.User;
import com.paterva.maltego.chatapi.user.UserPresence;
import com.paterva.maltego.util.output.OutputMessage;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractChatRoom
implements ChatRoom {
    private String _name;
    private String _dnsName;
    private Map<User, UserPresence> _users = new HashMap<User, UserPresence>();
    private User _clientUser;
    private PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private FileTransferController _fileTransferController = new DefaultFileTransferController();
    private Date _created = new Date();

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getDnsName() {
        return this._dnsName;
    }

    @Override
    public void setDnsName(String dnsName) {
        this._dnsName = dnsName;
    }

    public void add(User user, UserPresence presence) {
        this._users.put(user, presence);
        this.firePropertyChanged("chatRoomUserAdded", null, user);
    }

    public void remove(User user) {
        this._users.remove(user);
        this.firePropertyChanged("chatRoomUserRemoved", user, null);
    }

    @Override
    public List<User> getUsers() {
        return new ArrayList<User>(this._users.keySet());
    }

    public void setClientUser(User user) {
        this._clientUser = user;
    }

    @Override
    public User getClientUser() {
        return this._clientUser;
    }

    @Override
    public UserPresence getPresence(User user) {
        return this._users.get(user);
    }

    public void setPresence(User user, UserPresence presence) {
        this._users.put(user, presence);
        this.firePropertyChanged("chatRoomUserPresence", null, user);
    }

    @Override
    public String getAlias(User user) {
        return user.equals(this.getClientUser()) ? String.format("%s (you)", user.getAlias()) : user.getAlias();
    }

    @Override
    public String getCreator() {
        return "<unknown>";
    }

    @Override
    public Date getCreatedDate() {
        return this._created;
    }

    @Override
    public void logMessage(LogMessageLevel level, OutputMessage chatMessage, Date date) {
        this.fireLogMessage(level, chatMessage, date);
    }

    @Override
    public void logMessage(LogMessageLevel level, OutputMessage chatMessage, Color color, Date date) {
        this.fireLogMessage(level, chatMessage, color, date);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public FileTransferController getFileTransferController() {
        return this._fileTransferController;
    }

    protected void fireReceivedChatMessage(User user, OutputMessage chatMessage, Date date) {
        ChatMessagePropagator.chatMessage(this, user, chatMessage, date);
    }

    protected void fireLogMessage(LogMessageLevel level, OutputMessage chatMessage, Date date) {
        ChatMessagePropagator.logMessage(this, level, chatMessage, date);
    }

    protected void fireLogMessage(LogMessageLevel level, OutputMessage chatMessage, Color color, Date date) {
        ChatMessagePropagator.logMessage(this, level, chatMessage, color, date);
    }

    protected void fireUserChanged(User user) {
        this.firePropertyChanged("chatRoomUserChanged", null, user);
    }

    protected void firePropertyChanged(String property, Object oldValue, Object newValue) {
        this._changeSupport.firePropertyChange(property, oldValue, newValue);
    }
}

