/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.detailview;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.GraphLink;
import com.paterva.maltego.core.GraphPart;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.detailview.EmptyDetailView;
import com.paterva.maltego.detailview.collection.EntityCollectionHeader;
import com.paterva.maltego.detailview.collection.LinkCollectionHeader;
import com.paterva.maltego.detailview.html.HtmlDetailView;
import com.paterva.maltego.detailview.html.HtmlSelectListener;
import com.paterva.maltego.detailview.inspect.InspectBackPanel;
import com.paterva.maltego.detailview.inspect.Inspector;
import com.paterva.maltego.detailview.inspect.InspectorRegistry;
import com.paterva.maltego.detailview.list.EntityListDetailView;
import com.paterva.maltego.detailview.list.LinkListDetailView;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.selection.SelectionState;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.view.GraphModelViewMappings;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.ui.graph.GraphSelectionContext;
import com.paterva.maltego.ui.graph.HoverContext;
import com.paterva.maltego.ui.graph.SelectionProvider;
import com.paterva.maltego.util.ui.MouseUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DetailViewTopComponent
extends TopComponent
implements SelectionProvider {
    private static DetailViewTopComponent instance;
    private static final Logger LOG;
    private static final String PREFERRED_ID = "DetailViewTopComponent";
    private static final String SINGLE_NODE_VIEW = "SingleNodeView";
    private static final String ENTITY_LIST_VIEW = "EntityListView";
    private static final String LINK_LIST_VIEW = "LinkListView";
    private static final String EMPTY_NODE_VIEW = "EmptyNodeView";
    private final HtmlDetailView _htmlView = new HtmlDetailView();
    private final EntityListDetailView _entityListView = new EntityListDetailView();
    private final LinkListDetailView _linkListView = new LinkListDetailView();
    private final EntityCollectionHeader _entityCollectionHeader = new EntityCollectionHeader();
    private final LinkCollectionHeader _linkCollectionHeader = new LinkCollectionHeader();
    private final JPanel _singleHtmlView;
    private final HoverContext _hoverContext = HoverContext.forContextID((String)"graph");
    private final ChangeSupport _selectionChangeSupport = new ChangeSupport((Object)this);
    private String _currentCard = "EmptyNodeView";
    private HoverSelectListener _hoverListener;
    private ChangeListener _selectionListener;
    private AWTEventListener _rightClickBackListener;
    private GraphPart _hoveredPart;
    private GraphPart _selectedPart;
    private GraphPart _hoveredOrSelectedPart;

    public DetailViewTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(DetailViewTopComponent.class, (String)"CTL_DetailViewTopComponent"));
        this.setToolTipText(NbBundle.getMessage(DetailViewTopComponent.class, (String)"HINT_DetailViewTopComponent"));
        this.add(new EmptyDetailView(), EMPTY_NODE_VIEW);
        this._singleHtmlView = new JPanel(new BorderLayout());
        this.add(this._singleHtmlView, SINGLE_NODE_VIEW);
        JPanel entityListAndHeader = new JPanel(new BorderLayout());
        entityListAndHeader.add((Component)this._entityCollectionHeader, "North");
        entityListAndHeader.add(this._entityListView);
        this.add(entityListAndHeader, ENTITY_LIST_VIEW);
        JPanel linkListAndHeader = new JPanel(new BorderLayout());
        linkListAndHeader.add((Component)this._linkCollectionHeader, "North");
        linkListAndHeader.add(this._linkListView);
        this.add(linkListAndHeader, LINK_LIST_VIEW);
    }

    public void addNotify() {
        super.addNotify();
        this._hoverListener = new HoverSelectListener();
        this._hoverContext.addPropertyChangeListener((PropertyChangeListener)this._hoverListener);
        this._selectionListener = new GraphSelectionListener();
        GraphSelectionContext.instance().addChangeListener(this._selectionListener);
    }

    public void removeNotify() {
        this._hoverContext.removePropertyChangeListener((PropertyChangeListener)this._hoverListener);
        this._hoverListener = null;
        GraphSelectionContext.instance().removeChangeListener(this._selectionListener);
        this._selectionListener = null;
        this.render(null);
        super.removeNotify();
    }

    private void initComponents() {
        this.setLayout(new CardLayout());
    }

    public static synchronized DetailViewTopComponent getDefault() {
        if (instance == null) {
            instance = new DetailViewTopComponent();
        }
        return instance;
    }

    public static synchronized DetailViewTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(DetailViewTopComponent.class.getName()).warning("Cannot find DetailViewTopComponent component. It will not be located properly in the window system.");
            return DetailViewTopComponent.getDefault();
        }
        if (win instanceof DetailViewTopComponent) {
            return (DetailViewTopComponent)win;
        }
        Logger.getLogger(DetailViewTopComponent.class.getName()).warning("There seem to be multiple components with the 'DetailViewTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return DetailViewTopComponent.getDefault();
    }

    public void addHtmlSelectListener(HtmlSelectListener listener) {
        this._htmlView.addHtmlSelectListener(listener);
    }

    public void removeHtmlSelectListener(HtmlSelectListener listener) {
        this._htmlView.removeHtmlSelectListener(listener);
    }

    public int getPersistenceType() {
        return 0;
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    Object readProperties(Properties p) {
        DetailViewTopComponent singleton = DetailViewTopComponent.getDefault();
        singleton.readPropertiesImpl(p);
        return singleton;
    }

    private void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private void updateContentSafe() {
        try {
            this.updateContent();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void updateContent() throws GraphStoreException {
        boolean mustUpdate;
        GraphPart newSinglePart;
        LOG.fine("Update content");
        LOG.fine(() -> "BEFORE Hover:  " + this._hoveredPart);
        LOG.fine(() -> "BEFORE Select: " + this._selectedPart);
        LOG.fine(() -> "BEFORE Final:  " + this._hoveredOrSelectedPart);
        GraphPart hoverPart = this._hoverContext.getHoverPart();
        if (hoverPart != null) {
            GraphID graphID = hoverPart.getGraphID();
            if (!GraphStoreRegistry.getDefault().isExistingAndOpen(graphID)) {
                hoverPart = null;
            } else {
                GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
                if (!this.exist((GraphStore)view, hoverPart) && !this.exist(view.getModel(), hoverPart)) {
                    hoverPart = null;
                }
            }
        }
        GraphPart selectedPart = this.getSingleSelectedPart();
        LOG.log(Level.FINE, "Hover:  {0}", hoverPart);
        LOG.log(Level.FINE, "Select: {0}", selectedPart);
        boolean collectionChanged = Utilities.compareObjects((Object)this._hoveredPart, (Object)hoverPart) && Utilities.compareObjects((Object)this._selectedPart, (Object)selectedPart);
        GraphPart graphPart = newSinglePart = hoverPart != null ? hoverPart : selectedPart;
        if (collectionChanged) {
            LOG.fine("Collection changed");
            mustUpdate = true;
        } else {
            boolean bl = mustUpdate = !Utilities.compareObjects((Object)this._hoveredOrSelectedPart, (Object)newSinglePart);
            if (mustUpdate) {
                LOG.log(Level.FINE, "Old hover or select part: {0}", this._hoveredOrSelectedPart);
            }
        }
        this._hoveredPart = hoverPart;
        this._selectedPart = selectedPart;
        this._hoveredOrSelectedPart = newSinglePart;
        LOG.fine(() -> "AFTER Hover:  " + this._hoveredPart);
        LOG.fine(() -> "AFTER Select: " + this._selectedPart);
        LOG.fine(() -> "AFTER Final:  " + this._hoveredOrSelectedPart);
        if (mustUpdate) {
            LOG.log(Level.FINE, "Hover or select part: {0}", this._hoveredOrSelectedPart);
            this.updateContentSecondary();
        }
    }

    private boolean exist(GraphStore graphStore, GraphPart hoverPart) throws GraphStoreException {
        GraphLink graphLink;
        GraphEntity graphEntity;
        GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
        return hoverPart instanceof GraphEntity ? structureReader.exists((EntityID)(graphEntity = (GraphEntity)hoverPart).getID()) : hoverPart instanceof GraphLink && structureReader.exists((LinkID)(graphLink = (GraphLink)hoverPart).getID());
    }

    private GraphPart getSingleSelectedPart() throws GraphStoreException {
        Set links;
        GraphSelectionContext selectionCtx = GraphSelectionContext.instance();
        GraphID graphID = selectionCtx.getTopGraphID();
        if (!GraphStoreRegistry.getDefault().isExistingAndOpen(graphID)) {
            return null;
        }
        Set entities = selectionCtx.getSelectedViewEntities();
        GraphSelection topGraphSelection = selectionCtx.getTopGraphSelection();
        if (entities.size() == 1) {
            EntityID entityID = (EntityID)entities.iterator().next();
            SelectionState viewSelectionState = topGraphSelection.getViewSelectionState(entityID);
            if (viewSelectionState == SelectionState.YES) {
                return new GraphEntity(graphID, entityID);
            }
            if (viewSelectionState == SelectionState.PARTIAL && (entities = selectionCtx.getSelectedModelEntities()).size() == 1) {
                entityID = (EntityID)entities.iterator().next();
                return new GraphEntity(graphID, entityID);
            }
        } else if (entities.isEmpty() && (links = selectionCtx.getSelectedViewLinks()).size() == 1) {
            LinkID linkID = (LinkID)links.iterator().next();
            SelectionState viewSelectionState = topGraphSelection.getViewSelectionState(linkID);
            if (viewSelectionState == SelectionState.YES) {
                return new GraphLink(graphID, linkID);
            }
            if (viewSelectionState == SelectionState.PARTIAL && (links = selectionCtx.getSelectedModelLinks()).size() == 1) {
                linkID = (LinkID)links.iterator().next();
                return new GraphLink(graphID, linkID);
            }
        }
        return null;
    }

    private void updateContentSecondary() throws GraphStoreException {
        GraphID graphID;
        LOG.fine("Update content secondary");
        boolean showEmpty = true;
        GraphPart part = this._hoveredOrSelectedPart;
        if (part != null) {
            graphID = part.getGraphID();
            if (!GraphStoreRegistry.getDefault().isExistingAndOpen(graphID)) {
                part = null;
                this._hoveredOrSelectedPart = null;
            }
        }
        if (part != null) {
            GraphLink graphLink;
            LinkID linkID;
            graphID = part.getGraphID();
            GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
            GraphModelViewMappings mappings = view.getModelViewMappings();
            boolean showMulti = false;
            if (part instanceof GraphEntity) {
                GraphEntity graphEntity = (GraphEntity)part;
                EntityID entityID = (EntityID)graphEntity.getID();
                if (mappings.isOnlyViewEntity(entityID)) {
                    LOG.log(Level.FINE, "Show collection node: {0}", graphEntity);
                    Set modelEntities = mappings.getModelEntities(entityID);
                    this.showCard(ENTITY_LIST_VIEW);
                    this._entityCollectionHeader.setEntity(graphEntity);
                    this._entityListView.setEntities(graphID, modelEntities);
                    showMulti = true;
                }
            } else if (part instanceof GraphLink && mappings.isOnlyViewLink(linkID = (LinkID)(graphLink = (GraphLink)part).getID())) {
                LOG.log(Level.FINE, "Show collection edge: {0}", graphLink);
                Set modelLinks = mappings.getModelLinks(linkID);
                this.showCard(LINK_LIST_VIEW);
                this._linkCollectionHeader.setLink(graphLink);
                this._linkListView.setLinks(graphID, modelLinks);
                showMulti = true;
            }
            if (!showMulti) {
                this.onShowHover();
                this.render(part);
            } else {
                this.onShowSelection(true);
            }
            showEmpty = false;
        } else {
            GraphSelectionContext selectionCtx = GraphSelectionContext.instance();
            Set selectedModelEntities = selectionCtx.getSelectedModelEntities();
            LOG.log(Level.FINE, "Selected entities: {0}", selectedModelEntities);
            if (selectedModelEntities != null && !selectedModelEntities.isEmpty()) {
                this.showCard(ENTITY_LIST_VIEW);
                this._entityCollectionHeader.setEntity(null);
                this._entityListView.setEntities(selectionCtx.getTopGraphID(), selectedModelEntities);
                showEmpty = false;
            } else {
                Set selectedModelLinks = selectionCtx.getSelectedModelLinks();
                LOG.log(Level.FINE, "Selected links: {0}", selectedModelLinks);
                if (selectedModelLinks != null && !selectedModelLinks.isEmpty()) {
                    this.showCard(LINK_LIST_VIEW);
                    this._linkCollectionHeader.setLink(null);
                    this._linkListView.setLinks(selectionCtx.getTopGraphID(), selectedModelLinks);
                    showEmpty = false;
                }
            }
            if (!showEmpty) {
                this.onShowSelection(false);
            }
        }
        if (showEmpty) {
            this.onShowEmpty();
            this.render(null);
        }
    }

    private void render(GraphPart part) {
        if (part == null) {
            LOG.fine("Render empty");
            this.showCard(EMPTY_NODE_VIEW);
            this._htmlView.setSelectedPart(null);
            this._entityCollectionHeader.setEntity(null);
            this._linkCollectionHeader.setLink(null);
        } else {
            LOG.log(Level.FINE, "Render {0}", part);
            this._htmlView.setSelectedPart(part);
            GraphID graphID = part.getGraphID();
            Inspector inspector = InspectorRegistry.forGraph(graphID);
            this._singleHtmlView.removeAll();
            if (inspector.canBack()) {
                InspectBackPanel backButton = inspector.getBackButton();
                backButton.setPartID(part.getID());
                backButton.updateVisible();
                this._singleHtmlView.add((Component)backButton, "South");
                this.addRightClickListener(graphID);
            }
            this._singleHtmlView.add(this._htmlView);
            this.showCard(SINGLE_NODE_VIEW);
            this._selectionChangeSupport.fireChange();
        }
    }

    private void showCard(String name) {
        if (!SINGLE_NODE_VIEW.equals(name)) {
            this.removeRightClickListener();
        }
        CardLayout layout = (CardLayout)this.getLayout();
        layout.show((Container)((Object)this), name);
        this._currentCard = name;
    }

    protected void onShowHover() {
    }

    protected void onShowSelection(boolean singleSelection) {
    }

    protected void onShowEmpty() {
    }

    public Set<EntityID> getSelectedModelEntities() {
        Set<Guid> selected = Collections.EMPTY_SET;
        if (ENTITY_LIST_VIEW.equals(this._currentCard)) {
            selected = this._entityListView.getSelectedModelEntities();
            if (selected.isEmpty()) {
                selected = GraphSelectionContext.instance().getSelectedModelEntities();
            }
        } else if (this._selectedPart instanceof GraphEntity) {
            GraphEntity graphEntity = (GraphEntity)this._selectedPart;
            GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(this._selectedPart.getGraphID());
            GraphModelViewMappings mappings = view.getModelViewMappings();
            try {
                if (mappings.isModelEntity((EntityID)graphEntity.getID())) {
                    selected = Collections.singleton(graphEntity.getID());
                }
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return selected;
    }

    public Set<LinkID> getSelectedModelLinks() {
        Set<Guid> selected = Collections.EMPTY_SET;
        if (LINK_LIST_VIEW.equals(this._currentCard)) {
            selected = this._linkListView.getSelectedModelLinks();
            if (selected.isEmpty()) {
                selected = GraphSelectionContext.instance().getSelectedModelLinks();
            }
        } else if (this._selectedPart instanceof GraphLink) {
            GraphLink graphLink = (GraphLink)this._selectedPart;
            GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(this._selectedPart.getGraphID());
            GraphModelViewMappings mappings = view.getModelViewMappings();
            try {
                if (mappings.isModelLink((LinkID)graphLink.getID())) {
                    selected = Collections.singleton(graphLink.getID());
                }
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return selected;
    }

    public void addSelectionChangeListener(ChangeListener listener) {
        this._entityListView.addSelectionChangeListener(listener);
        this._linkListView.addSelectionChangeListener(listener);
        this._selectionChangeSupport.addChangeListener(listener);
    }

    public void removeSelectionChangeListener(ChangeListener listener) {
        this._entityListView.removeSelectionChangeListener(listener);
        this._linkListView.removeSelectionChangeListener(listener);
        this._selectionChangeSupport.removeChangeListener(listener);
    }

    private void addRightClickListener(GraphID graphID) {
        this._rightClickBackListener = new RightClickListener(graphID, (Component)((Object)this));
        Toolkit.getDefaultToolkit().addAWTEventListener(this._rightClickBackListener, 16L);
    }

    private void removeRightClickListener() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this._rightClickBackListener);
        this._rightClickBackListener = null;
    }

    static {
        LOG = Logger.getLogger(DetailViewTopComponent.class.getName());
    }

    private static class RightClickListener
    implements AWTEventListener {
        private final GraphID _graphID;
        private final Component _component;

        public RightClickListener(GraphID graphID, Component c) {
            this._graphID = graphID;
            this._component = c;
        }

        @Override
        public void eventDispatched(AWTEvent e) {
            MouseEvent m;
            if (e instanceof MouseEvent && (m = (MouseEvent)e).getID() == 500 && SwingUtilities.isRightMouseButton(m) && MouseUtil.isMouseInComponent((Component)this._component)) {
                try {
                    Inspector inspector;
                    if (GraphStoreRegistry.getDefault().isExistingAndOpen(this._graphID) && (inspector = InspectorRegistry.forGraph(this._graphID)).canBack()) {
                        inspector.back();
                    }
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private class GraphSelectionListener
    implements ChangeListener {
        private GraphSelectionListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            DetailViewTopComponent.this.updateContentSafe();
        }
    }

    private class HoverSelectListener
    implements PropertyChangeListener {
        private HoverSelectListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            GraphPart hoverPart = DetailViewTopComponent.this._hoverContext.getHoverPart();
            if (!Utilities.compareObjects((Object)DetailViewTopComponent.this._hoveredPart, (Object)hoverPart)) {
                LOG.fine(() -> "Old Hover: " + DetailViewTopComponent.this._hoveredPart);
                LOG.fine(() -> "New Hover: " + hoverPart);
                DetailViewTopComponent.this.updateContentSafe();
            }
        }
    }
}

