/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.api;

import com.google.gson.annotations.SerializedName;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeedTagType;
import com.paterva.maltego.seeds.api.HubSeedUrl;
import java.util.Collections;
import java.util.List;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="Mtg", strict=false)
public class HubSeeds {
    @ElementList(name="Seeds", type=HubSeedDescriptor.class, required=true)
    @SerializedName(value="Seeds")
    private List<HubSeedDescriptor> _seeds;
    @ElementList(name="TagTypes", type=HubSeedTagType.class, required=false)
    @SerializedName(value="TagTypes")
    private List<HubSeedTagType> _tagTypes;

    public HubSeeds() {
    }

    public HubSeeds(List<HubSeedDescriptor> seeds, List<HubSeedTagType> tagTypes) {
        this._seeds = seeds;
        this._tagTypes = tagTypes;
    }

    public List<HubSeedDescriptor> getSeeds() {
        return this._seeds;
    }

    public HubSeedDescriptor getSeedForName(String name) {
        if (this._seeds != null && name != null) {
            for (HubSeedDescriptor sd : this._seeds) {
                if (!name.equals(sd.getName())) continue;
                return sd;
            }
        }
        return null;
    }

    public HubSeedDescriptor getSeedForUrl(String url) {
        if (this._seeds != null && url != null) {
            for (HubSeedDescriptor sd : this._seeds) {
                for (HubSeedUrl otherURL : sd.getGrantedHubSeedUrls()) {
                    if (otherURL == null || !url.equals(otherURL.getUrl())) continue;
                    return sd;
                }
            }
        }
        return null;
    }

    public HubSeedDescriptor getSeed(String name, HubSeedUrl url) {
        return this.getSeed(name, url != null ? url.getUrl() : null);
    }

    public HubSeedDescriptor getSeed(String name, String url) {
        if (this._seeds != null) {
            for (HubSeedDescriptor sd : this._seeds) {
                if (!sd.isSame(name, url)) continue;
                return sd;
            }
        }
        return null;
    }

    public List<HubSeedTagType> getTagTypes() {
        return this._tagTypes != null ? this._tagTypes : Collections.emptyList();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Seeds:{\n");
        for (HubSeedDescriptor seed : this._seeds) {
            sb.append("   ").append(seed).append("\n");
        }
        sb.append("}\n");
        return sb.toString();
    }
}

