// @HEADER
// *****************************************************************************
//             Xpetra: A linear algebra interface package
//
// Copyright 2012 NTESS and the Xpetra contributors.
// SPDX-License-Identifier: BSD-3-Clause
// *****************************************************************************
// @HEADER

#ifndef XPETRA_TPETRAIMPORT_DECL_HPP
#define XPETRA_TPETRAIMPORT_DECL_HPP

/* this file is automatically generated - do not edit (see script/tpetra.py) */

#include "Xpetra_TpetraConfigDefs.hpp"

#include "Xpetra_Import.hpp"
#include "Xpetra_Exceptions.hpp"

#include "Xpetra_TpetraMap_decl.hpp"
#include "Tpetra_Import.hpp"

namespace Xpetra {

template <class LocalOrdinal,
          class GlobalOrdinal,
          class Node = Tpetra::KokkosClassic::DefaultNode::DefaultNodeType>
class TpetraImport
  : public Import<LocalOrdinal, GlobalOrdinal, Node> {
 public:
  //! The specialization of Map used by this class.
  typedef Map<LocalOrdinal, GlobalOrdinal, Node> map_type;

  //! @name Constructor/Destructor Methods
  //@{

  //! Construct an Import from the source and target Maps.
  TpetraImport(const Teuchos::RCP<const map_type> &source, const Teuchos::RCP<const map_type> &target);

  //! Constructor (with list of parameters).
  TpetraImport(const Teuchos::RCP<const map_type> &source, const Teuchos::RCP<const map_type> &target, const Teuchos::RCP<Teuchos::ParameterList> &plist);

  //! Copy constructor.
  TpetraImport(const Import<LocalOrdinal, GlobalOrdinal, Node> &import);

  //! Destructor.
  ~TpetraImport();

  //! Special "constructor"
  Teuchos::RCP<const Import<LocalOrdinal, GlobalOrdinal, Node> >
  createRemoteOnlyImport(const Teuchos::RCP<const map_type> &remoteTarget) const;

  //@}

  //! @name Import Attribute Methods
  //@{

  //! Number of initial identical IDs.
  size_t getNumSameIDs() const;

  //! Number of IDs to permute but not to communicate.
  size_t getNumPermuteIDs() const;

  //! List of local IDs in the source Map that are permuted.
  ArrayView<const LocalOrdinal> getPermuteFromLIDs() const;

  //! List of local IDs in the target Map that are permuted.
  ArrayView<const LocalOrdinal> getPermuteToLIDs() const;

  //! Number of entries not on the calling process.
  size_t getNumRemoteIDs() const;

  //! List of entries in the target Map to receive from other processes.
  ArrayView<const LocalOrdinal> getRemoteLIDs() const;

  //! Set parameters on distributor
  void setDistributorParameters(const Teuchos::RCP<Teuchos::ParameterList> params) const;

  //! Number of entries that must be sent by the calling process to other processes.
  size_t getNumExportIDs() const;

  //! List of entries in the source Map that will be sent to other processes.
  ArrayView<const LocalOrdinal> getExportLIDs() const;

  //! List of processes to which entries will be sent.
  ArrayView<const int> getExportPIDs() const;

  //! The Source Map used to construct this Import object.
  Teuchos::RCP<const Map<LocalOrdinal, GlobalOrdinal, Node> > getSourceMap() const;

  //! The Target Map used to construct this Import object.
  Teuchos::RCP<const Map<LocalOrdinal, GlobalOrdinal, Node> > getTargetMap() const;

  //@}

  //! @name I/O Methods
  //@{

  //! Print the Import's data to the given output stream.
  void print(std::ostream &os) const;

  //@}

  //! @name Xpetra specific
  //@{

  //! TpetraImport constructor to wrap a Tpetra::Import object
  TpetraImport(const RCP<const Tpetra::Import<LocalOrdinal, GlobalOrdinal, Node> > &import);

  RCP<const Tpetra::Import<LocalOrdinal, GlobalOrdinal, Node> > getTpetra_Import() const;

  //@}

 private:
  RCP<const Tpetra::Import<LocalOrdinal, GlobalOrdinal, Node> > import_;

};  // TpetraImport class

// TODO: move that elsewhere
template <class LocalOrdinal, class GlobalOrdinal, class Node>
const Tpetra::Import<LocalOrdinal, GlobalOrdinal, Node> &toTpetra(const Import<LocalOrdinal, GlobalOrdinal, Node> &import) {
  // TODO: throw exception
  const TpetraImport<LocalOrdinal, GlobalOrdinal, Node> &tpetraImport = dynamic_cast<const TpetraImport<LocalOrdinal, GlobalOrdinal, Node> &>(import);
  return *tpetraImport.getTpetra_Import();
}

template <class LocalOrdinal, class GlobalOrdinal, class Node>
const RCP<const Tpetra::Import<LocalOrdinal, GlobalOrdinal, Node> > toTpetra(const RCP<const Import<LocalOrdinal, GlobalOrdinal, Node> > &importObj) {
  typedef TpetraImport<LocalOrdinal, GlobalOrdinal, Node> TpetraImportClass;
  if (importObj != Teuchos::null) {
    XPETRA_RCP_DYNAMIC_CAST(const TpetraImportClass, rcpFromRef(*importObj), tpetraImport, "toTpetra");
    return tpetraImport->getTpetra_Import();
  }
  return Teuchos::null;
}

template <class LocalOrdinal, class GlobalOrdinal, class Node>
RCP<const Import<LocalOrdinal, GlobalOrdinal, Node> > toXpetra(const RCP<const Tpetra::Import<LocalOrdinal, GlobalOrdinal, Node> > &import) {
  if (!import.is_null())
    return rcp(new TpetraImport<LocalOrdinal, GlobalOrdinal, Node>(import));

  return Teuchos::null;
}

}  // namespace Xpetra

#endif  // XPETRA_TPETRAIMPORT_HPP
