## TFSA-2022-050: `CHECK`-fails due to attempting to build a reference tensor

### CVE Number
CVE-2022-23588

### Impact
A malicious user can cause a denial of service by altering a `SavedModel` such that [Grappler optimizer would attempt to build a tensor using a reference `dtype`](https://github.com/tensorflow/tensorflow/blob/a1320ec1eac186da1d03f033109191f715b2b130/tensorflow/core/grappler/optimizers/constant_folding.cc#L1328-L1402). This would result in a crash due to a `CHECK`-fail [in the `Tensor` constructor](https://github.com/tensorflow/tensorflow/blob/a1320ec1eac186da1d03f033109191f715b2b130/tensorflow/core/framework/tensor.cc#L733-L781) as reference types are not allowed.

### Patches
We have patched the issue in GitHub commit [6b5adc0877de832b2a7c189532dbbbc64622eeb6](https://github.com/tensorflow/tensorflow/commit/6b5adc0877de832b2a7c189532dbbbc64622eeb6).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.
