/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package agent.dbgeng.jna.dbgeng.io;

import java.util.List;

import com.sun.jna.*;
import com.sun.jna.platform.win32.WinDef.*;
import com.sun.jna.platform.win32.WinNT.HRESULT;
import com.sun.jna.win32.StdCallLibrary;

public class VTableIDebugOutputCallbacks2 extends VTableIDebugOutputCallbacks {
	public static class ByReference extends VTableIDebugOutputCallbacks2
			implements Structure.ByReference {
	}

	@SuppressWarnings("hiding")
	public static final List<String> FIELDS =
		createFieldsOrder("QueryInterfaceCallback", "AddRefCallback", "ReleaseCallback",
			"OutputCallback", "GetInterestMaskCallback", "Output2Callback");

	public GetInterestMaskCallback GetInterestMaskCallback;
	public Output2Callback Output2Callback;

	@Override
	public List<String> getFieldOrder() {
		return FIELDS;
	}

	public static interface GetInterestMaskCallback extends StdCallLibrary.StdCallCallback {
		HRESULT invoke(Pointer thisPointer, ULONGByReference Mask);
	}

	public static interface Output2Callback extends StdCallLibrary.StdCallCallback {
		HRESULT invoke(Pointer thisPointer, ULONG Which, ULONG Flags, ULONGLONG Arg, WString Text);
	}
}
