/*************************************************************************
 * odil - Copyright (C) Universite de Strasbourg
 * Distributed under the terms of the CeCILL-B license, as published by
 * the CEA-CNRS-INRIA. Refer to the LICENSE file or to
 * http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 * for details.
 ************************************************************************/

#include <map>
#include <string>
#include <tuple>

#include "odil/ElementsDictionary.h"
#include "odil/Tag.h"

namespace odil
{

namespace registry
{

void update_0018(
    ElementsDictionary & public_dictionary,
    std::map<std::string, odil::Tag> & public_tags)
{

    public_dictionary.emplace(Tag(0x0018, 0x0010), ElementsDictionaryEntry("Contrast/Bolus Agent", "ContrastBolusAgent",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0012), ElementsDictionaryEntry("Contrast/Bolus Agent Sequence", "ContrastBolusAgentSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0013), ElementsDictionaryEntry("Contrast/Bolus T1 Relaxivity", "ContrastBolusT1Relaxivity",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0014), ElementsDictionaryEntry("Contrast/Bolus Administration Route Sequence", "ContrastBolusAdministrationRouteSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0015), ElementsDictionaryEntry("Body Part Examined", "BodyPartExamined",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0020), ElementsDictionaryEntry("Scanning Sequence", "ScanningSequence",  "CS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x0021), ElementsDictionaryEntry("Sequence Variant", "SequenceVariant",  "CS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x0022), ElementsDictionaryEntry("Scan Options", "ScanOptions",  "CS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x0023), ElementsDictionaryEntry("MR Acquisition Type", "MRAcquisitionType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0024), ElementsDictionaryEntry("Sequence Name", "SequenceName",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0025), ElementsDictionaryEntry("Angio Flag", "AngioFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0026), ElementsDictionaryEntry("Intervention Drug Information Sequence", "InterventionDrugInformationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0027), ElementsDictionaryEntry("Intervention Drug Stop Time", "InterventionDrugStopTime",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0028), ElementsDictionaryEntry("Intervention Drug Dose", "InterventionDrugDose",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0029), ElementsDictionaryEntry("Intervention Drug Code Sequence", "InterventionDrugCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x002a), ElementsDictionaryEntry("Additional Drug Sequence", "AdditionalDrugSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0030), ElementsDictionaryEntry("Radionuclide", "Radionuclide",  "LO", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x0031), ElementsDictionaryEntry("Radiopharmaceutical", "Radiopharmaceutical",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0032), ElementsDictionaryEntry("Energy Window Centerline", "EnergyWindowCenterline",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0033), ElementsDictionaryEntry("Energy Window Total Width", "EnergyWindowTotalWidth",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x0034), ElementsDictionaryEntry("Intervention Drug Name", "InterventionDrugName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0035), ElementsDictionaryEntry("Intervention Drug Start Time", "InterventionDrugStartTime",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0036), ElementsDictionaryEntry("Intervention Sequence", "InterventionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0037), ElementsDictionaryEntry("Therapy Type", "TherapyType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0038), ElementsDictionaryEntry("Intervention Status", "InterventionStatus",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0039), ElementsDictionaryEntry("Therapy Description", "TherapyDescription",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x003a), ElementsDictionaryEntry("Intervention Description", "InterventionDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0040), ElementsDictionaryEntry("Cine Rate", "CineRate",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0042), ElementsDictionaryEntry("Initial Cine Run State", "InitialCineRunState",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0050), ElementsDictionaryEntry("Slice Thickness", "SliceThickness",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0060), ElementsDictionaryEntry("KVP", "KVP",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0070), ElementsDictionaryEntry("Counts Accumulated", "CountsAccumulated",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0071), ElementsDictionaryEntry("Acquisition Termination Condition", "AcquisitionTerminationCondition",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0072), ElementsDictionaryEntry("Effective Duration", "EffectiveDuration",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0073), ElementsDictionaryEntry("Acquisition Start Condition", "AcquisitionStartCondition",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0074), ElementsDictionaryEntry("Acquisition Start Condition Data", "AcquisitionStartConditionData",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0075), ElementsDictionaryEntry("Acquisition Termination Condition Data", "AcquisitionTerminationConditionData",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0080), ElementsDictionaryEntry("Repetition Time", "RepetitionTime",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0081), ElementsDictionaryEntry("Echo Time", "EchoTime",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0082), ElementsDictionaryEntry("Inversion Time", "InversionTime",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0083), ElementsDictionaryEntry("Number of Averages", "NumberOfAverages",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0084), ElementsDictionaryEntry("Imaging Frequency", "ImagingFrequency",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0085), ElementsDictionaryEntry("Imaged Nucleus", "ImagedNucleus",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0086), ElementsDictionaryEntry("Echo Number(s)", "EchoNumbers",  "IS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x0087), ElementsDictionaryEntry("Magnetic Field Strength", "MagneticFieldStrength",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0088), ElementsDictionaryEntry("Spacing Between Slices", "SpacingBetweenSlices",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0089), ElementsDictionaryEntry("Number of Phase Encoding Steps", "NumberOfPhaseEncodingSteps",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0090), ElementsDictionaryEntry("Data Collection Diameter", "DataCollectionDiameter",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0091), ElementsDictionaryEntry("Echo Train Length", "EchoTrainLength",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0093), ElementsDictionaryEntry("Percent Sampling", "PercentSampling",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0094), ElementsDictionaryEntry("Percent Phase Field of View", "PercentPhaseFieldOfView",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x0095), ElementsDictionaryEntry("Pixel Bandwidth", "PixelBandwidth",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1000), ElementsDictionaryEntry("Device Serial Number", "DeviceSerialNumber",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1002), ElementsDictionaryEntry("Device UID", "DeviceUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1003), ElementsDictionaryEntry("Device ID", "DeviceID",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1004), ElementsDictionaryEntry("Plate ID", "PlateID",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1005), ElementsDictionaryEntry("Generator ID", "GeneratorID",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1006), ElementsDictionaryEntry("Grid ID", "GridID",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1007), ElementsDictionaryEntry("Cassette ID", "CassetteID",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1008), ElementsDictionaryEntry("Gantry ID", "GantryID",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1009), ElementsDictionaryEntry("Unique Device Identifier", "UniqueDeviceIdentifier",  "UT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x100a), ElementsDictionaryEntry("UDI Sequence", "UDISequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x100b), ElementsDictionaryEntry("Manufacturer's Device Class UID", "ManufacturerDeviceClassUID",  "UI", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x1010), ElementsDictionaryEntry("Secondary Capture Device ID", "SecondaryCaptureDeviceID",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1011), ElementsDictionaryEntry("Hardcopy Creation Device ID", "HardcopyCreationDeviceID",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1012), ElementsDictionaryEntry("Date of Secondary Capture", "DateOfSecondaryCapture",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1014), ElementsDictionaryEntry("Time of Secondary Capture", "TimeOfSecondaryCapture",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1016), ElementsDictionaryEntry("Secondary Capture Device Manufacturer", "SecondaryCaptureDeviceManufacturer",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1017), ElementsDictionaryEntry("Hardcopy Device Manufacturer", "HardcopyDeviceManufacturer",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1018), ElementsDictionaryEntry("Secondary Capture Device Manufacturer's Model Name", "SecondaryCaptureDeviceManufacturerModelName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1019), ElementsDictionaryEntry("Secondary Capture Device Software Versions", "SecondaryCaptureDeviceSoftwareVersions",  "LO", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x101a), ElementsDictionaryEntry("Hardcopy Device Software Version", "HardcopyDeviceSoftwareVersion",  "LO", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x101b), ElementsDictionaryEntry("Hardcopy Device Manufacturer's Model Name", "HardcopyDeviceManufacturerModelName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1020), ElementsDictionaryEntry("Software Versions", "SoftwareVersions",  "LO", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x1022), ElementsDictionaryEntry("Video Image Format Acquired", "VideoImageFormatAcquired",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1023), ElementsDictionaryEntry("Digital Image Format Acquired", "DigitalImageFormatAcquired",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1030), ElementsDictionaryEntry("Protocol Name", "ProtocolName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1040), ElementsDictionaryEntry("Contrast/Bolus Route", "ContrastBolusRoute",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1041), ElementsDictionaryEntry("Contrast/Bolus Volume", "ContrastBolusVolume",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1042), ElementsDictionaryEntry("Contrast/Bolus Start Time", "ContrastBolusStartTime",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1043), ElementsDictionaryEntry("Contrast/Bolus Stop Time", "ContrastBolusStopTime",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1044), ElementsDictionaryEntry("Contrast/Bolus Total Dose", "ContrastBolusTotalDose",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1045), ElementsDictionaryEntry("Syringe Counts", "SyringeCounts",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1046), ElementsDictionaryEntry("Contrast Flow Rate", "ContrastFlowRate",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x1047), ElementsDictionaryEntry("Contrast Flow Duration", "ContrastFlowDuration",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x1048), ElementsDictionaryEntry("Contrast/Bolus Ingredient", "ContrastBolusIngredient",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1049), ElementsDictionaryEntry("Contrast/Bolus Ingredient Concentration", "ContrastBolusIngredientConcentration",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1050), ElementsDictionaryEntry("Spatial Resolution", "SpatialResolution",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1060), ElementsDictionaryEntry("Trigger Time", "TriggerTime",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1061), ElementsDictionaryEntry("Trigger Source or Type", "TriggerSourceOrType",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1062), ElementsDictionaryEntry("Nominal Interval", "NominalInterval",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1063), ElementsDictionaryEntry("Frame Time", "FrameTime",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1064), ElementsDictionaryEntry("Cardiac Framing Type", "CardiacFramingType",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1065), ElementsDictionaryEntry("Frame Time Vector", "FrameTimeVector",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x1066), ElementsDictionaryEntry("Frame Delay", "FrameDelay",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1067), ElementsDictionaryEntry("Image Trigger Delay", "ImageTriggerDelay",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1068), ElementsDictionaryEntry("Multiplex Group Time Offset", "MultiplexGroupTimeOffset",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1069), ElementsDictionaryEntry("Trigger Time Offset", "TriggerTimeOffset",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x106a), ElementsDictionaryEntry("Synchronization Trigger", "SynchronizationTrigger",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x106c), ElementsDictionaryEntry("Synchronization Channel", "SynchronizationChannel",  "US", "2"));
    public_dictionary.emplace(Tag(0x0018, 0x106e), ElementsDictionaryEntry("Trigger Sample Position", "TriggerSamplePosition",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1070), ElementsDictionaryEntry("Radiopharmaceutical Route", "RadiopharmaceuticalRoute",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1071), ElementsDictionaryEntry("Radiopharmaceutical Volume", "RadiopharmaceuticalVolume",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1072), ElementsDictionaryEntry("Radiopharmaceutical Start Time", "RadiopharmaceuticalStartTime",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1073), ElementsDictionaryEntry("Radiopharmaceutical Stop Time", "RadiopharmaceuticalStopTime",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1074), ElementsDictionaryEntry("Radionuclide Total Dose", "RadionuclideTotalDose",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1075), ElementsDictionaryEntry("Radionuclide Half Life", "RadionuclideHalfLife",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1076), ElementsDictionaryEntry("Radionuclide Positron Fraction", "RadionuclidePositronFraction",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1077), ElementsDictionaryEntry("Radiopharmaceutical Specific Activity", "RadiopharmaceuticalSpecificActivity",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1078), ElementsDictionaryEntry("Radiopharmaceutical Start DateTime", "RadiopharmaceuticalStartDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1079), ElementsDictionaryEntry("Radiopharmaceutical Stop DateTime", "RadiopharmaceuticalStopDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1080), ElementsDictionaryEntry("Beat Rejection Flag", "BeatRejectionFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1081), ElementsDictionaryEntry("Low R-R Value", "LowRRValue",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1082), ElementsDictionaryEntry("High R-R Value", "HighRRValue",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1083), ElementsDictionaryEntry("Intervals Acquired", "IntervalsAcquired",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1084), ElementsDictionaryEntry("Intervals Rejected", "IntervalsRejected",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1085), ElementsDictionaryEntry("PVC Rejection", "PVCRejection",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1086), ElementsDictionaryEntry("Skip Beats", "SkipBeats",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1088), ElementsDictionaryEntry("Heart Rate", "HeartRate",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1090), ElementsDictionaryEntry("Cardiac Number of Images", "CardiacNumberOfImages",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1094), ElementsDictionaryEntry("Trigger Window", "TriggerWindow",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1100), ElementsDictionaryEntry("Reconstruction Diameter", "ReconstructionDiameter",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1110), ElementsDictionaryEntry("Distance Source to Detector", "DistanceSourceToDetector",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1111), ElementsDictionaryEntry("Distance Source to Patient", "DistanceSourceToPatient",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1114), ElementsDictionaryEntry("Estimated Radiographic Magnification Factor", "EstimatedRadiographicMagnificationFactor",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1120), ElementsDictionaryEntry("Gantry/Detector Tilt", "GantryDetectorTilt",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1121), ElementsDictionaryEntry("Gantry/Detector Slew", "GantryDetectorSlew",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1130), ElementsDictionaryEntry("Table Height", "TableHeight",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1131), ElementsDictionaryEntry("Table Traverse", "TableTraverse",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1134), ElementsDictionaryEntry("Table Motion", "TableMotion",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1135), ElementsDictionaryEntry("Table Vertical Increment", "TableVerticalIncrement",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x1136), ElementsDictionaryEntry("Table Lateral Increment", "TableLateralIncrement",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x1137), ElementsDictionaryEntry("Table Longitudinal Increment", "TableLongitudinalIncrement",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x1138), ElementsDictionaryEntry("Table Angle", "TableAngle",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x113a), ElementsDictionaryEntry("Table Type", "TableType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1140), ElementsDictionaryEntry("Rotation Direction", "RotationDirection",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1141), ElementsDictionaryEntry("Angular Position", "AngularPosition",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1142), ElementsDictionaryEntry("Radial Position", "RadialPosition",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x1143), ElementsDictionaryEntry("Scan Arc", "ScanArc",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1144), ElementsDictionaryEntry("Angular Step", "AngularStep",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1145), ElementsDictionaryEntry("Center of Rotation Offset", "CenterOfRotationOffset",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1146), ElementsDictionaryEntry("Rotation Offset", "RotationOffset",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x1147), ElementsDictionaryEntry("Field of View Shape", "FieldOfViewShape",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1149), ElementsDictionaryEntry("Field of View Dimension(s)", "FieldOfViewDimensions",  "IS", "1-2"));
    public_dictionary.emplace(Tag(0x0018, 0x1150), ElementsDictionaryEntry("Exposure Time", "ExposureTime",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1151), ElementsDictionaryEntry("X-Ray Tube Current", "XRayTubeCurrent",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1152), ElementsDictionaryEntry("Exposure", "Exposure",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1153), ElementsDictionaryEntry("Exposure in uAs", "ExposureInuAs",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1154), ElementsDictionaryEntry("Average Pulse Width", "AveragePulseWidth",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1155), ElementsDictionaryEntry("Radiation Setting", "RadiationSetting",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1156), ElementsDictionaryEntry("Rectification Type", "RectificationType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x115a), ElementsDictionaryEntry("Radiation Mode", "RadiationMode",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x115e), ElementsDictionaryEntry("Image and Fluoroscopy Area Dose Product", "ImageAndFluoroscopyAreaDoseProduct",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1160), ElementsDictionaryEntry("Filter Type", "FilterType",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1161), ElementsDictionaryEntry("Type of Filters", "TypeOfFilters",  "LO", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x1162), ElementsDictionaryEntry("Intensifier Size", "IntensifierSize",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1164), ElementsDictionaryEntry("Imager Pixel Spacing", "ImagerPixelSpacing",  "DS", "2"));
    public_dictionary.emplace(Tag(0x0018, 0x1166), ElementsDictionaryEntry("Grid", "Grid",  "CS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x1170), ElementsDictionaryEntry("Generator Power", "GeneratorPower",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1180), ElementsDictionaryEntry("Collimator/grid Name", "CollimatorGridName",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1181), ElementsDictionaryEntry("Collimator Type", "CollimatorType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1182), ElementsDictionaryEntry("Focal Distance", "FocalDistance",  "IS", "1-2"));
    public_dictionary.emplace(Tag(0x0018, 0x1183), ElementsDictionaryEntry("X Focus Center", "XFocusCenter",  "DS", "1-2"));
    public_dictionary.emplace(Tag(0x0018, 0x1184), ElementsDictionaryEntry("Y Focus Center", "YFocusCenter",  "DS", "1-2"));
    public_dictionary.emplace(Tag(0x0018, 0x1190), ElementsDictionaryEntry("Focal Spot(s)", "FocalSpots",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x1191), ElementsDictionaryEntry("Anode Target Material", "AnodeTargetMaterial",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x11a0), ElementsDictionaryEntry("Body Part Thickness", "BodyPartThickness",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x11a2), ElementsDictionaryEntry("Compression Force", "CompressionForce",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x11a3), ElementsDictionaryEntry("Compression Pressure", "CompressionPressure",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x11a4), ElementsDictionaryEntry("Paddle Description", "PaddleDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x11a5), ElementsDictionaryEntry("Compression Contact Area", "CompressionContactArea",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x11b0), ElementsDictionaryEntry("Acquisition Mode", "AcquisitionMode",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x11b1), ElementsDictionaryEntry("Dose Mode Name", "DoseModeName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x11b2), ElementsDictionaryEntry("Acquired Subtraction Mask Flag", "AcquiredSubtractionMaskFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x11b3), ElementsDictionaryEntry("Fluoroscopy Persistence Flag", "FluoroscopyPersistenceFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x11b4), ElementsDictionaryEntry("Fluoroscopy Last Image Hold Persistence Flag", "FluoroscopyLastImageHoldPersistenceFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x11b5), ElementsDictionaryEntry("Upper Limit Number Of Persistent Fluoroscopy Frames", "UpperLimitNumberOfPersistentFluoroscopyFrames",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x11b6), ElementsDictionaryEntry("Contrast/Bolus Auto Injection Trigger Flag", "ContrastBolusAutoInjectionTriggerFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x11b7), ElementsDictionaryEntry("Contrast/Bolus Injection Delay", "ContrastBolusInjectionDelay",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x11b8), ElementsDictionaryEntry("XA Acquisition Phase Details Sequence", "XAAcquisitionPhaseDetailsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x11b9), ElementsDictionaryEntry("XA Acquisition Frame Rate", "XAAcquisitionFrameRate",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x11ba), ElementsDictionaryEntry("XA Plane Details Sequence", "XAPlaneDetailsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x11bb), ElementsDictionaryEntry("Acquisition Field of View Label", "AcquisitionFieldOfViewLabel",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x11bc), ElementsDictionaryEntry("X-Ray Filter Details Sequence", "XRayFilterDetailsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x11bd), ElementsDictionaryEntry("XA Acquisition Duration", "XAAcquisitionDuration",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x11be), ElementsDictionaryEntry("Reconstruction Pipeline Type", "ReconstructionPipelineType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x11bf), ElementsDictionaryEntry("Image Filter Details Sequence", "ImageFilterDetailsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x11c0), ElementsDictionaryEntry("Applied Mask Subtraction Flag", "AppliedMaskSubtractionFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x11c1), ElementsDictionaryEntry("Requested Series Description Code Sequence", "RequestedSeriesDescriptionCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1200), ElementsDictionaryEntry("Date of Last Calibration", "DateOfLastCalibration",  "DA", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x1201), ElementsDictionaryEntry("Time of Last Calibration", "TimeOfLastCalibration",  "TM", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x1202), ElementsDictionaryEntry("DateTime of Last Calibration", "DateTimeOfLastCalibration",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1203), ElementsDictionaryEntry("Calibration DateTime", "CalibrationDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1204), ElementsDictionaryEntry("Date of Manufacture", "DateOfManufacture",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1205), ElementsDictionaryEntry("Date of Installation", "DateOfInstallation",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1210), ElementsDictionaryEntry("Convolution Kernel", "ConvolutionKernel",  "SH", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x1240), ElementsDictionaryEntry("Upper/Lower Pixel Values", "UpperLowerPixelValues",  "IS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x1242), ElementsDictionaryEntry("Actual Frame Duration", "ActualFrameDuration",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1243), ElementsDictionaryEntry("Count Rate", "CountRate",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1244), ElementsDictionaryEntry("Preferred Playback Sequencing", "PreferredPlaybackSequencing",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1250), ElementsDictionaryEntry("Receive Coil Name", "ReceiveCoilName",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1251), ElementsDictionaryEntry("Transmit Coil Name", "TransmitCoilName",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1260), ElementsDictionaryEntry("Plate Type", "PlateType",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1261), ElementsDictionaryEntry("Phosphor Type", "PhosphorType",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1271), ElementsDictionaryEntry("Water Equivalent Diameter", "WaterEquivalentDiameter",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1272), ElementsDictionaryEntry("Water Equivalent Diameter Calculation Method Code Sequence", "WaterEquivalentDiameterCalculationMethodCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1300), ElementsDictionaryEntry("Scan Velocity", "ScanVelocity",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1301), ElementsDictionaryEntry("Whole Body Technique", "WholeBodyTechnique",  "CS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x1302), ElementsDictionaryEntry("Scan Length", "ScanLength",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1310), ElementsDictionaryEntry("Acquisition Matrix", "AcquisitionMatrix",  "US", "4"));
    public_dictionary.emplace(Tag(0x0018, 0x1312), ElementsDictionaryEntry("In-plane Phase Encoding Direction", "InPlanePhaseEncodingDirection",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1314), ElementsDictionaryEntry("Flip Angle", "FlipAngle",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1315), ElementsDictionaryEntry("Variable Flip Angle Flag", "VariableFlipAngleFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1316), ElementsDictionaryEntry("SAR", "SAR",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1318), ElementsDictionaryEntry("dB/dt", "dBdt",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1320), ElementsDictionaryEntry("B1rms", "B1rms",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1400), ElementsDictionaryEntry("Acquisition Device Processing Description", "AcquisitionDeviceProcessingDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1401), ElementsDictionaryEntry("Acquisition Device Processing Code", "AcquisitionDeviceProcessingCode",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1402), ElementsDictionaryEntry("Cassette Orientation", "CassetteOrientation",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1403), ElementsDictionaryEntry("Cassette Size", "CassetteSize",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1404), ElementsDictionaryEntry("Exposures on Plate", "ExposuresOnPlate",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1405), ElementsDictionaryEntry("Relative X-Ray Exposure", "RelativeXRayExposure",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1411), ElementsDictionaryEntry("Exposure Index", "ExposureIndex",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1412), ElementsDictionaryEntry("Target Exposure Index", "TargetExposureIndex",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1413), ElementsDictionaryEntry("Deviation Index", "DeviationIndex",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1450), ElementsDictionaryEntry("Column Angulation", "ColumnAngulation",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1460), ElementsDictionaryEntry("Tomo Layer Height", "TomoLayerHeight",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1470), ElementsDictionaryEntry("Tomo Angle", "TomoAngle",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1480), ElementsDictionaryEntry("Tomo Time", "TomoTime",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1490), ElementsDictionaryEntry("Tomo Type", "TomoType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1491), ElementsDictionaryEntry("Tomo Class", "TomoClass",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1495), ElementsDictionaryEntry("Number of Tomosynthesis Source Images", "NumberOfTomosynthesisSourceImages",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1500), ElementsDictionaryEntry("Positioner Motion", "PositionerMotion",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1508), ElementsDictionaryEntry("Positioner Type", "PositionerType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1510), ElementsDictionaryEntry("Positioner Primary Angle", "PositionerPrimaryAngle",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1511), ElementsDictionaryEntry("Positioner Secondary Angle", "PositionerSecondaryAngle",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1520), ElementsDictionaryEntry("Positioner Primary Angle Increment", "PositionerPrimaryAngleIncrement",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x1521), ElementsDictionaryEntry("Positioner Secondary Angle Increment", "PositionerSecondaryAngleIncrement",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x1530), ElementsDictionaryEntry("Detector Primary Angle", "DetectorPrimaryAngle",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1531), ElementsDictionaryEntry("Detector Secondary Angle", "DetectorSecondaryAngle",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1600), ElementsDictionaryEntry("Shutter Shape", "ShutterShape",  "CS", "1-3"));
    public_dictionary.emplace(Tag(0x0018, 0x1602), ElementsDictionaryEntry("Shutter Left Vertical Edge", "ShutterLeftVerticalEdge",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1604), ElementsDictionaryEntry("Shutter Right Vertical Edge", "ShutterRightVerticalEdge",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1606), ElementsDictionaryEntry("Shutter Upper Horizontal Edge", "ShutterUpperHorizontalEdge",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1608), ElementsDictionaryEntry("Shutter Lower Horizontal Edge", "ShutterLowerHorizontalEdge",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1610), ElementsDictionaryEntry("Center of Circular Shutter", "CenterOfCircularShutter",  "IS", "2"));
    public_dictionary.emplace(Tag(0x0018, 0x1612), ElementsDictionaryEntry("Radius of Circular Shutter", "RadiusOfCircularShutter",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1620), ElementsDictionaryEntry("Vertices of the Polygonal Shutter", "VerticesOfThePolygonalShutter",  "IS", "2-2n"));
    public_dictionary.emplace(Tag(0x0018, 0x1622), ElementsDictionaryEntry("Shutter Presentation Value", "ShutterPresentationValue",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1623), ElementsDictionaryEntry("Shutter Overlay Group", "ShutterOverlayGroup",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1624), ElementsDictionaryEntry("Shutter Presentation Color CIELab Value", "ShutterPresentationColorCIELabValue",  "US", "3"));
    public_dictionary.emplace(Tag(0x0018, 0x1630), ElementsDictionaryEntry("Outline Shape Type", "OutlineShapeType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1631), ElementsDictionaryEntry("Outline Left Vertical Edge", "OutlineLeftVerticalEdge",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1632), ElementsDictionaryEntry("Outline Right Vertical Edge", "OutlineRightVerticalEdge",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1633), ElementsDictionaryEntry("Outline Upper Horizontal Edge", "OutlineUpperHorizontalEdge",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1634), ElementsDictionaryEntry("Outline Lower Horizontal Edge", "OutlineLowerHorizontalEdge",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1635), ElementsDictionaryEntry("Center of Circular Outline", "CenterOfCircularOutline",  "FD", "2"));
    public_dictionary.emplace(Tag(0x0018, 0x1636), ElementsDictionaryEntry("Diameter of Circular Outline", "DiameterOfCircularOutline",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1637), ElementsDictionaryEntry("Number of Polygonal Vertices", "NumberOfPolygonalVertices",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1638), ElementsDictionaryEntry("Vertices of the Polygonal Outline", "VerticesOfThePolygonalOutline",  "OF", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1700), ElementsDictionaryEntry("Collimator Shape", "CollimatorShape",  "CS", "1-3"));
    public_dictionary.emplace(Tag(0x0018, 0x1702), ElementsDictionaryEntry("Collimator Left Vertical Edge", "CollimatorLeftVerticalEdge",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1704), ElementsDictionaryEntry("Collimator Right Vertical Edge", "CollimatorRightVerticalEdge",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1706), ElementsDictionaryEntry("Collimator Upper Horizontal Edge", "CollimatorUpperHorizontalEdge",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1708), ElementsDictionaryEntry("Collimator Lower Horizontal Edge", "CollimatorLowerHorizontalEdge",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1710), ElementsDictionaryEntry("Center of Circular Collimator", "CenterOfCircularCollimator",  "IS", "2"));
    public_dictionary.emplace(Tag(0x0018, 0x1712), ElementsDictionaryEntry("Radius of Circular Collimator", "RadiusOfCircularCollimator",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1720), ElementsDictionaryEntry("Vertices of the Polygonal Collimator", "VerticesOfThePolygonalCollimator",  "IS", "2-2n"));
    public_dictionary.emplace(Tag(0x0018, 0x1800), ElementsDictionaryEntry("Acquisition Time Synchronized", "AcquisitionTimeSynchronized",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1801), ElementsDictionaryEntry("Time Source", "TimeSource",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1802), ElementsDictionaryEntry("Time Distribution Protocol", "TimeDistributionProtocol",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x1803), ElementsDictionaryEntry("NTP Source Address", "NTPSourceAddress",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x2001), ElementsDictionaryEntry("Page Number Vector", "PageNumberVector",  "IS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x2002), ElementsDictionaryEntry("Frame Label Vector", "FrameLabelVector",  "SH", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x2003), ElementsDictionaryEntry("Frame Primary Angle Vector", "FramePrimaryAngleVector",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x2004), ElementsDictionaryEntry("Frame Secondary Angle Vector", "FrameSecondaryAngleVector",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x2005), ElementsDictionaryEntry("Slice Location Vector", "SliceLocationVector",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x2006), ElementsDictionaryEntry("Display Window Label Vector", "DisplayWindowLabelVector",  "SH", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x2010), ElementsDictionaryEntry("Nominal Scanned Pixel Spacing", "NominalScannedPixelSpacing",  "DS", "2"));
    public_dictionary.emplace(Tag(0x0018, 0x2020), ElementsDictionaryEntry("Digitizing Device Transport Direction", "DigitizingDeviceTransportDirection",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x2030), ElementsDictionaryEntry("Rotation of Scanned Film", "RotationOfScannedFilm",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x2041), ElementsDictionaryEntry("Biopsy Target Sequence", "BiopsyTargetSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x2042), ElementsDictionaryEntry("Target UID", "TargetUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x2043), ElementsDictionaryEntry("Localizing Cursor Position", "LocalizingCursorPosition",  "FL", "2"));
    public_dictionary.emplace(Tag(0x0018, 0x2044), ElementsDictionaryEntry("Calculated Target Position", "CalculatedTargetPosition",  "FL", "3"));
    public_dictionary.emplace(Tag(0x0018, 0x2045), ElementsDictionaryEntry("Target Label", "TargetLabel",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x2046), ElementsDictionaryEntry("Displayed Z Value", "DisplayedZValue",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x3100), ElementsDictionaryEntry("IVUS Acquisition", "IVUSAcquisition",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x3101), ElementsDictionaryEntry("IVUS Pullback Rate", "IVUSPullbackRate",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x3102), ElementsDictionaryEntry("IVUS Gated Rate", "IVUSGatedRate",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x3103), ElementsDictionaryEntry("IVUS Pullback Start Frame Number", "IVUSPullbackStartFrameNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x3104), ElementsDictionaryEntry("IVUS Pullback Stop Frame Number", "IVUSPullbackStopFrameNumber",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x3105), ElementsDictionaryEntry("Lesion Number", "LesionNumber",  "IS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x4000), ElementsDictionaryEntry("Acquisition Comments", "AcquisitionComments",  "LT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x5000), ElementsDictionaryEntry("Output Power", "OutputPower",  "SH", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x5010), ElementsDictionaryEntry("Transducer Data", "TransducerData",  "LO", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x5011), ElementsDictionaryEntry("Transducer Identification Sequence", "TransducerIdentificationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x5012), ElementsDictionaryEntry("Focus Depth", "FocusDepth",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x5020), ElementsDictionaryEntry("Processing Function", "ProcessingFunction",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x5021), ElementsDictionaryEntry("Postprocessing Function", "PostprocessingFunction",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x5022), ElementsDictionaryEntry("Mechanical Index", "MechanicalIndex",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x5024), ElementsDictionaryEntry("Bone Thermal Index", "BoneThermalIndex",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x5026), ElementsDictionaryEntry("Cranial Thermal Index", "CranialThermalIndex",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x5027), ElementsDictionaryEntry("Soft Tissue Thermal Index", "SoftTissueThermalIndex",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x5028), ElementsDictionaryEntry("Soft Tissue-focus Thermal Index", "SoftTissueFocusThermalIndex",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x5029), ElementsDictionaryEntry("Soft Tissue-surface Thermal Index", "SoftTissueSurfaceThermalIndex",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x5030), ElementsDictionaryEntry("Dynamic Range", "DynamicRange",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x5040), ElementsDictionaryEntry("Total Gain", "TotalGain",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x5050), ElementsDictionaryEntry("Depth of Scan Field", "DepthOfScanField",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x5100), ElementsDictionaryEntry("Patient Position", "PatientPosition",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x5101), ElementsDictionaryEntry("View Position", "ViewPosition",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x5104), ElementsDictionaryEntry("Projection Eponymous Name Code Sequence", "ProjectionEponymousNameCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x5210), ElementsDictionaryEntry("Image Transformation Matrix", "ImageTransformationMatrix",  "DS", "6"));
    public_dictionary.emplace(Tag(0x0018, 0x5212), ElementsDictionaryEntry("Image Translation Vector", "ImageTranslationVector",  "DS", "3"));
    public_dictionary.emplace(Tag(0x0018, 0x6000), ElementsDictionaryEntry("Sensitivity", "Sensitivity",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6011), ElementsDictionaryEntry("Sequence of Ultrasound Regions", "SequenceOfUltrasoundRegions",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6012), ElementsDictionaryEntry("Region Spatial Format", "RegionSpatialFormat",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6014), ElementsDictionaryEntry("Region Data Type", "RegionDataType",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6016), ElementsDictionaryEntry("Region Flags", "RegionFlags",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6018), ElementsDictionaryEntry("Region Location Min X0", "RegionLocationMinX0",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x601a), ElementsDictionaryEntry("Region Location Min Y0", "RegionLocationMinY0",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x601c), ElementsDictionaryEntry("Region Location Max X1", "RegionLocationMaxX1",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x601e), ElementsDictionaryEntry("Region Location Max Y1", "RegionLocationMaxY1",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6020), ElementsDictionaryEntry("Reference Pixel X0", "ReferencePixelX0",  "SL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6022), ElementsDictionaryEntry("Reference Pixel Y0", "ReferencePixelY0",  "SL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6024), ElementsDictionaryEntry("Physical Units X Direction", "PhysicalUnitsXDirection",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6026), ElementsDictionaryEntry("Physical Units Y Direction", "PhysicalUnitsYDirection",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6028), ElementsDictionaryEntry("Reference Pixel Physical Value X", "ReferencePixelPhysicalValueX",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x602a), ElementsDictionaryEntry("Reference Pixel Physical Value Y", "ReferencePixelPhysicalValueY",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x602c), ElementsDictionaryEntry("Physical Delta X", "PhysicalDeltaX",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x602e), ElementsDictionaryEntry("Physical Delta Y", "PhysicalDeltaY",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6030), ElementsDictionaryEntry("Transducer Frequency", "TransducerFrequency",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6031), ElementsDictionaryEntry("Transducer Type", "TransducerType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6032), ElementsDictionaryEntry("Pulse Repetition Frequency", "PulseRepetitionFrequency",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6034), ElementsDictionaryEntry("Doppler Correction Angle", "DopplerCorrectionAngle",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6036), ElementsDictionaryEntry("Steering Angle", "SteeringAngle",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6038), ElementsDictionaryEntry("Doppler Sample Volume X Position (Retired)", "DopplerSampleVolumeXPositionRetired",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6039), ElementsDictionaryEntry("Doppler Sample Volume X Position", "DopplerSampleVolumeXPosition",  "SL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x603a), ElementsDictionaryEntry("Doppler Sample Volume Y Position (Retired)", "DopplerSampleVolumeYPositionRetired",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x603b), ElementsDictionaryEntry("Doppler Sample Volume Y Position", "DopplerSampleVolumeYPosition",  "SL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x603c), ElementsDictionaryEntry("TM-Line Position X0 (Retired)", "TMLinePositionX0Retired",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x603d), ElementsDictionaryEntry("TM-Line Position X0", "TMLinePositionX0",  "SL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x603e), ElementsDictionaryEntry("TM-Line Position Y0 (Retired)", "TMLinePositionY0Retired",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x603f), ElementsDictionaryEntry("TM-Line Position Y0", "TMLinePositionY0",  "SL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6040), ElementsDictionaryEntry("TM-Line Position X1 (Retired)", "TMLinePositionX1Retired",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6041), ElementsDictionaryEntry("TM-Line Position X1", "TMLinePositionX1",  "SL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6042), ElementsDictionaryEntry("TM-Line Position Y1 (Retired)", "TMLinePositionY1Retired",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6043), ElementsDictionaryEntry("TM-Line Position Y1", "TMLinePositionY1",  "SL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6044), ElementsDictionaryEntry("Pixel Component Organization", "PixelComponentOrganization",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6046), ElementsDictionaryEntry("Pixel Component Mask", "PixelComponentMask",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6048), ElementsDictionaryEntry("Pixel Component Range Start", "PixelComponentRangeStart",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x604a), ElementsDictionaryEntry("Pixel Component Range Stop", "PixelComponentRangeStop",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x604c), ElementsDictionaryEntry("Pixel Component Physical Units", "PixelComponentPhysicalUnits",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x604e), ElementsDictionaryEntry("Pixel Component Data Type", "PixelComponentDataType",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6050), ElementsDictionaryEntry("Number of Table Break Points", "NumberOfTableBreakPoints",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6052), ElementsDictionaryEntry("Table of X Break Points", "TableOfXBreakPoints",  "UL", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x6054), ElementsDictionaryEntry("Table of Y Break Points", "TableOfYBreakPoints",  "FD", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x6056), ElementsDictionaryEntry("Number of Table Entries", "NumberOfTableEntries",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x6058), ElementsDictionaryEntry("Table of Pixel Values", "TableOfPixelValues",  "UL", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x605a), ElementsDictionaryEntry("Table of Parameter Values", "TableOfParameterValues",  "FL", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x6060), ElementsDictionaryEntry("R Wave Time Vector", "RWaveTimeVector",  "FL", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x6070), ElementsDictionaryEntry("Active Image Area Overlay Group", "ActiveImageAreaOverlayGroup",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x7000), ElementsDictionaryEntry("Detector Conditions Nominal Flag", "DetectorConditionsNominalFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x7001), ElementsDictionaryEntry("Detector Temperature", "DetectorTemperature",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x7004), ElementsDictionaryEntry("Detector Type", "DetectorType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x7005), ElementsDictionaryEntry("Detector Configuration", "DetectorConfiguration",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x7006), ElementsDictionaryEntry("Detector Description", "DetectorDescription",  "LT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x7008), ElementsDictionaryEntry("Detector Mode", "DetectorMode",  "LT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x700a), ElementsDictionaryEntry("Detector ID", "DetectorID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x700c), ElementsDictionaryEntry("Date of Last Detector Calibration", "DateOfLastDetectorCalibration",  "DA", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x700e), ElementsDictionaryEntry("Time of Last Detector Calibration", "TimeOfLastDetectorCalibration",  "TM", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x7010), ElementsDictionaryEntry("Exposures on Detector Since Last Calibration", "ExposuresOnDetectorSinceLastCalibration",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x7011), ElementsDictionaryEntry("Exposures on Detector Since Manufactured", "ExposuresOnDetectorSinceManufactured",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x7012), ElementsDictionaryEntry("Detector Time Since Last Exposure", "DetectorTimeSinceLastExposure",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x7014), ElementsDictionaryEntry("Detector Active Time", "DetectorActiveTime",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x7016), ElementsDictionaryEntry("Detector Activation Offset From Exposure", "DetectorActivationOffsetFromExposure",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x701a), ElementsDictionaryEntry("Detector Binning", "DetectorBinning",  "DS", "2"));
    public_dictionary.emplace(Tag(0x0018, 0x7020), ElementsDictionaryEntry("Detector Element Physical Size", "DetectorElementPhysicalSize",  "DS", "2"));
    public_dictionary.emplace(Tag(0x0018, 0x7022), ElementsDictionaryEntry("Detector Element Spacing", "DetectorElementSpacing",  "DS", "2"));
    public_dictionary.emplace(Tag(0x0018, 0x7024), ElementsDictionaryEntry("Detector Active Shape", "DetectorActiveShape",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x7026), ElementsDictionaryEntry("Detector Active Dimension(s)", "DetectorActiveDimensions",  "DS", "1-2"));
    public_dictionary.emplace(Tag(0x0018, 0x7028), ElementsDictionaryEntry("Detector Active Origin", "DetectorActiveOrigin",  "DS", "2"));
    public_dictionary.emplace(Tag(0x0018, 0x702a), ElementsDictionaryEntry("Detector Manufacturer Name", "DetectorManufacturerName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x702b), ElementsDictionaryEntry("Detector Manufacturer's Model Name", "DetectorManufacturerModelName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x7030), ElementsDictionaryEntry("Field of View Origin", "FieldOfViewOrigin",  "DS", "2"));
    public_dictionary.emplace(Tag(0x0018, 0x7032), ElementsDictionaryEntry("Field of View Rotation", "FieldOfViewRotation",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x7034), ElementsDictionaryEntry("Field of View Horizontal Flip", "FieldOfViewHorizontalFlip",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x7036), ElementsDictionaryEntry("Pixel Data Area Origin Relative To FOV", "PixelDataAreaOriginRelativeToFOV",  "FL", "2"));
    public_dictionary.emplace(Tag(0x0018, 0x7038), ElementsDictionaryEntry("Pixel Data Area Rotation Angle Relative To FOV", "PixelDataAreaRotationAngleRelativeToFOV",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x7040), ElementsDictionaryEntry("Grid Absorbing Material", "GridAbsorbingMaterial",  "LT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x7041), ElementsDictionaryEntry("Grid Spacing Material", "GridSpacingMaterial",  "LT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x7042), ElementsDictionaryEntry("Grid Thickness", "GridThickness",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x7044), ElementsDictionaryEntry("Grid Pitch", "GridPitch",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x7046), ElementsDictionaryEntry("Grid Aspect Ratio", "GridAspectRatio",  "IS", "2"));
    public_dictionary.emplace(Tag(0x0018, 0x7048), ElementsDictionaryEntry("Grid Period", "GridPeriod",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x704c), ElementsDictionaryEntry("Grid Focal Distance", "GridFocalDistance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x7050), ElementsDictionaryEntry("Filter Material", "FilterMaterial",  "CS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x7052), ElementsDictionaryEntry("Filter Thickness Minimum", "FilterThicknessMinimum",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x7054), ElementsDictionaryEntry("Filter Thickness Maximum", "FilterThicknessMaximum",  "DS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x7056), ElementsDictionaryEntry("Filter Beam Path Length Minimum", "FilterBeamPathLengthMinimum",  "FL", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x7058), ElementsDictionaryEntry("Filter Beam Path Length Maximum", "FilterBeamPathLengthMaximum",  "FL", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x7060), ElementsDictionaryEntry("Exposure Control Mode", "ExposureControlMode",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x7062), ElementsDictionaryEntry("Exposure Control Mode Description", "ExposureControlModeDescription",  "LT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x7064), ElementsDictionaryEntry("Exposure Status", "ExposureStatus",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x7065), ElementsDictionaryEntry("Phototimer Setting", "PhototimerSetting",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x8150), ElementsDictionaryEntry("Exposure Time in uS", "ExposureTimeInuS",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x8151), ElementsDictionaryEntry("X-Ray Tube Current in uA", "XRayTubeCurrentInuA",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9004), ElementsDictionaryEntry("Content Qualification", "ContentQualification",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9005), ElementsDictionaryEntry("Pulse Sequence Name", "PulseSequenceName",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9006), ElementsDictionaryEntry("MR Imaging Modifier Sequence", "MRImagingModifierSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9008), ElementsDictionaryEntry("Echo Pulse Sequence", "EchoPulseSequence",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9009), ElementsDictionaryEntry("Inversion Recovery", "InversionRecovery",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9010), ElementsDictionaryEntry("Flow Compensation", "FlowCompensation",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9011), ElementsDictionaryEntry("Multiple Spin Echo", "MultipleSpinEcho",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9012), ElementsDictionaryEntry("Multi-planar Excitation", "MultiPlanarExcitation",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9014), ElementsDictionaryEntry("Phase Contrast", "PhaseContrast",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9015), ElementsDictionaryEntry("Time of Flight Contrast", "TimeOfFlightContrast",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9016), ElementsDictionaryEntry("Spoiling", "Spoiling",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9017), ElementsDictionaryEntry("Steady State Pulse Sequence", "SteadyStatePulseSequence",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9018), ElementsDictionaryEntry("Echo Planar Pulse Sequence", "EchoPlanarPulseSequence",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9019), ElementsDictionaryEntry("Tag Angle First Axis", "TagAngleFirstAxis",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9020), ElementsDictionaryEntry("Magnetization Transfer", "MagnetizationTransfer",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9021), ElementsDictionaryEntry("T2 Preparation", "T2Preparation",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9022), ElementsDictionaryEntry("Blood Signal Nulling", "BloodSignalNulling",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9024), ElementsDictionaryEntry("Saturation Recovery", "SaturationRecovery",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9025), ElementsDictionaryEntry("Spectrally Selected Suppression", "SpectrallySelectedSuppression",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9026), ElementsDictionaryEntry("Spectrally Selected Excitation", "SpectrallySelectedExcitation",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9027), ElementsDictionaryEntry("Spatial Pre-saturation", "SpatialPresaturation",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9028), ElementsDictionaryEntry("Tagging", "Tagging",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9029), ElementsDictionaryEntry("Oversampling Phase", "OversamplingPhase",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9030), ElementsDictionaryEntry("Tag Spacing First Dimension", "TagSpacingFirstDimension",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9032), ElementsDictionaryEntry("Geometry of k-Space Traversal", "GeometryOfKSpaceTraversal",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9033), ElementsDictionaryEntry("Segmented k-Space Traversal", "SegmentedKSpaceTraversal",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9034), ElementsDictionaryEntry("Rectilinear Phase Encode Reordering", "RectilinearPhaseEncodeReordering",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9035), ElementsDictionaryEntry("Tag Thickness", "TagThickness",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9036), ElementsDictionaryEntry("Partial Fourier Direction", "PartialFourierDirection",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9037), ElementsDictionaryEntry("Cardiac Synchronization Technique", "CardiacSynchronizationTechnique",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9041), ElementsDictionaryEntry("Receive Coil Manufacturer Name", "ReceiveCoilManufacturerName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9042), ElementsDictionaryEntry("MR Receive Coil Sequence", "MRReceiveCoilSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9043), ElementsDictionaryEntry("Receive Coil Type", "ReceiveCoilType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9044), ElementsDictionaryEntry("Quadrature Receive Coil", "QuadratureReceiveCoil",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9045), ElementsDictionaryEntry("Multi-Coil Definition Sequence", "MultiCoilDefinitionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9046), ElementsDictionaryEntry("Multi-Coil Configuration", "MultiCoilConfiguration",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9047), ElementsDictionaryEntry("Multi-Coil Element Name", "MultiCoilElementName",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9048), ElementsDictionaryEntry("Multi-Coil Element Used", "MultiCoilElementUsed",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9049), ElementsDictionaryEntry("MR Transmit Coil Sequence", "MRTransmitCoilSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9050), ElementsDictionaryEntry("Transmit Coil Manufacturer Name", "TransmitCoilManufacturerName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9051), ElementsDictionaryEntry("Transmit Coil Type", "TransmitCoilType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9052), ElementsDictionaryEntry("Spectral Width", "SpectralWidth",  "FD", "1-2"));
    public_dictionary.emplace(Tag(0x0018, 0x9053), ElementsDictionaryEntry("Chemical Shift Reference", "ChemicalShiftReference",  "FD", "1-2"));
    public_dictionary.emplace(Tag(0x0018, 0x9054), ElementsDictionaryEntry("Volume Localization Technique", "VolumeLocalizationTechnique",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9058), ElementsDictionaryEntry("MR Acquisition Frequency Encoding Steps", "MRAcquisitionFrequencyEncodingSteps",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9059), ElementsDictionaryEntry("De-coupling", "Decoupling",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9060), ElementsDictionaryEntry("De-coupled Nucleus", "DecoupledNucleus",  "CS", "1-2"));
    public_dictionary.emplace(Tag(0x0018, 0x9061), ElementsDictionaryEntry("De-coupling Frequency", "DecouplingFrequency",  "FD", "1-2"));
    public_dictionary.emplace(Tag(0x0018, 0x9062), ElementsDictionaryEntry("De-coupling Method", "DecouplingMethod",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9063), ElementsDictionaryEntry("De-coupling Chemical Shift Reference", "DecouplingChemicalShiftReference",  "FD", "1-2"));
    public_dictionary.emplace(Tag(0x0018, 0x9064), ElementsDictionaryEntry("k-space Filtering", "KSpaceFiltering",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9065), ElementsDictionaryEntry("Time Domain Filtering", "TimeDomainFiltering",  "CS", "1-2"));
    public_dictionary.emplace(Tag(0x0018, 0x9066), ElementsDictionaryEntry("Number of Zero Fills", "NumberOfZeroFills",  "US", "1-2"));
    public_dictionary.emplace(Tag(0x0018, 0x9067), ElementsDictionaryEntry("Baseline Correction", "BaselineCorrection",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9069), ElementsDictionaryEntry("Parallel Reduction Factor In-plane", "ParallelReductionFactorInPlane",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9070), ElementsDictionaryEntry("Cardiac R-R Interval Specified", "CardiacRRIntervalSpecified",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9073), ElementsDictionaryEntry("Acquisition Duration", "AcquisitionDuration",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9074), ElementsDictionaryEntry("Frame Acquisition DateTime", "FrameAcquisitionDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9075), ElementsDictionaryEntry("Diffusion Directionality", "DiffusionDirectionality",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9076), ElementsDictionaryEntry("Diffusion Gradient Direction Sequence", "DiffusionGradientDirectionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9077), ElementsDictionaryEntry("Parallel Acquisition", "ParallelAcquisition",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9078), ElementsDictionaryEntry("Parallel Acquisition Technique", "ParallelAcquisitionTechnique",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9079), ElementsDictionaryEntry("Inversion Times", "InversionTimes",  "FD", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x9080), ElementsDictionaryEntry("Metabolite Map Description", "MetaboliteMapDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9081), ElementsDictionaryEntry("Partial Fourier", "PartialFourier",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9082), ElementsDictionaryEntry("Effective Echo Time", "EffectiveEchoTime",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9083), ElementsDictionaryEntry("Metabolite Map Code Sequence", "MetaboliteMapCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9084), ElementsDictionaryEntry("Chemical Shift Sequence", "ChemicalShiftSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9085), ElementsDictionaryEntry("Cardiac Signal Source", "CardiacSignalSource",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9087), ElementsDictionaryEntry("Diffusion b-value", "DiffusionBValue",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9089), ElementsDictionaryEntry("Diffusion Gradient Orientation", "DiffusionGradientOrientation",  "FD", "3"));
    public_dictionary.emplace(Tag(0x0018, 0x9090), ElementsDictionaryEntry("Velocity Encoding Direction", "VelocityEncodingDirection",  "FD", "3"));
    public_dictionary.emplace(Tag(0x0018, 0x9091), ElementsDictionaryEntry("Velocity Encoding Minimum Value", "VelocityEncodingMinimumValue",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9092), ElementsDictionaryEntry("Velocity Encoding Acquisition Sequence", "VelocityEncodingAcquisitionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9093), ElementsDictionaryEntry("Number of k-Space Trajectories", "NumberOfKSpaceTrajectories",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9094), ElementsDictionaryEntry("Coverage of k-Space", "CoverageOfKSpace",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9095), ElementsDictionaryEntry("Spectroscopy Acquisition Phase Rows", "SpectroscopyAcquisitionPhaseRows",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9096), ElementsDictionaryEntry("Parallel Reduction Factor In-plane (Retired)", "ParallelReductionFactorInPlaneRetired",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9098), ElementsDictionaryEntry("Transmitter Frequency", "TransmitterFrequency",  "FD", "1-2"));
    public_dictionary.emplace(Tag(0x0018, 0x9100), ElementsDictionaryEntry("Resonant Nucleus", "ResonantNucleus",  "CS", "1-2"));
    public_dictionary.emplace(Tag(0x0018, 0x9101), ElementsDictionaryEntry("Frequency Correction", "FrequencyCorrection",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9103), ElementsDictionaryEntry("MR Spectroscopy FOV/Geometry Sequence", "MRSpectroscopyFOVGeometrySequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9104), ElementsDictionaryEntry("Slab Thickness", "SlabThickness",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9105), ElementsDictionaryEntry("Slab Orientation", "SlabOrientation",  "FD", "3"));
    public_dictionary.emplace(Tag(0x0018, 0x9106), ElementsDictionaryEntry("Mid Slab Position", "MidSlabPosition",  "FD", "3"));
    public_dictionary.emplace(Tag(0x0018, 0x9107), ElementsDictionaryEntry("MR Spatial Saturation Sequence", "MRSpatialSaturationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9112), ElementsDictionaryEntry("MR Timing and Related Parameters Sequence", "MRTimingAndRelatedParametersSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9114), ElementsDictionaryEntry("MR Echo Sequence", "MREchoSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9115), ElementsDictionaryEntry("MR Modifier Sequence", "MRModifierSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9117), ElementsDictionaryEntry("MR Diffusion Sequence", "MRDiffusionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9118), ElementsDictionaryEntry("Cardiac Synchronization Sequence", "CardiacSynchronizationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9119), ElementsDictionaryEntry("MR Averages Sequence", "MRAveragesSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9125), ElementsDictionaryEntry("MR FOV/Geometry Sequence", "MRFOVGeometrySequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9126), ElementsDictionaryEntry("Volume Localization Sequence", "VolumeLocalizationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9127), ElementsDictionaryEntry("Spectroscopy Acquisition Data Columns", "SpectroscopyAcquisitionDataColumns",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9147), ElementsDictionaryEntry("Diffusion Anisotropy Type", "DiffusionAnisotropyType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9151), ElementsDictionaryEntry("Frame Reference DateTime", "FrameReferenceDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9152), ElementsDictionaryEntry("MR Metabolite Map Sequence", "MRMetaboliteMapSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9155), ElementsDictionaryEntry("Parallel Reduction Factor out-of-plane", "ParallelReductionFactorOutOfPlane",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9159), ElementsDictionaryEntry("Spectroscopy Acquisition Out-of-plane Phase Steps", "SpectroscopyAcquisitionOutOfPlanePhaseSteps",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9166), ElementsDictionaryEntry("Bulk Motion Status", "BulkMotionStatus",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9168), ElementsDictionaryEntry("Parallel Reduction Factor Second In-plane", "ParallelReductionFactorSecondInPlane",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9169), ElementsDictionaryEntry("Cardiac Beat Rejection Technique", "CardiacBeatRejectionTechnique",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9170), ElementsDictionaryEntry("Respiratory Motion Compensation Technique", "RespiratoryMotionCompensationTechnique",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9171), ElementsDictionaryEntry("Respiratory Signal Source", "RespiratorySignalSource",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9172), ElementsDictionaryEntry("Bulk Motion Compensation Technique", "BulkMotionCompensationTechnique",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9173), ElementsDictionaryEntry("Bulk Motion Signal Source", "BulkMotionSignalSource",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9174), ElementsDictionaryEntry("Applicable Safety Standard Agency", "ApplicableSafetyStandardAgency",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9175), ElementsDictionaryEntry("Applicable Safety Standard Description", "ApplicableSafetyStandardDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9176), ElementsDictionaryEntry("Operating Mode Sequence", "OperatingModeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9177), ElementsDictionaryEntry("Operating Mode Type", "OperatingModeType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9178), ElementsDictionaryEntry("Operating Mode", "OperatingMode",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9179), ElementsDictionaryEntry("Specific Absorption Rate Definition", "SpecificAbsorptionRateDefinition",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9180), ElementsDictionaryEntry("Gradient Output Type", "GradientOutputType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9181), ElementsDictionaryEntry("Specific Absorption Rate Value", "SpecificAbsorptionRateValue",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9182), ElementsDictionaryEntry("Gradient Output", "GradientOutput",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9183), ElementsDictionaryEntry("Flow Compensation Direction", "FlowCompensationDirection",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9184), ElementsDictionaryEntry("Tagging Delay", "TaggingDelay",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9185), ElementsDictionaryEntry("Respiratory Motion Compensation Technique Description", "RespiratoryMotionCompensationTechniqueDescription",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9186), ElementsDictionaryEntry("Respiratory Signal Source ID", "RespiratorySignalSourceID",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9195), ElementsDictionaryEntry("Chemical Shift Minimum Integration Limit in Hz", "ChemicalShiftMinimumIntegrationLimitInHz",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9196), ElementsDictionaryEntry("Chemical Shift Maximum Integration Limit in Hz", "ChemicalShiftMaximumIntegrationLimitInHz",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9197), ElementsDictionaryEntry("MR Velocity Encoding Sequence", "MRVelocityEncodingSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9198), ElementsDictionaryEntry("First Order Phase Correction", "FirstOrderPhaseCorrection",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9199), ElementsDictionaryEntry("Water Referenced Phase Correction", "WaterReferencedPhaseCorrection",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9200), ElementsDictionaryEntry("MR Spectroscopy Acquisition Type", "MRSpectroscopyAcquisitionType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9214), ElementsDictionaryEntry("Respiratory Cycle Position", "RespiratoryCyclePosition",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9217), ElementsDictionaryEntry("Velocity Encoding Maximum Value", "VelocityEncodingMaximumValue",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9218), ElementsDictionaryEntry("Tag Spacing Second Dimension", "TagSpacingSecondDimension",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9219), ElementsDictionaryEntry("Tag Angle Second Axis", "TagAngleSecondAxis",  "SS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9220), ElementsDictionaryEntry("Frame Acquisition Duration", "FrameAcquisitionDuration",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9226), ElementsDictionaryEntry("MR Image Frame Type Sequence", "MRImageFrameTypeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9227), ElementsDictionaryEntry("MR Spectroscopy Frame Type Sequence", "MRSpectroscopyFrameTypeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9231), ElementsDictionaryEntry("MR Acquisition Phase Encoding Steps in-plane", "MRAcquisitionPhaseEncodingStepsInPlane",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9232), ElementsDictionaryEntry("MR Acquisition Phase Encoding Steps out-of-plane", "MRAcquisitionPhaseEncodingStepsOutOfPlane",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9234), ElementsDictionaryEntry("Spectroscopy Acquisition Phase Columns", "SpectroscopyAcquisitionPhaseColumns",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9236), ElementsDictionaryEntry("Cardiac Cycle Position", "CardiacCyclePosition",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9239), ElementsDictionaryEntry("Specific Absorption Rate Sequence", "SpecificAbsorptionRateSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9240), ElementsDictionaryEntry("RF Echo Train Length", "RFEchoTrainLength",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9241), ElementsDictionaryEntry("Gradient Echo Train Length", "GradientEchoTrainLength",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9250), ElementsDictionaryEntry("Arterial Spin Labeling Contrast", "ArterialSpinLabelingContrast",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9251), ElementsDictionaryEntry("MR Arterial Spin Labeling Sequence", "MRArterialSpinLabelingSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9252), ElementsDictionaryEntry("ASL Technique Description", "ASLTechniqueDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9253), ElementsDictionaryEntry("ASL Slab Number", "ASLSlabNumber",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9254), ElementsDictionaryEntry("ASL Slab Thickness", "ASLSlabThickness",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9255), ElementsDictionaryEntry("ASL Slab Orientation", "ASLSlabOrientation",  "FD", "3"));
    public_dictionary.emplace(Tag(0x0018, 0x9256), ElementsDictionaryEntry("ASL Mid Slab Position", "ASLMidSlabPosition",  "FD", "3"));
    public_dictionary.emplace(Tag(0x0018, 0x9257), ElementsDictionaryEntry("ASL Context", "ASLContext",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9258), ElementsDictionaryEntry("ASL Pulse Train Duration", "ASLPulseTrainDuration",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9259), ElementsDictionaryEntry("ASL Crusher Flag", "ASLCrusherFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x925a), ElementsDictionaryEntry("ASL Crusher Flow Limit", "ASLCrusherFlowLimit",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x925b), ElementsDictionaryEntry("ASL Crusher Description", "ASLCrusherDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x925c), ElementsDictionaryEntry("ASL Bolus Cut-off Flag", "ASLBolusCutoffFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x925d), ElementsDictionaryEntry("ASL Bolus Cut-off Timing Sequence", "ASLBolusCutoffTimingSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x925e), ElementsDictionaryEntry("ASL Bolus Cut-off Technique", "ASLBolusCutoffTechnique",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x925f), ElementsDictionaryEntry("ASL Bolus Cut-off Delay Time", "ASLBolusCutoffDelayTime",  "UL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9260), ElementsDictionaryEntry("ASL Slab Sequence", "ASLSlabSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9295), ElementsDictionaryEntry("Chemical Shift Minimum Integration Limit in ppm", "ChemicalShiftMinimumIntegrationLimitInppm",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9296), ElementsDictionaryEntry("Chemical Shift Maximum Integration Limit in ppm", "ChemicalShiftMaximumIntegrationLimitInppm",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9297), ElementsDictionaryEntry("Water Reference Acquisition", "WaterReferenceAcquisition",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9298), ElementsDictionaryEntry("Echo Peak Position", "EchoPeakPosition",  "IS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9301), ElementsDictionaryEntry("CT Acquisition Type Sequence", "CTAcquisitionTypeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9302), ElementsDictionaryEntry("Acquisition Type", "AcquisitionType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9303), ElementsDictionaryEntry("Tube Angle", "TubeAngle",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9304), ElementsDictionaryEntry("CT Acquisition Details Sequence", "CTAcquisitionDetailsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9305), ElementsDictionaryEntry("Revolution Time", "RevolutionTime",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9306), ElementsDictionaryEntry("Single Collimation Width", "SingleCollimationWidth",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9307), ElementsDictionaryEntry("Total Collimation Width", "TotalCollimationWidth",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9308), ElementsDictionaryEntry("CT Table Dynamics Sequence", "CTTableDynamicsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9309), ElementsDictionaryEntry("Table Speed", "TableSpeed",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9310), ElementsDictionaryEntry("Table Feed per Rotation", "TableFeedPerRotation",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9311), ElementsDictionaryEntry("Spiral Pitch Factor", "SpiralPitchFactor",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9312), ElementsDictionaryEntry("CT Geometry Sequence", "CTGeometrySequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9313), ElementsDictionaryEntry("Data Collection Center (Patient)", "DataCollectionCenterPatient",  "FD", "3"));
    public_dictionary.emplace(Tag(0x0018, 0x9314), ElementsDictionaryEntry("CT Reconstruction Sequence", "CTReconstructionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9315), ElementsDictionaryEntry("Reconstruction Algorithm", "ReconstructionAlgorithm",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9316), ElementsDictionaryEntry("Convolution Kernel Group", "ConvolutionKernelGroup",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9317), ElementsDictionaryEntry("Reconstruction Field of View", "ReconstructionFieldOfView",  "FD", "2"));
    public_dictionary.emplace(Tag(0x0018, 0x9318), ElementsDictionaryEntry("Reconstruction Target Center (Patient)", "ReconstructionTargetCenterPatient",  "FD", "3"));
    public_dictionary.emplace(Tag(0x0018, 0x9319), ElementsDictionaryEntry("Reconstruction Angle", "ReconstructionAngle",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9320), ElementsDictionaryEntry("Image Filter", "ImageFilter",  "SH", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9321), ElementsDictionaryEntry("CT Exposure Sequence", "CTExposureSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9322), ElementsDictionaryEntry("Reconstruction Pixel Spacing", "ReconstructionPixelSpacing",  "FD", "2"));
    public_dictionary.emplace(Tag(0x0018, 0x9323), ElementsDictionaryEntry("Exposure Modulation Type", "ExposureModulationType",  "CS", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x9324), ElementsDictionaryEntry("Estimated Dose Saving", "EstimatedDoseSaving",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9325), ElementsDictionaryEntry("CT X-Ray Details Sequence", "CTXRayDetailsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9326), ElementsDictionaryEntry("CT Position Sequence", "CTPositionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9327), ElementsDictionaryEntry("Table Position", "TablePosition",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9328), ElementsDictionaryEntry("Exposure Time in ms", "ExposureTimeInms",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9329), ElementsDictionaryEntry("CT Image Frame Type Sequence", "CTImageFrameTypeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9330), ElementsDictionaryEntry("X-Ray Tube Current in mA", "XRayTubeCurrentInmA",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9332), ElementsDictionaryEntry("Exposure in mAs", "ExposureInmAs",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9333), ElementsDictionaryEntry("Constant Volume Flag", "ConstantVolumeFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9334), ElementsDictionaryEntry("Fluoroscopy Flag", "FluoroscopyFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9335), ElementsDictionaryEntry("Distance Source to Data Collection Center", "DistanceSourceToDataCollectionCenter",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9337), ElementsDictionaryEntry("Contrast/Bolus Agent Number", "ContrastBolusAgentNumber",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9338), ElementsDictionaryEntry("Contrast/Bolus Ingredient Code Sequence", "ContrastBolusIngredientCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9340), ElementsDictionaryEntry("Contrast Administration Profile Sequence", "ContrastAdministrationProfileSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9341), ElementsDictionaryEntry("Contrast/Bolus Usage Sequence", "ContrastBolusUsageSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9342), ElementsDictionaryEntry("Contrast/Bolus Agent Administered", "ContrastBolusAgentAdministered",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9343), ElementsDictionaryEntry("Contrast/Bolus Agent Detected", "ContrastBolusAgentDetected",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9344), ElementsDictionaryEntry("Contrast/Bolus Agent Phase", "ContrastBolusAgentPhase",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9345), ElementsDictionaryEntry("CTDIvol", "CTDIvol",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9346), ElementsDictionaryEntry("CTDI Phantom Type Code Sequence", "CTDIPhantomTypeCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9351), ElementsDictionaryEntry("Calcium Scoring Mass Factor Patient", "CalciumScoringMassFactorPatient",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9352), ElementsDictionaryEntry("Calcium Scoring Mass Factor Device", "CalciumScoringMassFactorDevice",  "FL", "3"));
    public_dictionary.emplace(Tag(0x0018, 0x9353), ElementsDictionaryEntry("Energy Weighting Factor", "EnergyWeightingFactor",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9360), ElementsDictionaryEntry("CT Additional X-Ray Source Sequence", "CTAdditionalXRaySourceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9361), ElementsDictionaryEntry("Multi-energy CT Acquisition", "MultienergyCTAcquisition",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9362), ElementsDictionaryEntry("Multi-energy CT Acquisition Sequence", "MultienergyCTAcquisitionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9363), ElementsDictionaryEntry("Multi-energy CT Processing Sequence", "MultienergyCTProcessingSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9364), ElementsDictionaryEntry("Multi-energy CT Characteristics Sequence", "MultienergyCTCharacteristicsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9365), ElementsDictionaryEntry("Multi-energy CT X-Ray Source Sequence", "MultienergyCTXRaySourceSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9366), ElementsDictionaryEntry("X-Ray Source Index", "XRaySourceIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9367), ElementsDictionaryEntry("X-Ray Source ID", "XRaySourceID",  "UC", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9368), ElementsDictionaryEntry("Multi-energy Source Technique", "MultienergySourceTechnique",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9369), ElementsDictionaryEntry("Source Start DateTime", "SourceStartDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x936a), ElementsDictionaryEntry("Source End DateTime", "SourceEndDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x936b), ElementsDictionaryEntry("Switching Phase Number", "SwitchingPhaseNumber",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x936c), ElementsDictionaryEntry("Switching Phase Nominal Duration", "SwitchingPhaseNominalDuration",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x936d), ElementsDictionaryEntry("Switching Phase Transition Duration", "SwitchingPhaseTransitionDuration",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x936e), ElementsDictionaryEntry("Effective Bin Energy", "EffectiveBinEnergy",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x936f), ElementsDictionaryEntry("Multi-energy CT X-Ray Detector Sequence", "MultienergyCTXRayDetectorSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9370), ElementsDictionaryEntry("X-Ray Detector Index", "XRayDetectorIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9371), ElementsDictionaryEntry("X-Ray Detector ID", "XRayDetectorID",  "UC", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9372), ElementsDictionaryEntry("Multi-energy Detector Type", "MultienergyDetectorType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9373), ElementsDictionaryEntry("X-Ray Detector Label", "XRayDetectorLabel",  "ST", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9374), ElementsDictionaryEntry("Nominal Max Energy", "NominalMaxEnergy",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9375), ElementsDictionaryEntry("Nominal Min Energy", "NominalMinEnergy",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9376), ElementsDictionaryEntry("Referenced X-Ray Detector Index", "ReferencedXRayDetectorIndex",  "US", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x9377), ElementsDictionaryEntry("Referenced X-Ray Source Index", "ReferencedXRaySourceIndex",  "US", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x9378), ElementsDictionaryEntry("Referenced Path Index", "ReferencedPathIndex",  "US", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x9379), ElementsDictionaryEntry("Multi-energy CT Path Sequence", "MultienergyCTPathSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x937a), ElementsDictionaryEntry("Multi-energy CT Path Index", "MultienergyCTPathIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x937b), ElementsDictionaryEntry("Multi-energy Acquisition Description", "MultienergyAcquisitionDescription",  "UT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x937c), ElementsDictionaryEntry("Monoenergetic Energy Equivalent", "MonoenergeticEnergyEquivalent",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x937d), ElementsDictionaryEntry("Material Code Sequence", "MaterialCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x937e), ElementsDictionaryEntry("Decomposition Method", "DecompositionMethod",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x937f), ElementsDictionaryEntry("Decomposition Description", "DecompositionDescription",  "UT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9380), ElementsDictionaryEntry("Decomposition Algorithm Identification Sequence", "DecompositionAlgorithmIdentificationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9381), ElementsDictionaryEntry("Decomposition Material Sequence", "DecompositionMaterialSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9382), ElementsDictionaryEntry("Material Attenuation Sequence", "MaterialAttenuationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9383), ElementsDictionaryEntry("Photon Energy", "PhotonEnergy",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9384), ElementsDictionaryEntry("X-Ray Mass Attenuation Coefficient", "XRayMassAttenuationCoefficient",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9401), ElementsDictionaryEntry("Projection Pixel Calibration Sequence", "ProjectionPixelCalibrationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9402), ElementsDictionaryEntry("Distance Source to Isocenter", "DistanceSourceToIsocenter",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9403), ElementsDictionaryEntry("Distance Object to Table Top", "DistanceObjectToTableTop",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9404), ElementsDictionaryEntry("Object Pixel Spacing in Center of Beam", "ObjectPixelSpacingInCenterOfBeam",  "FL", "2"));
    public_dictionary.emplace(Tag(0x0018, 0x9405), ElementsDictionaryEntry("Positioner Position Sequence", "PositionerPositionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9406), ElementsDictionaryEntry("Table Position Sequence", "TablePositionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9407), ElementsDictionaryEntry("Collimator Shape Sequence", "CollimatorShapeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9410), ElementsDictionaryEntry("Planes in Acquisition", "PlanesInAcquisition",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9412), ElementsDictionaryEntry("XA/XRF Frame Characteristics Sequence", "XAXRFFrameCharacteristicsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9417), ElementsDictionaryEntry("Frame Acquisition Sequence", "FrameAcquisitionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9420), ElementsDictionaryEntry("X-Ray Receptor Type", "XRayReceptorType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9423), ElementsDictionaryEntry("Acquisition Protocol Name", "AcquisitionProtocolName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9424), ElementsDictionaryEntry("Acquisition Protocol Description", "AcquisitionProtocolDescription",  "LT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9425), ElementsDictionaryEntry("Contrast/Bolus Ingredient Opaque", "ContrastBolusIngredientOpaque",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9426), ElementsDictionaryEntry("Distance Receptor Plane to Detector Housing", "DistanceReceptorPlaneToDetectorHousing",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9427), ElementsDictionaryEntry("Intensifier Active Shape", "IntensifierActiveShape",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9428), ElementsDictionaryEntry("Intensifier Active Dimension(s)", "IntensifierActiveDimensions",  "FL", "1-2"));
    public_dictionary.emplace(Tag(0x0018, 0x9429), ElementsDictionaryEntry("Physical Detector Size", "PhysicalDetectorSize",  "FL", "2"));
    public_dictionary.emplace(Tag(0x0018, 0x9430), ElementsDictionaryEntry("Position of Isocenter Projection", "PositionOfIsocenterProjection",  "FL", "2"));
    public_dictionary.emplace(Tag(0x0018, 0x9432), ElementsDictionaryEntry("Field of View Sequence", "FieldOfViewSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9433), ElementsDictionaryEntry("Field of View Description", "FieldOfViewDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9434), ElementsDictionaryEntry("Exposure Control Sensing Regions Sequence", "ExposureControlSensingRegionsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9435), ElementsDictionaryEntry("Exposure Control Sensing Region Shape", "ExposureControlSensingRegionShape",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9436), ElementsDictionaryEntry("Exposure Control Sensing Region Left Vertical Edge", "ExposureControlSensingRegionLeftVerticalEdge",  "SS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9437), ElementsDictionaryEntry("Exposure Control Sensing Region Right Vertical Edge", "ExposureControlSensingRegionRightVerticalEdge",  "SS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9438), ElementsDictionaryEntry("Exposure Control Sensing Region Upper Horizontal Edge", "ExposureControlSensingRegionUpperHorizontalEdge",  "SS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9439), ElementsDictionaryEntry("Exposure Control Sensing Region Lower Horizontal Edge", "ExposureControlSensingRegionLowerHorizontalEdge",  "SS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9440), ElementsDictionaryEntry("Center of Circular Exposure Control Sensing Region", "CenterOfCircularExposureControlSensingRegion",  "SS", "2"));
    public_dictionary.emplace(Tag(0x0018, 0x9441), ElementsDictionaryEntry("Radius of Circular Exposure Control Sensing Region", "RadiusOfCircularExposureControlSensingRegion",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9442), ElementsDictionaryEntry("Vertices of the Polygonal Exposure Control Sensing Region", "VerticesOfThePolygonalExposureControlSensingRegion",  "SS", "2-n"));
    public_dictionary.emplace(Tag(0x0018, 0x9447), ElementsDictionaryEntry("Column Angulation (Patient)", "ColumnAngulationPatient",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9449), ElementsDictionaryEntry("Beam Angle", "BeamAngle",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9451), ElementsDictionaryEntry("Frame Detector Parameters Sequence", "FrameDetectorParametersSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9452), ElementsDictionaryEntry("Calculated Anatomy Thickness", "CalculatedAnatomyThickness",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9455), ElementsDictionaryEntry("Calibration Sequence", "CalibrationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9456), ElementsDictionaryEntry("Object Thickness Sequence", "ObjectThicknessSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9457), ElementsDictionaryEntry("Plane Identification", "PlaneIdentification",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9461), ElementsDictionaryEntry("Field of View Dimension(s) in Float", "FieldOfViewDimensionsInFloat",  "FL", "1-2"));
    public_dictionary.emplace(Tag(0x0018, 0x9462), ElementsDictionaryEntry("Isocenter Reference System Sequence", "IsocenterReferenceSystemSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9463), ElementsDictionaryEntry("Positioner Isocenter Primary Angle", "PositionerIsocenterPrimaryAngle",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9464), ElementsDictionaryEntry("Positioner Isocenter Secondary Angle", "PositionerIsocenterSecondaryAngle",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9465), ElementsDictionaryEntry("Positioner Isocenter Detector Rotation Angle", "PositionerIsocenterDetectorRotationAngle",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9466), ElementsDictionaryEntry("Table X Position to Isocenter", "TableXPositionToIsocenter",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9467), ElementsDictionaryEntry("Table Y Position to Isocenter", "TableYPositionToIsocenter",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9468), ElementsDictionaryEntry("Table Z Position to Isocenter", "TableZPositionToIsocenter",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9469), ElementsDictionaryEntry("Table Horizontal Rotation Angle", "TableHorizontalRotationAngle",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9470), ElementsDictionaryEntry("Table Head Tilt Angle", "TableHeadTiltAngle",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9471), ElementsDictionaryEntry("Table Cradle Tilt Angle", "TableCradleTiltAngle",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9472), ElementsDictionaryEntry("Frame Display Shutter Sequence", "FrameDisplayShutterSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9473), ElementsDictionaryEntry("Acquired Image Area Dose Product", "AcquiredImageAreaDoseProduct",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9474), ElementsDictionaryEntry("C-arm Positioner Tabletop Relationship", "CArmPositionerTabletopRelationship",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9476), ElementsDictionaryEntry("X-Ray Geometry Sequence", "XRayGeometrySequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9477), ElementsDictionaryEntry("Irradiation Event Identification Sequence", "IrradiationEventIdentificationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9504), ElementsDictionaryEntry("X-Ray 3D Frame Type Sequence", "XRay3DFrameTypeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9506), ElementsDictionaryEntry("Contributing Sources Sequence", "ContributingSourcesSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9507), ElementsDictionaryEntry("X-Ray 3D Acquisition Sequence", "XRay3DAcquisitionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9508), ElementsDictionaryEntry("Primary Positioner Scan Arc", "PrimaryPositionerScanArc",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9509), ElementsDictionaryEntry("Secondary Positioner Scan Arc", "SecondaryPositionerScanArc",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9510), ElementsDictionaryEntry("Primary Positioner Scan Start Angle", "PrimaryPositionerScanStartAngle",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9511), ElementsDictionaryEntry("Secondary Positioner Scan Start Angle", "SecondaryPositionerScanStartAngle",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9514), ElementsDictionaryEntry("Primary Positioner Increment", "PrimaryPositionerIncrement",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9515), ElementsDictionaryEntry("Secondary Positioner Increment", "SecondaryPositionerIncrement",  "FL", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9516), ElementsDictionaryEntry("Start Acquisition DateTime", "StartAcquisitionDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9517), ElementsDictionaryEntry("End Acquisition DateTime", "EndAcquisitionDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9518), ElementsDictionaryEntry("Primary Positioner Increment Sign", "PrimaryPositionerIncrementSign",  "SS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9519), ElementsDictionaryEntry("Secondary Positioner Increment Sign", "SecondaryPositionerIncrementSign",  "SS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9524), ElementsDictionaryEntry("Application Name", "ApplicationName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9525), ElementsDictionaryEntry("Application Version", "ApplicationVersion",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9526), ElementsDictionaryEntry("Application Manufacturer", "ApplicationManufacturer",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9527), ElementsDictionaryEntry("Algorithm Type", "AlgorithmType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9528), ElementsDictionaryEntry("Algorithm Description", "AlgorithmDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9530), ElementsDictionaryEntry("X-Ray 3D Reconstruction Sequence", "XRay3DReconstructionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9531), ElementsDictionaryEntry("Reconstruction Description", "ReconstructionDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9538), ElementsDictionaryEntry("Per Projection Acquisition Sequence", "PerProjectionAcquisitionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9541), ElementsDictionaryEntry("Detector Position Sequence", "DetectorPositionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9542), ElementsDictionaryEntry("X-Ray Acquisition Dose Sequence", "XRayAcquisitionDoseSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9543), ElementsDictionaryEntry("X-Ray Source Isocenter Primary Angle", "XRaySourceIsocenterPrimaryAngle",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9544), ElementsDictionaryEntry("X-Ray Source Isocenter Secondary Angle", "XRaySourceIsocenterSecondaryAngle",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9545), ElementsDictionaryEntry("Breast Support Isocenter Primary Angle", "BreastSupportIsocenterPrimaryAngle",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9546), ElementsDictionaryEntry("Breast Support Isocenter Secondary Angle", "BreastSupportIsocenterSecondaryAngle",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9547), ElementsDictionaryEntry("Breast Support X Position to Isocenter", "BreastSupportXPositionToIsocenter",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9548), ElementsDictionaryEntry("Breast Support Y Position to Isocenter", "BreastSupportYPositionToIsocenter",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9549), ElementsDictionaryEntry("Breast Support Z Position to Isocenter", "BreastSupportZPositionToIsocenter",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9550), ElementsDictionaryEntry("Detector Isocenter Primary Angle", "DetectorIsocenterPrimaryAngle",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9551), ElementsDictionaryEntry("Detector Isocenter Secondary Angle", "DetectorIsocenterSecondaryAngle",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9552), ElementsDictionaryEntry("Detector X Position to Isocenter", "DetectorXPositionToIsocenter",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9553), ElementsDictionaryEntry("Detector Y Position to Isocenter", "DetectorYPositionToIsocenter",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9554), ElementsDictionaryEntry("Detector Z Position to Isocenter", "DetectorZPositionToIsocenter",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9555), ElementsDictionaryEntry("X-Ray Grid Sequence", "XRayGridSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9556), ElementsDictionaryEntry("X-Ray Filter Sequence", "XRayFilterSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9557), ElementsDictionaryEntry("Detector Active Area TLHC Position", "DetectorActiveAreaTLHCPosition",  "FD", "3"));
    public_dictionary.emplace(Tag(0x0018, 0x9558), ElementsDictionaryEntry("Detector Active Area Orientation", "DetectorActiveAreaOrientation",  "FD", "6"));
    public_dictionary.emplace(Tag(0x0018, 0x9559), ElementsDictionaryEntry("Positioner Primary Angle Direction", "PositionerPrimaryAngleDirection",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9601), ElementsDictionaryEntry("Diffusion b-matrix Sequence", "DiffusionBMatrixSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9602), ElementsDictionaryEntry("Diffusion b-value XX", "DiffusionBValueXX",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9603), ElementsDictionaryEntry("Diffusion b-value XY", "DiffusionBValueXY",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9604), ElementsDictionaryEntry("Diffusion b-value XZ", "DiffusionBValueXZ",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9605), ElementsDictionaryEntry("Diffusion b-value YY", "DiffusionBValueYY",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9606), ElementsDictionaryEntry("Diffusion b-value YZ", "DiffusionBValueYZ",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9607), ElementsDictionaryEntry("Diffusion b-value ZZ", "DiffusionBValueZZ",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9621), ElementsDictionaryEntry("Functional MR Sequence", "FunctionalMRSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9622), ElementsDictionaryEntry("Functional Settling Phase Frames Present", "FunctionalSettlingPhaseFramesPresent",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9623), ElementsDictionaryEntry("Functional Sync Pulse", "FunctionalSyncPulse",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9624), ElementsDictionaryEntry("Settling Phase Frame", "SettlingPhaseFrame",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9701), ElementsDictionaryEntry("Decay Correction DateTime", "DecayCorrectionDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9715), ElementsDictionaryEntry("Start Density Threshold", "StartDensityThreshold",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9716), ElementsDictionaryEntry("Start Relative Density Difference Threshold", "StartRelativeDensityDifferenceThreshold",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9717), ElementsDictionaryEntry("Start Cardiac Trigger Count Threshold", "StartCardiacTriggerCountThreshold",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9718), ElementsDictionaryEntry("Start Respiratory Trigger Count Threshold", "StartRespiratoryTriggerCountThreshold",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9719), ElementsDictionaryEntry("Termination Counts Threshold", "TerminationCountsThreshold",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9720), ElementsDictionaryEntry("Termination Density Threshold", "TerminationDensityThreshold",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9721), ElementsDictionaryEntry("Termination Relative Density Threshold", "TerminationRelativeDensityThreshold",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9722), ElementsDictionaryEntry("Termination Time Threshold", "TerminationTimeThreshold",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9723), ElementsDictionaryEntry("Termination Cardiac Trigger Count Threshold", "TerminationCardiacTriggerCountThreshold",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9724), ElementsDictionaryEntry("Termination Respiratory Trigger Count Threshold", "TerminationRespiratoryTriggerCountThreshold",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9725), ElementsDictionaryEntry("Detector Geometry", "DetectorGeometry",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9726), ElementsDictionaryEntry("Transverse Detector Separation", "TransverseDetectorSeparation",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9727), ElementsDictionaryEntry("Axial Detector Dimension", "AxialDetectorDimension",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9729), ElementsDictionaryEntry("Radiopharmaceutical Agent Number", "RadiopharmaceuticalAgentNumber",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9732), ElementsDictionaryEntry("PET Frame Acquisition Sequence", "PETFrameAcquisitionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9733), ElementsDictionaryEntry("PET Detector Motion Details Sequence", "PETDetectorMotionDetailsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9734), ElementsDictionaryEntry("PET Table Dynamics Sequence", "PETTableDynamicsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9735), ElementsDictionaryEntry("PET Position Sequence", "PETPositionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9736), ElementsDictionaryEntry("PET Frame Correction Factors Sequence", "PETFrameCorrectionFactorsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9737), ElementsDictionaryEntry("Radiopharmaceutical Usage Sequence", "RadiopharmaceuticalUsageSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9738), ElementsDictionaryEntry("Attenuation Correction Source", "AttenuationCorrectionSource",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9739), ElementsDictionaryEntry("Number of Iterations", "NumberOfIterations",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9740), ElementsDictionaryEntry("Number of Subsets", "NumberOfSubsets",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9749), ElementsDictionaryEntry("PET Reconstruction Sequence", "PETReconstructionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9751), ElementsDictionaryEntry("PET Frame Type Sequence", "PETFrameTypeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9755), ElementsDictionaryEntry("Time of Flight Information Used", "TimeOfFlightInformationUsed",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9756), ElementsDictionaryEntry("Reconstruction Type", "ReconstructionType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9758), ElementsDictionaryEntry("Decay Corrected", "DecayCorrected",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9759), ElementsDictionaryEntry("Attenuation Corrected", "AttenuationCorrected",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9760), ElementsDictionaryEntry("Scatter Corrected", "ScatterCorrected",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9761), ElementsDictionaryEntry("Dead Time Corrected", "DeadTimeCorrected",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9762), ElementsDictionaryEntry("Gantry Motion Corrected", "GantryMotionCorrected",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9763), ElementsDictionaryEntry("Patient Motion Corrected", "PatientMotionCorrected",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9764), ElementsDictionaryEntry("Count Loss Normalization Corrected", "CountLossNormalizationCorrected",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9765), ElementsDictionaryEntry("Randoms Corrected", "RandomsCorrected",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9766), ElementsDictionaryEntry("Non-uniform Radial Sampling Corrected", "NonUniformRadialSamplingCorrected",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9767), ElementsDictionaryEntry("Sensitivity Calibrated", "SensitivityCalibrated",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9768), ElementsDictionaryEntry("Detector Normalization Correction", "DetectorNormalizationCorrection",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9769), ElementsDictionaryEntry("Iterative Reconstruction Method", "IterativeReconstructionMethod",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9770), ElementsDictionaryEntry("Attenuation Correction Temporal Relationship", "AttenuationCorrectionTemporalRelationship",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9771), ElementsDictionaryEntry("Patient Physiological State Sequence", "PatientPhysiologicalStateSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9772), ElementsDictionaryEntry("Patient Physiological State Code Sequence", "PatientPhysiologicalStateCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9801), ElementsDictionaryEntry("Depth(s) of Focus", "DepthsOfFocus",  "FD", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x9803), ElementsDictionaryEntry("Excluded Intervals Sequence", "ExcludedIntervalsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9804), ElementsDictionaryEntry("Exclusion Start DateTime", "ExclusionStartDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9805), ElementsDictionaryEntry("Exclusion Duration", "ExclusionDuration",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9806), ElementsDictionaryEntry("US Image Description Sequence", "USImageDescriptionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9807), ElementsDictionaryEntry("Image Data Type Sequence", "ImageDataTypeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9808), ElementsDictionaryEntry("Data Type", "DataType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9809), ElementsDictionaryEntry("Transducer Scan Pattern Code Sequence", "TransducerScanPatternCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x980b), ElementsDictionaryEntry("Aliased Data Type", "AliasedDataType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x980c), ElementsDictionaryEntry("Position Measuring Device Used", "PositionMeasuringDeviceUsed",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x980d), ElementsDictionaryEntry("Transducer Geometry Code Sequence", "TransducerGeometryCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x980e), ElementsDictionaryEntry("Transducer Beam Steering Code Sequence", "TransducerBeamSteeringCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x980f), ElementsDictionaryEntry("Transducer Application Code Sequence", "TransducerApplicationCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9810), ElementsDictionaryEntry("Zero Velocity Pixel Value", "ZeroVelocityPixelValue",  "US or SS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9821), ElementsDictionaryEntry("Photoacoustic Excitation Characteristics Sequence", "PhotoacousticExcitationCharacteristicsSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9822), ElementsDictionaryEntry("Excitation Spectral Width", "ExcitationSpectralWidth",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9823), ElementsDictionaryEntry("Excitation Energy", "ExcitationEnergy",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9824), ElementsDictionaryEntry("Excitation Pulse Duration", "ExcitationPulseDuration",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9825), ElementsDictionaryEntry("Excitation Wavelength Sequence", "ExcitationWavelengthSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9826), ElementsDictionaryEntry("Excitation Wavelength", "ExcitationWavelength",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9828), ElementsDictionaryEntry("Illumination Translation Flag", "IlluminationTranslationFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9829), ElementsDictionaryEntry("Acoustic Coupling Medium Flag", "AcousticCouplingMediumFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x982a), ElementsDictionaryEntry("Acoustic Coupling Medium Code Sequence", "AcousticCouplingMediumCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x982b), ElementsDictionaryEntry("Acoustic Coupling Medium Temperature", "AcousticCouplingMediumTemperature",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x982c), ElementsDictionaryEntry("Transducer Response Sequence", "TransducerResponseSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x982d), ElementsDictionaryEntry("Center Frequency", "CenterFrequency",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x982e), ElementsDictionaryEntry("Fractional Bandwidth", "FractionalBandwidth",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x982f), ElementsDictionaryEntry("Lower Cutoff Frequency", "LowerCutoffFrequency",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9830), ElementsDictionaryEntry("Upper Cutoff Frequency", "UpperCutoffFrequency",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9831), ElementsDictionaryEntry("Transducer Technology Sequence", "TransducerTechnologySequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9832), ElementsDictionaryEntry("Sound Speed Correction Mechanism Code Sequence", "SoundSpeedCorrectionMechanismCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9833), ElementsDictionaryEntry("Object Sound Speed", "ObjectSoundSpeed",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9834), ElementsDictionaryEntry("Acoustic Coupling Medium Sound Speed", "AcousticCouplingMediumSoundSpeed",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9835), ElementsDictionaryEntry("Photoacoustic Image Frame Type Sequence", "PhotoacousticImageFrameTypeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9836), ElementsDictionaryEntry("Image Data Type Code Sequence", "ImageDataTypeCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9900), ElementsDictionaryEntry("Reference Location Label", "ReferenceLocationLabel",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9901), ElementsDictionaryEntry("Reference Location Description", "ReferenceLocationDescription",  "UT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9902), ElementsDictionaryEntry("Reference Basis Code Sequence", "ReferenceBasisCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9903), ElementsDictionaryEntry("Reference Geometry Code Sequence", "ReferenceGeometryCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9904), ElementsDictionaryEntry("Offset Distance", "OffsetDistance",  "DS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9905), ElementsDictionaryEntry("Offset Direction", "OffsetDirection",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9906), ElementsDictionaryEntry("Potential Scheduled Protocol Code Sequence", "PotentialScheduledProtocolCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9907), ElementsDictionaryEntry("Potential Requested Procedure Code Sequence", "PotentialRequestedProcedureCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9908), ElementsDictionaryEntry("Potential Reasons for Procedure", "PotentialReasonsForProcedure",  "UC", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x9909), ElementsDictionaryEntry("Potential Reasons for Procedure Code Sequence", "PotentialReasonsForProcedureCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x990a), ElementsDictionaryEntry("Potential Diagnostic Tasks", "PotentialDiagnosticTasks",  "UC", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x990b), ElementsDictionaryEntry("Contraindications Code Sequence", "ContraindicationsCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x990c), ElementsDictionaryEntry("Referenced Defined Protocol Sequence", "ReferencedDefinedProtocolSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x990d), ElementsDictionaryEntry("Referenced Performed Protocol Sequence", "ReferencedPerformedProtocolSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x990e), ElementsDictionaryEntry("Predecessor Protocol Sequence", "PredecessorProtocolSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x990f), ElementsDictionaryEntry("Protocol Planning Information", "ProtocolPlanningInformation",  "UT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9910), ElementsDictionaryEntry("Protocol Design Rationale", "ProtocolDesignRationale",  "UT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9911), ElementsDictionaryEntry("Patient Specification Sequence", "PatientSpecificationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9912), ElementsDictionaryEntry("Model Specification Sequence", "ModelSpecificationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9913), ElementsDictionaryEntry("Parameters Specification Sequence", "ParametersSpecificationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9914), ElementsDictionaryEntry("Instruction Sequence", "InstructionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9915), ElementsDictionaryEntry("Instruction Index", "InstructionIndex",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9916), ElementsDictionaryEntry("Instruction Text", "InstructionText",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9917), ElementsDictionaryEntry("Instruction Description", "InstructionDescription",  "UT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9918), ElementsDictionaryEntry("Instruction Performed Flag", "InstructionPerformedFlag",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9919), ElementsDictionaryEntry("Instruction Performed DateTime", "InstructionPerformedDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x991a), ElementsDictionaryEntry("Instruction Performance Comment", "InstructionPerformanceComment",  "UT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x991b), ElementsDictionaryEntry("Patient Positioning Instruction Sequence", "PatientPositioningInstructionSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x991c), ElementsDictionaryEntry("Positioning Method Code Sequence", "PositioningMethodCodeSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x991d), ElementsDictionaryEntry("Positioning Landmark Sequence", "PositioningLandmarkSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x991e), ElementsDictionaryEntry("Target Frame of Reference UID", "TargetFrameOfReferenceUID",  "UI", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x991f), ElementsDictionaryEntry("Acquisition Protocol Element Specification Sequence", "AcquisitionProtocolElementSpecificationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9920), ElementsDictionaryEntry("Acquisition Protocol Element Sequence", "AcquisitionProtocolElementSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9921), ElementsDictionaryEntry("Protocol Element Number", "ProtocolElementNumber",  "US", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9922), ElementsDictionaryEntry("Protocol Element Name", "ProtocolElementName",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9923), ElementsDictionaryEntry("Protocol Element Characteristics Summary", "ProtocolElementCharacteristicsSummary",  "UT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9924), ElementsDictionaryEntry("Protocol Element Purpose", "ProtocolElementPurpose",  "UT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9930), ElementsDictionaryEntry("Acquisition Motion", "AcquisitionMotion",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9931), ElementsDictionaryEntry("Acquisition Start Location Sequence", "AcquisitionStartLocationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9932), ElementsDictionaryEntry("Acquisition End Location Sequence", "AcquisitionEndLocationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9933), ElementsDictionaryEntry("Reconstruction Protocol Element Specification Sequence", "ReconstructionProtocolElementSpecificationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9934), ElementsDictionaryEntry("Reconstruction Protocol Element Sequence", "ReconstructionProtocolElementSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9935), ElementsDictionaryEntry("Storage Protocol Element Specification Sequence", "StorageProtocolElementSpecificationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9936), ElementsDictionaryEntry("Storage Protocol Element Sequence", "StorageProtocolElementSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9937), ElementsDictionaryEntry("Requested Series Description", "RequestedSeriesDescription",  "LO", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9938), ElementsDictionaryEntry("Source Acquisition Protocol Element Number", "SourceAcquisitionProtocolElementNumber",  "US", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x9939), ElementsDictionaryEntry("Source Acquisition Beam Number", "SourceAcquisitionBeamNumber",  "US", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x993a), ElementsDictionaryEntry("Source Reconstruction Protocol Element Number", "SourceReconstructionProtocolElementNumber",  "US", "1-n"));
    public_dictionary.emplace(Tag(0x0018, 0x993b), ElementsDictionaryEntry("Reconstruction Start Location Sequence", "ReconstructionStartLocationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x993c), ElementsDictionaryEntry("Reconstruction End Location Sequence", "ReconstructionEndLocationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x993d), ElementsDictionaryEntry("Reconstruction Algorithm Sequence", "ReconstructionAlgorithmSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x993e), ElementsDictionaryEntry("Reconstruction Target Center Location Sequence", "ReconstructionTargetCenterLocationSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9941), ElementsDictionaryEntry("Image Filter Description", "ImageFilterDescription",  "UT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9942), ElementsDictionaryEntry("CTDIvol Notification Trigger", "CTDIvolNotificationTrigger",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9943), ElementsDictionaryEntry("DLP Notification Trigger", "DLPNotificationTrigger",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9944), ElementsDictionaryEntry("Auto KVP Selection Type", "AutoKVPSelectionType",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9945), ElementsDictionaryEntry("Auto KVP Upper Bound", "AutoKVPUpperBound",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9946), ElementsDictionaryEntry("Auto KVP Lower Bound", "AutoKVPLowerBound",  "FD", "1"));
    public_dictionary.emplace(Tag(0x0018, 0x9947), ElementsDictionaryEntry("Protocol Defined Patient Position", "ProtocolDefinedPatientPosition",  "CS", "1"));
    public_dictionary.emplace(Tag(0x0018, 0xa001), ElementsDictionaryEntry("Contributing Equipment Sequence", "ContributingEquipmentSequence",  "SQ", "1"));
    public_dictionary.emplace(Tag(0x0018, 0xa002), ElementsDictionaryEntry("Contribution DateTime", "ContributionDateTime",  "DT", "1"));
    public_dictionary.emplace(Tag(0x0018, 0xa003), ElementsDictionaryEntry("Contribution Description", "ContributionDescription",  "ST", "1"));

    public_tags.emplace("ContrastBolusAgent", Tag(0x0018, 0x0010));
    public_tags.emplace("ContrastBolusAgentSequence", Tag(0x0018, 0x0012));
    public_tags.emplace("ContrastBolusT1Relaxivity", Tag(0x0018, 0x0013));
    public_tags.emplace("ContrastBolusAdministrationRouteSequence", Tag(0x0018, 0x0014));
    public_tags.emplace("BodyPartExamined", Tag(0x0018, 0x0015));
    public_tags.emplace("ScanningSequence", Tag(0x0018, 0x0020));
    public_tags.emplace("SequenceVariant", Tag(0x0018, 0x0021));
    public_tags.emplace("ScanOptions", Tag(0x0018, 0x0022));
    public_tags.emplace("MRAcquisitionType", Tag(0x0018, 0x0023));
    public_tags.emplace("SequenceName", Tag(0x0018, 0x0024));
    public_tags.emplace("AngioFlag", Tag(0x0018, 0x0025));
    public_tags.emplace("InterventionDrugInformationSequence", Tag(0x0018, 0x0026));
    public_tags.emplace("InterventionDrugStopTime", Tag(0x0018, 0x0027));
    public_tags.emplace("InterventionDrugDose", Tag(0x0018, 0x0028));
    public_tags.emplace("InterventionDrugCodeSequence", Tag(0x0018, 0x0029));
    public_tags.emplace("AdditionalDrugSequence", Tag(0x0018, 0x002a));
    public_tags.emplace("Radionuclide", Tag(0x0018, 0x0030));
    public_tags.emplace("Radiopharmaceutical", Tag(0x0018, 0x0031));
    public_tags.emplace("EnergyWindowCenterline", Tag(0x0018, 0x0032));
    public_tags.emplace("EnergyWindowTotalWidth", Tag(0x0018, 0x0033));
    public_tags.emplace("InterventionDrugName", Tag(0x0018, 0x0034));
    public_tags.emplace("InterventionDrugStartTime", Tag(0x0018, 0x0035));
    public_tags.emplace("InterventionSequence", Tag(0x0018, 0x0036));
    public_tags.emplace("TherapyType", Tag(0x0018, 0x0037));
    public_tags.emplace("InterventionStatus", Tag(0x0018, 0x0038));
    public_tags.emplace("TherapyDescription", Tag(0x0018, 0x0039));
    public_tags.emplace("InterventionDescription", Tag(0x0018, 0x003a));
    public_tags.emplace("CineRate", Tag(0x0018, 0x0040));
    public_tags.emplace("InitialCineRunState", Tag(0x0018, 0x0042));
    public_tags.emplace("SliceThickness", Tag(0x0018, 0x0050));
    public_tags.emplace("KVP", Tag(0x0018, 0x0060));
    public_tags.emplace("CountsAccumulated", Tag(0x0018, 0x0070));
    public_tags.emplace("AcquisitionTerminationCondition", Tag(0x0018, 0x0071));
    public_tags.emplace("EffectiveDuration", Tag(0x0018, 0x0072));
    public_tags.emplace("AcquisitionStartCondition", Tag(0x0018, 0x0073));
    public_tags.emplace("AcquisitionStartConditionData", Tag(0x0018, 0x0074));
    public_tags.emplace("AcquisitionTerminationConditionData", Tag(0x0018, 0x0075));
    public_tags.emplace("RepetitionTime", Tag(0x0018, 0x0080));
    public_tags.emplace("EchoTime", Tag(0x0018, 0x0081));
    public_tags.emplace("InversionTime", Tag(0x0018, 0x0082));
    public_tags.emplace("NumberOfAverages", Tag(0x0018, 0x0083));
    public_tags.emplace("ImagingFrequency", Tag(0x0018, 0x0084));
    public_tags.emplace("ImagedNucleus", Tag(0x0018, 0x0085));
    public_tags.emplace("EchoNumbers", Tag(0x0018, 0x0086));
    public_tags.emplace("MagneticFieldStrength", Tag(0x0018, 0x0087));
    public_tags.emplace("SpacingBetweenSlices", Tag(0x0018, 0x0088));
    public_tags.emplace("NumberOfPhaseEncodingSteps", Tag(0x0018, 0x0089));
    public_tags.emplace("DataCollectionDiameter", Tag(0x0018, 0x0090));
    public_tags.emplace("EchoTrainLength", Tag(0x0018, 0x0091));
    public_tags.emplace("PercentSampling", Tag(0x0018, 0x0093));
    public_tags.emplace("PercentPhaseFieldOfView", Tag(0x0018, 0x0094));
    public_tags.emplace("PixelBandwidth", Tag(0x0018, 0x0095));
    public_tags.emplace("DeviceSerialNumber", Tag(0x0018, 0x1000));
    public_tags.emplace("DeviceUID", Tag(0x0018, 0x1002));
    public_tags.emplace("DeviceID", Tag(0x0018, 0x1003));
    public_tags.emplace("PlateID", Tag(0x0018, 0x1004));
    public_tags.emplace("GeneratorID", Tag(0x0018, 0x1005));
    public_tags.emplace("GridID", Tag(0x0018, 0x1006));
    public_tags.emplace("CassetteID", Tag(0x0018, 0x1007));
    public_tags.emplace("GantryID", Tag(0x0018, 0x1008));
    public_tags.emplace("UniqueDeviceIdentifier", Tag(0x0018, 0x1009));
    public_tags.emplace("UDISequence", Tag(0x0018, 0x100a));
    public_tags.emplace("ManufacturerDeviceClassUID", Tag(0x0018, 0x100b));
    public_tags.emplace("SecondaryCaptureDeviceID", Tag(0x0018, 0x1010));
    public_tags.emplace("HardcopyCreationDeviceID", Tag(0x0018, 0x1011));
    public_tags.emplace("DateOfSecondaryCapture", Tag(0x0018, 0x1012));
    public_tags.emplace("TimeOfSecondaryCapture", Tag(0x0018, 0x1014));
    public_tags.emplace("SecondaryCaptureDeviceManufacturer", Tag(0x0018, 0x1016));
    public_tags.emplace("HardcopyDeviceManufacturer", Tag(0x0018, 0x1017));
    public_tags.emplace("SecondaryCaptureDeviceManufacturerModelName", Tag(0x0018, 0x1018));
    public_tags.emplace("SecondaryCaptureDeviceSoftwareVersions", Tag(0x0018, 0x1019));
    public_tags.emplace("HardcopyDeviceSoftwareVersion", Tag(0x0018, 0x101a));
    public_tags.emplace("HardcopyDeviceManufacturerModelName", Tag(0x0018, 0x101b));
    public_tags.emplace("SoftwareVersions", Tag(0x0018, 0x1020));
    public_tags.emplace("VideoImageFormatAcquired", Tag(0x0018, 0x1022));
    public_tags.emplace("DigitalImageFormatAcquired", Tag(0x0018, 0x1023));
    public_tags.emplace("ProtocolName", Tag(0x0018, 0x1030));
    public_tags.emplace("ContrastBolusRoute", Tag(0x0018, 0x1040));
    public_tags.emplace("ContrastBolusVolume", Tag(0x0018, 0x1041));
    public_tags.emplace("ContrastBolusStartTime", Tag(0x0018, 0x1042));
    public_tags.emplace("ContrastBolusStopTime", Tag(0x0018, 0x1043));
    public_tags.emplace("ContrastBolusTotalDose", Tag(0x0018, 0x1044));
    public_tags.emplace("SyringeCounts", Tag(0x0018, 0x1045));
    public_tags.emplace("ContrastFlowRate", Tag(0x0018, 0x1046));
    public_tags.emplace("ContrastFlowDuration", Tag(0x0018, 0x1047));
    public_tags.emplace("ContrastBolusIngredient", Tag(0x0018, 0x1048));
    public_tags.emplace("ContrastBolusIngredientConcentration", Tag(0x0018, 0x1049));
    public_tags.emplace("SpatialResolution", Tag(0x0018, 0x1050));
    public_tags.emplace("TriggerTime", Tag(0x0018, 0x1060));
    public_tags.emplace("TriggerSourceOrType", Tag(0x0018, 0x1061));
    public_tags.emplace("NominalInterval", Tag(0x0018, 0x1062));
    public_tags.emplace("FrameTime", Tag(0x0018, 0x1063));
    public_tags.emplace("CardiacFramingType", Tag(0x0018, 0x1064));
    public_tags.emplace("FrameTimeVector", Tag(0x0018, 0x1065));
    public_tags.emplace("FrameDelay", Tag(0x0018, 0x1066));
    public_tags.emplace("ImageTriggerDelay", Tag(0x0018, 0x1067));
    public_tags.emplace("MultiplexGroupTimeOffset", Tag(0x0018, 0x1068));
    public_tags.emplace("TriggerTimeOffset", Tag(0x0018, 0x1069));
    public_tags.emplace("SynchronizationTrigger", Tag(0x0018, 0x106a));
    public_tags.emplace("SynchronizationChannel", Tag(0x0018, 0x106c));
    public_tags.emplace("TriggerSamplePosition", Tag(0x0018, 0x106e));
    public_tags.emplace("RadiopharmaceuticalRoute", Tag(0x0018, 0x1070));
    public_tags.emplace("RadiopharmaceuticalVolume", Tag(0x0018, 0x1071));
    public_tags.emplace("RadiopharmaceuticalStartTime", Tag(0x0018, 0x1072));
    public_tags.emplace("RadiopharmaceuticalStopTime", Tag(0x0018, 0x1073));
    public_tags.emplace("RadionuclideTotalDose", Tag(0x0018, 0x1074));
    public_tags.emplace("RadionuclideHalfLife", Tag(0x0018, 0x1075));
    public_tags.emplace("RadionuclidePositronFraction", Tag(0x0018, 0x1076));
    public_tags.emplace("RadiopharmaceuticalSpecificActivity", Tag(0x0018, 0x1077));
    public_tags.emplace("RadiopharmaceuticalStartDateTime", Tag(0x0018, 0x1078));
    public_tags.emplace("RadiopharmaceuticalStopDateTime", Tag(0x0018, 0x1079));
    public_tags.emplace("BeatRejectionFlag", Tag(0x0018, 0x1080));
    public_tags.emplace("LowRRValue", Tag(0x0018, 0x1081));
    public_tags.emplace("HighRRValue", Tag(0x0018, 0x1082));
    public_tags.emplace("IntervalsAcquired", Tag(0x0018, 0x1083));
    public_tags.emplace("IntervalsRejected", Tag(0x0018, 0x1084));
    public_tags.emplace("PVCRejection", Tag(0x0018, 0x1085));
    public_tags.emplace("SkipBeats", Tag(0x0018, 0x1086));
    public_tags.emplace("HeartRate", Tag(0x0018, 0x1088));
    public_tags.emplace("CardiacNumberOfImages", Tag(0x0018, 0x1090));
    public_tags.emplace("TriggerWindow", Tag(0x0018, 0x1094));
    public_tags.emplace("ReconstructionDiameter", Tag(0x0018, 0x1100));
    public_tags.emplace("DistanceSourceToDetector", Tag(0x0018, 0x1110));
    public_tags.emplace("DistanceSourceToPatient", Tag(0x0018, 0x1111));
    public_tags.emplace("EstimatedRadiographicMagnificationFactor", Tag(0x0018, 0x1114));
    public_tags.emplace("GantryDetectorTilt", Tag(0x0018, 0x1120));
    public_tags.emplace("GantryDetectorSlew", Tag(0x0018, 0x1121));
    public_tags.emplace("TableHeight", Tag(0x0018, 0x1130));
    public_tags.emplace("TableTraverse", Tag(0x0018, 0x1131));
    public_tags.emplace("TableMotion", Tag(0x0018, 0x1134));
    public_tags.emplace("TableVerticalIncrement", Tag(0x0018, 0x1135));
    public_tags.emplace("TableLateralIncrement", Tag(0x0018, 0x1136));
    public_tags.emplace("TableLongitudinalIncrement", Tag(0x0018, 0x1137));
    public_tags.emplace("TableAngle", Tag(0x0018, 0x1138));
    public_tags.emplace("TableType", Tag(0x0018, 0x113a));
    public_tags.emplace("RotationDirection", Tag(0x0018, 0x1140));
    public_tags.emplace("AngularPosition", Tag(0x0018, 0x1141));
    public_tags.emplace("RadialPosition", Tag(0x0018, 0x1142));
    public_tags.emplace("ScanArc", Tag(0x0018, 0x1143));
    public_tags.emplace("AngularStep", Tag(0x0018, 0x1144));
    public_tags.emplace("CenterOfRotationOffset", Tag(0x0018, 0x1145));
    public_tags.emplace("RotationOffset", Tag(0x0018, 0x1146));
    public_tags.emplace("FieldOfViewShape", Tag(0x0018, 0x1147));
    public_tags.emplace("FieldOfViewDimensions", Tag(0x0018, 0x1149));
    public_tags.emplace("ExposureTime", Tag(0x0018, 0x1150));
    public_tags.emplace("XRayTubeCurrent", Tag(0x0018, 0x1151));
    public_tags.emplace("Exposure", Tag(0x0018, 0x1152));
    public_tags.emplace("ExposureInuAs", Tag(0x0018, 0x1153));
    public_tags.emplace("AveragePulseWidth", Tag(0x0018, 0x1154));
    public_tags.emplace("RadiationSetting", Tag(0x0018, 0x1155));
    public_tags.emplace("RectificationType", Tag(0x0018, 0x1156));
    public_tags.emplace("RadiationMode", Tag(0x0018, 0x115a));
    public_tags.emplace("ImageAndFluoroscopyAreaDoseProduct", Tag(0x0018, 0x115e));
    public_tags.emplace("FilterType", Tag(0x0018, 0x1160));
    public_tags.emplace("TypeOfFilters", Tag(0x0018, 0x1161));
    public_tags.emplace("IntensifierSize", Tag(0x0018, 0x1162));
    public_tags.emplace("ImagerPixelSpacing", Tag(0x0018, 0x1164));
    public_tags.emplace("Grid", Tag(0x0018, 0x1166));
    public_tags.emplace("GeneratorPower", Tag(0x0018, 0x1170));
    public_tags.emplace("CollimatorGridName", Tag(0x0018, 0x1180));
    public_tags.emplace("CollimatorType", Tag(0x0018, 0x1181));
    public_tags.emplace("FocalDistance", Tag(0x0018, 0x1182));
    public_tags.emplace("XFocusCenter", Tag(0x0018, 0x1183));
    public_tags.emplace("YFocusCenter", Tag(0x0018, 0x1184));
    public_tags.emplace("FocalSpots", Tag(0x0018, 0x1190));
    public_tags.emplace("AnodeTargetMaterial", Tag(0x0018, 0x1191));
    public_tags.emplace("BodyPartThickness", Tag(0x0018, 0x11a0));
    public_tags.emplace("CompressionForce", Tag(0x0018, 0x11a2));
    public_tags.emplace("CompressionPressure", Tag(0x0018, 0x11a3));
    public_tags.emplace("PaddleDescription", Tag(0x0018, 0x11a4));
    public_tags.emplace("CompressionContactArea", Tag(0x0018, 0x11a5));
    public_tags.emplace("AcquisitionMode", Tag(0x0018, 0x11b0));
    public_tags.emplace("DoseModeName", Tag(0x0018, 0x11b1));
    public_tags.emplace("AcquiredSubtractionMaskFlag", Tag(0x0018, 0x11b2));
    public_tags.emplace("FluoroscopyPersistenceFlag", Tag(0x0018, 0x11b3));
    public_tags.emplace("FluoroscopyLastImageHoldPersistenceFlag", Tag(0x0018, 0x11b4));
    public_tags.emplace("UpperLimitNumberOfPersistentFluoroscopyFrames", Tag(0x0018, 0x11b5));
    public_tags.emplace("ContrastBolusAutoInjectionTriggerFlag", Tag(0x0018, 0x11b6));
    public_tags.emplace("ContrastBolusInjectionDelay", Tag(0x0018, 0x11b7));
    public_tags.emplace("XAAcquisitionPhaseDetailsSequence", Tag(0x0018, 0x11b8));
    public_tags.emplace("XAAcquisitionFrameRate", Tag(0x0018, 0x11b9));
    public_tags.emplace("XAPlaneDetailsSequence", Tag(0x0018, 0x11ba));
    public_tags.emplace("AcquisitionFieldOfViewLabel", Tag(0x0018, 0x11bb));
    public_tags.emplace("XRayFilterDetailsSequence", Tag(0x0018, 0x11bc));
    public_tags.emplace("XAAcquisitionDuration", Tag(0x0018, 0x11bd));
    public_tags.emplace("ReconstructionPipelineType", Tag(0x0018, 0x11be));
    public_tags.emplace("ImageFilterDetailsSequence", Tag(0x0018, 0x11bf));
    public_tags.emplace("AppliedMaskSubtractionFlag", Tag(0x0018, 0x11c0));
    public_tags.emplace("RequestedSeriesDescriptionCodeSequence", Tag(0x0018, 0x11c1));
    public_tags.emplace("DateOfLastCalibration", Tag(0x0018, 0x1200));
    public_tags.emplace("TimeOfLastCalibration", Tag(0x0018, 0x1201));
    public_tags.emplace("DateTimeOfLastCalibration", Tag(0x0018, 0x1202));
    public_tags.emplace("CalibrationDateTime", Tag(0x0018, 0x1203));
    public_tags.emplace("DateOfManufacture", Tag(0x0018, 0x1204));
    public_tags.emplace("DateOfInstallation", Tag(0x0018, 0x1205));
    public_tags.emplace("ConvolutionKernel", Tag(0x0018, 0x1210));
    public_tags.emplace("UpperLowerPixelValues", Tag(0x0018, 0x1240));
    public_tags.emplace("ActualFrameDuration", Tag(0x0018, 0x1242));
    public_tags.emplace("CountRate", Tag(0x0018, 0x1243));
    public_tags.emplace("PreferredPlaybackSequencing", Tag(0x0018, 0x1244));
    public_tags.emplace("ReceiveCoilName", Tag(0x0018, 0x1250));
    public_tags.emplace("TransmitCoilName", Tag(0x0018, 0x1251));
    public_tags.emplace("PlateType", Tag(0x0018, 0x1260));
    public_tags.emplace("PhosphorType", Tag(0x0018, 0x1261));
    public_tags.emplace("WaterEquivalentDiameter", Tag(0x0018, 0x1271));
    public_tags.emplace("WaterEquivalentDiameterCalculationMethodCodeSequence", Tag(0x0018, 0x1272));
    public_tags.emplace("ScanVelocity", Tag(0x0018, 0x1300));
    public_tags.emplace("WholeBodyTechnique", Tag(0x0018, 0x1301));
    public_tags.emplace("ScanLength", Tag(0x0018, 0x1302));
    public_tags.emplace("AcquisitionMatrix", Tag(0x0018, 0x1310));
    public_tags.emplace("InPlanePhaseEncodingDirection", Tag(0x0018, 0x1312));
    public_tags.emplace("FlipAngle", Tag(0x0018, 0x1314));
    public_tags.emplace("VariableFlipAngleFlag", Tag(0x0018, 0x1315));
    public_tags.emplace("SAR", Tag(0x0018, 0x1316));
    public_tags.emplace("dBdt", Tag(0x0018, 0x1318));
    public_tags.emplace("B1rms", Tag(0x0018, 0x1320));
    public_tags.emplace("AcquisitionDeviceProcessingDescription", Tag(0x0018, 0x1400));
    public_tags.emplace("AcquisitionDeviceProcessingCode", Tag(0x0018, 0x1401));
    public_tags.emplace("CassetteOrientation", Tag(0x0018, 0x1402));
    public_tags.emplace("CassetteSize", Tag(0x0018, 0x1403));
    public_tags.emplace("ExposuresOnPlate", Tag(0x0018, 0x1404));
    public_tags.emplace("RelativeXRayExposure", Tag(0x0018, 0x1405));
    public_tags.emplace("ExposureIndex", Tag(0x0018, 0x1411));
    public_tags.emplace("TargetExposureIndex", Tag(0x0018, 0x1412));
    public_tags.emplace("DeviationIndex", Tag(0x0018, 0x1413));
    public_tags.emplace("ColumnAngulation", Tag(0x0018, 0x1450));
    public_tags.emplace("TomoLayerHeight", Tag(0x0018, 0x1460));
    public_tags.emplace("TomoAngle", Tag(0x0018, 0x1470));
    public_tags.emplace("TomoTime", Tag(0x0018, 0x1480));
    public_tags.emplace("TomoType", Tag(0x0018, 0x1490));
    public_tags.emplace("TomoClass", Tag(0x0018, 0x1491));
    public_tags.emplace("NumberOfTomosynthesisSourceImages", Tag(0x0018, 0x1495));
    public_tags.emplace("PositionerMotion", Tag(0x0018, 0x1500));
    public_tags.emplace("PositionerType", Tag(0x0018, 0x1508));
    public_tags.emplace("PositionerPrimaryAngle", Tag(0x0018, 0x1510));
    public_tags.emplace("PositionerSecondaryAngle", Tag(0x0018, 0x1511));
    public_tags.emplace("PositionerPrimaryAngleIncrement", Tag(0x0018, 0x1520));
    public_tags.emplace("PositionerSecondaryAngleIncrement", Tag(0x0018, 0x1521));
    public_tags.emplace("DetectorPrimaryAngle", Tag(0x0018, 0x1530));
    public_tags.emplace("DetectorSecondaryAngle", Tag(0x0018, 0x1531));
    public_tags.emplace("ShutterShape", Tag(0x0018, 0x1600));
    public_tags.emplace("ShutterLeftVerticalEdge", Tag(0x0018, 0x1602));
    public_tags.emplace("ShutterRightVerticalEdge", Tag(0x0018, 0x1604));
    public_tags.emplace("ShutterUpperHorizontalEdge", Tag(0x0018, 0x1606));
    public_tags.emplace("ShutterLowerHorizontalEdge", Tag(0x0018, 0x1608));
    public_tags.emplace("CenterOfCircularShutter", Tag(0x0018, 0x1610));
    public_tags.emplace("RadiusOfCircularShutter", Tag(0x0018, 0x1612));
    public_tags.emplace("VerticesOfThePolygonalShutter", Tag(0x0018, 0x1620));
    public_tags.emplace("ShutterPresentationValue", Tag(0x0018, 0x1622));
    public_tags.emplace("ShutterOverlayGroup", Tag(0x0018, 0x1623));
    public_tags.emplace("ShutterPresentationColorCIELabValue", Tag(0x0018, 0x1624));
    public_tags.emplace("OutlineShapeType", Tag(0x0018, 0x1630));
    public_tags.emplace("OutlineLeftVerticalEdge", Tag(0x0018, 0x1631));
    public_tags.emplace("OutlineRightVerticalEdge", Tag(0x0018, 0x1632));
    public_tags.emplace("OutlineUpperHorizontalEdge", Tag(0x0018, 0x1633));
    public_tags.emplace("OutlineLowerHorizontalEdge", Tag(0x0018, 0x1634));
    public_tags.emplace("CenterOfCircularOutline", Tag(0x0018, 0x1635));
    public_tags.emplace("DiameterOfCircularOutline", Tag(0x0018, 0x1636));
    public_tags.emplace("NumberOfPolygonalVertices", Tag(0x0018, 0x1637));
    public_tags.emplace("VerticesOfThePolygonalOutline", Tag(0x0018, 0x1638));
    public_tags.emplace("CollimatorShape", Tag(0x0018, 0x1700));
    public_tags.emplace("CollimatorLeftVerticalEdge", Tag(0x0018, 0x1702));
    public_tags.emplace("CollimatorRightVerticalEdge", Tag(0x0018, 0x1704));
    public_tags.emplace("CollimatorUpperHorizontalEdge", Tag(0x0018, 0x1706));
    public_tags.emplace("CollimatorLowerHorizontalEdge", Tag(0x0018, 0x1708));
    public_tags.emplace("CenterOfCircularCollimator", Tag(0x0018, 0x1710));
    public_tags.emplace("RadiusOfCircularCollimator", Tag(0x0018, 0x1712));
    public_tags.emplace("VerticesOfThePolygonalCollimator", Tag(0x0018, 0x1720));
    public_tags.emplace("AcquisitionTimeSynchronized", Tag(0x0018, 0x1800));
    public_tags.emplace("TimeSource", Tag(0x0018, 0x1801));
    public_tags.emplace("TimeDistributionProtocol", Tag(0x0018, 0x1802));
    public_tags.emplace("NTPSourceAddress", Tag(0x0018, 0x1803));
    public_tags.emplace("PageNumberVector", Tag(0x0018, 0x2001));
    public_tags.emplace("FrameLabelVector", Tag(0x0018, 0x2002));
    public_tags.emplace("FramePrimaryAngleVector", Tag(0x0018, 0x2003));
    public_tags.emplace("FrameSecondaryAngleVector", Tag(0x0018, 0x2004));
    public_tags.emplace("SliceLocationVector", Tag(0x0018, 0x2005));
    public_tags.emplace("DisplayWindowLabelVector", Tag(0x0018, 0x2006));
    public_tags.emplace("NominalScannedPixelSpacing", Tag(0x0018, 0x2010));
    public_tags.emplace("DigitizingDeviceTransportDirection", Tag(0x0018, 0x2020));
    public_tags.emplace("RotationOfScannedFilm", Tag(0x0018, 0x2030));
    public_tags.emplace("BiopsyTargetSequence", Tag(0x0018, 0x2041));
    public_tags.emplace("TargetUID", Tag(0x0018, 0x2042));
    public_tags.emplace("LocalizingCursorPosition", Tag(0x0018, 0x2043));
    public_tags.emplace("CalculatedTargetPosition", Tag(0x0018, 0x2044));
    public_tags.emplace("TargetLabel", Tag(0x0018, 0x2045));
    public_tags.emplace("DisplayedZValue", Tag(0x0018, 0x2046));
    public_tags.emplace("IVUSAcquisition", Tag(0x0018, 0x3100));
    public_tags.emplace("IVUSPullbackRate", Tag(0x0018, 0x3101));
    public_tags.emplace("IVUSGatedRate", Tag(0x0018, 0x3102));
    public_tags.emplace("IVUSPullbackStartFrameNumber", Tag(0x0018, 0x3103));
    public_tags.emplace("IVUSPullbackStopFrameNumber", Tag(0x0018, 0x3104));
    public_tags.emplace("LesionNumber", Tag(0x0018, 0x3105));
    public_tags.emplace("AcquisitionComments", Tag(0x0018, 0x4000));
    public_tags.emplace("OutputPower", Tag(0x0018, 0x5000));
    public_tags.emplace("TransducerData", Tag(0x0018, 0x5010));
    public_tags.emplace("TransducerIdentificationSequence", Tag(0x0018, 0x5011));
    public_tags.emplace("FocusDepth", Tag(0x0018, 0x5012));
    public_tags.emplace("ProcessingFunction", Tag(0x0018, 0x5020));
    public_tags.emplace("PostprocessingFunction", Tag(0x0018, 0x5021));
    public_tags.emplace("MechanicalIndex", Tag(0x0018, 0x5022));
    public_tags.emplace("BoneThermalIndex", Tag(0x0018, 0x5024));
    public_tags.emplace("CranialThermalIndex", Tag(0x0018, 0x5026));
    public_tags.emplace("SoftTissueThermalIndex", Tag(0x0018, 0x5027));
    public_tags.emplace("SoftTissueFocusThermalIndex", Tag(0x0018, 0x5028));
    public_tags.emplace("SoftTissueSurfaceThermalIndex", Tag(0x0018, 0x5029));
    public_tags.emplace("DynamicRange", Tag(0x0018, 0x5030));
    public_tags.emplace("TotalGain", Tag(0x0018, 0x5040));
    public_tags.emplace("DepthOfScanField", Tag(0x0018, 0x5050));
    public_tags.emplace("PatientPosition", Tag(0x0018, 0x5100));
    public_tags.emplace("ViewPosition", Tag(0x0018, 0x5101));
    public_tags.emplace("ProjectionEponymousNameCodeSequence", Tag(0x0018, 0x5104));
    public_tags.emplace("ImageTransformationMatrix", Tag(0x0018, 0x5210));
    public_tags.emplace("ImageTranslationVector", Tag(0x0018, 0x5212));
    public_tags.emplace("Sensitivity", Tag(0x0018, 0x6000));
    public_tags.emplace("SequenceOfUltrasoundRegions", Tag(0x0018, 0x6011));
    public_tags.emplace("RegionSpatialFormat", Tag(0x0018, 0x6012));
    public_tags.emplace("RegionDataType", Tag(0x0018, 0x6014));
    public_tags.emplace("RegionFlags", Tag(0x0018, 0x6016));
    public_tags.emplace("RegionLocationMinX0", Tag(0x0018, 0x6018));
    public_tags.emplace("RegionLocationMinY0", Tag(0x0018, 0x601a));
    public_tags.emplace("RegionLocationMaxX1", Tag(0x0018, 0x601c));
    public_tags.emplace("RegionLocationMaxY1", Tag(0x0018, 0x601e));
    public_tags.emplace("ReferencePixelX0", Tag(0x0018, 0x6020));
    public_tags.emplace("ReferencePixelY0", Tag(0x0018, 0x6022));
    public_tags.emplace("PhysicalUnitsXDirection", Tag(0x0018, 0x6024));
    public_tags.emplace("PhysicalUnitsYDirection", Tag(0x0018, 0x6026));
    public_tags.emplace("ReferencePixelPhysicalValueX", Tag(0x0018, 0x6028));
    public_tags.emplace("ReferencePixelPhysicalValueY", Tag(0x0018, 0x602a));
    public_tags.emplace("PhysicalDeltaX", Tag(0x0018, 0x602c));
    public_tags.emplace("PhysicalDeltaY", Tag(0x0018, 0x602e));
    public_tags.emplace("TransducerFrequency", Tag(0x0018, 0x6030));
    public_tags.emplace("TransducerType", Tag(0x0018, 0x6031));
    public_tags.emplace("PulseRepetitionFrequency", Tag(0x0018, 0x6032));
    public_tags.emplace("DopplerCorrectionAngle", Tag(0x0018, 0x6034));
    public_tags.emplace("SteeringAngle", Tag(0x0018, 0x6036));
    public_tags.emplace("DopplerSampleVolumeXPositionRetired", Tag(0x0018, 0x6038));
    public_tags.emplace("DopplerSampleVolumeXPosition", Tag(0x0018, 0x6039));
    public_tags.emplace("DopplerSampleVolumeYPositionRetired", Tag(0x0018, 0x603a));
    public_tags.emplace("DopplerSampleVolumeYPosition", Tag(0x0018, 0x603b));
    public_tags.emplace("TMLinePositionX0Retired", Tag(0x0018, 0x603c));
    public_tags.emplace("TMLinePositionX0", Tag(0x0018, 0x603d));
    public_tags.emplace("TMLinePositionY0Retired", Tag(0x0018, 0x603e));
    public_tags.emplace("TMLinePositionY0", Tag(0x0018, 0x603f));
    public_tags.emplace("TMLinePositionX1Retired", Tag(0x0018, 0x6040));
    public_tags.emplace("TMLinePositionX1", Tag(0x0018, 0x6041));
    public_tags.emplace("TMLinePositionY1Retired", Tag(0x0018, 0x6042));
    public_tags.emplace("TMLinePositionY1", Tag(0x0018, 0x6043));
    public_tags.emplace("PixelComponentOrganization", Tag(0x0018, 0x6044));
    public_tags.emplace("PixelComponentMask", Tag(0x0018, 0x6046));
    public_tags.emplace("PixelComponentRangeStart", Tag(0x0018, 0x6048));
    public_tags.emplace("PixelComponentRangeStop", Tag(0x0018, 0x604a));
    public_tags.emplace("PixelComponentPhysicalUnits", Tag(0x0018, 0x604c));
    public_tags.emplace("PixelComponentDataType", Tag(0x0018, 0x604e));
    public_tags.emplace("NumberOfTableBreakPoints", Tag(0x0018, 0x6050));
    public_tags.emplace("TableOfXBreakPoints", Tag(0x0018, 0x6052));
    public_tags.emplace("TableOfYBreakPoints", Tag(0x0018, 0x6054));
    public_tags.emplace("NumberOfTableEntries", Tag(0x0018, 0x6056));
    public_tags.emplace("TableOfPixelValues", Tag(0x0018, 0x6058));
    public_tags.emplace("TableOfParameterValues", Tag(0x0018, 0x605a));
    public_tags.emplace("RWaveTimeVector", Tag(0x0018, 0x6060));
    public_tags.emplace("ActiveImageAreaOverlayGroup", Tag(0x0018, 0x6070));
    public_tags.emplace("DetectorConditionsNominalFlag", Tag(0x0018, 0x7000));
    public_tags.emplace("DetectorTemperature", Tag(0x0018, 0x7001));
    public_tags.emplace("DetectorType", Tag(0x0018, 0x7004));
    public_tags.emplace("DetectorConfiguration", Tag(0x0018, 0x7005));
    public_tags.emplace("DetectorDescription", Tag(0x0018, 0x7006));
    public_tags.emplace("DetectorMode", Tag(0x0018, 0x7008));
    public_tags.emplace("DetectorID", Tag(0x0018, 0x700a));
    public_tags.emplace("DateOfLastDetectorCalibration", Tag(0x0018, 0x700c));
    public_tags.emplace("TimeOfLastDetectorCalibration", Tag(0x0018, 0x700e));
    public_tags.emplace("ExposuresOnDetectorSinceLastCalibration", Tag(0x0018, 0x7010));
    public_tags.emplace("ExposuresOnDetectorSinceManufactured", Tag(0x0018, 0x7011));
    public_tags.emplace("DetectorTimeSinceLastExposure", Tag(0x0018, 0x7012));
    public_tags.emplace("DetectorActiveTime", Tag(0x0018, 0x7014));
    public_tags.emplace("DetectorActivationOffsetFromExposure", Tag(0x0018, 0x7016));
    public_tags.emplace("DetectorBinning", Tag(0x0018, 0x701a));
    public_tags.emplace("DetectorElementPhysicalSize", Tag(0x0018, 0x7020));
    public_tags.emplace("DetectorElementSpacing", Tag(0x0018, 0x7022));
    public_tags.emplace("DetectorActiveShape", Tag(0x0018, 0x7024));
    public_tags.emplace("DetectorActiveDimensions", Tag(0x0018, 0x7026));
    public_tags.emplace("DetectorActiveOrigin", Tag(0x0018, 0x7028));
    public_tags.emplace("DetectorManufacturerName", Tag(0x0018, 0x702a));
    public_tags.emplace("DetectorManufacturerModelName", Tag(0x0018, 0x702b));
    public_tags.emplace("FieldOfViewOrigin", Tag(0x0018, 0x7030));
    public_tags.emplace("FieldOfViewRotation", Tag(0x0018, 0x7032));
    public_tags.emplace("FieldOfViewHorizontalFlip", Tag(0x0018, 0x7034));
    public_tags.emplace("PixelDataAreaOriginRelativeToFOV", Tag(0x0018, 0x7036));
    public_tags.emplace("PixelDataAreaRotationAngleRelativeToFOV", Tag(0x0018, 0x7038));
    public_tags.emplace("GridAbsorbingMaterial", Tag(0x0018, 0x7040));
    public_tags.emplace("GridSpacingMaterial", Tag(0x0018, 0x7041));
    public_tags.emplace("GridThickness", Tag(0x0018, 0x7042));
    public_tags.emplace("GridPitch", Tag(0x0018, 0x7044));
    public_tags.emplace("GridAspectRatio", Tag(0x0018, 0x7046));
    public_tags.emplace("GridPeriod", Tag(0x0018, 0x7048));
    public_tags.emplace("GridFocalDistance", Tag(0x0018, 0x704c));
    public_tags.emplace("FilterMaterial", Tag(0x0018, 0x7050));
    public_tags.emplace("FilterThicknessMinimum", Tag(0x0018, 0x7052));
    public_tags.emplace("FilterThicknessMaximum", Tag(0x0018, 0x7054));
    public_tags.emplace("FilterBeamPathLengthMinimum", Tag(0x0018, 0x7056));
    public_tags.emplace("FilterBeamPathLengthMaximum", Tag(0x0018, 0x7058));
    public_tags.emplace("ExposureControlMode", Tag(0x0018, 0x7060));
    public_tags.emplace("ExposureControlModeDescription", Tag(0x0018, 0x7062));
    public_tags.emplace("ExposureStatus", Tag(0x0018, 0x7064));
    public_tags.emplace("PhototimerSetting", Tag(0x0018, 0x7065));
    public_tags.emplace("ExposureTimeInuS", Tag(0x0018, 0x8150));
    public_tags.emplace("XRayTubeCurrentInuA", Tag(0x0018, 0x8151));
    public_tags.emplace("ContentQualification", Tag(0x0018, 0x9004));
    public_tags.emplace("PulseSequenceName", Tag(0x0018, 0x9005));
    public_tags.emplace("MRImagingModifierSequence", Tag(0x0018, 0x9006));
    public_tags.emplace("EchoPulseSequence", Tag(0x0018, 0x9008));
    public_tags.emplace("InversionRecovery", Tag(0x0018, 0x9009));
    public_tags.emplace("FlowCompensation", Tag(0x0018, 0x9010));
    public_tags.emplace("MultipleSpinEcho", Tag(0x0018, 0x9011));
    public_tags.emplace("MultiPlanarExcitation", Tag(0x0018, 0x9012));
    public_tags.emplace("PhaseContrast", Tag(0x0018, 0x9014));
    public_tags.emplace("TimeOfFlightContrast", Tag(0x0018, 0x9015));
    public_tags.emplace("Spoiling", Tag(0x0018, 0x9016));
    public_tags.emplace("SteadyStatePulseSequence", Tag(0x0018, 0x9017));
    public_tags.emplace("EchoPlanarPulseSequence", Tag(0x0018, 0x9018));
    public_tags.emplace("TagAngleFirstAxis", Tag(0x0018, 0x9019));
    public_tags.emplace("MagnetizationTransfer", Tag(0x0018, 0x9020));
    public_tags.emplace("T2Preparation", Tag(0x0018, 0x9021));
    public_tags.emplace("BloodSignalNulling", Tag(0x0018, 0x9022));
    public_tags.emplace("SaturationRecovery", Tag(0x0018, 0x9024));
    public_tags.emplace("SpectrallySelectedSuppression", Tag(0x0018, 0x9025));
    public_tags.emplace("SpectrallySelectedExcitation", Tag(0x0018, 0x9026));
    public_tags.emplace("SpatialPresaturation", Tag(0x0018, 0x9027));
    public_tags.emplace("Tagging", Tag(0x0018, 0x9028));
    public_tags.emplace("OversamplingPhase", Tag(0x0018, 0x9029));
    public_tags.emplace("TagSpacingFirstDimension", Tag(0x0018, 0x9030));
    public_tags.emplace("GeometryOfKSpaceTraversal", Tag(0x0018, 0x9032));
    public_tags.emplace("SegmentedKSpaceTraversal", Tag(0x0018, 0x9033));
    public_tags.emplace("RectilinearPhaseEncodeReordering", Tag(0x0018, 0x9034));
    public_tags.emplace("TagThickness", Tag(0x0018, 0x9035));
    public_tags.emplace("PartialFourierDirection", Tag(0x0018, 0x9036));
    public_tags.emplace("CardiacSynchronizationTechnique", Tag(0x0018, 0x9037));
    public_tags.emplace("ReceiveCoilManufacturerName", Tag(0x0018, 0x9041));
    public_tags.emplace("MRReceiveCoilSequence", Tag(0x0018, 0x9042));
    public_tags.emplace("ReceiveCoilType", Tag(0x0018, 0x9043));
    public_tags.emplace("QuadratureReceiveCoil", Tag(0x0018, 0x9044));
    public_tags.emplace("MultiCoilDefinitionSequence", Tag(0x0018, 0x9045));
    public_tags.emplace("MultiCoilConfiguration", Tag(0x0018, 0x9046));
    public_tags.emplace("MultiCoilElementName", Tag(0x0018, 0x9047));
    public_tags.emplace("MultiCoilElementUsed", Tag(0x0018, 0x9048));
    public_tags.emplace("MRTransmitCoilSequence", Tag(0x0018, 0x9049));
    public_tags.emplace("TransmitCoilManufacturerName", Tag(0x0018, 0x9050));
    public_tags.emplace("TransmitCoilType", Tag(0x0018, 0x9051));
    public_tags.emplace("SpectralWidth", Tag(0x0018, 0x9052));
    public_tags.emplace("ChemicalShiftReference", Tag(0x0018, 0x9053));
    public_tags.emplace("VolumeLocalizationTechnique", Tag(0x0018, 0x9054));
    public_tags.emplace("MRAcquisitionFrequencyEncodingSteps", Tag(0x0018, 0x9058));
    public_tags.emplace("Decoupling", Tag(0x0018, 0x9059));
    public_tags.emplace("DecoupledNucleus", Tag(0x0018, 0x9060));
    public_tags.emplace("DecouplingFrequency", Tag(0x0018, 0x9061));
    public_tags.emplace("DecouplingMethod", Tag(0x0018, 0x9062));
    public_tags.emplace("DecouplingChemicalShiftReference", Tag(0x0018, 0x9063));
    public_tags.emplace("KSpaceFiltering", Tag(0x0018, 0x9064));
    public_tags.emplace("TimeDomainFiltering", Tag(0x0018, 0x9065));
    public_tags.emplace("NumberOfZeroFills", Tag(0x0018, 0x9066));
    public_tags.emplace("BaselineCorrection", Tag(0x0018, 0x9067));
    public_tags.emplace("ParallelReductionFactorInPlane", Tag(0x0018, 0x9069));
    public_tags.emplace("CardiacRRIntervalSpecified", Tag(0x0018, 0x9070));
    public_tags.emplace("AcquisitionDuration", Tag(0x0018, 0x9073));
    public_tags.emplace("FrameAcquisitionDateTime", Tag(0x0018, 0x9074));
    public_tags.emplace("DiffusionDirectionality", Tag(0x0018, 0x9075));
    public_tags.emplace("DiffusionGradientDirectionSequence", Tag(0x0018, 0x9076));
    public_tags.emplace("ParallelAcquisition", Tag(0x0018, 0x9077));
    public_tags.emplace("ParallelAcquisitionTechnique", Tag(0x0018, 0x9078));
    public_tags.emplace("InversionTimes", Tag(0x0018, 0x9079));
    public_tags.emplace("MetaboliteMapDescription", Tag(0x0018, 0x9080));
    public_tags.emplace("PartialFourier", Tag(0x0018, 0x9081));
    public_tags.emplace("EffectiveEchoTime", Tag(0x0018, 0x9082));
    public_tags.emplace("MetaboliteMapCodeSequence", Tag(0x0018, 0x9083));
    public_tags.emplace("ChemicalShiftSequence", Tag(0x0018, 0x9084));
    public_tags.emplace("CardiacSignalSource", Tag(0x0018, 0x9085));
    public_tags.emplace("DiffusionBValue", Tag(0x0018, 0x9087));
    public_tags.emplace("DiffusionGradientOrientation", Tag(0x0018, 0x9089));
    public_tags.emplace("VelocityEncodingDirection", Tag(0x0018, 0x9090));
    public_tags.emplace("VelocityEncodingMinimumValue", Tag(0x0018, 0x9091));
    public_tags.emplace("VelocityEncodingAcquisitionSequence", Tag(0x0018, 0x9092));
    public_tags.emplace("NumberOfKSpaceTrajectories", Tag(0x0018, 0x9093));
    public_tags.emplace("CoverageOfKSpace", Tag(0x0018, 0x9094));
    public_tags.emplace("SpectroscopyAcquisitionPhaseRows", Tag(0x0018, 0x9095));
    public_tags.emplace("ParallelReductionFactorInPlaneRetired", Tag(0x0018, 0x9096));
    public_tags.emplace("TransmitterFrequency", Tag(0x0018, 0x9098));
    public_tags.emplace("ResonantNucleus", Tag(0x0018, 0x9100));
    public_tags.emplace("FrequencyCorrection", Tag(0x0018, 0x9101));
    public_tags.emplace("MRSpectroscopyFOVGeometrySequence", Tag(0x0018, 0x9103));
    public_tags.emplace("SlabThickness", Tag(0x0018, 0x9104));
    public_tags.emplace("SlabOrientation", Tag(0x0018, 0x9105));
    public_tags.emplace("MidSlabPosition", Tag(0x0018, 0x9106));
    public_tags.emplace("MRSpatialSaturationSequence", Tag(0x0018, 0x9107));
    public_tags.emplace("MRTimingAndRelatedParametersSequence", Tag(0x0018, 0x9112));
    public_tags.emplace("MREchoSequence", Tag(0x0018, 0x9114));
    public_tags.emplace("MRModifierSequence", Tag(0x0018, 0x9115));
    public_tags.emplace("MRDiffusionSequence", Tag(0x0018, 0x9117));
    public_tags.emplace("CardiacSynchronizationSequence", Tag(0x0018, 0x9118));
    public_tags.emplace("MRAveragesSequence", Tag(0x0018, 0x9119));
    public_tags.emplace("MRFOVGeometrySequence", Tag(0x0018, 0x9125));
    public_tags.emplace("VolumeLocalizationSequence", Tag(0x0018, 0x9126));
    public_tags.emplace("SpectroscopyAcquisitionDataColumns", Tag(0x0018, 0x9127));
    public_tags.emplace("DiffusionAnisotropyType", Tag(0x0018, 0x9147));
    public_tags.emplace("FrameReferenceDateTime", Tag(0x0018, 0x9151));
    public_tags.emplace("MRMetaboliteMapSequence", Tag(0x0018, 0x9152));
    public_tags.emplace("ParallelReductionFactorOutOfPlane", Tag(0x0018, 0x9155));
    public_tags.emplace("SpectroscopyAcquisitionOutOfPlanePhaseSteps", Tag(0x0018, 0x9159));
    public_tags.emplace("BulkMotionStatus", Tag(0x0018, 0x9166));
    public_tags.emplace("ParallelReductionFactorSecondInPlane", Tag(0x0018, 0x9168));
    public_tags.emplace("CardiacBeatRejectionTechnique", Tag(0x0018, 0x9169));
    public_tags.emplace("RespiratoryMotionCompensationTechnique", Tag(0x0018, 0x9170));
    public_tags.emplace("RespiratorySignalSource", Tag(0x0018, 0x9171));
    public_tags.emplace("BulkMotionCompensationTechnique", Tag(0x0018, 0x9172));
    public_tags.emplace("BulkMotionSignalSource", Tag(0x0018, 0x9173));
    public_tags.emplace("ApplicableSafetyStandardAgency", Tag(0x0018, 0x9174));
    public_tags.emplace("ApplicableSafetyStandardDescription", Tag(0x0018, 0x9175));
    public_tags.emplace("OperatingModeSequence", Tag(0x0018, 0x9176));
    public_tags.emplace("OperatingModeType", Tag(0x0018, 0x9177));
    public_tags.emplace("OperatingMode", Tag(0x0018, 0x9178));
    public_tags.emplace("SpecificAbsorptionRateDefinition", Tag(0x0018, 0x9179));
    public_tags.emplace("GradientOutputType", Tag(0x0018, 0x9180));
    public_tags.emplace("SpecificAbsorptionRateValue", Tag(0x0018, 0x9181));
    public_tags.emplace("GradientOutput", Tag(0x0018, 0x9182));
    public_tags.emplace("FlowCompensationDirection", Tag(0x0018, 0x9183));
    public_tags.emplace("TaggingDelay", Tag(0x0018, 0x9184));
    public_tags.emplace("RespiratoryMotionCompensationTechniqueDescription", Tag(0x0018, 0x9185));
    public_tags.emplace("RespiratorySignalSourceID", Tag(0x0018, 0x9186));
    public_tags.emplace("ChemicalShiftMinimumIntegrationLimitInHz", Tag(0x0018, 0x9195));
    public_tags.emplace("ChemicalShiftMaximumIntegrationLimitInHz", Tag(0x0018, 0x9196));
    public_tags.emplace("MRVelocityEncodingSequence", Tag(0x0018, 0x9197));
    public_tags.emplace("FirstOrderPhaseCorrection", Tag(0x0018, 0x9198));
    public_tags.emplace("WaterReferencedPhaseCorrection", Tag(0x0018, 0x9199));
    public_tags.emplace("MRSpectroscopyAcquisitionType", Tag(0x0018, 0x9200));
    public_tags.emplace("RespiratoryCyclePosition", Tag(0x0018, 0x9214));
    public_tags.emplace("VelocityEncodingMaximumValue", Tag(0x0018, 0x9217));
    public_tags.emplace("TagSpacingSecondDimension", Tag(0x0018, 0x9218));
    public_tags.emplace("TagAngleSecondAxis", Tag(0x0018, 0x9219));
    public_tags.emplace("FrameAcquisitionDuration", Tag(0x0018, 0x9220));
    public_tags.emplace("MRImageFrameTypeSequence", Tag(0x0018, 0x9226));
    public_tags.emplace("MRSpectroscopyFrameTypeSequence", Tag(0x0018, 0x9227));
    public_tags.emplace("MRAcquisitionPhaseEncodingStepsInPlane", Tag(0x0018, 0x9231));
    public_tags.emplace("MRAcquisitionPhaseEncodingStepsOutOfPlane", Tag(0x0018, 0x9232));
    public_tags.emplace("SpectroscopyAcquisitionPhaseColumns", Tag(0x0018, 0x9234));
    public_tags.emplace("CardiacCyclePosition", Tag(0x0018, 0x9236));
    public_tags.emplace("SpecificAbsorptionRateSequence", Tag(0x0018, 0x9239));
    public_tags.emplace("RFEchoTrainLength", Tag(0x0018, 0x9240));
    public_tags.emplace("GradientEchoTrainLength", Tag(0x0018, 0x9241));
    public_tags.emplace("ArterialSpinLabelingContrast", Tag(0x0018, 0x9250));
    public_tags.emplace("MRArterialSpinLabelingSequence", Tag(0x0018, 0x9251));
    public_tags.emplace("ASLTechniqueDescription", Tag(0x0018, 0x9252));
    public_tags.emplace("ASLSlabNumber", Tag(0x0018, 0x9253));
    public_tags.emplace("ASLSlabThickness", Tag(0x0018, 0x9254));
    public_tags.emplace("ASLSlabOrientation", Tag(0x0018, 0x9255));
    public_tags.emplace("ASLMidSlabPosition", Tag(0x0018, 0x9256));
    public_tags.emplace("ASLContext", Tag(0x0018, 0x9257));
    public_tags.emplace("ASLPulseTrainDuration", Tag(0x0018, 0x9258));
    public_tags.emplace("ASLCrusherFlag", Tag(0x0018, 0x9259));
    public_tags.emplace("ASLCrusherFlowLimit", Tag(0x0018, 0x925a));
    public_tags.emplace("ASLCrusherDescription", Tag(0x0018, 0x925b));
    public_tags.emplace("ASLBolusCutoffFlag", Tag(0x0018, 0x925c));
    public_tags.emplace("ASLBolusCutoffTimingSequence", Tag(0x0018, 0x925d));
    public_tags.emplace("ASLBolusCutoffTechnique", Tag(0x0018, 0x925e));
    public_tags.emplace("ASLBolusCutoffDelayTime", Tag(0x0018, 0x925f));
    public_tags.emplace("ASLSlabSequence", Tag(0x0018, 0x9260));
    public_tags.emplace("ChemicalShiftMinimumIntegrationLimitInppm", Tag(0x0018, 0x9295));
    public_tags.emplace("ChemicalShiftMaximumIntegrationLimitInppm", Tag(0x0018, 0x9296));
    public_tags.emplace("WaterReferenceAcquisition", Tag(0x0018, 0x9297));
    public_tags.emplace("EchoPeakPosition", Tag(0x0018, 0x9298));
    public_tags.emplace("CTAcquisitionTypeSequence", Tag(0x0018, 0x9301));
    public_tags.emplace("AcquisitionType", Tag(0x0018, 0x9302));
    public_tags.emplace("TubeAngle", Tag(0x0018, 0x9303));
    public_tags.emplace("CTAcquisitionDetailsSequence", Tag(0x0018, 0x9304));
    public_tags.emplace("RevolutionTime", Tag(0x0018, 0x9305));
    public_tags.emplace("SingleCollimationWidth", Tag(0x0018, 0x9306));
    public_tags.emplace("TotalCollimationWidth", Tag(0x0018, 0x9307));
    public_tags.emplace("CTTableDynamicsSequence", Tag(0x0018, 0x9308));
    public_tags.emplace("TableSpeed", Tag(0x0018, 0x9309));
    public_tags.emplace("TableFeedPerRotation", Tag(0x0018, 0x9310));
    public_tags.emplace("SpiralPitchFactor", Tag(0x0018, 0x9311));
    public_tags.emplace("CTGeometrySequence", Tag(0x0018, 0x9312));
    public_tags.emplace("DataCollectionCenterPatient", Tag(0x0018, 0x9313));
    public_tags.emplace("CTReconstructionSequence", Tag(0x0018, 0x9314));
    public_tags.emplace("ReconstructionAlgorithm", Tag(0x0018, 0x9315));
    public_tags.emplace("ConvolutionKernelGroup", Tag(0x0018, 0x9316));
    public_tags.emplace("ReconstructionFieldOfView", Tag(0x0018, 0x9317));
    public_tags.emplace("ReconstructionTargetCenterPatient", Tag(0x0018, 0x9318));
    public_tags.emplace("ReconstructionAngle", Tag(0x0018, 0x9319));
    public_tags.emplace("ImageFilter", Tag(0x0018, 0x9320));
    public_tags.emplace("CTExposureSequence", Tag(0x0018, 0x9321));
    public_tags.emplace("ReconstructionPixelSpacing", Tag(0x0018, 0x9322));
    public_tags.emplace("ExposureModulationType", Tag(0x0018, 0x9323));
    public_tags.emplace("EstimatedDoseSaving", Tag(0x0018, 0x9324));
    public_tags.emplace("CTXRayDetailsSequence", Tag(0x0018, 0x9325));
    public_tags.emplace("CTPositionSequence", Tag(0x0018, 0x9326));
    public_tags.emplace("TablePosition", Tag(0x0018, 0x9327));
    public_tags.emplace("ExposureTimeInms", Tag(0x0018, 0x9328));
    public_tags.emplace("CTImageFrameTypeSequence", Tag(0x0018, 0x9329));
    public_tags.emplace("XRayTubeCurrentInmA", Tag(0x0018, 0x9330));
    public_tags.emplace("ExposureInmAs", Tag(0x0018, 0x9332));
    public_tags.emplace("ConstantVolumeFlag", Tag(0x0018, 0x9333));
    public_tags.emplace("FluoroscopyFlag", Tag(0x0018, 0x9334));
    public_tags.emplace("DistanceSourceToDataCollectionCenter", Tag(0x0018, 0x9335));
    public_tags.emplace("ContrastBolusAgentNumber", Tag(0x0018, 0x9337));
    public_tags.emplace("ContrastBolusIngredientCodeSequence", Tag(0x0018, 0x9338));
    public_tags.emplace("ContrastAdministrationProfileSequence", Tag(0x0018, 0x9340));
    public_tags.emplace("ContrastBolusUsageSequence", Tag(0x0018, 0x9341));
    public_tags.emplace("ContrastBolusAgentAdministered", Tag(0x0018, 0x9342));
    public_tags.emplace("ContrastBolusAgentDetected", Tag(0x0018, 0x9343));
    public_tags.emplace("ContrastBolusAgentPhase", Tag(0x0018, 0x9344));
    public_tags.emplace("CTDIvol", Tag(0x0018, 0x9345));
    public_tags.emplace("CTDIPhantomTypeCodeSequence", Tag(0x0018, 0x9346));
    public_tags.emplace("CalciumScoringMassFactorPatient", Tag(0x0018, 0x9351));
    public_tags.emplace("CalciumScoringMassFactorDevice", Tag(0x0018, 0x9352));
    public_tags.emplace("EnergyWeightingFactor", Tag(0x0018, 0x9353));
    public_tags.emplace("CTAdditionalXRaySourceSequence", Tag(0x0018, 0x9360));
    public_tags.emplace("MultienergyCTAcquisition", Tag(0x0018, 0x9361));
    public_tags.emplace("MultienergyCTAcquisitionSequence", Tag(0x0018, 0x9362));
    public_tags.emplace("MultienergyCTProcessingSequence", Tag(0x0018, 0x9363));
    public_tags.emplace("MultienergyCTCharacteristicsSequence", Tag(0x0018, 0x9364));
    public_tags.emplace("MultienergyCTXRaySourceSequence", Tag(0x0018, 0x9365));
    public_tags.emplace("XRaySourceIndex", Tag(0x0018, 0x9366));
    public_tags.emplace("XRaySourceID", Tag(0x0018, 0x9367));
    public_tags.emplace("MultienergySourceTechnique", Tag(0x0018, 0x9368));
    public_tags.emplace("SourceStartDateTime", Tag(0x0018, 0x9369));
    public_tags.emplace("SourceEndDateTime", Tag(0x0018, 0x936a));
    public_tags.emplace("SwitchingPhaseNumber", Tag(0x0018, 0x936b));
    public_tags.emplace("SwitchingPhaseNominalDuration", Tag(0x0018, 0x936c));
    public_tags.emplace("SwitchingPhaseTransitionDuration", Tag(0x0018, 0x936d));
    public_tags.emplace("EffectiveBinEnergy", Tag(0x0018, 0x936e));
    public_tags.emplace("MultienergyCTXRayDetectorSequence", Tag(0x0018, 0x936f));
    public_tags.emplace("XRayDetectorIndex", Tag(0x0018, 0x9370));
    public_tags.emplace("XRayDetectorID", Tag(0x0018, 0x9371));
    public_tags.emplace("MultienergyDetectorType", Tag(0x0018, 0x9372));
    public_tags.emplace("XRayDetectorLabel", Tag(0x0018, 0x9373));
    public_tags.emplace("NominalMaxEnergy", Tag(0x0018, 0x9374));
    public_tags.emplace("NominalMinEnergy", Tag(0x0018, 0x9375));
    public_tags.emplace("ReferencedXRayDetectorIndex", Tag(0x0018, 0x9376));
    public_tags.emplace("ReferencedXRaySourceIndex", Tag(0x0018, 0x9377));
    public_tags.emplace("ReferencedPathIndex", Tag(0x0018, 0x9378));
    public_tags.emplace("MultienergyCTPathSequence", Tag(0x0018, 0x9379));
    public_tags.emplace("MultienergyCTPathIndex", Tag(0x0018, 0x937a));
    public_tags.emplace("MultienergyAcquisitionDescription", Tag(0x0018, 0x937b));
    public_tags.emplace("MonoenergeticEnergyEquivalent", Tag(0x0018, 0x937c));
    public_tags.emplace("MaterialCodeSequence", Tag(0x0018, 0x937d));
    public_tags.emplace("DecompositionMethod", Tag(0x0018, 0x937e));
    public_tags.emplace("DecompositionDescription", Tag(0x0018, 0x937f));
    public_tags.emplace("DecompositionAlgorithmIdentificationSequence", Tag(0x0018, 0x9380));
    public_tags.emplace("DecompositionMaterialSequence", Tag(0x0018, 0x9381));
    public_tags.emplace("MaterialAttenuationSequence", Tag(0x0018, 0x9382));
    public_tags.emplace("PhotonEnergy", Tag(0x0018, 0x9383));
    public_tags.emplace("XRayMassAttenuationCoefficient", Tag(0x0018, 0x9384));
    public_tags.emplace("ProjectionPixelCalibrationSequence", Tag(0x0018, 0x9401));
    public_tags.emplace("DistanceSourceToIsocenter", Tag(0x0018, 0x9402));
    public_tags.emplace("DistanceObjectToTableTop", Tag(0x0018, 0x9403));
    public_tags.emplace("ObjectPixelSpacingInCenterOfBeam", Tag(0x0018, 0x9404));
    public_tags.emplace("PositionerPositionSequence", Tag(0x0018, 0x9405));
    public_tags.emplace("TablePositionSequence", Tag(0x0018, 0x9406));
    public_tags.emplace("CollimatorShapeSequence", Tag(0x0018, 0x9407));
    public_tags.emplace("PlanesInAcquisition", Tag(0x0018, 0x9410));
    public_tags.emplace("XAXRFFrameCharacteristicsSequence", Tag(0x0018, 0x9412));
    public_tags.emplace("FrameAcquisitionSequence", Tag(0x0018, 0x9417));
    public_tags.emplace("XRayReceptorType", Tag(0x0018, 0x9420));
    public_tags.emplace("AcquisitionProtocolName", Tag(0x0018, 0x9423));
    public_tags.emplace("AcquisitionProtocolDescription", Tag(0x0018, 0x9424));
    public_tags.emplace("ContrastBolusIngredientOpaque", Tag(0x0018, 0x9425));
    public_tags.emplace("DistanceReceptorPlaneToDetectorHousing", Tag(0x0018, 0x9426));
    public_tags.emplace("IntensifierActiveShape", Tag(0x0018, 0x9427));
    public_tags.emplace("IntensifierActiveDimensions", Tag(0x0018, 0x9428));
    public_tags.emplace("PhysicalDetectorSize", Tag(0x0018, 0x9429));
    public_tags.emplace("PositionOfIsocenterProjection", Tag(0x0018, 0x9430));
    public_tags.emplace("FieldOfViewSequence", Tag(0x0018, 0x9432));
    public_tags.emplace("FieldOfViewDescription", Tag(0x0018, 0x9433));
    public_tags.emplace("ExposureControlSensingRegionsSequence", Tag(0x0018, 0x9434));
    public_tags.emplace("ExposureControlSensingRegionShape", Tag(0x0018, 0x9435));
    public_tags.emplace("ExposureControlSensingRegionLeftVerticalEdge", Tag(0x0018, 0x9436));
    public_tags.emplace("ExposureControlSensingRegionRightVerticalEdge", Tag(0x0018, 0x9437));
    public_tags.emplace("ExposureControlSensingRegionUpperHorizontalEdge", Tag(0x0018, 0x9438));
    public_tags.emplace("ExposureControlSensingRegionLowerHorizontalEdge", Tag(0x0018, 0x9439));
    public_tags.emplace("CenterOfCircularExposureControlSensingRegion", Tag(0x0018, 0x9440));
    public_tags.emplace("RadiusOfCircularExposureControlSensingRegion", Tag(0x0018, 0x9441));
    public_tags.emplace("VerticesOfThePolygonalExposureControlSensingRegion", Tag(0x0018, 0x9442));
    public_tags.emplace("ColumnAngulationPatient", Tag(0x0018, 0x9447));
    public_tags.emplace("BeamAngle", Tag(0x0018, 0x9449));
    public_tags.emplace("FrameDetectorParametersSequence", Tag(0x0018, 0x9451));
    public_tags.emplace("CalculatedAnatomyThickness", Tag(0x0018, 0x9452));
    public_tags.emplace("CalibrationSequence", Tag(0x0018, 0x9455));
    public_tags.emplace("ObjectThicknessSequence", Tag(0x0018, 0x9456));
    public_tags.emplace("PlaneIdentification", Tag(0x0018, 0x9457));
    public_tags.emplace("FieldOfViewDimensionsInFloat", Tag(0x0018, 0x9461));
    public_tags.emplace("IsocenterReferenceSystemSequence", Tag(0x0018, 0x9462));
    public_tags.emplace("PositionerIsocenterPrimaryAngle", Tag(0x0018, 0x9463));
    public_tags.emplace("PositionerIsocenterSecondaryAngle", Tag(0x0018, 0x9464));
    public_tags.emplace("PositionerIsocenterDetectorRotationAngle", Tag(0x0018, 0x9465));
    public_tags.emplace("TableXPositionToIsocenter", Tag(0x0018, 0x9466));
    public_tags.emplace("TableYPositionToIsocenter", Tag(0x0018, 0x9467));
    public_tags.emplace("TableZPositionToIsocenter", Tag(0x0018, 0x9468));
    public_tags.emplace("TableHorizontalRotationAngle", Tag(0x0018, 0x9469));
    public_tags.emplace("TableHeadTiltAngle", Tag(0x0018, 0x9470));
    public_tags.emplace("TableCradleTiltAngle", Tag(0x0018, 0x9471));
    public_tags.emplace("FrameDisplayShutterSequence", Tag(0x0018, 0x9472));
    public_tags.emplace("AcquiredImageAreaDoseProduct", Tag(0x0018, 0x9473));
    public_tags.emplace("CArmPositionerTabletopRelationship", Tag(0x0018, 0x9474));
    public_tags.emplace("XRayGeometrySequence", Tag(0x0018, 0x9476));
    public_tags.emplace("IrradiationEventIdentificationSequence", Tag(0x0018, 0x9477));
    public_tags.emplace("XRay3DFrameTypeSequence", Tag(0x0018, 0x9504));
    public_tags.emplace("ContributingSourcesSequence", Tag(0x0018, 0x9506));
    public_tags.emplace("XRay3DAcquisitionSequence", Tag(0x0018, 0x9507));
    public_tags.emplace("PrimaryPositionerScanArc", Tag(0x0018, 0x9508));
    public_tags.emplace("SecondaryPositionerScanArc", Tag(0x0018, 0x9509));
    public_tags.emplace("PrimaryPositionerScanStartAngle", Tag(0x0018, 0x9510));
    public_tags.emplace("SecondaryPositionerScanStartAngle", Tag(0x0018, 0x9511));
    public_tags.emplace("PrimaryPositionerIncrement", Tag(0x0018, 0x9514));
    public_tags.emplace("SecondaryPositionerIncrement", Tag(0x0018, 0x9515));
    public_tags.emplace("StartAcquisitionDateTime", Tag(0x0018, 0x9516));
    public_tags.emplace("EndAcquisitionDateTime", Tag(0x0018, 0x9517));
    public_tags.emplace("PrimaryPositionerIncrementSign", Tag(0x0018, 0x9518));
    public_tags.emplace("SecondaryPositionerIncrementSign", Tag(0x0018, 0x9519));
    public_tags.emplace("ApplicationName", Tag(0x0018, 0x9524));
    public_tags.emplace("ApplicationVersion", Tag(0x0018, 0x9525));
    public_tags.emplace("ApplicationManufacturer", Tag(0x0018, 0x9526));
    public_tags.emplace("AlgorithmType", Tag(0x0018, 0x9527));
    public_tags.emplace("AlgorithmDescription", Tag(0x0018, 0x9528));
    public_tags.emplace("XRay3DReconstructionSequence", Tag(0x0018, 0x9530));
    public_tags.emplace("ReconstructionDescription", Tag(0x0018, 0x9531));
    public_tags.emplace("PerProjectionAcquisitionSequence", Tag(0x0018, 0x9538));
    public_tags.emplace("DetectorPositionSequence", Tag(0x0018, 0x9541));
    public_tags.emplace("XRayAcquisitionDoseSequence", Tag(0x0018, 0x9542));
    public_tags.emplace("XRaySourceIsocenterPrimaryAngle", Tag(0x0018, 0x9543));
    public_tags.emplace("XRaySourceIsocenterSecondaryAngle", Tag(0x0018, 0x9544));
    public_tags.emplace("BreastSupportIsocenterPrimaryAngle", Tag(0x0018, 0x9545));
    public_tags.emplace("BreastSupportIsocenterSecondaryAngle", Tag(0x0018, 0x9546));
    public_tags.emplace("BreastSupportXPositionToIsocenter", Tag(0x0018, 0x9547));
    public_tags.emplace("BreastSupportYPositionToIsocenter", Tag(0x0018, 0x9548));
    public_tags.emplace("BreastSupportZPositionToIsocenter", Tag(0x0018, 0x9549));
    public_tags.emplace("DetectorIsocenterPrimaryAngle", Tag(0x0018, 0x9550));
    public_tags.emplace("DetectorIsocenterSecondaryAngle", Tag(0x0018, 0x9551));
    public_tags.emplace("DetectorXPositionToIsocenter", Tag(0x0018, 0x9552));
    public_tags.emplace("DetectorYPositionToIsocenter", Tag(0x0018, 0x9553));
    public_tags.emplace("DetectorZPositionToIsocenter", Tag(0x0018, 0x9554));
    public_tags.emplace("XRayGridSequence", Tag(0x0018, 0x9555));
    public_tags.emplace("XRayFilterSequence", Tag(0x0018, 0x9556));
    public_tags.emplace("DetectorActiveAreaTLHCPosition", Tag(0x0018, 0x9557));
    public_tags.emplace("DetectorActiveAreaOrientation", Tag(0x0018, 0x9558));
    public_tags.emplace("PositionerPrimaryAngleDirection", Tag(0x0018, 0x9559));
    public_tags.emplace("DiffusionBMatrixSequence", Tag(0x0018, 0x9601));
    public_tags.emplace("DiffusionBValueXX", Tag(0x0018, 0x9602));
    public_tags.emplace("DiffusionBValueXY", Tag(0x0018, 0x9603));
    public_tags.emplace("DiffusionBValueXZ", Tag(0x0018, 0x9604));
    public_tags.emplace("DiffusionBValueYY", Tag(0x0018, 0x9605));
    public_tags.emplace("DiffusionBValueYZ", Tag(0x0018, 0x9606));
    public_tags.emplace("DiffusionBValueZZ", Tag(0x0018, 0x9607));
    public_tags.emplace("FunctionalMRSequence", Tag(0x0018, 0x9621));
    public_tags.emplace("FunctionalSettlingPhaseFramesPresent", Tag(0x0018, 0x9622));
    public_tags.emplace("FunctionalSyncPulse", Tag(0x0018, 0x9623));
    public_tags.emplace("SettlingPhaseFrame", Tag(0x0018, 0x9624));
    public_tags.emplace("DecayCorrectionDateTime", Tag(0x0018, 0x9701));
    public_tags.emplace("StartDensityThreshold", Tag(0x0018, 0x9715));
    public_tags.emplace("StartRelativeDensityDifferenceThreshold", Tag(0x0018, 0x9716));
    public_tags.emplace("StartCardiacTriggerCountThreshold", Tag(0x0018, 0x9717));
    public_tags.emplace("StartRespiratoryTriggerCountThreshold", Tag(0x0018, 0x9718));
    public_tags.emplace("TerminationCountsThreshold", Tag(0x0018, 0x9719));
    public_tags.emplace("TerminationDensityThreshold", Tag(0x0018, 0x9720));
    public_tags.emplace("TerminationRelativeDensityThreshold", Tag(0x0018, 0x9721));
    public_tags.emplace("TerminationTimeThreshold", Tag(0x0018, 0x9722));
    public_tags.emplace("TerminationCardiacTriggerCountThreshold", Tag(0x0018, 0x9723));
    public_tags.emplace("TerminationRespiratoryTriggerCountThreshold", Tag(0x0018, 0x9724));
    public_tags.emplace("DetectorGeometry", Tag(0x0018, 0x9725));
    public_tags.emplace("TransverseDetectorSeparation", Tag(0x0018, 0x9726));
    public_tags.emplace("AxialDetectorDimension", Tag(0x0018, 0x9727));
    public_tags.emplace("RadiopharmaceuticalAgentNumber", Tag(0x0018, 0x9729));
    public_tags.emplace("PETFrameAcquisitionSequence", Tag(0x0018, 0x9732));
    public_tags.emplace("PETDetectorMotionDetailsSequence", Tag(0x0018, 0x9733));
    public_tags.emplace("PETTableDynamicsSequence", Tag(0x0018, 0x9734));
    public_tags.emplace("PETPositionSequence", Tag(0x0018, 0x9735));
    public_tags.emplace("PETFrameCorrectionFactorsSequence", Tag(0x0018, 0x9736));
    public_tags.emplace("RadiopharmaceuticalUsageSequence", Tag(0x0018, 0x9737));
    public_tags.emplace("AttenuationCorrectionSource", Tag(0x0018, 0x9738));
    public_tags.emplace("NumberOfIterations", Tag(0x0018, 0x9739));
    public_tags.emplace("NumberOfSubsets", Tag(0x0018, 0x9740));
    public_tags.emplace("PETReconstructionSequence", Tag(0x0018, 0x9749));
    public_tags.emplace("PETFrameTypeSequence", Tag(0x0018, 0x9751));
    public_tags.emplace("TimeOfFlightInformationUsed", Tag(0x0018, 0x9755));
    public_tags.emplace("ReconstructionType", Tag(0x0018, 0x9756));
    public_tags.emplace("DecayCorrected", Tag(0x0018, 0x9758));
    public_tags.emplace("AttenuationCorrected", Tag(0x0018, 0x9759));
    public_tags.emplace("ScatterCorrected", Tag(0x0018, 0x9760));
    public_tags.emplace("DeadTimeCorrected", Tag(0x0018, 0x9761));
    public_tags.emplace("GantryMotionCorrected", Tag(0x0018, 0x9762));
    public_tags.emplace("PatientMotionCorrected", Tag(0x0018, 0x9763));
    public_tags.emplace("CountLossNormalizationCorrected", Tag(0x0018, 0x9764));
    public_tags.emplace("RandomsCorrected", Tag(0x0018, 0x9765));
    public_tags.emplace("NonUniformRadialSamplingCorrected", Tag(0x0018, 0x9766));
    public_tags.emplace("SensitivityCalibrated", Tag(0x0018, 0x9767));
    public_tags.emplace("DetectorNormalizationCorrection", Tag(0x0018, 0x9768));
    public_tags.emplace("IterativeReconstructionMethod", Tag(0x0018, 0x9769));
    public_tags.emplace("AttenuationCorrectionTemporalRelationship", Tag(0x0018, 0x9770));
    public_tags.emplace("PatientPhysiologicalStateSequence", Tag(0x0018, 0x9771));
    public_tags.emplace("PatientPhysiologicalStateCodeSequence", Tag(0x0018, 0x9772));
    public_tags.emplace("DepthsOfFocus", Tag(0x0018, 0x9801));
    public_tags.emplace("ExcludedIntervalsSequence", Tag(0x0018, 0x9803));
    public_tags.emplace("ExclusionStartDateTime", Tag(0x0018, 0x9804));
    public_tags.emplace("ExclusionDuration", Tag(0x0018, 0x9805));
    public_tags.emplace("USImageDescriptionSequence", Tag(0x0018, 0x9806));
    public_tags.emplace("ImageDataTypeSequence", Tag(0x0018, 0x9807));
    public_tags.emplace("DataType", Tag(0x0018, 0x9808));
    public_tags.emplace("TransducerScanPatternCodeSequence", Tag(0x0018, 0x9809));
    public_tags.emplace("AliasedDataType", Tag(0x0018, 0x980b));
    public_tags.emplace("PositionMeasuringDeviceUsed", Tag(0x0018, 0x980c));
    public_tags.emplace("TransducerGeometryCodeSequence", Tag(0x0018, 0x980d));
    public_tags.emplace("TransducerBeamSteeringCodeSequence", Tag(0x0018, 0x980e));
    public_tags.emplace("TransducerApplicationCodeSequence", Tag(0x0018, 0x980f));
    public_tags.emplace("ZeroVelocityPixelValue", Tag(0x0018, 0x9810));
    public_tags.emplace("PhotoacousticExcitationCharacteristicsSequence", Tag(0x0018, 0x9821));
    public_tags.emplace("ExcitationSpectralWidth", Tag(0x0018, 0x9822));
    public_tags.emplace("ExcitationEnergy", Tag(0x0018, 0x9823));
    public_tags.emplace("ExcitationPulseDuration", Tag(0x0018, 0x9824));
    public_tags.emplace("ExcitationWavelengthSequence", Tag(0x0018, 0x9825));
    public_tags.emplace("ExcitationWavelength", Tag(0x0018, 0x9826));
    public_tags.emplace("IlluminationTranslationFlag", Tag(0x0018, 0x9828));
    public_tags.emplace("AcousticCouplingMediumFlag", Tag(0x0018, 0x9829));
    public_tags.emplace("AcousticCouplingMediumCodeSequence", Tag(0x0018, 0x982a));
    public_tags.emplace("AcousticCouplingMediumTemperature", Tag(0x0018, 0x982b));
    public_tags.emplace("TransducerResponseSequence", Tag(0x0018, 0x982c));
    public_tags.emplace("CenterFrequency", Tag(0x0018, 0x982d));
    public_tags.emplace("FractionalBandwidth", Tag(0x0018, 0x982e));
    public_tags.emplace("LowerCutoffFrequency", Tag(0x0018, 0x982f));
    public_tags.emplace("UpperCutoffFrequency", Tag(0x0018, 0x9830));
    public_tags.emplace("TransducerTechnologySequence", Tag(0x0018, 0x9831));
    public_tags.emplace("SoundSpeedCorrectionMechanismCodeSequence", Tag(0x0018, 0x9832));
    public_tags.emplace("ObjectSoundSpeed", Tag(0x0018, 0x9833));
    public_tags.emplace("AcousticCouplingMediumSoundSpeed", Tag(0x0018, 0x9834));
    public_tags.emplace("PhotoacousticImageFrameTypeSequence", Tag(0x0018, 0x9835));
    public_tags.emplace("ImageDataTypeCodeSequence", Tag(0x0018, 0x9836));
    public_tags.emplace("ReferenceLocationLabel", Tag(0x0018, 0x9900));
    public_tags.emplace("ReferenceLocationDescription", Tag(0x0018, 0x9901));
    public_tags.emplace("ReferenceBasisCodeSequence", Tag(0x0018, 0x9902));
    public_tags.emplace("ReferenceGeometryCodeSequence", Tag(0x0018, 0x9903));
    public_tags.emplace("OffsetDistance", Tag(0x0018, 0x9904));
    public_tags.emplace("OffsetDirection", Tag(0x0018, 0x9905));
    public_tags.emplace("PotentialScheduledProtocolCodeSequence", Tag(0x0018, 0x9906));
    public_tags.emplace("PotentialRequestedProcedureCodeSequence", Tag(0x0018, 0x9907));
    public_tags.emplace("PotentialReasonsForProcedure", Tag(0x0018, 0x9908));
    public_tags.emplace("PotentialReasonsForProcedureCodeSequence", Tag(0x0018, 0x9909));
    public_tags.emplace("PotentialDiagnosticTasks", Tag(0x0018, 0x990a));
    public_tags.emplace("ContraindicationsCodeSequence", Tag(0x0018, 0x990b));
    public_tags.emplace("ReferencedDefinedProtocolSequence", Tag(0x0018, 0x990c));
    public_tags.emplace("ReferencedPerformedProtocolSequence", Tag(0x0018, 0x990d));
    public_tags.emplace("PredecessorProtocolSequence", Tag(0x0018, 0x990e));
    public_tags.emplace("ProtocolPlanningInformation", Tag(0x0018, 0x990f));
    public_tags.emplace("ProtocolDesignRationale", Tag(0x0018, 0x9910));
    public_tags.emplace("PatientSpecificationSequence", Tag(0x0018, 0x9911));
    public_tags.emplace("ModelSpecificationSequence", Tag(0x0018, 0x9912));
    public_tags.emplace("ParametersSpecificationSequence", Tag(0x0018, 0x9913));
    public_tags.emplace("InstructionSequence", Tag(0x0018, 0x9914));
    public_tags.emplace("InstructionIndex", Tag(0x0018, 0x9915));
    public_tags.emplace("InstructionText", Tag(0x0018, 0x9916));
    public_tags.emplace("InstructionDescription", Tag(0x0018, 0x9917));
    public_tags.emplace("InstructionPerformedFlag", Tag(0x0018, 0x9918));
    public_tags.emplace("InstructionPerformedDateTime", Tag(0x0018, 0x9919));
    public_tags.emplace("InstructionPerformanceComment", Tag(0x0018, 0x991a));
    public_tags.emplace("PatientPositioningInstructionSequence", Tag(0x0018, 0x991b));
    public_tags.emplace("PositioningMethodCodeSequence", Tag(0x0018, 0x991c));
    public_tags.emplace("PositioningLandmarkSequence", Tag(0x0018, 0x991d));
    public_tags.emplace("TargetFrameOfReferenceUID", Tag(0x0018, 0x991e));
    public_tags.emplace("AcquisitionProtocolElementSpecificationSequence", Tag(0x0018, 0x991f));
    public_tags.emplace("AcquisitionProtocolElementSequence", Tag(0x0018, 0x9920));
    public_tags.emplace("ProtocolElementNumber", Tag(0x0018, 0x9921));
    public_tags.emplace("ProtocolElementName", Tag(0x0018, 0x9922));
    public_tags.emplace("ProtocolElementCharacteristicsSummary", Tag(0x0018, 0x9923));
    public_tags.emplace("ProtocolElementPurpose", Tag(0x0018, 0x9924));
    public_tags.emplace("AcquisitionMotion", Tag(0x0018, 0x9930));
    public_tags.emplace("AcquisitionStartLocationSequence", Tag(0x0018, 0x9931));
    public_tags.emplace("AcquisitionEndLocationSequence", Tag(0x0018, 0x9932));
    public_tags.emplace("ReconstructionProtocolElementSpecificationSequence", Tag(0x0018, 0x9933));
    public_tags.emplace("ReconstructionProtocolElementSequence", Tag(0x0018, 0x9934));
    public_tags.emplace("StorageProtocolElementSpecificationSequence", Tag(0x0018, 0x9935));
    public_tags.emplace("StorageProtocolElementSequence", Tag(0x0018, 0x9936));
    public_tags.emplace("RequestedSeriesDescription", Tag(0x0018, 0x9937));
    public_tags.emplace("SourceAcquisitionProtocolElementNumber", Tag(0x0018, 0x9938));
    public_tags.emplace("SourceAcquisitionBeamNumber", Tag(0x0018, 0x9939));
    public_tags.emplace("SourceReconstructionProtocolElementNumber", Tag(0x0018, 0x993a));
    public_tags.emplace("ReconstructionStartLocationSequence", Tag(0x0018, 0x993b));
    public_tags.emplace("ReconstructionEndLocationSequence", Tag(0x0018, 0x993c));
    public_tags.emplace("ReconstructionAlgorithmSequence", Tag(0x0018, 0x993d));
    public_tags.emplace("ReconstructionTargetCenterLocationSequence", Tag(0x0018, 0x993e));
    public_tags.emplace("ImageFilterDescription", Tag(0x0018, 0x9941));
    public_tags.emplace("CTDIvolNotificationTrigger", Tag(0x0018, 0x9942));
    public_tags.emplace("DLPNotificationTrigger", Tag(0x0018, 0x9943));
    public_tags.emplace("AutoKVPSelectionType", Tag(0x0018, 0x9944));
    public_tags.emplace("AutoKVPUpperBound", Tag(0x0018, 0x9945));
    public_tags.emplace("AutoKVPLowerBound", Tag(0x0018, 0x9946));
    public_tags.emplace("ProtocolDefinedPatientPosition", Tag(0x0018, 0x9947));
    public_tags.emplace("ContributingEquipmentSequence", Tag(0x0018, 0xa001));
    public_tags.emplace("ContributionDateTime", Tag(0x0018, 0xa002));
    public_tags.emplace("ContributionDescription", Tag(0x0018, 0xa003));
}

}

}