/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module.edition;

import java.time.Clock;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.dbapi.impl.BoltKernelDatabaseManagementServiceProvider;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.cypher.internal.javacompat.CommunityCypherEngineProvider;
import org.neo4j.dbms.CommunityDatabaseStateService;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseInfoService;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.dbms.database.DatabaseOperationCounts;
import org.neo4j.dbms.database.DatabaseReferenceCacheClearingListener;
import org.neo4j.dbms.database.DefaultDatabaseManager;
import org.neo4j.dbms.database.DefaultSystemGraphComponent;
import org.neo4j.dbms.database.DefaultSystemGraphInitializer;
import org.neo4j.dbms.database.StandaloneDatabaseContext;
import org.neo4j.dbms.database.StandaloneDatabaseInfoService;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponents;
import org.neo4j.dbms.database.SystemGraphInitializer;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.dbms.identity.DefaultIdentityModule;
import org.neo4j.dbms.identity.ServerIdentity;
import org.neo4j.dbms.procedures.StandaloneDatabaseStateProcedure;
import org.neo4j.dbms.systemgraph.CommunityTopologyGraphComponent;
import org.neo4j.exceptions.KernelException;
import org.neo4j.fabric.bootstrap.FabricServicesBootstrap;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.graphdb.factory.EditionLocksFactories;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.StandaloneEditionModule;
import org.neo4j.graphdb.factory.module.id.IdContextFactory;
import org.neo4j.graphdb.factory.module.id.IdContextFactoryBuilder;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.CommunitySecurityLog;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.security.provider.NoAuthSecurityProvider;
import org.neo4j.kernel.api.security.provider.SecurityProvider;
import org.neo4j.kernel.availability.CompositeDatabaseAvailabilityGuard;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.DatabaseStartupController;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.kernel.database.GlobalAvailabilityGuardController;
import org.neo4j.kernel.database.MapCachingDatabaseReferenceRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.SystemGraphDatabaseReferenceRepository;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.constraints.StandardConstraintSemantics;
import org.neo4j.kernel.impl.core.DefaultLabelIdCreator;
import org.neo4j.kernel.impl.core.DefaultPropertyTokenCreator;
import org.neo4j.kernel.impl.core.DefaultRelationshipTypeCreator;
import org.neo4j.kernel.impl.factory.CommunityCommitProcessFactory;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.locking.LocksFactory;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.log4j.LogExtended;
import org.neo4j.monitoring.Monitors;
import org.neo4j.procedure.builtin.routing.AbstractRoutingProcedureInstaller;
import org.neo4j.procedure.builtin.routing.ClientRoutingDomainChecker;
import org.neo4j.procedure.builtin.routing.DatabaseAvailabilityChecker;
import org.neo4j.procedure.builtin.routing.DefaultDatabaseAvailabilityChecker;
import org.neo4j.procedure.builtin.routing.SingleInstanceRoutingProcedureInstaller;
import org.neo4j.server.CommunityNeoWebServer;
import org.neo4j.server.config.AuthConfigProvider;
import org.neo4j.server.rest.repr.CommunityAuthConfigProvider;
import org.neo4j.server.security.auth.CommunitySecurityModule;
import org.neo4j.server.security.systemgraph.CommunityDefaultDatabaseResolver;
import org.neo4j.server.security.systemgraph.UserSecurityGraphComponent;
import org.neo4j.ssl.config.SslPolicyLoader;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.token.DelegatingTokenHolder;
import org.neo4j.token.TokenCreator;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;

public class CommunityEditionModule
extends StandaloneEditionModule {
    protected final SslPolicyLoader sslPolicyLoader;
    protected final GlobalModule globalModule;
    protected final ServerIdentity identityModule;
    private final CompositeDatabaseAvailabilityGuard globalAvailabilityGuard;
    protected DatabaseStateService databaseStateService;
    private ReadOnlyDatabases globalReadOnlyChecker;
    private FabricServicesBootstrap fabricServicesBootstrap;

    public CommunityEditionModule(GlobalModule globalModule) {
        Dependencies globalDependencies = globalModule.getGlobalDependencies();
        Config globalConfig = globalModule.getGlobalConfig();
        LogService logService = globalModule.getLogService();
        SystemNanoClock globalClock = globalModule.getGlobalClock();
        DependencyResolver externalDependencies = globalModule.getExternalDependencyResolver();
        this.globalModule = globalModule;
        this.watcherServiceFactory = databaseLayout -> CommunityEditionModule.createDatabaseFileSystemWatcher(globalModule.getFileWatcher(), databaseLayout, logService, this.fileWatcherFileNameFilter());
        this.sslPolicyLoader = SslPolicyLoader.create((Config)globalConfig, (LogProvider)logService.getInternalLogProvider());
        globalDependencies.satisfyDependency((Object)this.sslPolicyLoader);
        globalDependencies.satisfyDependency((Object)new DatabaseOperationCounts.Counter());
        globalDependencies.satisfyDependency((Object)this.createAuthConfigProvider(globalModule));
        this.identityModule = DefaultIdentityModule.fromGlobalModule(globalModule);
        globalDependencies.satisfyDependency((Object)this.identityModule);
        LocksFactory lockFactory = EditionLocksFactories.createLockFactory(globalConfig, logService);
        this.locksSupplier = () -> EditionLocksFactories.createLockManager(lockFactory, globalConfig, globalClock);
        this.idContextFactory = CommunityEditionModule.tryResolveOrCreate(IdContextFactory.class, externalDependencies, () -> CommunityEditionModule.createIdContextFactory(globalModule));
        this.tokenHoldersProvider = this.createTokenHolderProvider(globalModule);
        this.commitProcessFactory = new CommunityCommitProcessFactory();
        this.constraintSemantics = this.createSchemaRuleVerifier();
        this.connectionTracker = (NetworkConnectionTracker)globalDependencies.satisfyDependency((Object)CommunityEditionModule.createConnectionTracker());
        this.globalAvailabilityGuard = globalModule.getGlobalAvailabilityGuard();
    }

    @Override
    public DatabaseManager<? extends StandaloneDatabaseContext> createDatabaseManager(GlobalModule globalModule) {
        DefaultDatabaseManager databaseManager = new DefaultDatabaseManager(globalModule, this);
        this.databaseStateService = new CommunityDatabaseStateService(databaseManager);
        globalModule.getGlobalLife().add((Lifecycle)databaseManager);
        globalModule.getGlobalDependencies().satisfyDependency((Object)databaseManager);
        globalModule.getGlobalDependencies().satisfyDependency((Object)this.databaseStateService);
        this.globalReadOnlyChecker = CommunityEditionModule.createGlobalReadOnlyChecker(databaseManager, globalModule.getGlobalConfig(), globalModule.getTransactionEventListeners(), globalModule.getGlobalLife(), globalModule.getLogService().getInternalLogProvider());
        MapCachingDatabaseReferenceRepository databaseReferenceRepo = new MapCachingDatabaseReferenceRepository((DatabaseReferenceRepository)new SystemGraphDatabaseReferenceRepository(() -> ((DefaultDatabaseManager)databaseManager).getSystemDatabaseContext()));
        this.databaseReferenceRepo = databaseReferenceRepo;
        this.fabricServicesBootstrap = new FabricServicesBootstrap.Community(globalModule.getGlobalLife(), globalModule.getGlobalDependencies(), globalModule.getLogService(), (DatabaseManager)databaseManager, (DatabaseReferenceRepository)databaseReferenceRepo);
        DatabaseReferenceCacheClearingListener databaseIdCacheCleaner = new DatabaseReferenceCacheClearingListener(databaseManager.databaseIdRepository(), (DatabaseReferenceRepository.Caching)databaseReferenceRepo);
        globalModule.getTransactionEventListeners().registerTransactionEventListener("system", (TransactionEventListener)databaseIdCacheCleaner);
        return databaseManager;
    }

    protected Function<NamedDatabaseId, TokenHolders> createTokenHolderProvider(GlobalModule platform) {
        return databaseId -> {
            DatabaseManager databaseManager = (DatabaseManager)platform.getGlobalDependencies().resolveDependency(DefaultDatabaseManager.class);
            Supplier<Kernel> kernelSupplier = () -> {
                DatabaseContext databaseContext = (DatabaseContext)databaseManager.getDatabaseContext(databaseId).orElseThrow(() -> new IllegalStateException("Default and system database kernels should always be accessible"));
                return (Kernel)databaseContext.dependencies().resolveDependency(Kernel.class);
            };
            return new TokenHolders((TokenHolder)new DelegatingTokenHolder(CommunityEditionModule.createPropertyKeyCreator(kernelSupplier), "PropertyKey"), (TokenHolder)new DelegatingTokenHolder(CommunityEditionModule.createLabelIdCreator(kernelSupplier), "Label"), (TokenHolder)new DelegatingTokenHolder(CommunityEditionModule.createRelationshipTypeCreator(kernelSupplier), "RelationshipType"));
        };
    }

    private static IdContextFactory createIdContextFactory(GlobalModule globalModule) {
        return IdContextFactoryBuilder.of(globalModule.getFileSystem(), globalModule.getJobScheduler(), globalModule.getGlobalConfig(), globalModule.getTracers().getPageCacheTracer()).build();
    }

    protected Predicate<String> fileWatcherFileNameFilter() {
        return CommunityEditionModule.communityFileWatcherFileNameFilter();
    }

    static Predicate<String> communityFileWatcherFileNameFilter() {
        return CommunityEditionModule.defaultFileWatcherFilter();
    }

    protected ConstraintSemantics createSchemaRuleVerifier() {
        return new StandardConstraintSemantics();
    }

    protected static TokenCreator createRelationshipTypeCreator(Supplier<Kernel> kernelSupplier) {
        return new DefaultRelationshipTypeCreator(kernelSupplier);
    }

    protected static TokenCreator createPropertyKeyCreator(Supplier<Kernel> kernelSupplier) {
        return new DefaultPropertyTokenCreator(kernelSupplier);
    }

    protected static TokenCreator createLabelIdCreator(Supplier<Kernel> kernelSupplier) {
        return new DefaultLabelIdCreator(kernelSupplier);
    }

    @Override
    public QueryEngineProvider getQueryEngineProvider() {
        return new CommunityCypherEngineProvider();
    }

    @Override
    public DatabaseStartupController getDatabaseStartupController() {
        return new GlobalAvailabilityGuardController(this.globalAvailabilityGuard);
    }

    @Override
    public Lifecycle createWebServer(DatabaseManagementService managementService, Dependencies globalDependencies, Config config, LogProvider userLogProvider, DbmsInfo dbmsInfo) {
        return new CommunityNeoWebServer(managementService, globalDependencies, config, userLogProvider, dbmsInfo, this.globalModule.getMemoryPools(), this.globalModule.getTransactionManager(), this.globalModule.getGlobalClock());
    }

    @Override
    public DatabaseInfoService createDatabaseInfoService(DatabaseManager<?> databaseManager) {
        SocketAddress address = (SocketAddress)this.globalModule.getGlobalConfig().get(BoltConnector.advertised_address);
        return new StandaloneDatabaseInfoService(this.identityModule.serverId(), address, databaseManager, this.databaseStateService, this.globalReadOnlyChecker);
    }

    @Override
    public void registerEditionSpecificProcedures(GlobalProcedures globalProcedures, DatabaseManager<?> databaseManager) throws KernelException {
        globalProcedures.register((CallableProcedure)new StandaloneDatabaseStateProcedure(this.databaseStateService, (DatabaseIdRepository)databaseManager.databaseIdRepository(), ((SocketAddress)this.globalModule.getGlobalConfig().get(BoltConnector.advertised_address)).toString()));
    }

    @Override
    protected AbstractRoutingProcedureInstaller createRoutingProcedureInstaller(GlobalModule globalModule, DatabaseManager<?> databaseManager, ClientRoutingDomainChecker clientRoutingDomainChecker, DefaultDatabaseResolver defaultDatabaseResolver) {
        ConnectorPortRegister portRegister = globalModule.getConnectorPortRegister();
        Config config = globalModule.getGlobalConfig();
        LogProvider logProvider = globalModule.getLogService().getInternalLogProvider();
        DefaultDatabaseAvailabilityChecker databaseAvailabilityChecker = new DefaultDatabaseAvailabilityChecker(databaseManager);
        return new SingleInstanceRoutingProcedureInstaller((DatabaseAvailabilityChecker)databaseAvailabilityChecker, clientRoutingDomainChecker, portRegister, config, logProvider, this.databaseReferenceRepo, defaultDatabaseResolver);
    }

    @Override
    protected AuthConfigProvider createAuthConfigProvider(GlobalModule globalModule) {
        return new CommunityAuthConfigProvider();
    }

    @Override
    public SystemGraphInitializer createSystemGraphInitializer(GlobalModule globalModule) {
        Dependencies globalDependencies = globalModule.getGlobalDependencies();
        Supplier<GraphDatabaseService> systemSupplier = CommunityEditionModule.systemSupplier((DependencyResolver)globalDependencies);
        SystemGraphComponents systemGraphComponents = globalModule.getSystemGraphComponents();
        SystemGraphInitializer initializer = CommunityEditionModule.tryResolveOrCreate(SystemGraphInitializer.class, globalModule.getExternalDependencyResolver(), () -> new DefaultSystemGraphInitializer(systemSupplier, systemGraphComponents));
        return (SystemGraphInitializer)globalModule.getGlobalDependencies().satisfyDependency((Object)initializer);
    }

    @Override
    public void registerSystemGraphComponents(SystemGraphComponents systemGraphComponents, GlobalModule globalModule) {
        Config config = globalModule.getGlobalConfig();
        LogProvider log = globalModule.getLogService().getInternalLogProvider();
        SystemNanoClock clock = globalModule.getGlobalClock();
        DefaultSystemGraphComponent systemGraphComponent = new DefaultSystemGraphComponent(config, (Clock)clock);
        systemGraphComponents.register((SystemGraphComponent)systemGraphComponent);
        CommunityTopologyGraphComponent communityTopologyGraphComponentComponent = new CommunityTopologyGraphComponent(config, log);
        systemGraphComponents.register((SystemGraphComponent)communityTopologyGraphComponentComponent);
    }

    protected static Supplier<GraphDatabaseService> systemSupplier(DependencyResolver dependencies) {
        return () -> {
            DatabaseManager databaseManager = (DatabaseManager)dependencies.resolveDependency(DatabaseManager.class);
            return ((DatabaseContext)databaseManager.getDatabaseContext(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID).orElseThrow(() -> new RuntimeException("No database called `system` was found."))).databaseFacade();
        };
    }

    private void setupSecurityGraphInitializer(GlobalModule globalModule) {
        Config config = globalModule.getGlobalConfig();
        FileSystemAbstraction fileSystem = globalModule.getFileSystem();
        LogProvider logProvider = globalModule.getLogService().getUserLogProvider();
        CommunitySecurityLog securityLog = new CommunitySecurityLog((LogExtended)logProvider.getLog(UserSecurityGraphComponent.class));
        UserSecurityGraphComponent communityComponent = CommunitySecurityModule.createSecurityComponent((AbstractSecurityLog)securityLog, (Config)config, (FileSystemAbstraction)fileSystem, (LogProvider)logProvider);
        Dependencies dependencies = globalModule.getGlobalDependencies();
        SystemGraphComponents systemGraphComponents = (SystemGraphComponents)dependencies.resolveDependency(SystemGraphComponents.class);
        systemGraphComponents.register((SystemGraphComponent)communityComponent);
    }

    @Override
    public void createSecurityModule(GlobalModule globalModule) {
        this.setSecurityProvider(this.makeSecurityModule(globalModule));
    }

    private SecurityProvider makeSecurityModule(GlobalModule globalModule) {
        globalModule.getGlobalDependencies().satisfyDependency((Object)CommunitySecurityLog.NULL_LOG);
        this.setupSecurityGraphInitializer(globalModule);
        if (((Boolean)globalModule.getGlobalConfig().get(GraphDatabaseSettings.auth_enabled)).booleanValue()) {
            CommunitySecurityModule securityModule = new CommunitySecurityModule(globalModule.getLogService(), globalModule.getGlobalConfig(), globalModule.getGlobalDependencies());
            securityModule.setup();
            return securityModule;
        }
        return NoAuthSecurityProvider.INSTANCE;
    }

    @Override
    public void createDefaultDatabaseResolver(GlobalModule globalModule) {
        Supplier<GraphDatabaseService> systemDbSupplier = CommunityEditionModule.systemSupplier((DependencyResolver)globalModule.getGlobalDependencies());
        CommunityDefaultDatabaseResolver defaultDatabaseResolver = new CommunityDefaultDatabaseResolver(globalModule.getGlobalConfig(), systemDbSupplier);
        globalModule.getTransactionEventListeners().registerTransactionEventListener("system", (TransactionEventListener)defaultDatabaseResolver);
        this.setDefaultDatabaseResolver((DefaultDatabaseResolver)defaultDatabaseResolver);
    }

    public static <T> T tryResolveOrCreate(Class<T> clazz, DependencyResolver dependencies, Supplier<T> newInstanceMethod) {
        return (T)(dependencies.containsDependency(clazz) ? dependencies.resolveDependency(clazz) : newInstanceMethod.get());
    }

    @Override
    public BoltGraphDatabaseManagementServiceSPI createBoltDatabaseManagementServiceProvider(Dependencies dependencies, DatabaseManagementService managementService, Monitors monitors, SystemNanoClock clock, LogService logService) {
        BoltGraphDatabaseManagementServiceSPI kernelDatabaseManagementService = CommunityEditionModule.createBoltKernelDatabaseManagementServiceProvider(dependencies, managementService, monitors, clock, logService);
        return this.fabricServicesBootstrap.createBoltDatabaseManagementServiceProvider(kernelDatabaseManagementService, managementService, monitors, clock);
    }

    protected static BoltGraphDatabaseManagementServiceSPI createBoltKernelDatabaseManagementServiceProvider(Dependencies dependencies, DatabaseManagementService managementService, Monitors monitors, SystemNanoClock clock, LogService logService) {
        Config config = (Config)dependencies.resolveDependency(Config.class);
        Duration bookmarkAwaitDuration = (Duration)config.get(GraphDatabaseSettings.bookmark_ready_timeout);
        return new BoltKernelDatabaseManagementServiceProvider(managementService, monitors, clock, bookmarkAwaitDuration);
    }

    @Override
    public void bootstrapFabricServices() {
        this.fabricServicesBootstrap.bootstrapServices();
    }

    @Override
    public ReadOnlyDatabases getReadOnlyChecker() {
        return this.globalReadOnlyChecker;
    }
}

