/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph;

import org.neo4j.dbms.database.ComponentVersion;

public enum CommunityTopologyGraphVersion implements ComponentVersion
{
    COMMUNITY_TOPOLOGY_44(0, "Neo4j 4.4"),
    COMMUNITY_TOPOLOGY_UNKNOWN_VERSION(-1, String.format("no '%s' found", "community-topology-graph"));

    public static final int FIRST_VALID_COMMUNITY_TOPOLOGY_VERSION;
    public static final int LATEST_COMMUNITY_TOPOLOGY_VERSION;
    private final String description;
    private final int version;

    private CommunityTopologyGraphVersion(int version, String description) {
        this.version = version;
        this.description = description;
    }

    public String toString() {
        return this.description + "(" + this.version + ")";
    }

    public int getVersion() {
        return this.version;
    }

    public String getComponentName() {
        return "community-topology-graph";
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isCurrent() {
        return this.version == LATEST_COMMUNITY_TOPOLOGY_VERSION;
    }

    public boolean migrationSupported() {
        return this.version >= FIRST_VALID_COMMUNITY_TOPOLOGY_VERSION && this.version <= LATEST_COMMUNITY_TOPOLOGY_VERSION;
    }

    public boolean runtimeSupported() {
        return this.version >= FIRST_VALID_COMMUNITY_TOPOLOGY_VERSION && this.version <= LATEST_COMMUNITY_TOPOLOGY_VERSION;
    }

    static {
        FIRST_VALID_COMMUNITY_TOPOLOGY_VERSION = COMMUNITY_TOPOLOGY_44.getVersion();
        LATEST_COMMUNITY_TOPOLOGY_VERSION = COMMUNITY_TOPOLOGY_44.getVersion();
    }
}

