/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.identity;

import java.util.UUID;
import org.neo4j.dbms.identity.AbstractIdentityModule;
import org.neo4j.dbms.identity.ServerId;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.state.SimpleStorage;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;

public class DefaultIdentityModule
extends AbstractIdentityModule {
    private final ServerId serverId;

    public static DefaultIdentityModule fromGlobalModule(GlobalModule globalModule) {
        return new DefaultIdentityModule(globalModule.getLogService(), globalModule.getFileSystem(), globalModule.getNeo4jLayout(), globalModule.getOtherMemoryPool().getPoolMemoryTracker());
    }

    DefaultIdentityModule(LogService logService, FileSystemAbstraction fs, Neo4jLayout layout, MemoryTracker memoryTracker) {
        Log log = logService.getInternalLog(this.getClass());
        SimpleStorage<ServerId> storage = DefaultIdentityModule.createServerIdStorage(fs, layout.serverIdFile());
        this.serverId = DefaultIdentityModule.readOrGenerate(storage, log, ServerId.class, ServerId::new, UUID::randomUUID);
        logService.getUserLog(this.getClass()).info("This instance is %s (%s)", new Object[]{this.serverId, this.serverId.uuid()});
    }

    @Override
    public ServerId serverId() {
        return this.serverId;
    }
}

