/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import java.util.Objects;
import java.util.function.Function;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.internal.id.IdValidator;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.IntStoreHeader;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.Record;

public abstract class BaseRecordFormat<RECORD extends AbstractBaseRecord>
implements RecordFormat<RECORD> {
    public static final int IN_USE_BIT = 1;
    public static final Function<StoreHeader, Integer> INT_STORE_HEADER_READER = header -> ((IntStoreHeader)header).value();
    private final Function<StoreHeader, Integer> recordSize;
    private final int recordHeaderSize;
    private final long maxId;
    private final boolean pageAligned;

    public static Function<StoreHeader, Integer> fixedRecordSize(int recordSize) {
        return header -> recordSize;
    }

    protected BaseRecordFormat(Function<StoreHeader, Integer> recordSize, int recordHeaderSize, int idBits, boolean pageAligned) {
        this.recordSize = recordSize;
        this.recordHeaderSize = recordHeaderSize;
        this.maxId = (1L << idBits) - 1L;
        this.pageAligned = pageAligned;
    }

    @Override
    public int getRecordSize(StoreHeader header) {
        return this.recordSize.apply(header);
    }

    @Override
    public int getRecordHeaderSize() {
        return this.recordHeaderSize;
    }

    @Override
    public long getNextRecordReference(RECORD record) {
        return Record.NULL_REFERENCE.intValue();
    }

    public static long longFromIntAndMod(long base, long modifier) {
        return modifier == 0L && IdValidator.isReservedId((long)base) ? -1L : base | modifier;
    }

    @Override
    public void prepare(RECORD record, int recordSize, IdSequence idSequence, CursorContext cursorContext) {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseRecordFormat that = (BaseRecordFormat)o;
        return this.recordHeaderSize == that.recordHeaderSize && this.pageAligned == that.pageAligned;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.recordHeaderSize, this.pageAligned);
    }

    @Override
    public int getPageSize(int pageCachePageSize, int recordSize, int reservedBytes) {
        return this.pageAligned ? pageCachePageSize : Math.min(pageCachePageSize, pageCachePageSize + reservedBytes - pageCachePageSize % recordSize);
    }

    @Override
    public final long getMaxId() {
        return this.maxId;
    }
}

